/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class EvaluationContextManager
implements IWindowListener,
IPageListener,
ISelectionListener,
IPartListener2 {
    private static final String DEBUGGER_ACTIVE = String.valueOf(CDebugUIPlugin.getUniqueIdentifier()) + ".debuggerActive";
    protected static EvaluationContextManager fgManager;
    private Map<IWorkbenchPage, IDMVMContext> fContextsByPage = null;

    protected EvaluationContextManager() {
    }

    public static void startup() {
        Runnable r = new Runnable(){

            public void run() {
                if (fgManager == null) {
                    fgManager = new EvaluationContextManager();
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
                    int i = 0;
                    while (i < windows.length) {
                        fgManager.windowOpened(windows[i]);
                        ++i;
                    }
                    workbench.addWindowListener((IWindowListener)fgManager);
                }
            }
        };
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        display.asyncExec(r);
    }

    public void windowActivated(IWorkbenchWindow window) {
        this.windowOpened(window);
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowClosed(IWorkbenchWindow window) {
        window.removePageListener((IPageListener)this);
    }

    public void windowOpened(IWorkbenchWindow window) {
        IWorkbenchPage[] pages = window.getPages();
        int i = 0;
        while (i < pages.length) {
            window.addPageListener((IPageListener)this);
            this.pageOpened(pages[i]);
            ++i;
        }
    }

    public void pageActivated(IWorkbenchPage page) {
        this.pageOpened(page);
    }

    public void pageClosed(IWorkbenchPage page) {
        page.removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        page.removePartListener((IPartListener2)this);
    }

    public void pageOpened(IWorkbenchPage page) {
        page.addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        page.addPartListener((IPartListener2)this);
        IWorkbenchPartReference ref = page.getActivePartReference();
        if (ref != null) {
            this.partActivated(ref);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        Object element;
        IStructuredSelection ss;
        IWorkbenchPage page = part.getSite().getPage();
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (element = ss.getFirstElement()) instanceof IDMVMContext) {
            this.setContext(page, (IDMVMContext)element);
            return;
        }
        this.removeContext(page);
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
        if ("org.eclipse.debug.ui.DebugView".equals(partRef.getId())) {
            this.removeContext(partRef.getPage());
        }
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    private void setContext(IWorkbenchPage page, IDMVMContext target) {
        if (this.fContextsByPage == null) {
            this.fContextsByPage = new HashMap<IWorkbenchPage, IDMVMContext>();
        }
        this.fContextsByPage.put(page, target);
        System.setProperty(DEBUGGER_ACTIVE, Boolean.TRUE.toString());
    }

    private void removeContext(IWorkbenchPage page) {
        if (this.fContextsByPage != null) {
            this.fContextsByPage.remove(page);
            if (this.fContextsByPage.isEmpty()) {
                System.setProperty(DEBUGGER_ACTIVE, Boolean.FALSE.toString());
            }
        }
    }
}

