/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui.disassembly;

import java.util.Iterator;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.DisassemblyRulerColumn;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.model.DisassemblyDocument;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class DisassemblyViewer
extends SourceViewer {
    private boolean fUserTriggeredScrolling;
    private int fCachedLastTopPixel;
    private ResizeListener fResizeListener;

    public DisassemblyViewer(Composite parent, IVerticalRuler ruler, IOverviewRuler overviewRuler, boolean showsAnnotationOverview, int styles) {
        super(parent, ruler, overviewRuler, showsAnnotationOverview, styles);
        this.setEditable(false);
    }

    protected void createControl(Composite parent, int styles) {
        super.createControl(parent, styles);
        this.fResizeListener = new ResizeListener();
        this.getTextWidget().addControlListener((ControlListener)this.fResizeListener);
    }

    protected void handleDispose() {
        if (this.fResizeListener != null) {
            this.getTextWidget().removeControlListener((ControlListener)this.fResizeListener);
        }
        super.handleDispose();
    }

    public void doOperation(int operation) {
        switch (operation) {
            case 4: {
                String selectedText;
                StyledText textWidget = this.getTextWidget();
                if (textWidget == null || !this.redraws()) {
                    return;
                }
                if (textWidget.getSelectionCount() == 0) {
                    return;
                }
                try {
                    selectedText = this.getSelectedText();
                }
                catch (BadLocationException e) {
                    DsfUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", e.getLocalizedMessage(), (Throwable)e));
                    return;
                }
                Clipboard clipboard = new Clipboard(textWidget.getDisplay());
                clipboard.setContents(new Object[]{selectedText}, new Transfer[]{TextTransfer.getInstance()});
                clipboard.dispose();
                break;
            }
            default: {
                super.doOperation(operation);
            }
        }
    }

    public String getSelectedText() throws BadLocationException {
        StringBuffer text = new StringBuffer(200);
        String lineSeparator = System.getProperty("line.separator");
        DisassemblyDocument doc = (DisassemblyDocument)this.getDocument();
        Point selection = this.getSelectedRange();
        int startOffset = selection.x;
        int length = selection.y;
        int endOffset = startOffset + length;
        int startLine = doc.getLineOfOffset(startOffset);
        int endLine = doc.getLineOfOffset(endOffset);
        int firstLineOffset = startOffset - doc.getLineOffset(startLine);
        if (firstLineOffset > 0) {
            int lineLength = doc.getLineInformation(startLine).getLength();
            text.append(doc.get(startOffset, Math.min(lineLength - firstLineOffset, length)));
            if (++startLine <= endLine) {
                text.append(lineSeparator);
            }
        }
        int line = startLine;
        while (line < endLine) {
            String lineText = this.getLineText(line);
            text.append(lineText);
            text.append(lineSeparator);
            ++line;
        }
        if (doc.getLineOffset(endLine) < endOffset && startLine <= endLine) {
            int lineStart = doc.getLineOffset(endLine);
            text.append(this.getLinePrefix(endLine));
            text.append(doc.get(lineStart, endOffset - lineStart));
        }
        return text.toString();
    }

    public String getLineText(int line) throws BadLocationException {
        IDocument doc = this.getDocument();
        IRegion lineRegion = doc.getLineInformation(line);
        return String.valueOf(this.getLinePrefix(line)) + doc.get(lineRegion.getOffset(), lineRegion.getLength());
    }

    public String getLinePrefix(int line) {
        StringBuffer prefix = new StringBuffer(10);
        IVerticalRuler ruler = this.getVerticalRuler();
        if (ruler instanceof CompositeRuler) {
            Iterator iter = ((CompositeRuler)ruler).getDecoratorIterator();
            while (iter.hasNext()) {
                IVerticalRulerColumn column = (IVerticalRulerColumn)iter.next();
                if (!(column instanceof DisassemblyRulerColumn)) continue;
                DisassemblyRulerColumn disassColumn = (DisassemblyRulerColumn)column;
                String columnText = disassColumn.createDisplayString(line);
                prefix.append(columnText);
                int columnWidth = disassColumn.computeNumberOfCharacters();
                columnWidth -= columnText.length();
                while (columnWidth-- > 0) {
                    prefix.append(' ');
                }
                prefix.append(' ');
            }
        }
        return prefix.toString();
    }

    public void revealOffset(int offset, boolean onTop) {
        try {
            IDocument doc = this.getVisibleDocument();
            int focusLine = doc.getLineOfOffset(offset);
            StyledText textWidget = this.getTextWidget();
            int top = textWidget.getTopIndex();
            if (top > -1) {
                int lines = this.getEstimatedVisibleLinesInViewport();
                int bottom = top + lines;
                int bottomBuffer = Math.max(1, lines / 3);
                if (onTop || focusLine < top || focusLine > bottom - bottomBuffer) {
                    if (focusLine > bottom - bottomBuffer && focusLine <= bottom) {
                        int scrollDelta = focusLine - (bottom - bottomBuffer);
                        textWidget.setTopIndex(top + scrollDelta);
                    } else {
                        int topBuffer = onTop ? 0 : lines / 3;
                        textWidget.setTopIndex(Math.max(0, focusLine - topBuffer));
                    }
                    this.updateViewportListeners(6);
                }
            }
        }
        catch (BadLocationException ble) {
            throw new IllegalArgumentException(ble.getLocalizedMessage());
        }
    }

    private int getEstimatedVisibleLinesInViewport() {
        Rectangle clArea;
        StyledText textWidget = this.getTextWidget();
        if (textWidget != null && !(clArea = textWidget.getClientArea()).isEmpty()) {
            return clArea.height / textWidget.getLineHeight();
        }
        return -1;
    }

    int getLastTopPixel() {
        return this.fCachedLastTopPixel;
    }

    boolean isUserTriggeredScrolling() {
        return this.fUserTriggeredScrolling;
    }

    protected void updateViewportListeners(int origin) {
        this.fCachedLastTopPixel = this.fLastTopPixel;
        boolean bl = this.fUserTriggeredScrolling = origin != 6 && origin != 5;
        if (origin == 5) {
            this.fLastTopPixel = -1;
        }
        super.updateViewportListeners(origin);
    }

    class ResizeListener
    implements ControlListener {
        ResizeListener() {
        }

        public void controlResized(ControlEvent e) {
            DisassemblyViewer.this.updateViewportListeners(5);
        }

        public void controlMoved(ControlEvent e) {
        }
    }
}

