/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.sourcelookup;

import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceNotFoundElement;
import org.eclipse.cdt.debug.internal.ui.sourcelookup.CSourceNotFoundEditorInput;
import org.eclipse.cdt.debug.ui.ICDebugUIConstants;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.debug.sourcelookup.DsfSourceLookupParticipant;
import org.eclipse.cdt.dsf.debug.ui.sourcelookup.IInstructionPointerPresentation;
import org.eclipse.cdt.dsf.debug.ui.sourcelookup.InstructionPointerManager;
import org.eclipse.cdt.dsf.debug.ui.sourcelookup.SourceLookupResult;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.SteppingController;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ISourcePresentation;
import org.eclipse.debug.ui.sourcelookup.ISourceDisplay;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

@ThreadSafe
public class DsfSourceDisplayAdapter
implements ISourceDisplay,
SteppingController.ISteppingControlParticipant {
    private static final boolean DEBUG = false;
    private DsfSession fSession;
    private DsfExecutor fExecutor;
    private DsfServicesTracker fServicesTracker;
    private FrameData fPrevFrameData;
    private SourceLookupResult fPrevResult;
    private ISourceLookupDirector fSourceLookup;
    private DsfSourceLookupParticipant fSourceLookupParticipant;
    private InstructionPointerManager fIPManager;
    private LookupJob fRunningLookupJob;
    private DisplayJob fRunningDisplayJob;
    private DisplayJob fPendingDisplayJob;
    private ClearingJob fRunningClearingJob;
    private Set<IRunControl.IExecutionDMContext> fPendingExecDmcsToClear = new HashSet<IRunControl.IExecutionDMContext>();
    private SteppingController fController;
    private int fSelectionChangeDelay = 150;
    private long fStepStartTime = 0L;
    private long fLastStepTime = 0L;
    private long fStepCount;
    private boolean fEnableLineBackgroundPainter;

    public DsfSourceDisplayAdapter(DsfSession session, ISourceLookupDirector sourceLocator) {
        this(session, sourceLocator, null);
    }

    public DsfSourceDisplayAdapter(DsfSession session, ISourceLookupDirector sourceLocator, SteppingController controller) {
        this.fSession = session;
        this.fExecutor = session.getExecutor();
        this.fServicesTracker = new DsfServicesTracker(DsfUIPlugin.getBundleContext(), session.getId());
        this.fSourceLookup = sourceLocator;
        this.fSourceLookupParticipant = new DsfSourceLookupParticipant(session);
        this.fSourceLookup.addParticipants(new ISourceLookupParticipant[]{this.fSourceLookupParticipant});
        IInstructionPointerPresentation ipPresentation = (IInstructionPointerPresentation)session.getModelAdapter(IInstructionPointerPresentation.class);
        this.fIPManager = new InstructionPointerManager(ipPresentation);
        this.fExecutor.execute((Runnable)new DsfRunnable(){

            public void run() {
                DsfSourceDisplayAdapter.this.fSession.addServiceEventListener((Object)DsfSourceDisplayAdapter.this, null);
            }
        });
        this.fController = controller;
        if (this.fController != null) {
            this.fController.addSteppingControlParticipant(this);
        }
    }

    public void setSelectionChangeDelay(int delay) {
        this.fSelectionChangeDelay = delay;
    }

    public void dispose() {
        if (this.fController != null) {
            this.fController.removeSteppingControlParticipant(this);
            this.fController = null;
        }
        try {
            this.fExecutor.execute((Runnable)new DsfRunnable(){

                public void run() {
                    DsfSourceDisplayAdapter.this.fSession.removeServiceEventListener((Object)DsfSourceDisplayAdapter.this);
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {}
        this.fServicesTracker.dispose();
        this.fSourceLookup.removeParticipants(new ISourceLookupParticipant[]{this.fSourceLookupParticipant});
        Display display = Display.getDefault();
        if (!display.isDisposed()) {
            display.asyncExec(new Runnable(){

                public void run() {
                    DsfSourceDisplayAdapter.this.enableLineBackgroundPainter();
                    DsfSourceDisplayAdapter.this.fIPManager.removeAllAnnotations();
                }
            });
        }
    }

    public void displaySource(Object context, IWorkbenchPage page, boolean force) {
        this.fStepCount = 0L;
        IStack.IFrameDMContext displayFrame = null;
        if (context instanceof IDMVMContext) {
            IDMContext dmc = ((IDMVMContext)context).getDMContext();
            if (dmc instanceof IStack.IFrameDMContext) {
                displayFrame = (IStack.IFrameDMContext)dmc;
            }
        } else if (context instanceof IStack.IFrameDMContext) {
            displayFrame = (IStack.IFrameDMContext)context;
        }
        if (displayFrame != null) {
            this.doDisplaySource(displayFrame, page, force, false);
        }
    }

    private void doDisplaySource(final IStack.IFrameDMContext context, final IWorkbenchPage page, final boolean force, final boolean eventTriggered) {
        if (context.getLevel() < 0) {
            return;
        }
        this.fExecutor.execute((Runnable)new DsfRunnable(){

            public void run() {
                IStack stackService = (IStack)DsfSourceDisplayAdapter.this.fServicesTracker.getService(IStack.class);
                if (stackService == null) {
                    return;
                }
                stackService.getFrameData(context, (DataRequestMonitor)new DataRequestMonitor<IStack.IFrameDMData>((Executor)DsfSourceDisplayAdapter.this.fExecutor, null){

                    public void handleSuccess() {
                        FrameData frameData = new FrameData();
                        frameData.fDmc = context;
                        frameData.fLevel = context.getLevel();
                        IStack.IFrameDMData data = (IStack.IFrameDMData)this.getData();
                        frameData.fLine = data.getLine() - 1;
                        frameData.fFile = data.getFile();
                        if (!force && frameData.equals(DsfSourceDisplayAdapter.this.fPrevFrameData)) {
                            DsfSourceDisplayAdapter.this.fPrevResult.updateArtifact((IDMContext)context);
                            DsfSourceDisplayAdapter.this.startDisplayJob(DsfSourceDisplayAdapter.this.fPrevResult, frameData, page, eventTriggered);
                        } else {
                            DsfSourceDisplayAdapter.this.startLookupJob(frameData, page, eventTriggered);
                        }
                    }

                    protected void handleFailure() {
                        DsfSourceDisplayAdapter.this.doneStepping((IDMContext)context);
                    }

                    protected void handleRejectedExecutionException() {
                        DsfSourceDisplayAdapter.this.doneStepping((IDMContext)context);
                    }
                });
            }
        });
    }

    private void executeFromJob(Runnable runnable) {
        try {
            this.fExecutor.execute(runnable);
        }
        catch (RejectedExecutionException rejectedExecutionException) {}
    }

    private void startLookupJob(FrameData frameData, IWorkbenchPage page, boolean eventTriggered) {
        if (this.fRunningLookupJob != null) {
            this.fRunningLookupJob.cancel();
            if (!eventTriggered && frameData.isIdentical(this.fRunningLookupJob.fFrameData)) {
                return;
            }
            this.fRunningLookupJob.cancel();
            if (!(!this.fRunningLookupJob.fEventTriggered || eventTriggered && this.fRunningLookupJob.getDmc().equals(frameData.fDmc))) {
                this.doneStepping(this.fRunningLookupJob.getDmc());
            }
        }
        this.fRunningLookupJob = new LookupJob(frameData, page, eventTriggered);
        this.fRunningLookupJob.schedule();
    }

    private void startDisplayJob(SourceLookupResult lookupResult, FrameData frameData, IWorkbenchPage page, boolean eventTriggered) {
        DisplayJob nextDisplayJob = new DisplayJob(lookupResult, frameData, page, eventTriggered);
        if (this.fRunningDisplayJob != null) {
            this.fPendingDisplayJob = null;
            IRunControl.IExecutionDMContext[] execCtxs = (IRunControl.IExecutionDMContext[])DMContexts.getAllAncestorsOfType((IDMContext)frameData.fDmc, IRunControl.IExecutionDMContext.class);
            this.fPendingExecDmcsToClear.removeAll(Arrays.asList(execCtxs));
            if (!eventTriggered && frameData.isIdentical(this.fRunningDisplayJob.fFrameData)) {
                return;
            }
            this.fRunningDisplayJob.cancel();
            if (!(!this.fRunningDisplayJob.fEventTriggered || this.fRunningDisplayJob.fDoneStepping.getAndSet(true) || eventTriggered && this.fRunningDisplayJob.getDmc().equals(lookupResult.getDmc()))) {
                this.doneStepping(this.fRunningDisplayJob.getDmc());
            }
        }
        if (this.fRunningClearingJob != null) {
            this.fPendingDisplayJob = nextDisplayJob;
        } else {
            this.fRunningDisplayJob = nextDisplayJob;
            this.fRunningDisplayJob.schedule();
        }
    }

    private void doneStepping(IDMContext context) {
        IRunControl.IExecutionDMContext dmc;
        if (this.fController != null && (dmc = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)context, IRunControl.IExecutionDMContext.class)) != null) {
            try {
                this.fController.getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        DsfSourceDisplayAdapter.this.fController.doneStepping(dmc, DsfSourceDisplayAdapter.this);
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {}
        }
    }

    private void serviceDisplayAndClearingJobs() {
        if (!this.fPendingExecDmcsToClear.isEmpty()) {
            this.fRunningClearingJob = new ClearingJob(this.fPendingExecDmcsToClear);
            this.fRunningClearingJob.schedule();
            this.fPendingExecDmcsToClear = new HashSet<IRunControl.IExecutionDMContext>();
        } else if (this.fPendingDisplayJob != null) {
            this.fRunningDisplayJob = this.fPendingDisplayJob;
            this.fRunningDisplayJob.schedule();
            this.fPendingDisplayJob = null;
        }
    }

    private void startAnnotationClearingJob(IRunControl.IExecutionDMContext execDmc) {
        this.fPendingExecDmcsToClear.add(execDmc);
        if (this.fRunningLookupJob != null && DMContexts.isAncestorOf((IDMContext)this.fRunningLookupJob.getDmc(), (IDMContext)execDmc)) {
            this.fRunningLookupJob.cancel();
            this.fRunningLookupJob = null;
        }
        if (this.fPendingDisplayJob != null && DMContexts.isAncestorOf((IDMContext)this.fPendingDisplayJob.getDmc(), (IDMContext)execDmc)) {
            this.fPendingDisplayJob = null;
        }
        if (this.fRunningClearingJob == null && this.fRunningDisplayJob == null) {
            this.fRunningClearingJob = new ClearingJob(this.fPendingExecDmcsToClear);
            this.fRunningClearingJob.schedule();
            this.fPendingExecDmcsToClear = new HashSet<IRunControl.IExecutionDMContext>();
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IResumedDMEvent e) {
        if (e.getReason() != IRunControl.StateChangeReason.STEP) {
            this.startAnnotationClearingJob((IRunControl.IExecutionDMContext)e.getDMContext());
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IExitedDMEvent e) {
        this.startAnnotationClearingJob((IRunControl.IExecutionDMContext)e.getDMContext());
    }

    @DsfServiceEventHandler
    public void eventDispatched(SteppingController.SteppingTimedOutEvent e) {
        this.startAnnotationClearingJob((IRunControl.IExecutionDMContext)e.getDMContext());
    }

    @DsfServiceEventHandler
    public void eventDispatched(final IRunControl.ISuspendedDMEvent e) {
        this.updateStepTiming();
        if (e.getReason() == IRunControl.StateChangeReason.STEP || e.getReason() == IRunControl.StateChangeReason.BREAKPOINT) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IDMContext dmc;
                    IAdaptable context = DebugUITools.getDebugContext();
                    if (context instanceof IDMVMContext && (dmc = ((IDMVMContext)context).getDMContext()) instanceof IStack.IFrameDMContext && DMContexts.isAncestorOf((IDMContext)dmc, (IDMContext)e.getDMContext())) {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        DsfSourceDisplayAdapter.this.doDisplaySource((IStack.IFrameDMContext)dmc, page, false, true);
                        return;
                    }
                    DsfSourceDisplayAdapter.this.doneStepping(e.getDMContext());
                }
            });
        } else {
            this.doneStepping(e.getDMContext());
        }
    }

    private void updateStepTiming() {
        long now = System.currentTimeMillis();
        if (now - this.fLastStepTime > (long)Math.max(this.fSelectionChangeDelay, 200)) {
            this.fStepCount = 0L;
            this.fStepStartTime = this.fLastStepTime = now;
            return;
        }
        this.fLastStepTime = now;
        ++this.fStepCount;
    }

    private void disableLineBackgroundPainter() {
        if (!this.fEnableLineBackgroundPainter) {
            this.fEnableLineBackgroundPainter = EditorsUI.getPreferenceStore().getBoolean("currentLine");
            if (this.fEnableLineBackgroundPainter) {
                EditorsUI.getPreferenceStore().setValue("currentLine", false);
            }
        }
    }

    private void enableLineBackgroundPainter() {
        if (this.fEnableLineBackgroundPainter) {
            this.fEnableLineBackgroundPainter = false;
            EditorsUI.getPreferenceStore().setValue("currentLine", true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ClearingJob
    extends UIJob {
        Set<IRunControl.IExecutionDMContext> fDmcsToClear;

        public ClearingJob(Set<IRunControl.IExecutionDMContext> dmcs) {
            super("Debug Source Display");
            this.setSystem(true);
            this.setPriority(10);
            this.fDmcsToClear = dmcs;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            DsfRunnable clearingJobFinishedRunnable = new DsfRunnable(){

                public void run() {
                    if (!$assertionsDisabled && DsfSourceDisplayAdapter.this.fRunningClearingJob != ClearingJob.this) {
                        throw new AssertionError();
                    }
                    DsfSourceDisplayAdapter.this.fRunningClearingJob = null;
                    DsfSourceDisplayAdapter.this.serviceDisplayAndClearingJobs();
                }
            };
            DsfSourceDisplayAdapter.this.enableLineBackgroundPainter();
            if (monitor.isCanceled()) {
                DsfSourceDisplayAdapter.this.executeFromJob((Runnable)clearingJobFinishedRunnable);
                return Status.CANCEL_STATUS;
            }
            for (IRunControl.IExecutionDMContext dmc : this.fDmcsToClear) {
                DsfSourceDisplayAdapter.this.fIPManager.removeAnnotations(dmc);
            }
            DsfSourceDisplayAdapter.this.executeFromJob((Runnable)clearingJobFinishedRunnable);
            return Status.OK_STATUS;
        }
    }

    class DisplayJob
    extends UIJob {
        private final SourceLookupResult fResult;
        private final IWorkbenchPage fPage;
        private final FrameData fFrameData;
        private final DsfRunnable fDisplayJobFinishedRunnable;
        private final AtomicBoolean fDoneStepping;
        private IRegion fRegion;
        private ITextViewer fTextViewer;
        private final boolean fEventTriggered;

        IDMContext getDmc() {
            return this.fResult.getDmc();
        }

        public DisplayJob(SourceLookupResult result, FrameData frameData, IWorkbenchPage page, boolean eventTriggered) {
            super("Debug Source Display");
            this.fDisplayJobFinishedRunnable = new DsfRunnable(){

                public void run() {
                    if (DsfSourceDisplayAdapter.this.fRunningDisplayJob == DisplayJob.this) {
                        DsfSourceDisplayAdapter.this.fRunningDisplayJob = null;
                        if (DisplayJob.this.fEventTriggered && !DisplayJob.this.fDoneStepping.getAndSet(true)) {
                            DsfSourceDisplayAdapter.this.doneStepping(DisplayJob.this.fResult.getDmc());
                        }
                        DsfSourceDisplayAdapter.this.serviceDisplayAndClearingJobs();
                    }
                }
            };
            this.fDoneStepping = new AtomicBoolean(false);
            this.setSystem(true);
            this.setPriority(10);
            this.fResult = result;
            this.fFrameData = frameData;
            this.fPage = page;
            this.fEventTriggered = eventTriggered;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                DsfSourceDisplayAdapter.this.executeFromJob((Runnable)this.fDisplayJobFinishedRunnable);
                return Status.CANCEL_STATUS;
            }
            if (this.fRegion != null && this.fTextViewer != null) {
                if (DsfSourceDisplayAdapter.this.fRunningDisplayJob == this) {
                    if (!this.shouldCancelSelectionChange()) {
                        DsfSourceDisplayAdapter.this.enableLineBackgroundPainter();
                        this.fTextViewer.setSelectedRange(this.fRegion.getOffset(), 0);
                    }
                    DsfSourceDisplayAdapter.this.executeFromJob((Runnable)this.fDisplayJobFinishedRunnable);
                }
            } else {
                IEditorPart editor = this.openEditor(this.fResult, this.fPage);
                if (editor == null) {
                    DsfSourceDisplayAdapter.this.executeFromJob((Runnable)this.fDisplayJobFinishedRunnable);
                    return Status.OK_STATUS;
                }
                ITextEditor textEditor = null;
                textEditor = editor instanceof ITextEditor ? (ITextEditor)editor : (ITextEditor)editor.getAdapter(ITextEditor.class);
                if (textEditor != null && this.positionEditor(textEditor, this.fFrameData)) {
                    return Status.OK_STATUS;
                }
                DsfSourceDisplayAdapter.this.executeFromJob((Runnable)this.fDisplayJobFinishedRunnable);
            }
            return Status.OK_STATUS;
        }

        private boolean shouldCancelSelectionChange() {
            Query<Boolean> delaySelectionChangeQuery = new Query<Boolean>(){

                protected void execute(DataRequestMonitor<Boolean> rm) {
                    IRunControl.IExecutionDMContext execCtx = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)((DisplayJob)DisplayJob.this).fFrameData.fDmc, IRunControl.IExecutionDMContext.class);
                    IRunControl runControl = (IRunControl)DsfSourceDisplayAdapter.this.fServicesTracker.getService(IRunControl.class);
                    rm.setData((Object)(runControl != null && execCtx != null && (DsfSourceDisplayAdapter.this.fController != null && DsfSourceDisplayAdapter.this.fController.getPendingStepCount(execCtx) != 0 || runControl.isStepping(execCtx)) ? 1 : 0));
                    rm.done();
                }
            };
            try {
                DsfSourceDisplayAdapter.this.fExecutor.execute((Runnable)delaySelectionChangeQuery);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                return false;
            }
            try {
                return (Boolean)delaySelectionChangeQuery.get();
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
            catch (ExecutionException executionException) {
                return false;
            }
        }

        private IEditorPart openEditor(SourceLookupResult result, IWorkbenchPage page) {
            IEditorInput input = result.getEditorInput();
            String id = result.getEditorId();
            if (input == null || id == null) {
                return null;
            }
            return this.openEditor(page, input, id);
        }

        private IEditorPart openEditor(final IWorkbenchPage page, final IEditorInput input, final String id) {
            final IEditorPart[] editor = new IEditorPart[1];
            Runnable r = new Runnable(){

                public void run() {
                    if (!page.getWorkbenchWindow().getWorkbench().isClosing()) {
                        try {
                            editor[0] = page.openEditor(input, id, false);
                        }
                        catch (PartInitException partInitException) {}
                    }
                }
            };
            BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)r);
            return editor[0];
        }

        private boolean positionEditor(ITextEditor editor, FrameData frameData) {
            this.fRegion = this.getLineInformation(editor, frameData.fLine);
            if (this.fRegion != null) {
                DsfSourceDisplayAdapter.this.fIPManager.addAnnotation(editor, frameData.fDmc, new Position(this.fRegion.getOffset(), this.fRegion.getLength()), frameData.fLevel == 0);
                Object tot = editor.getAdapter(ITextOperationTarget.class);
                if (tot instanceof ITextViewer) {
                    this.fTextViewer = (ITextViewer)tot;
                    int widgetLine = frameData.fLine;
                    if (tot instanceof ITextViewerExtension5) {
                        ITextViewerExtension5 ext5 = (ITextViewerExtension5)tot;
                        ext5.exposeModelRange(this.fRegion);
                        widgetLine = ext5.modelLine2WidgetLine(widgetLine);
                    }
                    this.revealLine(this.fTextViewer, widgetLine);
                    if (DsfSourceDisplayAdapter.this.fStepCount > 0L && DsfSourceDisplayAdapter.this.fSelectionChangeDelay > 0) {
                        DsfSourceDisplayAdapter.this.disableLineBackgroundPainter();
                        this.schedule(DsfSourceDisplayAdapter.this.fSelectionChangeDelay);
                        if (!this.fDoneStepping.getAndSet(true)) {
                            DsfSourceDisplayAdapter.this.doneStepping(this.getDmc());
                        }
                        return true;
                    }
                    DsfSourceDisplayAdapter.this.enableLineBackgroundPainter();
                    this.fTextViewer.setSelectedRange(this.fRegion.getOffset(), 0);
                } else {
                    editor.selectAndReveal(this.fRegion.getOffset(), 0);
                }
            }
            return false;
        }

        private void revealLine(ITextViewer viewer, int focusLine) {
            StyledText textWidget = viewer.getTextWidget();
            int top = textWidget.getTopIndex();
            if (top > -1) {
                int lines = this.getEstimatedVisibleLinesInViewport(textWidget);
                int bottom = top + lines;
                int bottomBuffer = Math.max(1, lines / 3);
                if (focusLine < top || focusLine > bottom - bottomBuffer) {
                    if (focusLine > bottom - bottomBuffer && focusLine <= bottom) {
                        int scrollDelta = focusLine - (bottom - bottomBuffer);
                        textWidget.setTopIndex(top + scrollDelta);
                    } else {
                        int topBuffer = lines / 3;
                        textWidget.setTopIndex(Math.max(0, focusLine - topBuffer));
                    }
                }
            }
        }

        private int getEstimatedVisibleLinesInViewport(StyledText textWidget) {
            Rectangle clArea;
            if (textWidget != null && !(clArea = textWidget.getClientArea()).isEmpty()) {
                return clArea.height / textWidget.getLineHeight();
            }
            return -1;
        }

        private IRegion getLineInformation(ITextEditor editor, int lineNumber) {
            IDocumentProvider provider = editor.getDocumentProvider();
            IEditorInput input = editor.getEditorInput();
            try {
                provider.connect((Object)input);
            }
            catch (CoreException coreException) {
                return null;
            }
            try {
                IDocument document = provider.getDocument((Object)input);
                if (document != null) {
                    IRegion iRegion = document.getLineInformation(lineNumber);
                    return iRegion;
                }
            }
            catch (BadLocationException badLocationException) {
            }
            finally {
                provider.disconnect((Object)input);
            }
            return null;
        }
    }

    private static final class FrameData {
        IStack.IFrameDMContext fDmc;
        int fLine;
        int fLevel;
        String fFile;

        private FrameData() {
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FrameData other = (FrameData)obj;
            if (!this.fDmc.equals(other.fDmc)) {
                return false;
            }
            return !(this.fFile == null ? other.fFile != null : !this.fFile.equals(other.fFile));
        }

        public boolean isIdentical(FrameData frameData) {
            return this.equals(frameData) && this.fLine == frameData.fLine;
        }
    }

    class LookupJob
    extends Job {
        private final IWorkbenchPage fPage;
        private final FrameData fFrameData;
        private final boolean fEventTriggered;

        public LookupJob(FrameData frameData, IWorkbenchPage page, boolean eventTriggered) {
            super("DSF Source Lookup");
            this.setPriority(10);
            this.setSystem(true);
            this.fFrameData = frameData;
            this.fPage = page;
            this.fEventTriggered = eventTriggered;
        }

        IDMContext getDmc() {
            return this.fFrameData.fDmc;
        }

        protected IStatus run(final IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            final SourceLookupResult result = this.performLookup();
            DsfSourceDisplayAdapter.this.executeFromJob((Runnable)new DsfRunnable(){

                public void run() {
                    if (!monitor.isCanceled()) {
                        DsfSourceDisplayAdapter.this.fPrevResult = result;
                        DsfSourceDisplayAdapter.this.fPrevFrameData = LookupJob.this.fFrameData;
                        DsfSourceDisplayAdapter.this.fRunningLookupJob = null;
                        DsfSourceDisplayAdapter.this.startDisplayJob(DsfSourceDisplayAdapter.this.fPrevResult, LookupJob.this.fFrameData, LookupJob.this.fPage, LookupJob.this.fEventTriggered);
                    }
                }
            });
            return Status.OK_STATUS;
        }

        private SourceLookupResult performLookup() {
            IStack.IFrameDMContext dmc = this.fFrameData.fDmc;
            SourceLookupResult result = new SourceLookupResult((IDMContext)dmc, null, null, null);
            String editorId = null;
            CSourceNotFoundEditorInput editorInput = null;
            Object sourceElement = DsfSourceDisplayAdapter.this.fSourceLookup.getSourceElement((Object)dmc);
            if (sourceElement == null) {
                editorInput = new CSourceNotFoundEditorInput((Object)new CSourceNotFoundElement((IAdaptable)dmc, DsfSourceDisplayAdapter.this.fSourceLookup.getLaunchConfiguration(), this.fFrameData.fFile));
                editorId = ICDebugUIConstants.CSOURCENOTFOUND_EDITOR_ID;
            } else {
                ISourcePresentation presentation = null;
                if (DsfSourceDisplayAdapter.this.fSourceLookup instanceof ISourcePresentation) {
                    presentation = (ISourcePresentation)DsfSourceDisplayAdapter.this.fSourceLookup;
                } else if (dmc != null) {
                    presentation = (ISourcePresentation)dmc.getAdapter(ISourcePresentation.class);
                }
                if (presentation != null) {
                    editorInput = presentation.getEditorInput(sourceElement);
                    if (editorInput != null) {
                        editorId = presentation.getEditorId((IEditorInput)editorInput, sourceElement);
                    }
                } else if (sourceElement instanceof IFile) {
                    editorId = this.getEditorIdForFilename(((IFile)sourceElement).getName());
                    editorInput = new FileEditorInput((IFile)sourceElement);
                } else if (sourceElement instanceof ITranslationUnit) {
                    try {
                        URI uriLocation = ((ITranslationUnit)sourceElement).getLocationURI();
                        IFileStore fileStore = EFS.getStore((URI)uriLocation);
                        editorInput = new FileStoreEditorInput(fileStore);
                        editorId = this.getEditorIdForFilename(fileStore.getName());
                    }
                    catch (CoreException coreException) {
                        editorInput = new CSourceNotFoundEditorInput((Object)new CSourceNotFoundElement((IAdaptable)dmc, DsfSourceDisplayAdapter.this.fSourceLookup.getLaunchConfiguration(), this.fFrameData.fFile));
                        editorId = ICDebugUIConstants.CSOURCENOTFOUND_EDITOR_ID;
                    }
                } else if (sourceElement instanceof LocalFileStorage) {
                    File file = ((LocalFileStorage)sourceElement).getFile();
                    IFileStore fileStore = EFS.getLocalFileSystem().fromLocalFile(file);
                    editorInput = new FileStoreEditorInput(fileStore);
                    editorId = this.getEditorIdForFilename(file.getName());
                }
            }
            result.setEditorInput((IEditorInput)editorInput);
            result.setEditorId(editorId);
            result.setSourceElement(sourceElement);
            return result;
        }

        private String getEditorIdForFilename(String filename) {
            try {
                IEditorDescriptor descriptor = IDE.getEditorDescriptor((String)filename);
                return descriptor.getId();
            }
            catch (PartInitException exc) {
                DsfUIPlugin.log(exc);
                return "org.eclipse.ui.DefaultTextEditor";
            }
        }
    }
}

