/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.ui.viewmodel.properties;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IElementPropertiesProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IPropertiesUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelColumnInfo;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.VMPropertiesUpdate;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class PropertiesBasedLabelProvider
implements IElementLabelProvider {
    public static final String ID_COLUMN_NO_COLUMNS = "ID_COLUMN_NO_COLUMNS";
    private Map<String, LabelColumnInfo> fColumnInfos = Collections.synchronizedMap(new HashMap());

    public LabelColumnInfo setColumnInfo(String columnId, LabelColumnInfo info) {
        LabelColumnInfo oldInfo = this.fColumnInfos.put(columnId, info);
        return oldInfo;
    }

    public LabelColumnInfo getColumnInfo(String columnId) {
        return this.fColumnInfos.get(columnId);
    }

    public void update(ILabelUpdate[] labelUpdates) {
        IElementPropertiesProvider propertiesProvider = this.getElementPropertiesProvider(labelUpdates[0].getElement());
        if (propertiesProvider == null) {
            ILabelUpdate[] iLabelUpdateArray = labelUpdates;
            int n = labelUpdates.length;
            int n2 = 0;
            while (n2 < n) {
                ILabelUpdate update = iLabelUpdateArray[n2];
                update.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", "Properties-based label provider " + this + " failed to generate a label, no properties provider registered for element: " + labelUpdates[0].getElement()));
                update.done();
                ++n2;
            }
            return;
        }
        String[] columnIds = labelUpdates[0].getColumnIds();
        Set<String> propertyNames = this.calcPropertyNamesForColumns(columnIds);
        IPropertiesUpdate[] propertiesUpdates = new IPropertiesUpdate[labelUpdates.length];
        int i = 0;
        while (i < labelUpdates.length) {
            final ILabelUpdate labelUpdate = labelUpdates[i];
            propertiesUpdates[i] = new VMPropertiesUpdate(propertyNames, (IViewerUpdate)labelUpdate, (DataRequestMonitor<Map<String, Object>>)new ViewerDataRequestMonitor<Map<String, Object>>(ImmediateExecutor.getInstance(), (IViewerUpdate)labelUpdate){

                protected void handleCompleted() {
                    PropertiesBasedLabelProvider.this.updateLabel(labelUpdate, this.getStatus(), (Map)this.getData());
                }
            });
            ++i;
        }
        propertiesProvider.update(propertiesUpdates);
    }

    private Set<String> calcPropertyNamesForColumns(String[] columnIds) {
        HashSet<String> propertyNames;
        block5: {
            block4: {
                propertyNames = new HashSet<String>();
                if (columnIds != null) break block4;
                LabelColumnInfo columnInfo = this.getColumnInfo(ID_COLUMN_NO_COLUMNS);
                if (columnInfo == null) break block5;
                String[] stringArray = columnInfo.getPropertyNames();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String propertyName = stringArray[n2];
                    propertyNames.add(propertyName);
                    ++n2;
                }
                break block5;
            }
            String[] stringArray = columnIds;
            int n = columnIds.length;
            int n3 = 0;
            while (n3 < n) {
                String columnId = stringArray[n3];
                LabelColumnInfo info = this.getColumnInfo(columnId);
                if (info != null) {
                    String[] infoPropertyNames = info.getPropertyNames();
                    int i = 0;
                    while (i < infoPropertyNames.length) {
                        propertyNames.add(infoPropertyNames[i]);
                        ++i;
                    }
                }
                ++n3;
            }
        }
        return propertyNames;
    }

    protected void updateLabel(ILabelUpdate update, IStatus status, Map<String, Object> properties) {
        if (update.getColumnIds() == null) {
            LabelColumnInfo info = this.getColumnInfo(ID_COLUMN_NO_COLUMNS);
            if (info != null) {
                info.updateColumn(update, 0, status, properties);
            }
        } else {
            String[] columnIds = update.getColumnIds();
            int i = 0;
            while (i < columnIds.length) {
                LabelColumnInfo info = this.getColumnInfo(columnIds[i]);
                if (info != null) {
                    info.updateColumn(update, i, status, properties);
                }
                ++i;
            }
        }
        update.done();
    }

    private IElementPropertiesProvider getElementPropertiesProvider(Object element) {
        if (element instanceof IAdaptable) {
            return (IElementPropertiesProvider)((IAdaptable)element).getAdapter(IElementPropertiesProvider.class);
        }
        return null;
    }
}

