/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.internal.ui;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.launch.internal.MultiLaunchConfigurationDelegate;
import org.eclipse.cdt.launch.internal.ui.LaunchMessages;
import org.eclipse.cdt.launch.internal.ui.MultiLaunchConfigurationSelectionDialog;
import org.eclipse.cdt.launch.ui.CommonTabLite;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTabGroup;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class MultiLaunchConfigurationTabGroup
extends AbstractLaunchConfigurationTabGroup {
    public void createTabs(ILaunchConfigurationDialog dialog, String mode) {
        ILaunchConfigurationTab[] tabs = new ILaunchConfigurationTab[]{new GroupLaunchTab(mode), new CommonTabLite()};
        this.setTabs(tabs);
    }

    static abstract class ButtonComposite
    extends Composite
    implements SelectionListener {
        Button upButton;
        Button downButton;
        Button addButton;
        Button deleteButton;
        Button editButton;

        public ButtonComposite(Composite parent, int style) {
            super(parent, style);
            this.setLayout((Layout)new GridLayout());
            this.upButton = this.createPushButton(this, LaunchMessages.getString("MultiLaunchConfigurationTabGroup.1"));
            this.downButton = this.createPushButton(this, LaunchMessages.getString("MultiLaunchConfigurationTabGroup.2"));
            this.editButton = this.createPushButton(this, LaunchMessages.getString("MultiLaunchConfigurationTabGroup.3"));
            this.addButton = this.createPushButton(this, LaunchMessages.getString("MultiLaunchConfigurationTabGroup.4"));
            this.deleteButton = this.createPushButton(this, LaunchMessages.getString("MultiLaunchConfigurationTabGroup.5"));
        }

        protected void updateWidgetEnablement() {
        }

        protected Button createPushButton(Composite parent, String key) {
            Button button = new Button(parent, 8);
            button.setText(key);
            button.setFont(parent.getFont());
            GridData data = new GridData(768);
            button.setLayoutData((Object)data);
            button.addSelectionListener((SelectionListener)this);
            return button;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Widget widget = e.widget;
            if (widget == this.upButton) {
                this.upPressed();
            } else if (widget == this.downButton) {
                this.downPressed();
            } else if (widget == this.addButton) {
                this.addPressed();
            } else if (widget == this.deleteButton) {
                this.deletePressed();
            } else if (widget == this.editButton) {
                this.editPressed();
            }
        }

        protected abstract void addPressed();

        protected abstract void editPressed();

        protected abstract void deletePressed();

        protected abstract void downPressed();

        protected abstract void upPressed();
    }

    static class CheckStateProvider
    implements ICheckStateProvider {
        CheckStateProvider() {
        }

        public boolean isChecked(Object element) {
            if (element instanceof MultiLaunchConfigurationDelegate.LaunchElement) {
                return ((MultiLaunchConfigurationDelegate.LaunchElement)element).enabled;
            }
            return false;
        }

        public boolean isGrayed(Object element) {
            return false;
        }
    }

    static class ContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        protected List<MultiLaunchConfigurationDelegate.LaunchElement> input;

        ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
            this.input = null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof List) {
                this.input = (List)newInput;
            }
        }

        public Object[] getChildren(Object parentElement) {
            return parentElement == this.input ? this.input.toArray() : null;
        }

        public Object getParent(Object element) {
            return element == this.input ? null : this.input;
        }

        public boolean hasChildren(Object element) {
            return element == this.input ? this.input.size() > 0 : false;
        }
    }

    static class GroupLaunchTab
    extends AbstractLaunchConfigurationTab {
        protected CheckboxTreeViewer treeViewer;
        protected List<MultiLaunchConfigurationDelegate.LaunchElement> input = new ArrayList<MultiLaunchConfigurationDelegate.LaunchElement>();
        private String mode;

        public GroupLaunchTab(String mode) {
            this.mode = mode;
        }

        public void createControl(Composite parent) {
            Composite comp = new Composite(parent, 0);
            this.setControl((Control)comp);
            comp.setLayout((Layout)new GridLayout(2, false));
            this.treeViewer = new CheckboxTreeViewer(comp, 2818);
            Tree table = this.treeViewer.getTree();
            table.setFont(parent.getFont());
            this.treeViewer.setContentProvider((IContentProvider)new ContentProvider());
            this.treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            this.treeViewer.setCheckStateProvider((ICheckStateProvider)new CheckStateProvider());
            table.setHeaderVisible(true);
            table.setLayoutData((Object)new GridData(1808));
            TreeColumn col1 = new TreeColumn(table, 0);
            col1.setText(LaunchMessages.getString("MultiLaunchConfigurationTabGroup.6"));
            col1.setWidth(300);
            TreeColumn col2 = new TreeColumn(table, 0);
            col2.setText(LaunchMessages.getString("MultiLaunchConfigurationTabGroup.7"));
            col2.setWidth(100);
            TreeColumn col3 = new TreeColumn(table, 0);
            col3.setText(LaunchMessages.getString("MultiLaunchConfigurationTabGroup.12"));
            col3.setWidth(100);
            this.treeViewer.setInput(this.input);
            final ButtonComposite buts = new ButtonComposite(comp, 0){

                protected void addPressed() {
                    MultiLaunchConfigurationSelectionDialog dialog = MultiLaunchConfigurationSelectionDialog.createDialog(GroupLaunchTab.this.treeViewer.getControl().getShell(), GroupLaunchTab.this.mode, false);
                    if (dialog.open() == 0) {
                        ILaunchConfiguration[] configs = dialog.getSelectedLaunchConfigurations();
                        if (configs.length < 1) {
                            return;
                        }
                        ILaunchConfiguration[] iLaunchConfigurationArray = configs;
                        int n = configs.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                            MultiLaunchConfigurationDelegate.LaunchElement el = new MultiLaunchConfigurationDelegate.LaunchElement();
                            GroupLaunchTab.this.input.add(el);
                            el.index = GroupLaunchTab.this.input.size() - 1;
                            el.enabled = true;
                            el.name = config.getName();
                            el.data = config;
                            el.mode = dialog.getMode();
                            el.action = dialog.getAction();
                            el.actionParam = dialog.getActionParam();
                            GroupLaunchTab.this.treeViewer.refresh(true);
                            GroupLaunchTab.this.treeViewer.setChecked((Object)el, el.enabled);
                            ++n2;
                        }
                        this.updateWidgetEnablement();
                        GroupLaunchTab.this.updateLaunchConfigurationDialog();
                    }
                }

                protected void updateWidgetEnablement() {
                    this.downButton.setEnabled(this.isDownEnabled());
                    this.upButton.setEnabled(this.isUpEnabled());
                    int selectionCount = this.getSelectionCount();
                    this.editButton.setEnabled(selectionCount == 1);
                    this.deleteButton.setEnabled(selectionCount > 0);
                }

                protected void editPressed() {
                    int index = this.getSingleSelectionIndex();
                    if (index < 0) {
                        return;
                    }
                    MultiLaunchConfigurationDelegate.LaunchElement el = GroupLaunchTab.this.input.get(index);
                    MultiLaunchConfigurationSelectionDialog dialog = MultiLaunchConfigurationSelectionDialog.createDialog(GroupLaunchTab.this.treeViewer.getControl().getShell(), el.mode, true);
                    if (MultiLaunchConfigurationDelegate.isValidLaunchReference(el.data)) {
                        dialog.setInitialSelection(el);
                    }
                    if (dialog.open() == 0) {
                        ILaunchConfiguration[] confs = dialog.getSelectedLaunchConfigurations();
                        if (confs.length < 0) {
                            return;
                        }
                        if (!$assertionsDisabled && confs.length != 1) {
                            throw new AssertionError((Object)"invocation of the dialog for editing an entry sholdn't allow OK to be hit if the user chooses multiple launch configs in the dialog");
                        }
                        el.name = confs[0].getName();
                        el.data = confs[0];
                        el.mode = dialog.getMode();
                        el.action = dialog.getAction();
                        el.actionParam = dialog.getActionParam();
                        GroupLaunchTab.this.treeViewer.refresh(true);
                        this.updateWidgetEnablement();
                        GroupLaunchTab.this.updateLaunchConfigurationDialog();
                    }
                }

                protected void deletePressed() {
                    int[] indices = this.getMultiSelectionIndices();
                    if (indices.length < 1) {
                        return;
                    }
                    int i = indices.length - 1;
                    while (i >= 0) {
                        GroupLaunchTab.this.input.remove(indices[i]);
                        --i;
                    }
                    GroupLaunchTab.this.treeViewer.refresh(true);
                    this.updateWidgetEnablement();
                    GroupLaunchTab.this.updateLaunchConfigurationDialog();
                }

                private int getSingleSelectionIndex() {
                    StructuredSelection sel = (StructuredSelection)GroupLaunchTab.this.treeViewer.getSelection();
                    if (sel.size() != 1) {
                        return -1;
                    }
                    MultiLaunchConfigurationDelegate.LaunchElement el = (MultiLaunchConfigurationDelegate.LaunchElement)sel.getFirstElement();
                    return GroupLaunchTab.this.input.indexOf(el);
                }

                private int[] getMultiSelectionIndices() {
                    StructuredSelection sel = (StructuredSelection)GroupLaunchTab.this.treeViewer.getSelection();
                    ArrayList<Integer> indices = new ArrayList<Integer>();
                    for (MultiLaunchConfigurationDelegate.LaunchElement el : sel) {
                        indices.add(GroupLaunchTab.this.input.indexOf(el));
                    }
                    int[] result = new int[indices.size()];
                    int i = 0;
                    while (i < result.length) {
                        result[i] = (Integer)indices.get(i);
                        ++i;
                    }
                    return result;
                }

                private int getSelectionCount() {
                    return ((StructuredSelection)GroupLaunchTab.this.treeViewer.getSelection()).size();
                }

                protected void downPressed() {
                    if (!this.isDownEnabled()) {
                        return;
                    }
                    int index = this.getSingleSelectionIndex();
                    MultiLaunchConfigurationDelegate.LaunchElement x = GroupLaunchTab.this.input.get(index);
                    GroupLaunchTab.this.input.set(index, GroupLaunchTab.this.input.get(index + 1));
                    GroupLaunchTab.this.input.set(index + 1, x);
                    GroupLaunchTab.this.treeViewer.refresh(true);
                    this.updateWidgetEnablement();
                    GroupLaunchTab.this.updateLaunchConfigurationDialog();
                }

                protected boolean isDownEnabled() {
                    int index = this.getSingleSelectionIndex();
                    return index >= 0 && index != GroupLaunchTab.this.input.size() - 1;
                }

                protected boolean isUpEnabled() {
                    return this.getSingleSelectionIndex() > 0;
                }

                protected void upPressed() {
                    if (!this.isUpEnabled()) {
                        return;
                    }
                    int index = this.getSingleSelectionIndex();
                    MultiLaunchConfigurationDelegate.LaunchElement x = GroupLaunchTab.this.input.get(index);
                    GroupLaunchTab.this.input.set(index, GroupLaunchTab.this.input.get(index - 1));
                    GroupLaunchTab.this.input.set(index - 1, x);
                    GroupLaunchTab.this.treeViewer.refresh(true);
                    this.updateWidgetEnablement();
                    GroupLaunchTab.this.updateLaunchConfigurationDialog();
                }
            };
            this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    buts.updateWidgetEnablement();
                }
            });
            this.treeViewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    buts.editPressed();
                }
            });
            this.treeViewer.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    ((MultiLaunchConfigurationDelegate.LaunchElement)event.getElement()).enabled = event.getChecked();
                    GroupLaunchTab.this.updateLaunchConfigurationDialog();
                }
            });
            buts.updateWidgetEnablement();
            GridData layoutData = new GridData(1024);
            layoutData.verticalAlignment = 1;
            buts.setLayoutData(layoutData);
        }

        public String getName() {
            return LaunchMessages.getString("MultiLaunchConfigurationTabGroup.10");
        }

        public void initializeFrom(ILaunchConfiguration configuration) {
            MultiLaunchConfigurationDelegate.createLaunchElements(configuration, this.input);
            if (this.treeViewer != null) {
                this.treeViewer.refresh(true);
            }
        }

        public void performApply(ILaunchConfigurationWorkingCopy configuration) {
            MultiLaunchConfigurationDelegate.storeLaunchElements(configuration, this.input);
        }

        public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        }

        public boolean isValid(ILaunchConfiguration launchConfig) {
            this.setMessage(null);
            this.setErrorMessage(null);
            int validLaunches = 0;
            for (MultiLaunchConfigurationDelegate.LaunchElement element : this.input) {
                if (!element.enabled) continue;
                if (element.data == null) {
                    this.setErrorMessage(MessageFormat.format(LaunchMessages.getString("MultiLaunchConfigurationTabGroup.14"), element.name));
                    return false;
                }
                if (!MultiLaunchConfigurationDelegate.isValidLaunchReference(element.data)) {
                    this.setErrorMessage(MessageFormat.format(LaunchMessages.getString("MultiLaunchConfigurationTabGroup.15"), element.name));
                    return false;
                }
                ++validLaunches;
            }
            if (validLaunches < 1) {
                this.setErrorMessage(LaunchMessages.getString("MultiLaunchConfigurationTabGroup.16"));
                return false;
            }
            return true;
        }
    }

    static class LabelProvider
    extends BaseLabelProvider
    implements ITableLabelProvider {
        LabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (!(element instanceof MultiLaunchConfigurationDelegate.LaunchElement)) {
                return null;
            }
            if (columnIndex == 0) {
                MultiLaunchConfigurationDelegate.LaunchElement el = (MultiLaunchConfigurationDelegate.LaunchElement)element;
                if (el.data == null || !MultiLaunchConfigurationDelegate.isValidLaunchReference(el.data)) {
                    Image errorImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
                    return errorImage;
                }
                try {
                    String key = el.data.getType().getIdentifier();
                    return DebugPluginImages.getImage((String)key);
                }
                catch (CoreException coreException) {
                    Image errorImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
                    return errorImage;
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof MultiLaunchConfigurationDelegate.LaunchElement)) {
                return null;
            }
            MultiLaunchConfigurationDelegate.LaunchElement el = (MultiLaunchConfigurationDelegate.LaunchElement)element;
            if (columnIndex == 0) {
                try {
                    return el.data != null ? String.valueOf(el.data.getType().getName()) + "::" + el.name : el.name;
                }
                catch (CoreException coreException) {
                    return el.name;
                }
            }
            if (columnIndex == 1) {
                return el.mode;
            }
            if (columnIndex == 2) {
                MultiLaunchConfigurationDelegate.LaunchElement.EPostLaunchAction action = el.action;
                switch (action) {
                    case NONE: {
                        return "";
                    }
                    case WAIT_FOR_TERMINATION: {
                        return LaunchMessages.getString("MultiLaunchConfigurationDelegate.Action.WaitUntilTerminated");
                    }
                    case DELAY: {
                        Object actionParam = el.actionParam;
                        return LaunchMessages.getFormattedString("MultiLaunchConfigurationTabGroup.13", actionParam instanceof Integer ? Integer.toString((Integer)actionParam) : "?");
                    }
                }
                assert (false) : "new post launch action missing logic here";
                return "";
            }
            return null;
        }
    }
}

