/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.internal.ui;

import java.text.MessageFormat;
import org.eclipse.cdt.launch.internal.ui.LaunchMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;

public class BuildErrPrompter
implements IStatusHandler {
    public static final int STATUS_CODE_ERR_IN_MAIN_PROJ = 1002;
    public static final int STATUS_CODE_ERR_IN_REFERENCED_PROJS = 1003;

    public Object handleStatus(IStatus status, Object source) throws CoreException {
        String message;
        if (!(source instanceof Object[])) {
            assert (false) : "status handler not given expected arguments";
            return Boolean.TRUE;
        }
        Object[] args = (Object[])source;
        if (!(args.length == 3 && args[0] instanceof ILaunchConfiguration && args[1] instanceof String && args[2] instanceof String)) {
            assert (false) : "status handler not given expected arguments";
            return Boolean.TRUE;
        }
        ILaunchConfiguration launchConfig = (ILaunchConfiguration)args[0];
        String projectName = (String)args[1];
        String buildConfigName = (String)args[2];
        if (DebugUITools.isPrivate((ILaunchConfiguration)launchConfig)) {
            return Boolean.TRUE;
        }
        Shell shell = DebugUIPlugin.getShell();
        String title = LaunchConfigurationsMessages.CompileErrorPromptStatusHandler_0;
        if (status.getCode() == 1002) {
            message = buildConfigName.length() > 0 ? MessageFormat.format(LaunchMessages.getString("BuildErrPrompter.error_in_specific_config"), projectName, buildConfigName) : MessageFormat.format(LaunchMessages.getString("BuildErrPrompter.error_in_active_config"), projectName);
        } else if (status.getCode() == 1003) {
            message = buildConfigName.length() > 0 ? MessageFormat.format(LaunchMessages.getString("BuildErrPrompter.error_in_referenced_project_specific"), projectName, buildConfigName) : MessageFormat.format(LaunchMessages.getString("BuildErrPrompter.error_in_referenced_project_active"), projectName);
        } else {
            assert (false) : "this prompter was called for an unexpected status";
            return Boolean.TRUE;
        }
        IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
        String pref = store.getString("org.eclipse.debug.ui.cancel_launch_with_compile_errors");
        if (pref != null && pref.equals("always")) {
            return Boolean.TRUE;
        }
        MessageDialogWithToggle dialog = new MessageDialogWithToggle(shell, title, null, message, 3, new String[]{IDialogConstants.PROCEED_LABEL, IDialogConstants.CANCEL_LABEL}, 0, LaunchConfigurationsMessages.CompileErrorProjectPromptStatusHandler_1, false);
        int open = dialog.open();
        if (open == 10) {
            if (dialog.getToggleState()) {
                store.setValue("org.eclipse.debug.ui.cancel_launch_with_compile_errors", "always");
            }
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

