/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.core;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CommandLauncher;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.resources.ACBuilder;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.internal.core.ConsoleOutputSniffer;
import org.eclipse.cdt.make.core.IMakeBuilderInfo;
import org.eclipse.cdt.make.core.MakeBuilderUtil;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.internal.core.MakeMessages;
import org.eclipse.cdt.make.internal.core.StreamMonitor;
import org.eclipse.cdt.make.internal.core.scannerconfig.ScannerInfoConsoleParserFactory;
import org.eclipse.cdt.utils.CommandLineUtil;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public class MakeBuilder
extends ACBuilder {
    public static final String BUILDER_ID = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".makeBuilder";

    protected IProject[] build(int kind, Map args0, IProgressMonitor monitor) throws CoreException {
        boolean isClean;
        Map args = args0;
        boolean bPerformBuild = true;
        IMakeBuilderInfo info = MakeCorePlugin.createBuildInfo(args, BUILDER_ID);
        if (!this.shouldBuild(kind, info)) {
            return new IProject[0];
        }
        if (kind == 9) {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta != null) {
                IResource res = delta.getResource();
                if (res != null) {
                    bPerformBuild = res.getProject().equals((Object)this.getProject());
                }
            } else {
                bPerformBuild = false;
            }
        }
        if (bPerformBuild && (isClean = this.invokeMake(kind, info, monitor))) {
            this.forgetLastBuiltState();
        }
        this.checkCancel(monitor);
        return this.getProject().getReferencedProjects();
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        final IMakeBuilderInfo info = MakeCorePlugin.createBuildInfo(this.getProject(), BUILDER_ID);
        if (this.shouldBuild(15, info)) {
            IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
            final ISchedulingRule rule = ruleFactory.modifyRule((IResource)this.getProject());
            Job backgroundJob = new Job("Standard Make Builder"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                            public void run(IProgressMonitor monitor) {
                                MakeBuilder.this.invokeMake(15, info, monitor);
                            }
                        }, rule, 1, monitor);
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                    IStatus returnStatus = Status.OK_STATUS;
                    return returnStatus;
                }
            };
            backgroundJob.setRule(rule);
            backgroundJob.schedule();
        }
    }

    protected boolean invokeMake(int kind, IMakeBuilderInfo info, IProgressMonitor monitor) {
        boolean isClean;
        block21: {
            isClean = false;
            IProject currProject = this.getProject();
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask(String.valueOf(MakeMessages.getString("MakeBuilder.Invoking_Make_Builder")) + currProject.getName(), 100);
            try {
                try {
                    StreamMonitor streamMon;
                    IPath buildCommand = info.getBuildCommand();
                    if (buildCommand == null) break block21;
                    IConsole console = CCorePlugin.getDefault().getConsole();
                    console.start(currProject);
                    ConsoleOutputStream cos = console.getOutputStream();
                    this.removeAllMarkers(currProject);
                    IPath workingDirectory = MakeBuilderUtil.getBuildDirectory(currProject, info);
                    URI workingDirectoryURI = MakeBuilderUtil.getBuildDirectoryURI(currProject, info);
                    String[] targets = this.getTargets(kind, info);
                    if (targets.length != 0 && targets[targets.length - 1].equals(info.getCleanBuildTarget())) {
                        isClean = true;
                    }
                    String errMsg = null;
                    CommandLauncher launcher = new CommandLauncher();
                    launcher.setProject(currProject);
                    launcher.showCommand(true);
                    HashMap<Object, Object> envMap = new HashMap<Object, Object>();
                    if (info.appendEnvironment()) {
                        Properties env = launcher.getEnvironment();
                        envMap.putAll(env);
                    }
                    envMap.putAll(info.getExpandedEnvironment());
                    ArrayList<String> strings = new ArrayList<String>(envMap.size());
                    Set entrySet = envMap.entrySet();
                    for (Map.Entry entry : entrySet) {
                        StringBuffer buffer = new StringBuffer((String)entry.getKey());
                        buffer.append('=').append((String)entry.getValue());
                        strings.add(buffer.toString());
                    }
                    String[] env = strings.toArray(new String[strings.size()]);
                    String[] buildArguments = targets;
                    if (info.isDefaultBuildCmd()) {
                        if (!info.isStopOnError()) {
                            buildArguments = new String[targets.length + 1];
                            buildArguments[0] = "-k";
                            System.arraycopy(targets, 0, buildArguments, 1, targets.length);
                        }
                    } else {
                        String args = info.getBuildArguments();
                        if (args != null && !args.equals("")) {
                            String[] newArgs = this.makeArray(args);
                            buildArguments = new String[targets.length + newArgs.length];
                            System.arraycopy(newArgs, 0, buildArguments, 0, newArgs.length);
                            System.arraycopy(targets, 0, buildArguments, newArgs.length, targets.length);
                        }
                    }
                    QualifiedName qName = new QualifiedName(MakeCorePlugin.getUniqueIdentifier(), "progressMonitor");
                    Integer last = (Integer)this.getProject().getSessionProperty(qName);
                    if (last == null) {
                        last = new Integer(100);
                    }
                    ErrorParserManager epm = new ErrorParserManager(this.getProject(), workingDirectoryURI, (IMarkerGenerator)this, info.getErrorParsers());
                    epm.setOutputStream((OutputStream)cos);
                    StreamMonitor stdout = streamMon = new StreamMonitor((IProgressMonitor)new SubProgressMonitor(monitor, 100), (OutputStream)epm, last);
                    StreamMonitor stderr = streamMon;
                    ConsoleOutputSniffer sniffer = ScannerInfoConsoleParserFactory.getMakeBuilderOutputSniffer(stdout, stderr, this.getProject(), workingDirectory, null, (IMarkerGenerator)this, null);
                    OutputStream consoleOut = sniffer == null ? stdout : sniffer.getOutputStream();
                    OutputStream consoleErr = sniffer == null ? stderr : sniffer.getErrorStream();
                    Process p = launcher.execute(buildCommand, buildArguments, env, workingDirectory, monitor);
                    if (p != null) {
                        try {
                            p.getOutputStream().close();
                        }
                        catch (IOException iOException) {}
                        monitor.subTask(String.valueOf(MakeMessages.getString("MakeBuilder.Invoking_Command")) + launcher.getCommandLine());
                        if (launcher.waitAndRead(consoleOut, consoleErr, (IProgressMonitor)new SubProgressMonitor(monitor, 0)) != 0) {
                            errMsg = launcher.getErrorMessage();
                        }
                        monitor.subTask(MakeMessages.getString("MakeBuilder.Updating_project"));
                        this.refreshProject(currProject);
                    } else {
                        errMsg = launcher.getErrorMessage();
                    }
                    this.getProject().setSessionProperty(qName, !monitor.isCanceled() && !isClean ? new Integer(streamMon.getWorkDone()) : null);
                    if (errMsg != null) {
                        StringBuffer buf = new StringBuffer(String.valueOf(buildCommand.toString()) + " ");
                        String[] stringArray = buildArguments;
                        int n = buildArguments.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String buildArgument = stringArray[n2];
                            buf.append(buildArgument);
                            buf.append(' ');
                            ++n2;
                        }
                        String errorDesc = MakeMessages.getFormattedString("MakeBuilder.buildError", buf.toString());
                        buf = new StringBuffer(errorDesc);
                        buf.append(System.getProperty("line.separator", "\n"));
                        buf.append("(").append(errMsg).append(")");
                        cos.write(buf.toString().getBytes());
                        cos.flush();
                    }
                    ((OutputStream)stdout).close();
                    ((OutputStream)stderr).close();
                    monitor.subTask(MakeMessages.getString("MakeBuilder.Creating_Markers"));
                    consoleOut.close();
                    consoleErr.close();
                    cos.close();
                }
                catch (Exception e) {
                    MakeCorePlugin.log(e);
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }
        return isClean;
    }

    protected void refreshProject(IProject project) {
        try {
            project.refreshLocal(2, null);
        }
        catch (CoreException e) {
            MakeCorePlugin.log(e);
        }
    }

    public void checkCancel(IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected boolean shouldBuild(int kind, IMakeBuilderInfo info) {
        switch (kind) {
            case 9: {
                return info.isAutoBuildEnable();
            }
            case 6: 
            case 10: {
                return info.isFullBuildEnabled() | info.isIncrementalBuildEnabled();
            }
            case 15: {
                return info.isCleanBuildEnabled();
            }
        }
        return true;
    }

    protected String[] getTargets(int kind, IMakeBuilderInfo info) {
        String targets = "";
        switch (kind) {
            case 9: {
                targets = info.getAutoBuildTarget();
                break;
            }
            case 6: 
            case 10: {
                targets = info.getIncrementalBuildTarget();
                break;
            }
            case 15: {
                targets = info.getCleanBuildTarget();
            }
        }
        return this.makeArray(targets);
    }

    private String[] makeArray(String string) {
        return CommandLineUtil.argumentsToArray((String)string);
    }

    private void removeAllMarkers(IProject currProject) throws CoreException {
        IWorkspace workspace = currProject.getWorkspace();
        IMarker[] markers = currProject.findMarkers("org.eclipse.cdt.core.problem", true, 2);
        if (markers != null) {
            workspace.deleteMarkers(markers);
        }
    }
}

