/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.actions;

import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.part.EditorPart;

public abstract class AbstractTargetAction
extends ActionDelegate
implements IObjectActionDelegate,
IWorkbenchWindowActionDelegate {
    private IWorkbenchPart fPart;
    private IWorkbenchWindow fWindow;
    private boolean isEnabled;
    protected IContainer fContainer;

    protected Shell getShell() {
        if (this.fPart != null) {
            return this.fPart.getSite().getShell();
        }
        if (this.fWindow != null) {
            return this.fWindow.getShell();
        }
        return MakeUIPlugin.getActiveWorkbenchShell();
    }

    protected IContainer getSelectedContainer() {
        return this.fContainer;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fPart = targetPart;
    }

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.isEnabled = false;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            Object obj = sel.getFirstElement();
            if (obj instanceof ICElement) {
                if (obj instanceof ICContainer || obj instanceof ICProject) {
                    this.fContainer = (IContainer)((ICElement)obj).getUnderlyingResource();
                } else if ((obj = ((ICElement)obj).getResource()) != null) {
                    this.fContainer = ((IResource)obj).getParent();
                }
            } else {
                this.fContainer = obj instanceof IResource ? (obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent()) : (obj instanceof IMakeTarget ? ((IMakeTarget)obj).getContainer() : null);
            }
        } else if (selection instanceof ITextSelection) {
            IFile file;
            IWorkbenchPart part;
            this.fContainer = null;
            IWorkbenchPart iWorkbenchPart = part = this.fPart != null ? this.fPart : this.fWindow.getActivePage().getActivePart();
            if (part instanceof TextEditor && (file = ResourceUtil.getFile((IEditorInput)((EditorPart)part).getEditorInput())) != null) {
                this.fContainer = file.getParent();
            }
        }
        if (this.fContainer != null && MakeCorePlugin.getDefault().getTargetManager().hasTargetBuilder(this.fContainer.getProject())) {
            this.isEnabled = true;
        }
        if (action != null) {
            action.setEnabled(this.isEnabled);
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }
}

