/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core.tests;

import java.util.Iterator;
import java.util.Properties;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElementProvider;
import org.eclipse.cdt.managedbuilder.core.tests.TestConfigElement;

public class TestManagedConfigProvider
implements IManagedConfigElementProvider {
    public IManagedConfigElement[] getConfigElements() {
        try {
            Properties props = new Properties();
            props.load(this.getClass().getResourceAsStream("test_commands"));
            IManagedConfigElement[] ret = new IManagedConfigElement[props.size()];
            Iterator<Object> it = props.keySet().iterator();
            int i = 0;
            while (it.hasNext()) {
                String targetId = (String)it.next();
                String command = props.getProperty(targetId);
                ret[i++] = this.createTarget(targetId, command);
            }
            return ret;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new IManagedConfigElement[0];
        }
    }

    private IManagedConfigElement createTarget(String targetId, String command) {
        TestConfigElement toolRef = new TestConfigElement("toolReference", new String[][]{{"id", "test.forward.tool"}, {"command", command}}, new IManagedConfigElement[0]);
        TestConfigElement config = new TestConfigElement("configuration", new String[][]{{"id", String.valueOf(targetId) + ".config"}, {"name", "test.forward.config"}}, new IManagedConfigElement[]{toolRef});
        TestConfigElement target = new TestConfigElement("target", new String[][]{{"id", targetId}, {"name", targetId.substring(targetId.lastIndexOf(46) + 1).replace('_', ' ')}, {"parent", "test.forward.parent.target"}, {"isTest", "true"}, {"osList", "win32,linux,solaris"}}, new IManagedConfigElement[]{config});
        return target;
    }
}

