/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.build.internal.core.scannerconfig;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.build.core.scannerconfig.CfgInfoContext;
import org.eclipse.cdt.build.core.scannerconfig.ICfgScannerConfigBuilderInfo2Set;
import org.eclipse.cdt.build.core.scannerconfig.ScannerConfigBuilder;
import org.eclipse.cdt.build.internal.core.scannerconfig.CfgScannerConfigUtil;
import org.eclipse.cdt.build.internal.core.scannerconfig.PerFileSettingsCalculator;
import org.eclipse.cdt.build.internal.core.scannerconfig2.CfgScannerConfigProfileManager;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.core.settings.model.extension.CFolderData;
import org.eclipse.cdt.core.settings.model.extension.CResourceData;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IDiscoveredPathManager;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector2;
import org.eclipse.cdt.make.core.scannerconfig.PathInfo;
import org.eclipse.cdt.make.internal.core.scannerconfig.DiscoveredScannerInfoStore;
import org.eclipse.cdt.make.internal.core.scannerconfig2.PerFileSICollector;
import org.eclipse.cdt.make.internal.core.scannerconfig2.SCProfileInstance;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFileInfo;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.FolderInfo;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.BuildFileData;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.BuildFolderData;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.BuildLanguageData;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;

public class CfgDiscoveredPathManager
implements IResourceChangeListener {
    public static CfgDiscoveredPathManager fInstance;
    private IDiscoveredPathManager fBaseMngr;
    private ILock lock = Job.getJobManager().newLock();

    private CfgDiscoveredPathManager() {
        this.fBaseMngr = MakeCorePlugin.getDefault().getDiscoveryManager();
    }

    public static CfgDiscoveredPathManager getInstance() {
        if (fInstance == null) {
            fInstance = new CfgDiscoveredPathManager();
            fInstance.startup();
        }
        return fInstance;
    }

    public static void stop() {
        if (fInstance != null) {
            fInstance.shutdown();
        }
    }

    public void startup() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void shutdown() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getSource() instanceof IWorkspace) {
            IResource resource = event.getResource();
            switch (event.getType()) {
                case 1: {
                    break;
                }
                case 2: 
                case 4: {
                    resource.getType();
                }
            }
        }
    }

    public void updateCoreSettings(final IProject project, final IConfiguration[] cfgs) {
        try {
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    ManagedBuildManager.updateCoreSettings(project, cfgs, true);
                }
            };
            CoreModel.run((IWorkspaceRunnable)runnable, null);
        }
        catch (CoreException e) {
            ManagedBuilderCorePlugin.log(e);
        }
    }

    public PathInfo getDiscoveredInfo(IProject project, CfgInfoContext context) throws CoreException {
        ContextInfo cInfo = this.getContextInfo(context);
        PathInfo info = this.getCachedPathInfo(cInfo);
        if (info == null) {
            try {
                this.lock.acquire();
                info = this.getCachedPathInfo(cInfo);
                if (info == null) {
                    IDiscoveredPathManager.IDiscoveredPathInfo baseInfo = this.loadPathInfo(project, context.getConfiguration(), cInfo);
                    info = this.resolveCacheBaseDiscoveredInfo(cInfo, baseInfo);
                }
            }
            finally {
                this.lock.release();
            }
        }
        return info;
    }

    private PathInfo resolveCacheBaseDiscoveredInfo(ContextInfo cInfo, IDiscoveredPathManager.IDiscoveredPathInfo baseInfo) {
        if (cInfo.fIsPerFileCache) {
            if (baseInfo instanceof IDiscoveredPathManager.IPerFileDiscoveredPathInfo2) {
                this.resolveCachePerFileInfo(cInfo, (IDiscoveredPathManager.IPerFileDiscoveredPathInfo2)baseInfo);
            }
            return this.getCachedPathInfo(cInfo);
        }
        ((FolderInfo)cInfo.fLoadContext.getConfiguration().getRootFolderInfo()).setContainsDiscoveredScannerInfo(true);
        Map map = baseInfo.getSymbols();
        IPath[] paths = baseInfo.getIncludePaths();
        PathInfo info = new PathInfo(paths, null, map, null, null);
        this.setCachedPathInfo(cInfo, info);
        return info;
    }

    private void resolveCachePerFileInfo(ContextInfo cInfo, IDiscoveredPathManager.IPerFileDiscoveredPathInfo2 info) {
        CResourceData rcData;
        CConfigurationData data = cInfo.fLoadContext.getConfiguration().getConfigurationData();
        if (data == null) {
            return;
        }
        PerFileSettingsCalculator calculator = new PerFileSettingsCalculator();
        PerFileSettingsCalculator.IRcSettingInfo[] rcInfos = calculator.getSettingInfos(cInfo.fLoadContext.getConfiguration().getOwner().getProject(), data, info, true);
        CResourceData[] rcDatas = data.getResourceDatas();
        HashMap<IPath, CResourceData> rcDataMap = new HashMap<IPath, CResourceData>();
        int i = 0;
        while (i < rcDatas.length) {
            rcData = rcDatas[i];
            rcDataMap.put(rcData.getPath(), rcData);
            ++i;
        }
        boolean rootSettingFound = false;
        boolean fileSettingFound = false;
        int i2 = 0;
        while (i2 < rcInfos.length) {
            PerFileSettingsCalculator.IRcSettingInfo rcInfo = rcInfos[i2];
            rcData = rcInfo.getResourceData();
            IPath path = rcData.getPath();
            if (path.segmentCount() != 0) {
                fileSettingFound = true;
            } else {
                rootSettingFound = true;
            }
            rcDataMap.remove(path);
            this.cache(cInfo, rcInfo);
            ++i2;
        }
        if (rootSettingFound && fileSettingFound) {
            ((BuildFolderData)data.getRootFolderData()).setContainsDiscoveredScannerInfo(false);
        }
        if (!rcDataMap.isEmpty()) {
            for (CResourceData tmpRcData : rcDataMap.values()) {
                if (tmpRcData.getPath().segmentCount() == 0 && tmpRcData.getType() == 4) {
                    this.cache(cInfo, PerFileSettingsCalculator.createEmptyRcSettingInfo((CFolderData)tmpRcData));
                    continue;
                }
                this.clearCache(tmpRcData);
            }
        }
    }

    private void cache(ContextInfo cInfo, PerFileSettingsCalculator.IRcSettingInfo rcSetting) {
        CResourceData rcData = rcSetting.getResourceData();
        this.clearCache(rcData);
        PerFileSettingsCalculator.ILangSettingInfo[] lInfos = rcSetting.getLangInfos();
        int i = 0;
        while (i < lInfos.length) {
            this.cache(cInfo, lInfos[i]);
            ++i;
        }
    }

    private void cache(ContextInfo cInfo, PerFileSettingsCalculator.ILangSettingInfo lInfo) {
        BuildLanguageData bld = (BuildLanguageData)lInfo.getLanguageData();
        this.setCachedPathInfo(cInfo, (Configuration)bld.getConfiguration(), (Tool)bld.getTool(), bld.getInputType(), lInfo.getFilePathInfo());
    }

    private void clearCache(CResourceData rcData) {
        if (rcData.getType() == 8) {
            IFileInfo fiInfo = ((BuildFileData)rcData).getFileInfo();
            ITool[] tools = fiInfo.getTools();
            this.clearCache(tools);
        } else {
            IFolderInfo foInfo = ((BuildFolderData)rcData).getFolderInfo();
            ITool[] tools = foInfo.getTools();
            this.clearCache(tools);
        }
    }

    private void clearCache(ITool[] tools) {
        int i = 0;
        while (i < tools.length) {
            ((Tool)tools[i]).clearAllDiscoveredInfo();
            ++i;
        }
    }

    private IDiscoveredPathManager.IDiscoveredPathInfo loadPathInfo(IProject project, IConfiguration cfg, ContextInfo cInfo) throws CoreException {
        IScannerInfoCollector newC;
        SCProfileInstance instance;
        ICfgScannerConfigBuilderInfo2Set container;
        IScannerConfigBuilderInfo2 buildInfo;
        IDiscoveredPathManager.IDiscoveredPathInfo info = this.fBaseMngr.getDiscoveredInfo(cfg.getOwner().getProject(), cInfo.fLoadContext.toInfoContext(), false);
        if (!DiscoveredScannerInfoStore.getInstance().hasInfo(project, cInfo.fLoadContext.toInfoContext(), info.getSerializable()) && (buildInfo = (container = cInfo.fCfgInfo).getInfo(cInfo.fLoadContext)) != null && (instance = ScannerConfigBuilder.build(cInfo.fLoadContext, buildInfo, 0, null, (IProgressMonitor)new NullProgressMonitor())) != null && (newC = instance.getScannerInfoCollector()) instanceof IScannerInfoCollector2 && !(newC instanceof PerFileSICollector)) {
            info = ((IScannerInfoCollector2)newC).createPathInfoObject();
        }
        return info;
    }

    private PathInfo getCachedPathInfo(ContextInfo cInfo) {
        PathInfo info = this.getCachedPathInfo(cInfo, true, true, false);
        return info;
    }

    private void removeCachedPathInfo(ContextInfo cInfo) {
        if (cInfo.fIsPerFileCache) {
            Configuration cfg = (Configuration)cInfo.fInitialContext.getConfiguration();
            cfg.clearDiscoveredPathInfo();
            IResourceInfo[] infos = cfg.getResourceInfos();
            int i = 0;
            while (i < infos.length) {
                IResourceInfo rcInfo = infos[i];
                ITool[] tools = rcInfo.getTools();
                int k = 0;
                while (k < tools.length) {
                    Tool tool = (Tool)tools[k];
                    tool.clearAllDiscoveredPathInfo();
                    ++k;
                }
                ++i;
            }
        } else {
            this.setCachedPathInfo(cInfo, null);
        }
    }

    private PathInfo getCachedPathInfo(ContextInfo cInfo, boolean queryParent, boolean clearIfInvalid, boolean clear) {
        return this.getCachedPathInfo(cInfo, (Configuration)cInfo.fCacheContext.getConfiguration(), (Tool)cInfo.fCacheContext.getTool(), cInfo.fCacheContext.getInputType(), queryParent, clearIfInvalid, clear);
    }

    private PathInfo getCachedPathInfo(ContextInfo cInfo, Configuration cfg, Tool tool, IInputType inType, boolean queryParent, boolean clearIfInvalid, boolean clear) {
        PathInfoCache infoCache = this.getPathInfoCache(cInfo, cfg, tool, inType, queryParent, clearIfInvalid, clear);
        if (infoCache != null && this.isCacheValid(cInfo, infoCache)) {
            return infoCache.fPathInfo;
        }
        return null;
    }

    private PathInfoCache getPathInfoCache(ContextInfo cInfo, Configuration cfg, Tool tool, IInputType inType, boolean queryParent, boolean clearIfInvalid, boolean clear) {
        PathInfoCache info = null;
        if (tool != null) {
            info = tool.getDiscoveredPathInfo(inType);
            if (info != null) {
                if (clear || clearIfInvalid && !this.isCacheValid(cInfo, info)) {
                    tool.clearDiscoveredPathInfo(inType);
                }
            } else if (queryParent) {
                ITool superTool = tool.getSuperClass();
                if (!superTool.isExtensionElement()) {
                    if (inType != null) {
                        IInputType superInType = null;
                        String[] exts = inType.getSourceExtensions(tool);
                        int i = 0;
                        while (i < exts.length) {
                            superInType = superTool.getInputType(exts[i]);
                            if (superInType != null) break;
                            ++i;
                        }
                        if (superInType != null) {
                            info = this.getPathInfoCache(cInfo, cfg, (Tool)superTool, superInType, true, clearIfInvalid, clear);
                        }
                    } else {
                        info = this.getPathInfoCache(cInfo, cfg, (Tool)superTool, null, true, clearIfInvalid, clear);
                    }
                } else {
                    info = this.getPathInfoCache(cInfo, cfg, null, null, true, clearIfInvalid, clear);
                }
            }
        } else {
            info = cfg.getDiscoveredPathInfo();
            if (clear || clearIfInvalid && !this.isCacheValid(cInfo, info)) {
                cfg.clearDiscoveredPathInfo();
            }
        }
        return info;
    }

    private boolean isCacheValid(ContextInfo cInfo, PathInfoCache cache) {
        if (cache == null) {
            return true;
        }
        if (cInfo.fInfo != null) {
            String id = cInfo.fInfo.getSelectedProfileId();
            return id.equals(cache.fProfileId);
        }
        return false;
    }

    private ContextInfo getContextInfo(CfgInfoContext context) {
        return this.getContextInfo(context, null);
    }

    private ContextInfo getContextInfo(CfgInfoContext context, ICfgScannerConfigBuilderInfo2Set cfgInfo) {
        if (cfgInfo == null) {
            cfgInfo = CfgScannerConfigProfileManager.getCfgScannerConfigBuildInfo(context.getConfiguration());
        }
        boolean isPerRcType = cfgInfo.isPerRcTypeDiscovery();
        ContextInfo contextInfo = new ContextInfo();
        contextInfo.fInitialContext = context;
        contextInfo.fCfgInfo = cfgInfo;
        if (isPerRcType) {
            contextInfo.fCacheContext = contextInfo.fLoadContext = CfgScannerConfigUtil.adjustPerRcTypeContext(contextInfo.fInitialContext);
            contextInfo.fIsPerFileCache = false;
            contextInfo.fInfo = cfgInfo.getInfo(contextInfo.fLoadContext);
        } else {
            contextInfo.fLoadContext = new CfgInfoContext(context.getConfiguration());
            contextInfo.fInfo = cfgInfo.getInfo(contextInfo.fLoadContext);
            contextInfo.fIsPerFileCache = CfgScannerConfigProfileManager.isPerFileProfile(contextInfo.fInfo.getSelectedProfileId());
            contextInfo.fCacheContext = contextInfo.fIsPerFileCache ? contextInfo.fInitialContext : contextInfo.fLoadContext;
        }
        return contextInfo;
    }

    private PathInfo setCachedPathInfo(ContextInfo cInfo, PathInfo info) {
        CfgInfoContext cacheContext = cInfo.fCacheContext;
        return this.setCachedPathInfo(cInfo, (Configuration)cacheContext.getConfiguration(), (Tool)cacheContext.getTool(), cacheContext.getInputType(), info);
    }

    private PathInfo setCachedPathInfo(ContextInfo cInfo, Configuration cfg, Tool tool, IInputType inType, PathInfo info) {
        PathInfoCache cache;
        if (info != null) {
            String id = cInfo.fInfo != null ? cInfo.fInfo.getSelectedProfileId() : null;
            cache = new PathInfoCache(id, info);
        } else {
            cache = null;
        }
        PathInfoCache oldInfo = tool != null ? (info != null ? tool.setDiscoveredPathInfo(inType, cache) : tool.clearDiscoveredPathInfo(inType)) : (info != null ? cfg.setDiscoveredPathInfo(cache) : cfg.clearDiscoveredPathInfo());
        return oldInfo != null ? oldInfo.fPathInfo : null;
    }

    public void removeDiscoveredInfo(IProject project, CfgInfoContext context) {
        this.removeDiscoveredInfo(project, context, true);
    }

    public void removeDiscoveredInfo(IProject project, CfgInfoContext context, boolean removeBaseCache) {
        ContextInfo cInfo = this.getContextInfo(context);
        this.removeCachedPathInfo(cInfo);
        if (removeBaseCache) {
            this.fBaseMngr.removeDiscoveredInfo(project, cInfo.fLoadContext.toInfoContext());
        }
    }

    private static class ContextInfo {
        CfgInfoContext fInitialContext;
        CfgInfoContext fCacheContext;
        CfgInfoContext fLoadContext;
        ICfgScannerConfigBuilderInfo2Set fCfgInfo;
        IScannerConfigBuilderInfo2 fInfo;
        boolean fIsPerFileCache;
    }

    public static class PathInfoCache {
        private PathInfo fPathInfo;
        private String fProfileId;

        public PathInfo getPathInfo() {
            return this.fPathInfo;
        }

        private PathInfoCache(String profileId, PathInfo pathInfo) {
            this.fProfileId = profileId;
            this.fPathInfo = pathInfo;
        }
    }
}

