/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.cdt.core.CCProjectNature;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedProject;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChain;
import org.eclipse.cdt.managedbuilder.ui.wizards.CfgHolder;
import org.eclipse.cdt.managedbuilder.ui.wizards.Messages;
import org.eclipse.cdt.managedbuilder.ui.wizards.NewMakeProjFromExistingPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class NewMakeProjFromExisting
extends Wizard
implements IImportWizard,
INewWizard {
    NewMakeProjFromExistingPage page;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(Messages.NewMakeProjFromExisting_0);
    }

    public void addPages() {
        this.page = new NewMakeProjFromExistingPage();
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        final String projectName = this.page.getProjectName();
        final String location = this.page.getLocation();
        final boolean isCPP = this.page.isCPP();
        final IToolChain toolChain = this.page.getToolChain();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                monitor.beginTask(Messages.NewMakeProjFromExisting_1, 10);
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IProject project = workspace.getRoot().getProject(projectName);
                IProjectDescription description = workspace.newProjectDescription(project.getName());
                description.setLocation((IPath)new Path(location));
                CCorePlugin.getDefault().createCDTProject(description, project, monitor);
                if (isCPP) {
                    CCProjectNature.addCCNature((IProject)project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                ICProjectDescriptionManager pdMgr = CoreModel.getDefault().getProjectDescriptionManager();
                ICProjectDescription projDesc = pdMgr.createProjectDescription(project, false);
                ManagedBuildInfo info = ManagedBuildManager.createBuildInfo((IResource)project);
                ManagedProject mProj = new ManagedProject(projDesc);
                info.setManagedProject((IManagedProject)mProj);
                monitor.worked(1);
                CfgHolder cfgHolder = new CfgHolder(toolChain, null);
                String s = toolChain == null ? "0" : ((ToolChain)toolChain).getId();
                Configuration config = new Configuration(mProj, (ToolChain)toolChain, ManagedBuildManager.calculateChildId((String)s, null), cfgHolder.getName());
                IBuilder builder = config.getEditableBuilder();
                builder.setManagedBuildOn(false);
                CConfigurationData data = config.getConfigurationData();
                projDesc.createConfiguration(ManagedBuildManager.CFG_DATA_PROVIDER_ID, data);
                monitor.worked(1);
                pdMgr.setProjectDescription(project, projDesc);
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

