/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.Arrays;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICLanguageKeywords;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.ASTCache;
import org.eclipse.cdt.internal.ui.editor.ASTProvider;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.CElementHyperlink;
import org.eclipse.cdt.internal.ui.text.CWordFinder;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.texteditor.ITextEditor;

public class CElementHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(final ITextViewer textViewer, final IRegion region, boolean canShowMultipleHyperlinks) {
        ITextEditor textEditor = (ITextEditor)this.getAdapter(ITextEditor.class);
        if (region == null || !(textEditor instanceof CEditor)) {
            return null;
        }
        final IAction openAction = textEditor.getAction("OpenDeclarations");
        if (openAction == null) {
            return null;
        }
        try {
            String partitionType = TextUtilities.getContentType((IDocument)textViewer.getDocument(), (String)"___c_partitioning", (int)region.getOffset(), (boolean)false);
            if (!"__dftl_partition_content_type".equals(partitionType) && !"__c_preprocessor".equals(partitionType)) {
                return null;
            }
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        IWorkingCopy workingCopy = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(textEditor.getEditorInput());
        if (workingCopy == null) {
            return null;
        }
        final IHyperlink[] result = new IHyperlink[1];
        IStatus status = ASTProvider.getASTProvider().runOnAST((ICElement)workingCopy, ASTProvider.WAIT_ACTIVE_ONLY, null, new ASTCache.ASTRunnable(){

            public IStatus runOnAST(ILanguage lang, IASTTranslationUnit ast) {
                if (ast != null) {
                    int offset = region.getOffset();
                    int length = Math.max(1, region.getLength());
                    IASTNodeSelector nodeSelector = ast.getNodeSelector(null);
                    IASTName selectedName = nodeSelector.findEnclosingName(offset, length);
                    IASTFileLocation linkLocation = null;
                    if (selectedName != null) {
                        linkLocation = selectedName.getParent() instanceof IASTPreprocessorIncludeStatement ? selectedName.getParent().getFileLocation() : selectedName.getFileLocation();
                    } else {
                        IASTImplicitName implicit = nodeSelector.findEnclosingImplicitName(offset, length);
                        if (implicit != null) {
                            linkLocation = implicit.getFileLocation();
                        } else {
                            IASTNode cand = nodeSelector.findEnclosingNode(offset, length);
                            if (cand instanceof IASTPreprocessorIncludeStatement) {
                                linkLocation = cand.getFileLocation();
                            }
                        }
                    }
                    if (linkLocation != null) {
                        result[0] = new CElementHyperlink((IRegion)new Region(linkLocation.getNodeOffset(), linkLocation.getNodeLength()), openAction);
                    } else {
                        IDocument document = textViewer.getDocument();
                        IRegion wordRegion = CWordFinder.findWord(document, offset);
                        if (wordRegion != null) {
                            try {
                                String word = document.get(wordRegion.getOffset(), wordRegion.getLength());
                                if (word.length() > 0 && !Character.isDigit(word.charAt(0)) && !CElementHyperlinkDetector.isLanguageKeyword(lang, word)) {
                                    result[0] = new CElementHyperlink((IRegion)new Region(wordRegion.getOffset(), wordRegion.getLength()), openAction);
                                }
                            }
                            catch (BadLocationException badLocationException) {}
                        }
                    }
                }
                return Status.OK_STATUS;
            }
        });
        if (!status.isOK()) {
            CUIPlugin.log(status);
        }
        return result[0] == null ? null : result;
    }

    private static boolean isLanguageKeyword(ILanguage lang, String word) {
        ICLanguageKeywords keywords = (ICLanguageKeywords)lang.getAdapter(ICLanguageKeywords.class);
        if (keywords != null) {
            if (Arrays.asList(keywords.getKeywords()).contains(word)) {
                return true;
            }
            if (Arrays.asList(keywords.getBuiltinTypes()).contains(word)) {
                return true;
            }
            if (Arrays.asList(keywords.getPreprocessorKeywords()).contains(String.valueOf('#') + word)) {
                return true;
            }
        }
        return false;
    }
}

