/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.wizards;

import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.actions.NewProjectAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOpenWizardAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private Class<?>[] fActivatedOnTypes;
    private boolean fAcceptEmptySelection;

    public AbstractOpenWizardAction(String label, boolean acceptEmptySelection) {
        this(label, null, acceptEmptySelection);
    }

    public AbstractOpenWizardAction(String label, Class<?>[] activatedOnTypes, boolean acceptEmptySelection) {
        super(label);
        this.fActivatedOnTypes = activatedOnTypes;
        this.fAcceptEmptySelection = acceptEmptySelection;
    }

    protected AbstractOpenWizardAction() {
        this.fActivatedOnTypes = null;
        this.fAcceptEmptySelection = true;
    }

    protected IWorkbench getWorkbench() {
        return CUIPlugin.getDefault().getWorkbench();
    }

    private boolean isOfAcceptedType(Object obj) {
        if (this.fActivatedOnTypes != null) {
            Class<?>[] classArray = this.fActivatedOnTypes;
            int n = this.fActivatedOnTypes.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> activatedOnType = classArray[n2];
                if (activatedOnType.isInstance(obj)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        return true;
    }

    private boolean isEnabled(IStructuredSelection selection) {
        for (Object obj : selection) {
            if (this.isOfAcceptedType(obj) && this.shouldAcceptElement(obj)) continue;
            return false;
        }
        return true;
    }

    protected boolean shouldAcceptElement(Object obj) {
        return true;
    }

    protected abstract Wizard createWizard() throws CoreException;

    protected IStructuredSelection getCurrentSelection() {
        IWorkbenchWindow window = CUIPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            IFile file;
            IEditorInput input;
            ISelection selection = window.getSelectionService().getSelection();
            if (selection instanceof IStructuredSelection) {
                return (IStructuredSelection)selection;
            }
            IWorkbenchPart part = window.getPartService().getActivePart();
            if (part instanceof IEditorPart && (input = ((IEditorPart)part).getEditorInput()) instanceof IFileEditorInput && (file = ((IFileEditorInput)input).getFile()) != null) {
                return new StructuredSelection((Object)file);
            }
        }
        return StructuredSelection.EMPTY;
    }

    public void run() {
        Shell shell = CUIPlugin.getActiveWorkbenchShell();
        try {
            Wizard wizard = this.createWizard();
            if (wizard instanceof IWorkbenchWizard) {
                ((IWorkbenchWizard)wizard).init(this.getWorkbench(), this.getCurrentSelection());
            }
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            PixelConverter converter = new PixelConverter((Control)CUIPlugin.getActiveWorkbenchShell());
            dialog.setMinimumPageSize(converter.convertWidthInCharsToPixels(70), converter.convertHeightInCharsToPixels(20));
            dialog.create();
            dialog.open();
        }
        catch (CoreException e) {
            String title = NewWizardMessages.AbstractOpenWizardAction_createerror_title;
            String message = NewWizardMessages.AbstractOpenWizardAction_createerror_message;
            ExceptionHandler.handle(e, shell, title, message);
        }
    }

    public boolean canActionBeAdded() {
        IStructuredSelection selection = this.getCurrentSelection();
        if (selection == null || selection.isEmpty()) {
            return this.fAcceptEmptySelection;
        }
        return this.isEnabled(selection);
    }

    public void run(IAction action) {
        this.run();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    protected boolean checkWorkspaceNotEmpty() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace.getRoot().getProjects().length == 0) {
            String message;
            String title;
            Shell shell = CUIPlugin.getActiveWorkbenchShell();
            if (MessageDialog.openQuestion((Shell)shell, (String)(title = NewWizardMessages.AbstractOpenWizardAction_noproject_title), (String)(message = NewWizardMessages.AbstractOpenWizardAction_noproject_message))) {
                IWorkbenchWindow window = CUIPlugin.getActiveWorkbenchWindow();
                new NewProjectAction(window).run();
                return workspace.getRoot().getProjects().length != 0;
            }
            return false;
        }
        return true;
    }
}

