/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.extractlocalvariable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.INodeFactory;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.CPPASTVisitor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTDeclarationStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTEqualsInitializer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTIdExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTLiteralExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunction;
import org.eclipse.cdt.internal.core.dom.rewrite.DeclarationGeneratorImpl;
import org.eclipse.cdt.internal.ui.refactoring.CRefactoring;
import org.eclipse.cdt.internal.ui.refactoring.ModificationCollector;
import org.eclipse.cdt.internal.ui.refactoring.NameNVisibilityInformation;
import org.eclipse.cdt.internal.ui.refactoring.NodeContainer;
import org.eclipse.cdt.internal.ui.refactoring.extractlocalvariable.ExtractLocalVariableRefactoringDescription;
import org.eclipse.cdt.internal.ui.refactoring.extractlocalvariable.Messages;
import org.eclipse.cdt.internal.ui.refactoring.utils.NodeHelper;
import org.eclipse.cdt.internal.ui.refactoring.utils.SelectionHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.TextEditGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractLocalVariableRefactoring
extends CRefactoring {
    public static final String ID = "org.eclipse.cdt.internal.ui.refactoring.extractlocalvariable.ExtractLocalVariableRefactoring";
    private IASTExpression target = null;
    private final NameNVisibilityInformation info;
    private NodeContainer container;

    public ExtractLocalVariableRefactoring(IFile file, ISelection selection, NameNVisibilityInformation info, ICProject project) {
        super(file, selection, null, project);
        this.info = info;
        this.name = Messages.ExtractLocalVariable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)9);
        try {
            this.lockIndex();
            try {
                boolean oneMarked;
                RefactoringStatus status = super.checkInitialConditions((IProgressMonitor)sm.newChild(6));
                if (status.hasError()) {
                    RefactoringStatus refactoringStatus = status;
                    return refactoringStatus;
                }
                this.container = this.findAllExpressions();
                if (this.container.size() < 1) {
                    this.initStatus.addFatalError(Messages.ExpressionMustBeSelected);
                    RefactoringStatus refactoringStatus = this.initStatus;
                    return refactoringStatus;
                }
                sm.worked(1);
                if (this.isProgressMonitorCanceld((IProgressMonitor)sm, this.initStatus)) {
                    RefactoringStatus refactoringStatus = this.initStatus;
                    return refactoringStatus;
                }
                boolean bl = oneMarked = this.region != null && this.isOneMarked(this.container.getNodesToWrite(), this.region);
                if (!oneMarked) {
                    if (this.target == null) {
                        this.initStatus.addFatalError(Messages.NoExpressionSelected);
                    } else {
                        this.initStatus.addFatalError(Messages.TooManyExpressionsSelected);
                    }
                    RefactoringStatus refactoringStatus = this.initStatus;
                    return refactoringStatus;
                }
                sm.worked(1);
                if (this.isProgressMonitorCanceld((IProgressMonitor)sm, this.initStatus)) {
                    RefactoringStatus refactoringStatus = this.initStatus;
                    return refactoringStatus;
                }
                this.container.findAllNames();
                sm.worked(1);
                this.container.getAllAfterUsedNames();
                this.info.addNamesToUsedNames(this.findAllDeclaredNames());
                sm.worked(1);
                NodeHelper.findMethodContext(this.container.getNodesToWrite().get(0), this.getIndex());
                sm.worked(1);
                this.info.setName(this.guessTempName());
                sm.done();
                return this.initStatus;
            }
            finally {
                this.unlockIndex();
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        return this.initStatus;
    }

    private ArrayList<String> findAllDeclaredNames() {
        ArrayList<String> names = new ArrayList<String>();
        IASTFunctionDefinition funcDef = NodeHelper.findFunctionDefinitionInAncestors((IASTNode)this.target);
        ICPPASTCompositeTypeSpecifier comTypeSpec = this.getCompositeTypeSpecifier(funcDef);
        if (comTypeSpec != null) {
            IASTDeclaration[] iASTDeclarationArray = comTypeSpec.getMembers();
            int n = iASTDeclarationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTDeclaration dec = iASTDeclarationArray[n2];
                if (dec instanceof IASTSimpleDeclaration) {
                    IASTSimpleDeclaration simpDec = (IASTSimpleDeclaration)dec;
                    IASTDeclarator[] iASTDeclaratorArray = simpDec.getDeclarators();
                    int n3 = iASTDeclaratorArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IASTDeclarator decor = iASTDeclaratorArray[n4];
                        names.add(decor.getName().getRawSignature());
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return names;
    }

    private ICPPASTCompositeTypeSpecifier getCompositeTypeSpecifier(IASTFunctionDefinition funcDef) {
        IASTNode spec;
        CPPFunction function;
        IASTDeclarator[] decls;
        IBinding binding;
        if (funcDef != null && (binding = funcDef.getDeclarator().getName().resolveBinding()) instanceof CPPFunction && (decls = (function = (CPPFunction)binding).getDeclarations()) != null && decls.length > 0 && (spec = decls[0].getParent().getParent()) instanceof ICPPASTCompositeTypeSpecifier) {
            ICPPASTCompositeTypeSpecifier compTypeSpec = (ICPPASTCompositeTypeSpecifier)spec;
            return compTypeSpec;
        }
        return null;
    }

    private boolean isOneMarked(List<IASTNode> selectedNodes, Region textSelection) {
        boolean oneMarked = false;
        for (IASTNode node : selectedNodes) {
            IASTExpression expression;
            boolean isInSameFileSelection;
            if (!(node instanceof IASTExpression) || !(isInSameFileSelection = SelectionHelper.isInSameFileSelection(textSelection, (IASTNode)(expression = (IASTExpression)node), this.file)) || !this.isExpressionInSelection(expression, textSelection)) continue;
            if (this.target == null) {
                this.target = expression;
                oneMarked = true;
                continue;
            }
            if (this.isTargetChild(expression)) continue;
            oneMarked = false;
        }
        return oneMarked;
    }

    private boolean isExpressionInSelection(IASTExpression expression, Region selection) {
        IASTFileLocation location = expression.getFileLocation();
        int e1 = location.getNodeOffset();
        int e2 = location.getNodeOffset() + location.getNodeLength();
        int s1 = selection.getOffset();
        int s2 = selection.getOffset() + selection.getLength();
        return e1 >= s1 && e2 <= s2;
    }

    private boolean isTargetChild(IASTExpression child) {
        if (this.target == null) {
            return false;
        }
        IASTExpression node = child;
        while (node != null) {
            if (node.getParent() == this.target) {
                return true;
            }
            node = node.getParent();
        }
        return false;
    }

    private NodeContainer findAllExpressions() {
        final NodeContainer container = new NodeContainer();
        this.unit.accept((ASTVisitor)new CPPASTVisitor(){
            {
                this.shouldVisitExpressions = true;
            }

            public int visit(IASTExpression expression) {
                if (SelectionHelper.isSelectedFile(ExtractLocalVariableRefactoring.this.region, (IASTNode)expression, ExtractLocalVariableRefactoring.this.file)) {
                    container.add((IASTNode)expression);
                    return 1;
                }
                return super.visit(expression);
            }
        });
        return container;
    }

    @Override
    protected void collectModifications(IProgressMonitor pm, ModificationCollector collector) throws CoreException, OperationCanceledException {
        try {
            this.lockIndex();
            try {
                String variableName = this.info.getName();
                TextEditGroup editGroup = new TextEditGroup(Messages.CreateLocalVariable);
                IASTStatement declInsertPoint = this.getParentStatement((IASTNode)this.target);
                IASTDeclarationStatement declaration = this.getVariableNodes(variableName);
                declaration.setParent(declInsertPoint.getParent());
                ASTRewrite rewriter = collector.rewriterForTranslationUnit(this.unit);
                rewriter.insertBefore(declInsertPoint.getParent(), (IASTNode)declInsertPoint, (IASTNode)declaration, editGroup);
                CPPASTIdExpression idExpression = new CPPASTIdExpression((IASTName)new CPPASTName(variableName.toCharArray()));
                rewriter.replace((IASTNode)this.target, (IASTNode)idExpression, editGroup);
            }
            finally {
                this.unlockIndex();
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    private IASTStatement getParentStatement(IASTNode node) {
        while (node != null) {
            if (node instanceof IASTStatement && !(node.getParent() instanceof IASTForStatement)) {
                return (IASTStatement)node;
            }
            node = node.getParent();
        }
        return null;
    }

    private IASTDeclarationStatement getVariableNodes(String newName) {
        INodeFactory factory = this.unit.getASTNodeFactory();
        IASTSimpleDeclaration simple = factory.newSimpleDeclaration(null);
        DeclarationGeneratorImpl generator = new DeclarationGeneratorImpl(factory);
        IASTDeclSpecifier declSpec = generator.createDeclSpecFromType(this.target.getExpressionType());
        declSpec.setStorageClass(0);
        simple.setDeclSpecifier(declSpec);
        IASTDeclarator decl = generator.createDeclaratorFromType(this.target.getExpressionType(), newName.toCharArray());
        CPPASTEqualsInitializer init = new CPPASTEqualsInitializer();
        init.setInitializerClause((IASTInitializerClause)ExtractLocalVariableRefactoring.deblock(this.target.copy()));
        decl.setInitializer((IASTInitializer)init);
        simple.addDeclarator(decl);
        return new CPPASTDeclarationStatement((IASTDeclaration)simple);
    }

    private static IASTExpression deblock(IASTExpression expression) {
        IASTUnaryExpression unary;
        if (expression instanceof IASTUnaryExpression && (unary = (IASTUnaryExpression)expression).getOperator() == 11) {
            return ExtractLocalVariableRefactoring.deblock(unary.getOperand());
        }
        return expression;
    }

    public String guessTempName() {
        String[] proposals = this.guessTempNames();
        if (proposals.length == 0) {
            return this.info.getName();
        }
        return proposals[0];
    }

    public String[] guessTempNames() {
        String name;
        IScope scope;
        final ArrayList<String> guessedTempNames = new ArrayList<String>();
        final ArrayList<String> usedNames = new ArrayList<String>();
        IASTFunctionDefinition funcDef = NodeHelper.findFunctionDefinitionInAncestors((IASTNode)this.target);
        if (funcDef != null && funcDef.getBody() instanceof IASTCompoundStatement) {
            IASTCompoundStatement body = (IASTCompoundStatement)funcDef.getBody();
            scope = body.getScope();
        } else {
            scope = null;
        }
        if (this.target != null) {
            this.target.accept((ASTVisitor)new CPPASTVisitor(){
                {
                    this.shouldVisitNames = true;
                    this.shouldVisitExpressions = true;
                }

                public int visit(IASTName name) {
                    this.addTempName(name.getLastName().toString());
                    return super.visit(name);
                }

                public int visit(IASTExpression expression) {
                    if (expression instanceof CPPASTLiteralExpression) {
                        CPPASTLiteralExpression literal = (CPPASTLiteralExpression)expression;
                        String name = null;
                        char[] value = literal.getValue();
                        switch (literal.getKind()) {
                            case 2: {
                                name = Character.toString(value[0]);
                                break;
                            }
                            case 1: {
                                name = "f";
                                break;
                            }
                            case 0: {
                                name = "i";
                                break;
                            }
                            case 3: {
                                name = literal.toString();
                                break;
                            }
                            case 5: 
                            case 6: {
                                name = "b";
                            }
                        }
                        if (name != null) {
                            this.addTempName(name);
                        }
                    }
                    return super.visit(expression);
                }

                private void addTempName(String name) {
                    char[] tmpName = new char[name.length()];
                    int len = 0;
                    int i = 0;
                    while (i < name.length()) {
                        char c = name.charAt(i);
                        if (len == 0 && Character.isJavaIdentifierStart(c)) {
                            tmpName[len++] = Character.toLowerCase(c);
                        } else if (Character.isJavaIdentifierPart(c)) {
                            tmpName[len++] = c;
                        }
                        ++i;
                    }
                    name = new String(tmpName, 0, len);
                    if (name.length() > 0) {
                        if (ExtractLocalVariableRefactoring.this.nameAvailable(name, guessedTempNames, scope)) {
                            guessedTempNames.add(name);
                        } else {
                            usedNames.add(name);
                        }
                    }
                }
            });
        }
        if (guessedTempNames.isEmpty() && (name = this.makeTempName(usedNames, scope)) != null) {
            guessedTempNames.add(name);
        }
        return guessedTempNames.toArray(new String[0]);
    }

    private boolean nameAvailable(String name, List<String> guessedNames, IScope scope) {
        if (guessedNames.contains(name) || this.info.getUsedNames().contains(name)) {
            return false;
        }
        try {
            if (scope != null) {
                IBinding[] bindings = scope.find(name);
                return bindings == null || bindings.length == 0;
            }
        }
        catch (DOMException dOMException) {}
        return true;
    }

    private String makeTempName(List<String> usedNames, IScope scope) {
        ArrayList<String> noNames = new ArrayList<String>();
        int i = 0;
        while (i < 10) {
            for (String used : usedNames) {
                String name = String.valueOf(used) + i;
                if (!this.nameAvailable(name, noNames, scope)) continue;
                return name;
            }
            ++i;
        }
        return null;
    }

    @Override
    protected RefactoringDescriptor getRefactoringDescriptor() {
        Map<String, String> arguments = this.getArgumentMap();
        ExtractLocalVariableRefactoringDescription desc = new ExtractLocalVariableRefactoringDescription(this.project.getProject().getName(), "Extract Local Variable Refactoring", "Extract " + this.target.getRawSignature(), arguments);
        return desc;
    }

    private Map<String, String> getArgumentMap() {
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("fileName", this.file.getLocationURI().toString());
        arguments.put("selection", String.valueOf(this.region.getOffset()) + "," + this.region.getLength());
        arguments.put("name", this.info.getName());
        return arguments;
    }
}

