/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.doctools;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.doctools.IDocCommentOwner;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProjectMap {
    private static final String ATTRVAL_STORAGEID = "org.eclipse.cdt.internal.ui.text.commentOwnerProjectMappings";
    private static final String ELEMENT_DOC_COMMENT_OWNER = "doc-comment-owner";
    private static final String ATTRKEY_DCO_ID = "id";
    private static final String ELEMENT_PATH = "path";
    private static final String ATTRKEY_PATH_VALUE = "value";
    private IProject fProject;
    private Map<IPath, String> fMap;

    public ProjectMap(IProject project) {
        try {
            this.fMap = ProjectMap.load(project);
        }
        catch (CoreException ce) {
            CUIPlugin.log(ce);
            this.fMap = new HashMap<IPath, String>();
        }
        this.fProject = project;
    }

    public String getOwnerID(IResource resource) {
        String id = null;
        if (resource != null) {
            IPath p = resource.getProjectRelativePath();
            while (true) {
                if (this.fMap.containsKey(p)) {
                    id = this.fMap.get(p);
                    break;
                }
                if (p.isEmpty()) break;
                p = p.removeLastSegments(1);
            }
        }
        return id;
    }

    public void setCommentOwner(IResource resource, IDocCommentOwner owner) {
        Assert.isNotNull((Object)resource);
        if (ResourcesPlugin.getWorkspace().getRoot().equals((Object)resource)) {
            throw new IllegalStateException();
        }
        if (owner != null) {
            this.fMap.put(resource.getProjectRelativePath(), owner.getID());
        } else {
            this.fMap.remove(resource.getProjectRelativePath());
        }
        try {
            this.save();
        }
        catch (CoreException ce) {
            CUIPlugin.log(ce);
        }
    }

    public boolean isEmpty() {
        return this.fMap.isEmpty();
    }

    private static Map<IPath, String> load(IProject project) throws CoreException {
        HashMap<IPath, String> result = new HashMap<IPath, String>();
        ICDescriptor pd = CCorePlugin.getDefault().getCProjectDescription(project, true);
        ICStorageElement e = pd.getProjectStorageElement(ATTRVAL_STORAGEID);
        ICStorageElement[] iCStorageElementArray = e.getChildrenByName(ELEMENT_DOC_COMMENT_OWNER);
        int n = iCStorageElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICStorageElement node = iCStorageElementArray[n2];
            String commentOwnerID = node.getAttribute(ATTRKEY_DCO_ID);
            if (commentOwnerID != null) {
                ICStorageElement[] iCStorageElementArray2 = node.getChildrenByName(ELEMENT_PATH);
                int n3 = iCStorageElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    ICStorageElement path = iCStorageElementArray2[n4];
                    String pathValue = path.getAttribute(ATTRKEY_PATH_VALUE);
                    if (pathValue != null) {
                        result.put(Path.fromPortableString((String)pathValue), commentOwnerID);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return result;
    }

    public void save() throws CoreException {
        ICDescriptor pd = CCorePlugin.getDefault().getCProjectDescription(this.fProject, true);
        ICStorageElement data = pd.getProjectStorageElement(ATTRVAL_STORAGEID);
        ICStorageElement[] iCStorageElementArray = data.getChildren();
        int n = iCStorageElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICStorageElement child = iCStorageElementArray[n2];
            data.removeChild(child);
            ++n2;
        }
        for (String cid : this.fMap.values()) {
            ICStorageElement commentNode = data.createChild(ELEMENT_DOC_COMMENT_OWNER);
            commentNode.setAttribute(ATTRKEY_DCO_ID, cid);
            for (IPath path : this.fMap.keySet()) {
                String ccid = this.fMap.get(path);
                if (!cid.equals(ccid)) continue;
                ICStorageElement pathNode = commentNode.createChild(ELEMENT_PATH);
                pathNode.setAttribute(ATTRKEY_PATH_VALUE, path.toPortableString());
            }
        }
        pd.saveProjectData();
    }
}

