/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.dialogs.TypedViewerFilter;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElement;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementAttribute;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementLabelProvider;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementSorter;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathBasePage;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.ExclusionPatternDialog;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.MultipleFolderSelectionDialog;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.NewSourceFolderDialog;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.NewFolderDialog;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class CPathSourceEntryPage
extends CPathBasePage {
    private ListDialogField<CPElement> fCPathList;
    private ICProject fCurrCProject;
    private IPath fProjPath;
    private IWorkspaceRoot fWorkspaceRoot;
    private TreeListDialogField<CPElement> fFoldersList;
    private final int IDX_ADD = 0;
    private final int IDX_EDIT = 2;
    private final int IDX_REMOVE = 3;

    public CPathSourceEntryPage(ListDialogField<CPElement> classPathList) {
        super(CPathEntryMessages.SourcePathEntryPage_title);
        this.setDescription(CPathEntryMessages.SourcePathEntryPage_description);
        this.fWorkspaceRoot = CUIPlugin.getWorkspace().getRoot();
        this.fCPathList = classPathList;
        SourceContainerAdapter adapter = new SourceContainerAdapter();
        String[] stringArray = new String[4];
        stringArray[0] = CPathEntryMessages.SourcePathEntryPage_folders_add_button;
        stringArray[2] = CPathEntryMessages.SourcePathEntryPath_folders_edit_button;
        stringArray[3] = CPathEntryMessages.SourcePathEntryPage_folders_remove_button;
        String[] buttonLabels = stringArray;
        this.fFoldersList = new TreeListDialogField<CPElement>(adapter, buttonLabels, (ILabelProvider)new CPElementLabelProvider());
        this.fFoldersList.setDialogFieldListener(adapter);
        this.fFoldersList.setLabelText(CPathEntryMessages.SourcePathEntryPage_folders_label);
        this.fFoldersList.setViewerComparator((ViewerComparator)new CPElementSorter());
        this.fFoldersList.enableButton(2, false);
        this.fFoldersList.enableButton(3, false);
        this.fFoldersList.setTreeExpansionLevel(2);
    }

    public Image getImage() {
        return CPluginImages.get("org.eclipse.cdt.ui.sroot_obj.gif");
    }

    public void init(ICProject cproject) {
        this.fCurrCProject = cproject;
        this.fProjPath = this.fCurrCProject.getProject().getFullPath();
        this.updateFoldersList();
    }

    private void updateFoldersList() {
        List<CPElement> folders = this.filterList(this.fCPathList.getElements());
        this.fFoldersList.setElements(folders);
        int i = 0;
        while (i < folders.size()) {
            CPElement cpe = folders.get(i);
            IPath[] patterns = (IPath[])cpe.getAttribute("exclusion");
            if (patterns.length > 0) {
                this.fFoldersList.expandElement(cpe, 3);
            }
            ++i;
        }
    }

    @Override
    public void createControl(Composite parent) {
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        LayoutUtil.doDefaultLayout(composite, new DialogField[]{this.fFoldersList}, true);
        LayoutUtil.setHorizontalGrabbing(this.fFoldersList.getTreeControl(null));
        int buttonBarWidth = converter.convertWidthInCharsToPixels(24);
        this.fFoldersList.setButtonsMinWidth(buttonBarWidth);
        List<CPElement> elements = this.fFoldersList.getElements();
        int i = 0;
        while (i < elements.size()) {
            CPElement elem = elements.get(i);
            IPath[] patterns = (IPath[])elem.getAttribute("exclusion");
            if (patterns.length > 0) {
                this.fFoldersList.expandElement(elem, 3);
            }
            ++i;
        }
        this.setControl((Control)composite);
        CUIPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.cdt.ui.std_prop_source");
    }

    protected void sourcePageKeyPressed(TreeListDialogField<CPElement> field, KeyEvent event) {
        List<Object> selection;
        if (field == this.fFoldersList && event.character == '\u007f' && event.stateMask == 0 && this.canRemove(selection = field.getSelectedElements())) {
            this.removeEntry();
        }
    }

    protected void sourcePageDoubleClicked(TreeListDialogField<CPElement> field) {
        List<Object> selection;
        if (field == this.fFoldersList && this.canEdit(selection = field.getSelectedElements())) {
            this.editEntry();
        }
    }

    protected void sourcePageCustomButtonPressed(DialogField field, int index) {
        if (field == this.fFoldersList) {
            if (index == 0) {
                ArrayList<CPElement> elementsToAdd = new ArrayList<CPElement>(10);
                IProject project = this.fCurrCProject.getProject();
                if (project.exists()) {
                    CPElement[] srcentries = this.openSourceContainerDialog(null);
                    if (srcentries != null) {
                        CPElement[] cPElementArray = srcentries;
                        int n = srcentries.length;
                        int n2 = 0;
                        while (n2 < n) {
                            CPElement srcentrie = cPElementArray[n2];
                            elementsToAdd.add(srcentrie);
                            ++n2;
                        }
                    }
                } else {
                    CPElement entry = this.openNewSourceContainerDialog(null, false);
                    if (entry != null) {
                        elementsToAdd.add(entry);
                    }
                }
                if (!elementsToAdd.isEmpty()) {
                    HashSet<CPElement> modifiedElements = new HashSet<CPElement>();
                    this.askForAddingExclusionPatternsDialog(elementsToAdd, modifiedElements);
                    this.fFoldersList.addElements(elementsToAdd);
                    this.fFoldersList.postSetSelection((ISelection)new StructuredSelection(elementsToAdd));
                    if (!modifiedElements.isEmpty()) {
                        for (CPElement elem : modifiedElements) {
                            this.fFoldersList.refresh(elem);
                            this.fFoldersList.expandElement(elem, 3);
                        }
                    }
                }
            } else if (index == 2) {
                this.editEntry();
            } else if (index == 3) {
                this.removeEntry();
            }
        }
    }

    private void editEntry() {
        List<Object> selElements = this.fFoldersList.getSelectedElements();
        if (selElements.size() != 1) {
            return;
        }
        Object elem = selElements.get(0);
        if (this.fFoldersList.getIndexOfElement(elem) != -1) {
            this.editElementEntry((CPElement)elem);
        } else if (elem instanceof CPElementAttribute) {
            this.editAttributeEntry((CPElementAttribute)elem);
        }
    }

    private void editElementEntry(CPElement elem) {
        CPElement res = null;
        res = this.openNewSourceContainerDialog(elem, true);
        if (res != null) {
            this.fFoldersList.replaceElement(elem, res);
        }
    }

    private void editAttributeEntry(CPElementAttribute elem) {
        String key = elem.getKey();
        if (key.equals("exclusion")) {
            CPElement selElement = elem.getParent();
            ExclusionPatternDialog dialog = new ExclusionPatternDialog(this.getShell(), selElement);
            if (dialog.open() == 0) {
                selElement.setAttribute("exclusion", dialog.getExclusionPattern());
                this.fFoldersList.refresh();
                this.fCPathList.dialogFieldChanged();
            }
        }
    }

    protected void sourcePageSelectionChanged(DialogField field) {
        List<Object> selected = this.fFoldersList.getSelectedElements();
        this.fFoldersList.enableButton(2, this.canEdit(selected));
        this.fFoldersList.enableButton(3, this.canRemove(selected));
    }

    private void removeEntry() {
        List<Object> selElements = this.fFoldersList.getSelectedElements();
        int i = selElements.size() - 1;
        while (i >= 0) {
            Object elem = selElements.get(i);
            if (elem instanceof CPElementAttribute) {
                CPElementAttribute attrib = (CPElementAttribute)elem;
                String key = attrib.getKey();
                Path[] value = key.equals("exclusion") ? new Path[]{} : null;
                attrib.getParent().setAttribute(key, value);
                selElements.remove(i);
            }
            --i;
        }
        if (selElements.isEmpty()) {
            this.fFoldersList.refresh();
            this.fCPathList.dialogFieldChanged();
        } else {
            this.fFoldersList.removeElements(selElements);
        }
    }

    private boolean canRemove(List<?> selElements) {
        if (selElements.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < selElements.size()) {
            CPElement curr;
            CPElementAttribute attrib;
            Object elem = selElements.get(i);
            if (elem instanceof CPElementAttribute ? ((attrib = (CPElementAttribute)elem).getKey().equals("exclusion") ? ((IPath[])attrib.getValue()).length == 0 : attrib.getValue() == null) : elem instanceof CPElement && (curr = (CPElement)elem).getParentContainer() != null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean canEdit(List<?> selElements) {
        if (selElements.size() != 1) {
            return false;
        }
        Object elem = selElements.get(0);
        if (elem instanceof CPElement) {
            return false;
        }
        return elem instanceof CPElementAttribute;
    }

    void sourcePageDialogFieldChanged(DialogField field) {
        if (this.fCurrCProject == null) {
            return;
        }
        if (field == this.fFoldersList) {
            this.updateClasspathList();
        }
    }

    private void updateClasspathList() {
        int nEntries;
        List<CPElement> srcelements = this.fFoldersList.getElements();
        List<CPElement> cpelements = this.fCPathList.getElements();
        int lastRemovePos = nEntries = cpelements.size();
        int afterLastSourcePos = 0;
        int i = nEntries - 1;
        while (i >= 0) {
            CPElement cpe = cpelements.get(i);
            int kind = cpe.getEntryKind();
            if (this.isEntryKind(kind)) {
                if (!srcelements.remove(cpe)) {
                    cpelements.remove(i);
                    lastRemovePos = i;
                } else if (lastRemovePos == nEntries) {
                    afterLastSourcePos = i + 1;
                }
            }
            --i;
        }
        if (!srcelements.isEmpty()) {
            int insertPos = Math.min(afterLastSourcePos, lastRemovePos);
            cpelements.addAll(insertPos, srcelements);
        }
        if (lastRemovePos != nEntries || !srcelements.isEmpty()) {
            this.fCPathList.setElements(cpelements);
        }
    }

    private CPElement openNewSourceContainerDialog(CPElement existing, boolean includeLinked) {
        if (includeLinked) {
            NewFolderDialog dialog = new NewFolderDialog(this.getShell(), (IContainer)this.fCurrCProject.getProject());
            if (dialog.open() == 0) {
                IResource createdFolder = (IResource)dialog.getResult()[0];
                return this.newCPSourceElement(createdFolder);
            }
            return null;
        }
        String title = existing == null ? CPathEntryMessages.SourcePathEntryPage_NewSourceFolderDialog_new_title : CPathEntryMessages.SourcePathEntryPage_NewSourceFolderDialog_edit_title;
        IProject proj = this.fCurrCProject.getProject();
        NewSourceFolderDialog dialog = new NewSourceFolderDialog(this.getShell(), title, proj, this.getExistingContainers(existing), existing);
        dialog.setMessage(NLS.bind((String)CPathEntryMessages.SourcePathEntryPage_NewSourceFolderDialog_description, (Object)this.fProjPath.toString()));
        if (dialog.open() == 0) {
            IContainer folder = dialog.getSourceFolder();
            return this.newCPSourceElement((IResource)folder);
        }
        return null;
    }

    private void askForAddingExclusionPatternsDialog(List<CPElement> newEntries, Set<CPElement> modifiedEntries) {
        this.fixNestingConflicts(newEntries, this.fFoldersList.getElements(), modifiedEntries);
        if (!modifiedEntries.isEmpty()) {
            String title = CPathEntryMessages.SourcePathEntryPage_exclusion_added_title;
            String message = CPathEntryMessages.SourcePathEntryPage_exclusion_added_message;
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
        }
    }

    private CPElement[] openSourceContainerDialog(CPElement existing) {
        Class[] acceptedClasses = new Class[]{IProject.class, IFolder.class};
        List<IContainer> existingContainers = this.getExistingContainers(null);
        IProject[] allProjects = this.fWorkspaceRoot.getProjects();
        ArrayList<IProject> rejectedElements = new ArrayList<IProject>(allProjects.length);
        IProject currProject = this.fCurrCProject.getProject();
        int i = 0;
        while (i < allProjects.length) {
            if (!allProjects[i].equals((Object)currProject)) {
                rejectedElements.add(allProjects[i]);
            }
            ++i;
        }
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses, rejectedElements.toArray());
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        BaseWorkbenchContentProvider cp = new BaseWorkbenchContentProvider();
        String title = existing == null ? CPathEntryMessages.SourcePathEntryPage_ExistingSourceFolderDialog_new_title : CPathEntryMessages.SourcePathEntryPage_ExistingSourceFolderDialog_edit_title;
        String message = existing == null ? CPathEntryMessages.SourcePathEntryPage_ExistingSourceFolderDialog_new_description : CPathEntryMessages.SourcePathEntryPage_ExistingSourceFolderDialog_edit_description;
        MultipleFolderSelectionDialog dialog = new MultipleFolderSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setExisting(existingContainers.toArray());
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.addFilter(filter);
        dialog.setInput(this.fCurrCProject.getProject().getParent());
        if (existing == null) {
            dialog.setInitialFocus(this.fCurrCProject.getProject());
        } else {
            dialog.setInitialFocus(existing.getResource());
        }
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            CPElement[] res = new CPElement[elements.length];
            int i2 = 0;
            while (i2 < res.length) {
                IResource elem = (IResource)elements[i2];
                res[i2] = this.newCPSourceElement(elem);
                ++i2;
            }
            return res;
        }
        return null;
    }

    private List<IContainer> getExistingContainers(CPElement existing) {
        ArrayList<IContainer> res = new ArrayList<IContainer>();
        List<CPElement> cplist = this.fFoldersList.getElements();
        int i = 0;
        while (i < cplist.size()) {
            IResource resource;
            CPElement elem = cplist.get(i);
            if (elem != existing && (resource = elem.getResource()) instanceof IContainer) {
                res.add((IContainer)resource);
            }
            ++i;
        }
        return res;
    }

    private CPElement newCPSourceElement(IResource res) {
        Assert.isNotNull((Object)res);
        return new CPElement(this.fCurrCProject, 8, res.getFullPath(), res);
    }

    public List<Object> getSelection() {
        return this.fFoldersList.getSelectedElements();
    }

    @Override
    public void setSelection(List<?> selElements) {
        this.fFoldersList.selectElements((ISelection)new StructuredSelection(selElements));
    }

    @Override
    public boolean isEntryKind(int kind) {
        return kind == 8;
    }

    @Override
    public void performApply(IProgressMonitor monitor) throws CoreException {
    }

    @Override
    public void performDefaults() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SourceContainerAdapter
    implements ITreeListAdapter<CPElement>,
    IDialogFieldListener {
        private final Object[] EMPTY_ARR = new Object[0];

        private SourceContainerAdapter() {
        }

        @Override
        public void customButtonPressed(TreeListDialogField<CPElement> field, int index) {
            CPathSourceEntryPage.this.sourcePageCustomButtonPressed(field, index);
        }

        @Override
        public void selectionChanged(TreeListDialogField<CPElement> field) {
            CPathSourceEntryPage.this.sourcePageSelectionChanged(field);
        }

        @Override
        public void doubleClicked(TreeListDialogField<CPElement> field) {
            CPathSourceEntryPage.this.sourcePageDoubleClicked(field);
        }

        @Override
        public void keyPressed(TreeListDialogField<CPElement> field, KeyEvent event) {
            CPathSourceEntryPage.this.sourcePageKeyPressed(field, event);
        }

        @Override
        public Object[] getChildren(TreeListDialogField<CPElement> field, Object element) {
            if (element instanceof CPElement) {
                return ((CPElement)element).getChildren();
            }
            return this.EMPTY_ARR;
        }

        @Override
        public Object getParent(TreeListDialogField<CPElement> field, Object element) {
            if (element instanceof CPElementAttribute) {
                return ((CPElementAttribute)element).getParent();
            }
            return null;
        }

        @Override
        public boolean hasChildren(TreeListDialogField<CPElement> field, Object element) {
            return element instanceof CPElement;
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            CPathSourceEntryPage.this.sourcePageDialogFieldChanged(field);
        }
    }
}

