/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.extractfunction;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.INodeFactory;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNewExpression;
import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTBinaryExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFieldReference;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFunctionDefinition;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTIdExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTLiteralExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTReturnStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTSimpleDeclSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTSimpleDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunction;
import org.eclipse.cdt.internal.core.dom.rewrite.DeclarationGeneratorImpl;
import org.eclipse.cdt.internal.ui.refactoring.NodeContainer;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.ExtractedFunctionConstructionHelper;
import org.eclipse.text.edits.TextEditGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractExpression
extends ExtractedFunctionConstructionHelper {
    static final char[] ZERO = new char[]{'0'};

    @Override
    public void constructMethodBody(IASTCompoundStatement compound, List<IASTNode> list, ASTRewrite rewrite, TextEditGroup group) {
        CPPASTReturnStatement statement = new CPPASTReturnStatement();
        CPPASTLiteralExpression nullReturnExp = new CPPASTLiteralExpression(0, ZERO);
        statement.setReturnValue((IASTExpression)nullReturnExp);
        ASTRewrite nestedRewrite = rewrite.insertBefore((IASTNode)compound, null, (IASTNode)statement, group);
        nestedRewrite.replace((IASTNode)nullReturnExp, (IASTNode)this.getExpression(list), group);
    }

    private IASTExpression getExpression(List<IASTNode> list) {
        if (list.size() > 1) {
            CPPASTBinaryExpression bExp = new CPPASTBinaryExpression();
            bExp.setParent(list.get(0).getParent());
            bExp.setOperand1((IASTExpression)list.get(0).copy());
            bExp.setOperator(((IASTBinaryExpression)list.get(1).getParent()).getOperator());
            bExp.setOperand2(this.getExpression(list.subList(1, list.size())));
            return bExp;
        }
        return (IASTExpression)list.get(0).copy();
    }

    @Override
    public IASTDeclSpecifier determineReturnType(IASTNode extractedNode, NodeContainer.NameInformation _) {
        List<ITypedef> typdefs = this.getTypdefs(extractedNode);
        if (extractedNode instanceof IASTExpression) {
            IASTExpression exp = (IASTExpression)extractedNode;
            INodeFactory factory = extractedNode.getTranslationUnit().getASTNodeFactory();
            DeclarationGeneratorImpl generator = new DeclarationGeneratorImpl(factory);
            IType expressionType = exp.getExpressionType();
            for (ITypedef typedef : typdefs) {
                if (!typedef.getType().isSameType(expressionType)) continue;
                return generator.createDeclSpecFromType((IType)typedef);
            }
            return generator.createDeclSpecFromType(expressionType);
        }
        return ExtractExpression.createSimpleDeclSpecifier(IBasicType.Kind.eVoid);
    }

    private List<ITypedef> getTypdefs(IASTNode extractedNode) {
        final ArrayList<ITypedef> typeDefs = new ArrayList<ITypedef>();
        extractedNode.accept(new ASTVisitor(){
            {
                this.shouldVisitExpressions = true;
            }

            public int visit(IASTExpression expression) {
                if (expression instanceof IASTIdExpression) {
                    IASTIdExpression id = (IASTIdExpression)expression;
                    IBinding binding = id.getName().resolveBinding();
                    IType expressionType = null;
                    if (binding instanceof IVariable) {
                        try {
                            expressionType = ((IVariable)binding).getType();
                        }
                        catch (DOMException dOMException) {}
                    }
                    if (binding instanceof IType) {
                        expressionType = (IType)binding;
                    }
                    if (expressionType != null && expressionType instanceof ITypedef) {
                        ITypedef typdef = (ITypedef)expressionType;
                        typeDefs.add(typdef);
                    }
                }
                return 3;
            }
        });
        return typeDefs;
    }

    private static IASTDeclSpecifier createSimpleDeclSpecifier(IBasicType.Kind type) {
        CPPASTSimpleDeclSpecifier declSpec = new CPPASTSimpleDeclSpecifier();
        declSpec.setType(type);
        return declSpec;
    }

    private static IASTName findCalledFunctionName(IASTFunctionCallExpression callExpression) {
        IASTExpression functionNameExpression = callExpression.getFunctionNameExpression();
        IASTName functionName = null;
        if (functionNameExpression instanceof CPPASTIdExpression) {
            CPPASTIdExpression idExpression = (CPPASTIdExpression)functionNameExpression;
            functionName = idExpression.getName();
        } else if (functionNameExpression instanceof CPPASTFieldReference) {
            CPPASTFieldReference fieldReference = (CPPASTFieldReference)functionNameExpression;
            functionName = fieldReference.getFieldName();
        }
        return functionName;
    }

    @Override
    protected boolean isReturnTypeAPointer(IASTNode node) {
        IBinding binding;
        if (node instanceof ICPPASTNewExpression) {
            return true;
        }
        if (!(node instanceof IASTFunctionCallExpression)) {
            return false;
        }
        IASTName functionName = ExtractExpression.findCalledFunctionName((IASTFunctionCallExpression)node);
        if (functionName != null && (binding = functionName.resolveBinding()) instanceof CPPFunction) {
            IASTNode parent;
            CPPFunction function = (CPPFunction)binding;
            if (function.getDefinition() != null) {
                IASTNode parent2 = function.getDefinition().getParent();
                if (parent2 instanceof CPPASTFunctionDefinition) {
                    CPPASTFunctionDefinition definition = (CPPASTFunctionDefinition)parent2;
                    return definition.getDeclarator().getPointerOperators().length > 0;
                }
            } else if (ExtractExpression.hasDeclaration(function) && (parent = function.getDeclarations()[0].getParent()) instanceof CPPASTSimpleDeclaration) {
                CPPASTSimpleDeclaration declaration = (CPPASTSimpleDeclaration)parent;
                return declaration.getDeclarators().length > 0 && declaration.getDeclarators()[0].getPointerOperators().length > 0;
            }
        }
        return false;
    }

    private static boolean hasDeclaration(CPPFunction function) {
        return function != null && function.getDeclarations() != null && function.getDeclarations().length > 0;
    }

    @Override
    public IASTNode createReturnAssignment(IASTNode node, IASTExpressionStatement stmt, IASTExpression callExpression) {
        return callExpression;
    }
}

