/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.c.hover;

import org.eclipse.cdt.internal.ui.editor.CSourceViewer;
import org.eclipse.cdt.internal.ui.text.CTextTools;
import org.eclipse.cdt.internal.ui.text.SimpleCSourceViewerConfiguration;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension3;
import org.eclipse.jface.text.IInformationControlExtension5;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SourceViewerInformationControl
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension3,
IInformationControlExtension5,
DisposeListener {
    private Shell fShell;
    private StyledText fText;
    private SourceViewer fViewer;
    private Font fTextFont;
    private Label fStatusField;
    private Label fSeparator;
    private Font fStatusTextFont;
    private int fMaxWidth = -1;
    private int fMaxHeight = -1;
    private final int fOrientation;
    private Color fBackgroundColor;
    private boolean fIsSystemBackgroundColor = true;

    public SourceViewerInformationControl(Shell parent, boolean isResizable, int orientation, String statusFieldText) {
        Assert.isLegal((orientation == 0x4000000 || orientation == 0x2000000 || orientation == 0 ? 1 : 0) != 0);
        this.fOrientation = orientation;
        int shellStyle = 0x4004 | orientation | (isResizable ? 16 : 0);
        int textStyle = isResizable ? 768 : 0;
        this.fShell = new Shell(parent, 0x84000 | shellStyle);
        Display display = this.fShell.getDisplay();
        this.initializeColors();
        Shell composite = this.fShell;
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        composite.setLayoutData((Object)gd);
        if (statusFieldText != null) {
            composite = new Composite((Composite)composite, 0);
            layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.verticalSpacing = 1;
            composite.setLayout((Layout)layout);
            gd = new GridData(1808);
            composite.setLayoutData((Object)gd);
            composite.setForeground(display.getSystemColor(28));
            composite.setBackground(this.fBackgroundColor);
        }
        IPreferenceStore store = CUIPlugin.getDefault().getCombinedPreferenceStore();
        this.fViewer = new CSourceViewer((Composite)composite, null, null, false, textStyle, store);
        CTextTools tools = CUIPlugin.getDefault().getTextTools();
        this.fViewer.configure((SourceViewerConfiguration)new SimpleCSourceViewerConfiguration(tools.getColorManager(), store, null, "___c_partitioning", false));
        this.fViewer.setEditable(false);
        this.fText = this.fViewer.getTextWidget();
        gd = new GridData(1809);
        this.fText.setLayoutData((Object)gd);
        this.fText.setForeground(display.getSystemColor(28));
        this.fText.setBackground(this.fBackgroundColor);
        this.initializeFont();
        this.fText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    SourceViewerInformationControl.this.fShell.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        if (statusFieldText != null) {
            this.fSeparator = new Label((Composite)composite, 259);
            this.fSeparator.setLayoutData((Object)new GridData(768));
            this.fStatusField = new Label((Composite)composite, 131072);
            this.fStatusField.setText(statusFieldText);
            Font font = this.fStatusField.getFont();
            FontData[] fontDatas = font.getFontData();
            int i = 0;
            while (i < fontDatas.length) {
                fontDatas[i].setHeight(fontDatas[i].getHeight() * 9 / 10);
                ++i;
            }
            this.fStatusTextFont = new Font((Device)this.fStatusField.getDisplay(), fontDatas);
            this.fStatusField.setFont(this.fStatusTextFont);
            GridData gd2 = new GridData(770);
            this.fStatusField.setLayoutData((Object)gd2);
            this.fStatusField.setForeground(display.getSystemColor(17));
            this.fStatusField.setBackground(this.fBackgroundColor);
        }
        this.addDisposeListener(this);
    }

    private void initializeColors() {
        RGB bgRGB = this.getHoverBackgroundColorRGB();
        if (bgRGB != null) {
            this.fBackgroundColor = new Color((Device)this.fShell.getDisplay(), bgRGB);
            this.fIsSystemBackgroundColor = false;
        } else {
            this.fBackgroundColor = this.fShell.getDisplay().getSystemColor(29);
            this.fIsSystemBackgroundColor = true;
        }
    }

    private RGB getHoverBackgroundColorRGB() {
        IPreferenceStore store = CUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("sourceHoverBackgroundColor.SystemDefault") ? null : PreferenceConverter.getColor((IPreferenceStore)store, (String)"sourceHoverBackgroundColor");
    }

    private void initializeFont() {
        this.fTextFont = JFaceResources.getFont((String)"org.eclipse.cdt.ui.editors.textfont");
        StyledText styledText = this.getViewer().getTextWidget();
        styledText.setFont(this.fTextFont);
    }

    public void setInput(Object input) {
        if (input instanceof String) {
            this.setInformation((String)input);
        } else {
            this.setInformation(null);
        }
    }

    public void setInformation(String content) {
        if (content == null) {
            this.fViewer.setInput(null);
            return;
        }
        Document doc = new Document(content);
        CUIPlugin.getDefault().getTextTools().setupCDocument((IDocument)doc);
        this.fViewer.setInput((Object)doc);
    }

    public void setVisible(boolean visible) {
        this.fShell.setVisible(visible);
    }

    public void widgetDisposed(DisposeEvent event) {
        if (this.fStatusTextFont != null && !this.fStatusTextFont.isDisposed()) {
            this.fStatusTextFont.dispose();
        }
        this.fStatusTextFont = null;
        this.fTextFont = null;
        this.fShell = null;
        this.fText = null;
    }

    public final void dispose() {
        if (!this.fIsSystemBackgroundColor) {
            this.fBackgroundColor.dispose();
        }
        if (this.fShell != null && !this.fShell.isDisposed()) {
            this.fShell.dispose();
        } else {
            this.widgetDisposed(null);
        }
    }

    public void setSize(int width, int height) {
        this.fShell.setSize(width, height);
    }

    public void setLocation(Point location) {
        this.fShell.setLocation(location);
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
        this.fMaxWidth = maxWidth;
        this.fMaxHeight = maxHeight;
    }

    public Point computeSizeHint() {
        int x = -1;
        int y = -1;
        Point size = this.fShell.computeSize(x, y);
        if (size.x > this.fMaxWidth) {
            x = this.fMaxWidth;
        }
        if (size.y > this.fMaxHeight) {
            y = this.fMaxHeight;
        }
        if (x != -1 || y != -1) {
            size = this.fShell.computeSize(x, y, false);
        }
        return size;
    }

    public void addDisposeListener(DisposeListener listener) {
        this.fShell.addDisposeListener(listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.fShell.removeDisposeListener(listener);
    }

    public void setForegroundColor(Color foreground) {
        this.fText.setForeground(foreground);
    }

    public void setBackgroundColor(Color background) {
        this.fText.setBackground(background);
    }

    public boolean isFocusControl() {
        return this.fShell.getDisplay().getActiveShell() == this.fShell;
    }

    public void setFocus() {
        this.fShell.forceFocus();
        this.fText.setFocus();
    }

    public void addFocusListener(FocusListener listener) {
        this.fText.addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.fText.removeFocusListener(listener);
    }

    public boolean hasContents() {
        return this.fText.getCharCount() > 0;
    }

    protected ISourceViewer getViewer() {
        return this.fViewer;
    }

    public Rectangle computeTrim() {
        Rectangle trim = this.fShell.computeTrim(0, 0, 0, 0);
        this.addInternalTrim(trim);
        return trim;
    }

    private void addInternalTrim(Rectangle trim) {
        Rectangle textTrim = this.fText.computeTrim(0, 0, 0, 0);
        trim.x += textTrim.x;
        trim.y += textTrim.y;
        trim.width += textTrim.width;
        trim.height += textTrim.height;
        if (this.fStatusField != null) {
            trim.height += this.fSeparator.computeSize((int)-1, (int)-1).y;
            trim.height += this.fStatusField.computeSize((int)-1, (int)-1).y;
            ++trim.height;
        }
    }

    public Rectangle getBounds() {
        return this.fShell.getBounds();
    }

    public boolean restoresLocation() {
        return false;
    }

    public boolean restoresSize() {
        return false;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new SourceViewerInformationControl(parent, true, SourceViewerInformationControl.this.fOrientation, null);
            }
        };
    }

    public boolean containsControl(Control control) {
        do {
            if (control == this.fShell) {
                return true;
            }
            if (!(control instanceof Shell)) continue;
            return false;
        } while ((control = control.getParent()) != null);
        return false;
    }

    public boolean isVisible() {
        return this.fShell != null && !this.fShell.isDisposed() && this.fShell.isVisible();
    }

    public Point computeSizeConstraints(int widthInChars, int heightInChars) {
        GC gc = new GC((Drawable)this.fText);
        gc.setFont(this.fTextFont);
        int width = gc.getFontMetrics().getAverageCharWidth();
        int height = gc.getFontMetrics().getHeight();
        gc.dispose();
        return new Point(widthInChars * width, heightInChars * height);
    }
}

