/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.text.doctools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DefaultMultilineCommentAutoEditStrategy
implements IAutoEditStrategy {
    protected static final String MULTILINE_START = "/*";
    protected static final String MULTILINE_MID = " * ";
    protected static final String MULTILINE_END = "*/";
    private static String fgDefaultLineDelim = "\n";

    public void customizeDocumentCommand(IDocument doc, DocumentCommand cmd) {
        fgDefaultLineDelim = TextUtilities.getDefaultLineDelimiter((IDocument)doc);
        if (doc instanceof IDocumentExtension4) {
            boolean forNewLine = cmd.length == 0 && cmd.text != null && DefaultMultilineCommentAutoEditStrategy.endsWithDelimiter(doc, cmd.text);
            boolean forCommentEnd = "/".equals(cmd.text);
            if (forNewLine || forCommentEnd) {
                IDocumentExtension4 ext4 = (IDocumentExtension4)doc;
                DocumentRewriteSession drs = ext4.startRewriteSession(DocumentRewriteSessionType.UNRESTRICTED_SMALL);
                try {
                    if (forNewLine) {
                        this.customizeDocumentAfterNewLine(doc, cmd);
                    } else if (forCommentEnd) {
                        this.customizeDocumentForMultilineCommentEnd(doc, cmd);
                    }
                }
                finally {
                    ext4.stopRewriteSession(drs);
                }
            }
        }
    }

    protected void customizeDocumentForMultilineCommentEnd(IDocument doc, DocumentCommand command) {
        if (command.offset < 2 || doc.getLength() == 0) {
            return;
        }
        try {
            if ("* ".equals(doc.get(command.offset - 2, 2))) {
                ++command.length;
                --command.offset;
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    public void customizeDocumentAfterNewLine(IDocument doc, DocumentCommand c) {
        int offset = c.offset;
        if (offset == -1 || doc.getLength() == 0) {
            return;
        }
        String lineDelim = TextUtilities.getDefaultLineDelimiter((IDocument)doc);
        StringBuilder buf = new StringBuilder(c.text);
        try {
            boolean commentAtStart;
            IRegion line = doc.getLineInformationOfOffset(c.offset);
            int lineStart = line.getOffset();
            int firstNonWS = DefaultMultilineCommentAutoEditStrategy.findEndOfWhiteSpaceAt(doc, lineStart, c.offset);
            IRegion prefix = DefaultMultilineCommentAutoEditStrategy.findPrefixRange(doc, line);
            String indentation = doc.get(prefix.getOffset(), prefix.getLength());
            int lengthToAdd = Math.min(offset - prefix.getOffset(), prefix.getLength());
            buf.append(indentation.substring(0, lengthToAdd));
            boolean bl = commentAtStart = firstNonWS < c.offset && doc.getChar(firstNonWS) == '/';
            if (commentAtStart) {
                buf.append(MULTILINE_MID);
            }
            c.shiftsCaret = false;
            c.caretOffset = c.offset + buf.length();
            if (commentAtStart && this.shouldCloseMultiline(doc, c.offset)) {
                try {
                    IASTNodeSelector ans;
                    IASTNode node;
                    doc.replace(c.offset, 0, String.valueOf(indentation) + " " + MULTILINE_END);
                    buf.append(lineDelim);
                    IASTDeclaration dec = null;
                    IASTTranslationUnit ast = this.getAST();
                    if (ast != null && (dec = DefaultMultilineCommentAutoEditStrategy.findFollowingDeclaration(ast, offset)) == null && (node = (ans = ast.getNodeSelector(ast.getFilePath())).findEnclosingNode(offset, 0)) instanceof IASTDeclaration) {
                        dec = (IASTDeclaration)node;
                    }
                    if (dec != null) {
                        ITypedRegion partition = TextUtilities.getPartition((IDocument)doc, (String)"___c_partitioning", (int)offset, (boolean)false);
                        StringBuilder content = this.customizeAfterNewLineForDeclaration(doc, dec, partition);
                        buf.append((CharSequence)DefaultMultilineCommentAutoEditStrategy.indent(content, String.valueOf(indentation) + MULTILINE_MID, lineDelim));
                    }
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
            }
            c.text = buf.toString();
        }
        catch (BadLocationException badLocationException) {}
    }

    protected StringBuilder customizeAfterNewLineForDeclaration(IDocument doc, IASTDeclaration dec, ITypedRegion region) {
        return new StringBuilder();
    }

    public static IASTDeclaration findFollowingDeclaration(IASTTranslationUnit unit, final int offset) {
        final IASTDeclaration[] dec = new IASTDeclaration[1];
        ASTVisitor av = new ASTVisitor(){
            IASTDeclaration stopWhenLeaving;
            {
                this.shouldVisitTranslationUnit = true;
                this.shouldVisitDeclarations = true;
            }

            public int visit(IASTDeclaration declaration) {
                IASTFileLocation loc = declaration.getFileLocation();
                if (loc != null) {
                    boolean candidateEnclosesOffset;
                    int candidateOffset = loc.getNodeOffset();
                    int candidateEndOffset = candidateOffset + loc.getNodeLength();
                    if (offset <= candidateOffset) {
                        dec[0] = declaration;
                        return 2;
                    }
                    boolean bl = candidateEnclosesOffset = offset >= candidateOffset && offset < candidateEndOffset;
                    if (candidateEnclosesOffset) {
                        this.stopWhenLeaving = declaration;
                    }
                }
                return 3;
            }

            public int leave(IASTDeclaration declaration) {
                if (declaration == this.stopWhenLeaving) {
                    return 2;
                }
                return 3;
            }
        };
        if (unit != null) {
            unit.accept(av);
        }
        return dec[0];
    }

    public IASTTranslationUnit getAST() {
        ITranslationUnit unit = DefaultMultilineCommentAutoEditStrategy.getTranslationUnit();
        try {
            if (unit != null) {
                IASTTranslationUnit ast = unit.getAST(null, 6);
                return ast;
            }
        }
        catch (CModelException ce) {
            CUIPlugin.log(ce);
        }
        catch (CoreException ce) {
            CUIPlugin.log(ce);
        }
        return null;
    }

    public boolean shouldCloseMultiline(IDocument document, int offset) {
        String comment;
        int partitionEnd;
        block6: {
            ITypedRegion partition;
            block5: {
                try {
                    IRegion line = document.getLineInformationOfOffset(offset);
                    partition = TextUtilities.getPartition((IDocument)document, (String)"___c_partitioning", (int)offset, (boolean)false);
                    partitionEnd = partition.getOffset() + partition.getLength();
                    if (line.getOffset() < partitionEnd) break block5;
                    return false;
                }
                catch (BadLocationException badLocationException) {
                    return false;
                }
            }
            comment = document.get(partition.getOffset(), partition.getLength());
            if (comment.indexOf(MULTILINE_START, offset - partition.getOffset()) == -1) break block6;
            return true;
        }
        if (document.getLength() == partitionEnd) {
            return !comment.endsWith(MULTILINE_END);
        }
        return false;
    }

    protected static ITranslationUnit getTranslationUnit() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        IEditorPart editor = page.getActiveEditor();
        if (editor == null) {
            return null;
        }
        IWorkingCopyManager manager = CUIPlugin.getDefault().getWorkingCopyManager();
        IWorkingCopy unit = manager.getWorkingCopy(editor.getEditorInput());
        if (unit == null) {
            return null;
        }
        return unit;
    }

    private static final StringBuilder indent(StringBuilder buffer, String indent, String lineDelim) {
        StringBuilder result = new StringBuilder();
        BufferedReader br = new BufferedReader(new StringReader(buffer.toString()));
        try {
            String line = br.readLine();
            while (line != null) {
                result.append(indent).append(line).append(lineDelim);
                line = br.readLine();
            }
        }
        catch (IOException iOException) {
            throw new AssertionError();
        }
        return result;
    }

    protected static final StringBuilder indent(StringBuilder buffer, String indent) {
        StringBuilder result = new StringBuilder();
        BufferedReader br = new BufferedReader(new StringReader(buffer.toString()));
        try {
            String line = br.readLine();
            while (line != null) {
                result.append(indent).append(line).append(fgDefaultLineDelim);
                line = br.readLine();
            }
        }
        catch (IOException iOException) {
            throw new AssertionError();
        }
        return result;
    }

    protected static int findEndOfWhiteSpaceAt(IDocument document, int offset, int end) throws BadLocationException {
        while (offset < end) {
            char c = document.getChar(offset);
            if (c != ' ' && c != '\t') {
                return offset;
            }
            ++offset;
        }
        return end;
    }

    protected static IRegion findPrefixRange(IDocument document, IRegion line) throws BadLocationException {
        int lineEnd;
        int lineOffset = line.getOffset();
        int indentEnd = DefaultMultilineCommentAutoEditStrategy.findEndOfWhiteSpaceAt(document, lineOffset, lineEnd = lineOffset + line.getLength());
        if (indentEnd < lineEnd && document.getChar(indentEnd) == '*') {
            ++indentEnd;
            while (indentEnd < lineEnd && !DefaultMultilineCommentAutoEditStrategy.isWhitespace(document.getChar(indentEnd))) {
                ++indentEnd;
            }
            while (indentEnd < lineEnd && DefaultMultilineCommentAutoEditStrategy.isWhitespace(document.getChar(indentEnd))) {
                ++indentEnd;
            }
        }
        return new Region(lineOffset, indentEnd - lineOffset);
    }

    private static boolean isWhitespace(char ch) {
        return ch == ' ' || ch == '\t';
    }

    protected static boolean endsWithDelimiter(IDocument d, String txt) {
        String[] delimiters = d.getLegalLineDelimiters();
        int i = 0;
        while (i < delimiters.length) {
            if (txt.endsWith(delimiters[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

