/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.cdt.ui;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tm.internal.tcf.cdt.ui.Activator;
import org.eclipse.tm.internal.tcf.debug.ui.launch.ITCFLaunchContext;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;

public class TCFLaunchContext
implements ITCFLaunchContext {
    public boolean isActive() {
        return this.getContext(null) != null;
    }

    public boolean isSupportedSelection(Object selection) {
        if (selection instanceof IProject) {
            return CoreModel.getDefault().getCModel().getCProject(((IProject)selection).getName()) != null;
        }
        return selection instanceof ICElement;
    }

    public IPath getPath(Object selection) {
        if (selection instanceof IResource) {
            return ((IResource)selection).getLocation();
        }
        if (selection instanceof ICElement) {
            return ((ICElement)selection).getResource().getLocation();
        }
        return null;
    }

    public IProject getProject(Object selection) {
        if (selection instanceof IProject) {
            return (IProject)selection;
        }
        if (selection instanceof ICElement) {
            return ((ICElement)selection).getCProject().getProject();
        }
        return null;
    }

    public void setDefaults(ILaunchConfigurationDialog dlg, ILaunchConfigurationWorkingCopy config) {
        ICElement element = this.getContext((ILaunchConfiguration)config);
        if (element != null) {
            this.initializeCProject(element, config);
            this.initializeProgramName(element, dlg, config);
        }
    }

    private ICElement getContext(ILaunchConfiguration config) {
        ICElement ce;
        IStructuredSelection ss;
        ISelection selection;
        String projectName = null;
        String programName = null;
        if (config != null) {
            try {
                projectName = config.getAttribute("org.eclipse.tm.tcf.debug.ProjectName", null);
                programName = config.getAttribute("org.eclipse.tm.tcf.debug.LocalProgramFile", null);
            }
            catch (CoreException e) {
                Activator.log(e);
            }
        }
        Object obj = null;
        IWorkbenchPage page = Activator.getActivePage();
        if (projectName != null && !projectName.equals("")) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            ICProject cProject = CCorePlugin.getDefault().getCoreModel().create(project);
            if (cProject != null && cProject.exists()) {
                obj = cProject;
            }
        } else if (page != null && (selection = page.getSelection()) instanceof IStructuredSelection && !(ss = (IStructuredSelection)selection).isEmpty()) {
            obj = ss.getFirstElement();
        }
        if (obj instanceof IResource) {
            ce = CoreModel.getDefault().create((IResource)obj);
            if (ce == null) {
                IProject pro = ((IResource)obj).getProject();
                ce = CoreModel.getDefault().create(pro);
            }
            obj = ce;
        }
        if (obj instanceof ICElement) {
            if (programName == null || programName.equals("")) {
                return obj;
            }
            ce = obj;
            IProject project = (IProject)ce.getCProject().getResource();
            IPath programFile = project.getFile(programName).getLocation();
            ce = CCorePlugin.getDefault().getCoreModel().create(programFile);
            if (ce != null && ce.exists()) {
                return ce;
            }
            return obj;
        }
        IEditorPart part = page.getActiveEditor();
        if (part != null) {
            IEditorInput input = part.getEditorInput();
            return (ICElement)input.getAdapter(ICElement.class);
        }
        return null;
    }

    private void initializeCProject(ICElement cElement, ILaunchConfigurationWorkingCopy config) {
        ICProject cProject = cElement.getCProject();
        String name = null;
        if (cProject != null && cProject.exists()) {
            name = cProject.getElementName();
            config.setMappedResources(new IResource[]{cProject.getProject()});
        }
        config.setAttribute("org.eclipse.tm.tcf.debug.ProjectName", name);
    }

    private void initializeProgramName(ICElement cElement, ILaunchConfigurationDialog dlg, ILaunchConfigurationWorkingCopy config) {
        String name;
        boolean renamed = false;
        if (!(cElement instanceof IBinary)) {
            cElement = cElement.getCProject();
        }
        if (cElement instanceof ICProject) {
            IProject project = cElement.getCProject().getProject();
            name = project.getName();
            ICProjectDescription projDes = CCorePlugin.getDefault().getProjectDescription(project);
            if (projDes != null) {
                String buildConfigName = projDes.getActiveConfiguration().getName();
                name = String.valueOf(name) + " " + buildConfigName;
            }
            name = dlg.generateName(name);
            config.rename(name);
            renamed = true;
        }
        IBinary binary = null;
        if (cElement instanceof ICProject) {
            IBinary[] bins = this.getBinaryFiles((ICProject)cElement);
            if (bins != null && bins.length == 1) {
                binary = bins[0];
            }
        } else if (cElement instanceof IBinary) {
            binary = (IBinary)cElement;
        }
        if (binary != null) {
            String path = binary.getResource().getProjectRelativePath().toOSString();
            config.setAttribute("org.eclipse.tm.tcf.debug.LocalProgramFile", path);
            if (!renamed) {
                String name2 = binary.getElementName();
                int index = name2.lastIndexOf(46);
                if (index > 0) {
                    name2 = name2.substring(0, index);
                }
                name2 = dlg.generateName(name2);
                config.rename(name2);
                renamed = true;
            }
        }
        if (!renamed) {
            name = dlg.generateName(cElement.getCProject().getElementName());
            config.rename(name);
        }
    }

    public String getBuildConfigID(IProject project) {
        ICProjectDescription projDes = CCorePlugin.getDefault().getProjectDescription(project);
        if (projDes == null) {
            return null;
        }
        return projDes.getActiveConfiguration().getId();
    }

    private IBinary[] getBinaryFiles(final ICProject cproject) {
        if (cproject == null || !cproject.exists()) {
            return null;
        }
        Display display = Display.getCurrent();
        final Object[] ret = new Object[1];
        BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

            public void run() {
                try {
                    ret[0] = cproject.getBinaryContainer().getBinaries();
                }
                catch (CModelException e) {
                    Activator.errorDialog("Launch UI internal error", e);
                }
            }
        });
        return (IBinary[])ret[0];
    }

    public boolean isBinary(IProject project, IPath path) throws CoreException {
        ICExtensionReference[] parserRef = CCorePlugin.getDefault().getBinaryParserExtensions(project);
        int i = 0;
        while (i < parserRef.length) {
            try {
                IBinaryParser parser = (IBinaryParser)parserRef[i].createExtension();
                if (parser.getBinary(path) != null) {
                    return true;
                }
            }
            catch (Exception exception) {}
            ++i;
        }
        IBinaryParser parser = CCorePlugin.getDefault().getDefaultBinaryParser();
        try {
            return parser.getBinary(path) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String chooseBinary(Shell shell, IProject project) {
        CElementLabelProvider programLabelProvider = new CElementLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IBinary) {
                    IBinary bin = (IBinary)element;
                    StringBuffer name = new StringBuffer();
                    name.append(bin.getPath().lastSegment());
                    return name.toString();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                IBinary belement;
                if (!(element instanceof ICElement)) {
                    return super.getImage(element);
                }
                ICElement celement = (ICElement)element;
                if (celement.getElementType() == 14 && (belement = (IBinary)celement).isExecutable()) {
                    return DebugUITools.getImage((String)"IMG_ACT_RUN");
                }
                return super.getImage(element);
            }
        };
        CElementLabelProvider qualifierLabelProvider = new CElementLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IBinary) {
                    IBinary bin = (IBinary)element;
                    StringBuffer name = new StringBuffer();
                    name.append(String.valueOf(bin.getCPU()) + (bin.isLittleEndian() ? "le" : "be"));
                    name.append(" - ");
                    name.append(bin.getPath().toString());
                    return name.toString();
                }
                return super.getText(element);
            }
        };
        TwoPaneElementSelector dialog = new TwoPaneElementSelector(shell, (ILabelProvider)programLabelProvider, (ILabelProvider)qualifierLabelProvider);
        dialog.setElements((Object[])this.getBinaryFiles(this.getCProject(project.getName())));
        dialog.setMessage("Choose program to run");
        dialog.setTitle("Program Selection");
        dialog.setUpperListLabel("Binaries:");
        dialog.setLowerListLabel("Qualifier:");
        dialog.setMultipleSelection(false);
        if (dialog.open() != 0) {
            return null;
        }
        IBinary binary = (IBinary)dialog.getFirstResult();
        return binary.getResource().getProjectRelativePath().toString();
    }

    private ICProject getCProject(String name) {
        String projectName = name.trim();
        if (projectName.length() < 1) {
            return null;
        }
        return CoreModel.getDefault().getCModel().getCProject(projectName);
    }
}

