/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.services.local;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.tm.internal.tcf.core.LocalPeer;
import org.eclipse.tm.internal.tcf.core.RemotePeer;
import org.eclipse.tm.internal.tcf.core.ServiceManager;
import org.eclipse.tm.internal.tcf.core.TransportManager;
import org.eclipse.tm.internal.tcf.services.local.ChannelProxy;
import org.eclipse.tm.tcf.core.AbstractChannel;
import org.eclipse.tm.tcf.core.AbstractPeer;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IPeer;
import org.eclipse.tm.tcf.protocol.IService;
import org.eclipse.tm.tcf.protocol.IServiceProvider;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.JSON;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.tm.tcf.services.ILocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocatorService
implements ILocator {
    private static final int DISCOVEY_PORT = 1534;
    private static final int MAX_PACKET_SIZE = 8952;
    private static final int PREF_PACKET_SIZE = 1452;
    private static LocatorService locator;
    private static final Map<String, IPeer> peers;
    private static final ArrayList<ILocator.LocatorListener> listeners;
    private static final HashMap<String, Throwable> error_log;
    private final HashSet<SubNet> subnets = new HashSet();
    private final ArrayList<Slave> slaves = new ArrayList();
    private final byte[] inp_buf = new byte[8952];
    private final byte[] out_buf = new byte[8952];
    private InetAddress loopback_addr;
    private static final HashMap<String, AddressCacheItem> addr_cache;
    private static boolean addr_request;
    private static LocalPeer local_peer;
    private DatagramSocket socket;
    private long last_master_packet_time;
    private final Thread timer_thread = new Thread(){

        public void run() {
            while (true) {
                try {
                    while (true) {
                        1.sleep(15000L);
                        Protocol.invokeAndWait(new Runnable(){

                            public void run() {
                                LocatorService.this.refresh_timer();
                            }
                        });
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    return;
                }
                catch (Throwable x) {
                    LocatorService.this.log("Unhandled exception in TCF discovery timer thread", x);
                    continue;
                }
                break;
            }
        }
    };
    private Thread dns_lookup_thread = new Thread(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                try lbl-1000:
                // 2 sources

                {
                    while (true) {
                        set = null;
                        var4_4 = LocatorService.access$2();
                        synchronized (var4_4) {
                            if (!LocatorService.access$3()) {
                                LocatorService.access$2().wait(60000L);
                            }
                            time = System.currentTimeMillis();
                            i = LocatorService.access$2().values().iterator();
                            while (true) {
                                if (!i.hasNext()) {
                                    LocatorService.access$4(false);
                                    break;
                                }
                                a = (AddressCacheItem)i.next();
                                if (a.time_stamp + 600000L >= time) continue;
                                if (a.used) {
                                    if (set == null) {
                                        set = new HashSet<AddressCacheItem>();
                                    }
                                    set.add(a);
                                    continue;
                                }
                                i.remove();
                            }
                        }
                        if (set == null) continue;
                        var5_5 = set.iterator();
                        if (true) ** GOTO lbl51
                        break;
                    }
                }
                catch (Throwable x) {
                    LocatorService.access$1(LocatorService.this, "Unhandled exception in TCF discovery DNS lookup thread", x);
                    continue;
                }
                break;
            }
            do {
                a = (AddressCacheItem)var5_5.next();
                addr = null;
                try {
                    addr = InetAddress.getByName(a.host);
                }
                catch (UnknownHostException v1) {}
                var7_7 = LocatorService.access$2();
                synchronized (var7_7) {
                    a.address = addr;
                    a.time_stamp = time;
                    a.used = false;
                }
lbl51:
                // 2 sources

            } while (var5_5.hasNext());
            ** while (true)
        }
    };
    private final Thread input_thread = new Thread(){

        public void run() {
            while (true) {
                DatagramSocket socket = LocatorService.this.socket;
                try {
                    final DatagramPacket p = new DatagramPacket(LocatorService.this.inp_buf, LocatorService.this.inp_buf.length);
                    socket.receive(p);
                    Protocol.invokeAndWait(new Runnable(){

                        public void run() {
                            LocatorService.this.handleDatagramPacket(p);
                        }
                    });
                    continue;
                }
                catch (IllegalStateException illegalStateException) {
                    return;
                }
                catch (Exception x) {
                    if (socket != LocatorService.this.socket) continue;
                    LocatorService.this.log("Cannot read from datagram socket at port " + socket.getLocalPort(), x);
                    continue;
                }
                break;
            }
        }
    };

    static {
        peers = new HashMap<String, IPeer>();
        listeners = new ArrayList();
        error_log = new HashMap();
        addr_cache = new HashMap();
        ServiceManager.addServiceProvider(new IServiceProvider(){

            public IService[] getLocalService(final IChannel channel) {
                channel.addCommandServer(locator, new IChannel.ICommandServer(){

                    public void command(IToken token, String name, byte[] data) {
                        locator.command((AbstractChannel)channel, token, name, data);
                    }
                });
                return new IService[]{locator};
            }

            public IService getServiceProxy(IChannel channel, String service_name) {
                return null;
            }
        });
    }

    public LocatorService() {
        locator = this;
        try {
            this.loopback_addr = InetAddress.getByName(null);
            this.out_buf[0] = 84;
            this.out_buf[1] = 67;
            this.out_buf[2] = 70;
            this.out_buf[3] = 50;
            this.out_buf[4] = 0;
            this.out_buf[5] = 0;
            this.out_buf[6] = 0;
            this.out_buf[7] = 0;
            try {
                this.socket = new DatagramSocket(1534);
            }
            catch (SocketException socketException) {
                this.socket = new DatagramSocket();
            }
            this.socket.setBroadcast(true);
            this.input_thread.setName("TCF Locator Receiver");
            this.timer_thread.setName("TCF Locator Timer");
            this.dns_lookup_thread.setName("TCF Locator DNS Lookup");
            this.input_thread.setDaemon(true);
            this.timer_thread.setDaemon(true);
            this.dns_lookup_thread.setDaemon(true);
            this.input_thread.start();
            this.timer_thread.start();
            this.dns_lookup_thread.start();
            listeners.add(new ILocator.LocatorListener(){

                public void peerAdded(IPeer peer) {
                    LocatorService.this.sendPeerInfo(peer, null, 0);
                }

                public void peerChanged(IPeer peer) {
                    LocatorService.this.sendPeerInfo(peer, null, 0);
                }

                public void peerHeartBeat(String id) {
                }

                public void peerRemoved(String id) {
                }
            });
            this.refreshSubNetList();
            this.sendPeersRequest(null, 0);
            this.sendAll(null, 0, null, System.currentTimeMillis());
        }
        catch (Exception x) {
            this.log("Cannot open UDP socket for TCF discovery protocol", x);
        }
    }

    public static LocalPeer getLocalPeer() {
        return local_peer;
    }

    public static ILocator.LocatorListener[] getListeners() {
        return listeners.toArray(new ILocator.LocatorListener[listeners.size()]);
    }

    public static void addPeer(AbstractPeer peer) {
        assert (peers.get(peer.getID()) == null);
        if (peer instanceof LocalPeer) {
            local_peer = (LocalPeer)peer;
        }
        peers.put(peer.getID(), peer);
        peer.sendPeerAddedEvent();
    }

    public static void removePeer(AbstractPeer peer) {
        String id = peer.getID();
        assert (peers.get(id) == peer);
        peers.remove(id);
        peer.sendPeerRemovedEvent();
    }

    private Map<String, Object> makeErrorReport(int code, String msg) {
        HashMap<String, Object> err = new HashMap<String, Object>();
        err.put("Time", new Long(System.currentTimeMillis()));
        err.put("Code", new Integer(code));
        err.put("Format", msg);
        return err;
    }

    private void command(AbstractChannel channel, IToken token, String name, byte[] data) {
        try {
            if (name.equals("redirect")) {
                String peer_id = (String)JSON.parseSequence(data)[0];
                IPeer peer = peers.get(peer_id);
                if (peer == null) {
                    channel.sendResult(token, JSON.toJSONSequence(new Object[]{this.makeErrorReport(7, "Unknown peer ID")}));
                    return;
                }
                channel.sendResult(token, JSON.toJSONSequence(new Object[1]));
                if (peer instanceof LocalPeer) {
                    channel.sendEvent(Protocol.getLocator(), "Hello", JSON.toJSONSequence(new Object[]{channel.getLocalServices()}));
                    return;
                }
                new ChannelProxy(channel, peer.openChannel());
            } else if (name.equals("sync")) {
                channel.sendResult(token, null);
            } else if (name.equals("getPeers")) {
                int i = 0;
                Object[] arr = new Object[peers.size()];
                for (IPeer p : peers.values()) {
                    arr[i++] = p.getAttributes();
                }
                Object[] objectArray = new Object[2];
                objectArray[1] = arr;
                channel.sendResult(token, JSON.toJSONSequence(objectArray));
            } else {
                channel.rejectCommand(token);
            }
        }
        catch (Throwable x) {
            channel.terminate(x);
        }
    }

    private void log(String msg, Throwable x) {
        if (error_log.get(msg) == null) {
            error_log.put(msg, x);
            Protocol.log(msg, x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InetAddress getInetAddress(String host) {
        if (host == null || host.length() == 0) {
            return null;
        }
        HashMap<String, AddressCacheItem> hashMap = addr_cache;
        synchronized (hashMap) {
            AddressCacheItem i = addr_cache.get(host);
            if (i == null) {
                i = new AddressCacheItem(host);
                char ch = host.charAt(0);
                if (ch == '[' || ch == ':' || ch >= '0' && ch <= '9') {
                    try {
                        i.address = InetAddress.getByName(host);
                    }
                    catch (UnknownHostException unknownHostException) {}
                    i.time_stamp = System.currentTimeMillis();
                } else {
                    addr_request = true;
                    addr_cache.notify();
                }
                addr_cache.put(host, i);
            }
            i.used = true;
            return i.address;
        }
    }

    private void refresh_timer() {
        long time = System.currentTimeMillis();
        if (this.slaves.size() > 0) {
            int i = 0;
            while (i < this.slaves.size()) {
                Slave s = this.slaves.get(i);
                if (s.last_packet_time + 60000L < time) {
                    this.slaves.remove(i);
                    continue;
                }
                ++i;
            }
        }
        ArrayList<RemotePeer> stale_peers = null;
        for (IPeer p : peers.values()) {
            RemotePeer r;
            if (!(p instanceof RemotePeer) || (r = (RemotePeer)p).getLastUpdateTime() + 60000L >= time) continue;
            if (stale_peers == null) {
                stale_peers = new ArrayList<RemotePeer>();
            }
            stale_peers.add(r);
        }
        if (stale_peers != null) {
            IChannel[] open_channels = TransportManager.getOpenChannels();
            HashSet<IPeer> connected_peers = new HashSet<IPeer>();
            IChannel[] iChannelArray = open_channels;
            int n = open_channels.length;
            int n2 = 0;
            while (n2 < n) {
                IChannel c = iChannelArray[n2];
                connected_peers.add(c.getRemotePeer());
                ++n2;
            }
            for (RemotePeer p : stale_peers) {
                if (connected_peers.contains(p)) continue;
                p.dispose();
            }
        }
        if (this.socket.getLocalPort() != 1534 && this.last_master_packet_time + 30000L <= time) {
            DatagramSocket s0 = this.socket;
            DatagramSocket s1 = null;
            try {
                s1 = new DatagramSocket(1534);
                s1.setBroadcast(true);
                this.socket = s1;
                s0.close();
            }
            catch (Throwable throwable) {}
        }
        this.refreshSubNetList();
        if (this.socket.getLocalPort() != 1534) {
            for (SubNet subnet : this.subnets) {
                this.addSlave(subnet.address, this.socket.getLocalPort(), time);
            }
        }
        this.sendAll(null, 0, null, time);
    }

    private Slave addSlave(InetAddress addr, int port, long timestamp) {
        for (Slave s : this.slaves) {
            if (s.port != port || !s.address.equals(addr)) continue;
            if (s.last_packet_time < timestamp) {
                s.last_packet_time = timestamp;
            }
            return s;
        }
        long time = System.currentTimeMillis();
        Slave s = new Slave(addr, port);
        s.last_packet_time = timestamp;
        this.slaves.add(s);
        this.sendPeersRequest(addr, port);
        this.sendAll(addr, port, s, time);
        this.sendSlaveInfo(s, time);
        return s;
    }

    /*
     * Unable to fully structure code
     */
    private void refreshSubNetList() {
        set = new HashSet<SubNet>();
        try {
            e = NetworkInterface.getNetworkInterfaces();
            block6: while (e.hasMoreElements()) {
                f = e.nextElement();
                try {
                    m0 = f.getClass().getMethod("getInterfaceAddresses", new Class[0]);
                    for (E ia : (List)m0.invoke((Object)f, new Object[0])) {
                        m1 = ia.getClass().getMethod("getNetworkPrefixLength", new Class[0]);
                        m2 = ia.getClass().getMethod("getAddress", new Class[0]);
                        m3 = ia.getClass().getMethod("getBroadcast", new Class[0]);
                        network_prefix_len = ((Short)m1.invoke(ia, new Object[0])).shortValue();
                        address = (InetAddress)m2.invoke(ia, new Object[0]);
                        broadcast = (InetAddress)m3.invoke(ia, new Object[0]);
                        if (network_prefix_len <= 0 && (buf = address.getAddress()).length == 4 && buf[0] == 127) {
                            network_prefix_len = 8;
                            buf[3] = -1;
                            buf[2] = -1;
                            buf[1] = -1;
                            broadcast = InetAddress.getByAddress(buf);
                        }
                        if (address instanceof Inet4Address && network_prefix_len > 32) {
                            network_prefix_len = 24;
                        }
                        if (network_prefix_len <= 0 || address == null || broadcast == null) continue;
                        set.add(new SubNet(network_prefix_len, address, broadcast));
                    }
                    continue;
                }
                catch (Exception v0) {
                    n = f.getInetAddresses();
                    ** while (n.hasMoreElements())
                }
lbl-1000:
                // 1 sources

                {
                    addr = n.nextElement();
                    buf = addr.getAddress();
                    if (buf.length != 4) continue;
                    buf[3] = -1;
                    try {
                        set.add(new SubNet(24, addr, InetAddress.getByAddress(buf)));
                    }
                    catch (UnknownHostException v1) {}
                    continue;
lbl41:
                    // 1 sources

                }
            }
        }
        catch (SocketException x) {
            this.log("Cannot get list of network interfaces", x);
        }
        i = this.subnets.iterator();
        while (i.hasNext()) {
            s = i.next();
            if (set.contains(s)) continue;
            i.remove();
        }
        for (SubNet s : set) {
            if (this.subnets.contains(s)) continue;
            this.subnets.add(s);
        }
    }

    private byte[] getUTF8Bytes(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (Exception x) {
            this.log("UTF-8 character encoder is not available", x);
            return s.getBytes();
        }
    }

    private boolean sendDatagramPacket(SubNet subnet, int size, InetAddress addr, int port) {
        block7: {
            block6: {
                try {
                    if (addr == null) {
                        addr = subnet.broadcast;
                        port = 1534;
                        for (Slave slave : this.slaves) {
                            this.sendDatagramPacket(subnet, size, slave.address, slave.port);
                        }
                    }
                    if (subnet.contains(addr)) break block6;
                    return false;
                }
                catch (Exception x) {
                    this.log("Cannot send datagram packet to " + addr, x);
                    return false;
                }
            }
            if (port != this.socket.getLocalPort() || !addr.equals(subnet.address)) break block7;
            return false;
        }
        this.socket.send(new DatagramPacket(this.out_buf, size, addr, port));
        return true;
    }

    private void sendPeersRequest(InetAddress addr, int port) {
        this.out_buf[4] = 1;
        for (SubNet subnet : this.subnets) {
            this.sendDatagramPacket(subnet, 8, addr, port);
        }
    }

    private void sendPeerInfo(IPeer peer, InetAddress addr, int port) {
        Map<String, String> attrs = peer.getAttributes();
        InetAddress peer_addr = this.getInetAddress(attrs.get("Host"));
        if (peer_addr == null) {
            return;
        }
        if (attrs.get("Port") == null) {
            return;
        }
        this.out_buf[4] = 2;
        int i = 8;
        for (SubNet subnet : this.subnets) {
            if (peer instanceof RemotePeer) {
                if (this.socket.getLocalPort() != 1534) {
                    return;
                }
                if (!subnet.address.equals(this.loopback_addr) && !subnet.address.equals(peer_addr)) continue;
            }
            if (!subnet.address.equals(this.loopback_addr) && !subnet.contains(peer_addr)) continue;
            if (i == 8) {
                StringBuffer sb = new StringBuffer(this.out_buf.length);
                for (String key : attrs.keySet()) {
                    sb.append(key);
                    sb.append('=');
                    sb.append(attrs.get(key));
                    sb.append('\u0000');
                }
                byte[] bt = this.getUTF8Bytes(sb.toString());
                if (i + bt.length > this.out_buf.length) {
                    return;
                }
                System.arraycopy(bt, 0, this.out_buf, i, bt.length);
                i += bt.length;
            }
            if (!this.sendDatagramPacket(subnet, i, addr, port)) continue;
            subnet.send_all_ok = true;
        }
    }

    private void sendEmptyPacket(InetAddress addr, int port) {
        this.out_buf[4] = 4;
        for (SubNet subnet : this.subnets) {
            if (subnet.send_all_ok) continue;
            this.sendDatagramPacket(subnet, 8, addr, port);
        }
    }

    private void sendAll(InetAddress addr, int port, Slave sl, long time) {
        for (SubNet subnet : this.subnets) {
            subnet.send_all_ok = false;
        }
        for (IPeer peer : peers.values()) {
            this.sendPeerInfo(peer, addr, port);
        }
        if (addr != null && sl != null && sl.last_req_slaves_time + 60000L >= time) {
            this.sendSlavesInfo(addr, port, time);
        }
        this.sendEmptyPacket(addr, port);
    }

    private void sendSlavesRequest(SubNet subnet, InetAddress addr, int port) {
        this.out_buf[4] = 3;
        this.sendDatagramPacket(subnet, 8, addr, port);
    }

    private void sendSlaveInfo(Slave x, long time) {
        this.out_buf[4] = 4;
        for (SubNet subnet : this.subnets) {
            if (!subnet.contains(x.address)) continue;
            int i = 8;
            String s = String.valueOf(x.last_packet_time) + ":" + x.port + ":" + x.address.getHostAddress();
            byte[] bt = this.getUTF8Bytes(s);
            System.arraycopy(bt, 0, this.out_buf, i, bt.length);
            i += bt.length;
            this.out_buf[i++] = 0;
            for (Slave y : this.slaves) {
                if (!subnet.contains(y.address) || y.last_req_slaves_time + 60000L < time) continue;
                this.sendDatagramPacket(subnet, i, y.address, y.port);
            }
        }
    }

    private void sendSlavesInfo(InetAddress addr, int port, long time) {
        this.out_buf[4] = 4;
        for (SubNet subnet : this.subnets) {
            if (!subnet.contains(addr)) continue;
            int i = 8;
            for (Slave x : this.slaves) {
                if (x.last_packet_time + 60000L < time || x.port == port && x.address.equals(addr) || !subnet.address.equals(this.loopback_addr) && !subnet.contains(x.address)) continue;
                subnet.send_all_ok = true;
                String s = String.valueOf(x.last_packet_time) + ":" + x.port + ":" + x.address.getHostAddress();
                byte[] bt = this.getUTF8Bytes(s);
                if (i > 8 && i + bt.length >= 1452) {
                    this.sendDatagramPacket(subnet, i, addr, port);
                    i = 8;
                }
                System.arraycopy(bt, 0, this.out_buf, i, bt.length);
                i += bt.length;
                this.out_buf[i++] = 0;
            }
            if (i <= 8) continue;
            this.sendDatagramPacket(subnet, i, addr, port);
        }
    }

    private boolean isRemote(InetAddress address, int port) {
        if (port != this.socket.getLocalPort()) {
            return true;
        }
        for (SubNet s : this.subnets) {
            if (!s.address.equals(address)) continue;
            return false;
        }
        return true;
    }

    private void handleDatagramPacket(DatagramPacket p) {
        try {
            long time = System.currentTimeMillis();
            byte[] buf = p.getData();
            int len = p.getLength();
            if (len < 8) {
                return;
            }
            if (buf[0] != 84) {
                return;
            }
            if (buf[1] != 67) {
                return;
            }
            if (buf[2] != 70) {
                return;
            }
            if (buf[3] != 50) {
                return;
            }
            int remote_port = p.getPort();
            InetAddress remote_address = p.getAddress();
            if (this.isRemote(remote_address, remote_port)) {
                Slave sl = null;
                if (remote_port != 1534) {
                    sl = this.addSlave(remote_address, remote_port, time);
                }
                switch (buf[4]) {
                    case 2: {
                        this.handlePeerInfoPacket(p);
                        break;
                    }
                    case 1: {
                        this.handleReqInfoPacket(p, sl, time);
                        break;
                    }
                    case 4: {
                        this.handleSlavesInfoPacket(p);
                        break;
                    }
                    case 3: {
                        this.handleReqSlavesPacket(p, sl, time);
                    }
                }
                for (SubNet subnet : this.subnets) {
                    if (!subnet.contains(remote_address)) continue;
                    long delay = 20000L;
                    if (remote_port != 1534) {
                        delay = 40000L;
                    } else if (!subnet.address.equals(remote_address)) {
                        delay = 30000L;
                    }
                    if (subnet.last_slaves_req_time + delay <= time) {
                        this.sendSlavesRequest(subnet, remote_address, remote_port);
                        subnet.last_slaves_req_time = time;
                    }
                    if (!subnet.address.equals(remote_address) || remote_port != 1534) continue;
                    this.last_master_packet_time = time;
                }
            }
        }
        catch (Throwable x) {
            this.log("Invalid datagram packet received from " + p.getAddress(), x);
        }
    }

    private void handlePeerInfoPacket(DatagramPacket p) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            String s = new String(p.getData(), 8, p.getLength() - 8, "UTF-8");
            int l = s.length();
            int i = 0;
            while (i < l) {
                int i0 = i;
                while (i < l && s.charAt(i) != '=' && s.charAt(i) != '\u0000') {
                    ++i;
                }
                int i1 = i;
                if (i >= l || s.charAt(i) == '=') {
                    // empty if block
                }
                int i2 = ++i;
                while (i < l && s.charAt(i) != '\u0000') {
                    ++i;
                }
                int i3 = i;
                if (i < l && s.charAt(i) == '\u0000') {
                    ++i;
                }
                String key = s.substring(i0, i1);
                String val = s.substring(i2, i3);
                map.put(key, val);
            }
            String id = (String)map.get("ID");
            if (id == null) {
                throw new Exception("Invalid peer info: no ID");
            }
            InetAddress peer_addr = this.getInetAddress((String)map.get("Host"));
            if (peer_addr == null) {
                return;
            }
            for (SubNet subnet : this.subnets) {
                if (!subnet.contains(peer_addr)) continue;
                IPeer peer = peers.get(id);
                if (peer instanceof RemotePeer) {
                    ((RemotePeer)peer).updateAttributes(map);
                } else if (peer == null) {
                    new RemotePeer(map);
                }
                break;
            }
        }
        catch (Exception x) {
            this.log("Invalid datagram packet received from " + p.getAddress(), x);
        }
    }

    private void handleReqInfoPacket(DatagramPacket p, Slave sl, long time) {
        this.sendAll(p.getAddress(), p.getPort(), sl, time);
    }

    private void handleSlavesInfoPacket(DatagramPacket p) {
        try {
            String s = new String(p.getData(), 8, p.getLength() - 8, "UTF-8");
            int l = s.length();
            int i = 0;
            while (i < l) {
                long time;
                String host;
                InetAddress addr;
                int port;
                int time0 = i;
                while (i < l && s.charAt(i) != ':' && s.charAt(i) != '\u0000') {
                    ++i;
                }
                int time1 = i;
                if (i >= l || s.charAt(i) == ':') {
                    // empty if block
                }
                int port0 = ++i;
                while (i < l && s.charAt(i) != ':' && s.charAt(i) != '\u0000') {
                    ++i;
                }
                int port1 = i;
                if (i >= l || s.charAt(i) == ':') {
                    // empty if block
                }
                int host0 = ++i;
                while (i < l && s.charAt(i) != '\u0000') {
                    ++i;
                }
                int host1 = i;
                if (i < l && s.charAt(i) == '\u0000') {
                    ++i;
                }
                if ((port = Integer.parseInt(s.substring(port0, port1))) == 1534 || (addr = this.getInetAddress(host = s.substring(host0, host1))) == null) continue;
                long time_now = System.currentTimeMillis();
                long l2 = time = time0 != time1 ? Long.parseLong(s.substring(time0, time1)) : time_now;
                if (time < time_now - 600000L || time > time_now + 600000L) {
                    this.log("Invalid datagram packet received from " + p.getAddress(), new Exception("Invalid slave info timestamp: " + time));
                    continue;
                }
                this.addSlave(addr, port, time);
            }
        }
        catch (Exception x) {
            this.log("Invalid datagram packet received from " + p.getAddress(), x);
        }
    }

    private void handleReqSlavesPacket(DatagramPacket p, Slave sl, long time) {
        if (sl != null) {
            sl.last_req_slaves_time = time;
        }
        this.sendSlavesInfo(p.getAddress(), p.getPort(), time);
    }

    public static LocatorService getLocator() {
        return locator;
    }

    @Override
    public String getName() {
        return "Locator";
    }

    @Override
    public Map<String, IPeer> getPeers() {
        assert (Protocol.isDispatchThread());
        return peers;
    }

    @Override
    public IToken redirect(String peer_id, ILocator.DoneRedirect done) {
        throw new Error("Channel redirect cannot be done on local peer");
    }

    @Override
    public IToken sync(ILocator.DoneSync done) {
        throw new Error("Channel sync cannot be done on local peer");
    }

    @Override
    public void addListener(ILocator.LocatorListener listener) {
        assert (listener != null);
        assert (Protocol.isDispatchThread());
        listeners.add(listener);
    }

    @Override
    public void removeListener(ILocator.LocatorListener listener) {
        assert (Protocol.isDispatchThread());
        listeners.remove(listener);
    }

    static /* synthetic */ HashMap access$2() {
        return addr_cache;
    }

    static /* synthetic */ boolean access$3() {
        return addr_request;
    }

    static /* synthetic */ void access$4(boolean bl) {
        addr_request = bl;
    }

    private static class AddressCacheItem {
        final String host;
        InetAddress address;
        long time_stamp;
        boolean used;

        AddressCacheItem(String host) {
            this.host = host;
        }
    }

    private static class Slave {
        final InetAddress address;
        final int port;
        long last_packet_time;
        long last_req_slaves_time;

        Slave(InetAddress address, int port) {
            this.address = address;
            this.port = port;
        }

        public String toString() {
            return String.valueOf(this.address.getHostAddress()) + ":" + this.port;
        }
    }

    private static class SubNet {
        final int prefix_length;
        final InetAddress address;
        final InetAddress broadcast;
        long last_slaves_req_time;
        boolean send_all_ok;

        SubNet(int prefix_length, InetAddress address, InetAddress broadcast) {
            this.prefix_length = prefix_length;
            this.address = address;
            this.broadcast = broadcast;
        }

        boolean contains(InetAddress addr) {
            int n;
            byte[] a2;
            if (addr == null || this.address == null) {
                return false;
            }
            byte[] a1 = addr.getAddress();
            if (a1.length != (a2 = this.address.getAddress()).length) {
                return false;
            }
            int i = 0;
            int l = this.prefix_length <= a1.length * 8 ? this.prefix_length : a1.length * 8;
            while (i + 8 <= l) {
                n = i / 8;
                if (a1[n] != a2[n]) {
                    return false;
                }
                i += 8;
            }
            while (i < l) {
                n = i / 8;
                int m = 1 << 7 - i % 8;
                if ((a1[n] & m) != (a2[n] & m)) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public boolean equals(Object o) {
            if (!(o instanceof SubNet)) {
                return false;
            }
            SubNet x = (SubNet)o;
            return this.prefix_length == x.prefix_length && this.broadcast.equals(x.broadcast) && this.address.equals(x.address);
        }

        public int hashCode() {
            return this.address.hashCode();
        }

        public String toString() {
            return String.valueOf(this.address.getHostAddress()) + "/" + this.prefix_length;
        }
    }
}

