/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.tcf.core;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.tm.internal.tcf.core.TransportManager;
import org.eclipse.tm.internal.tcf.services.local.LocatorService;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IPeer;
import org.eclipse.tm.tcf.protocol.JSON;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.tm.tcf.services.ILocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractPeer
implements IPeer {
    private final Map<String, String> ro_attrs;
    private final Map<String, String> rw_attrs;
    private long last_heart_beat_time;

    public AbstractPeer(Map<String, String> attrs) {
        assert (Protocol.isDispatchThread());
        this.rw_attrs = attrs != null ? new HashMap<String, String>(attrs) : new HashMap<String, String>();
        this.ro_attrs = Collections.unmodifiableMap(this.rw_attrs);
        assert (this.getID() != null);
        LocatorService.addPeer(this);
    }

    void onChannelTerminated() {
        this.last_heart_beat_time = 0L;
    }

    public void updateAttributes(Map<String, String> attrs) {
        boolean equ = true;
        assert (attrs.get("ID").equals(this.rw_attrs.get("ID")));
        for (String key : this.rw_attrs.keySet()) {
            if (this.rw_attrs.get(key).equals(attrs.get(key))) continue;
            equ = false;
            break;
        }
        for (String key : attrs.keySet()) {
            if (attrs.get(key).equals(this.rw_attrs.get(key))) continue;
            equ = false;
            break;
        }
        long time = System.currentTimeMillis();
        if (!equ) {
            this.rw_attrs.clear();
            this.rw_attrs.putAll(attrs);
            ILocator.LocatorListener[] locatorListenerArray = LocatorService.getListeners();
            int n = locatorListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILocator.LocatorListener l = locatorListenerArray[n2];
                try {
                    l.peerChanged(this);
                }
                catch (Throwable x) {
                    Protocol.log("Unhandled exception in Locator listener", x);
                }
                ++n2;
            }
            try {
                Object[] args = new Object[]{this.rw_attrs};
                Protocol.sendEvent("Locator", "peerChanged", JSON.toJSONSequence(args));
            }
            catch (IOException x) {
                Protocol.log("Locator: failed to send 'peerChanged' event", x);
            }
            this.last_heart_beat_time = time;
        } else if (this.last_heart_beat_time + 15000L < time) {
            ILocator.LocatorListener[] locatorListenerArray = LocatorService.getListeners();
            int n = locatorListenerArray.length;
            int n3 = 0;
            while (n3 < n) {
                ILocator.LocatorListener l = locatorListenerArray[n3];
                try {
                    l.peerHeartBeat(attrs.get("ID"));
                }
                catch (Throwable x) {
                    Protocol.log("Unhandled exception in Locator listener", x);
                }
                ++n3;
            }
            try {
                Object[] args = new Object[]{this.rw_attrs.get("ID")};
                Protocol.sendEvent("Locator", "peerHeartBeat", JSON.toJSONSequence(args));
            }
            catch (IOException x) {
                Protocol.log("Locator: failed to send 'peerHeartBeat' event", x);
            }
            this.last_heart_beat_time = time;
        }
    }

    public void sendPeerAddedEvent() {
        ILocator.LocatorListener[] locatorListenerArray = LocatorService.getListeners();
        int n = locatorListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILocator.LocatorListener l = locatorListenerArray[n2];
            try {
                l.peerAdded(this);
            }
            catch (Throwable x) {
                Protocol.log("Unhandled exception in Locator listener", x);
            }
            ++n2;
        }
        try {
            Object[] args = new Object[]{this.rw_attrs};
            Protocol.sendEvent("Locator", "peerAdded", JSON.toJSONSequence(args));
        }
        catch (IOException x) {
            Protocol.log("Locator: failed to send 'peerAdded' event", x);
        }
        this.last_heart_beat_time = System.currentTimeMillis();
    }

    public void sendPeerRemovedEvent() {
        ILocator.LocatorListener[] locatorListenerArray = LocatorService.getListeners();
        int n = locatorListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILocator.LocatorListener l = locatorListenerArray[n2];
            try {
                l.peerRemoved(this.rw_attrs.get("ID"));
            }
            catch (Throwable x) {
                Protocol.log("Unhandled exception in Locator listener", x);
            }
            ++n2;
        }
        try {
            Object[] args = new Object[]{this.rw_attrs.get("ID")};
            Protocol.sendEvent("Locator", "peerRemoved", JSON.toJSONSequence(args));
        }
        catch (IOException x) {
            Protocol.log("Locator: failed to send 'peerRemoved' event", x);
        }
    }

    public void dispose() {
        assert (Protocol.isDispatchThread());
        TransportManager.peerDisposed(this);
        LocatorService.removePeer(this);
    }

    @Override
    public Map<String, String> getAttributes() {
        assert (Protocol.isDispatchThread());
        return this.ro_attrs;
    }

    @Override
    public String getID() {
        assert (Protocol.isDispatchThread());
        return this.ro_attrs.get("ID");
    }

    @Override
    public String getName() {
        assert (Protocol.isDispatchThread());
        return this.ro_attrs.get("Name");
    }

    @Override
    public String getOSName() {
        assert (Protocol.isDispatchThread());
        return this.ro_attrs.get("OSName");
    }

    @Override
    public String getTransportName() {
        assert (Protocol.isDispatchThread());
        return this.ro_attrs.get("TransportName");
    }

    @Override
    public IChannel openChannel() {
        return TransportManager.openChannel(this);
    }
}

