/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.model;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.tm.internal.tcf.debug.model.TCFContextState;
import org.eclipse.tm.internal.tcf.debug.model.TCFSourceRef;
import org.eclipse.tm.internal.tcf.debug.ui.ImageCache;
import org.eclipse.tm.internal.tcf.debug.ui.model.ISymbolOwner;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFChildrenExecContext;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFChildrenStackTrace;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModel;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNode;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeStackFrame;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeSymbol;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.tm.tcf.services.IMemory;
import org.eclipse.tm.tcf.services.IMemoryMap;
import org.eclipse.tm.tcf.services.IProcesses;
import org.eclipse.tm.tcf.services.IRunControl;
import org.eclipse.tm.tcf.util.TCFDataCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCFNodeExecContext
extends TCFNode
implements ISymbolOwner {
    private final int seq_no;
    private final TCFChildrenExecContext children_exec;
    private final TCFChildrenStackTrace children_stack;
    private final TCFDataCache<IMemory.MemoryContext> mem_context;
    private final TCFDataCache<IRunControl.RunControlContext> run_context;
    private final TCFDataCache<MemoryRegion[]> memory_map;
    private final TCFDataCache<IProcesses.ProcessContext> prs_context;
    private final TCFDataCache<TCFContextState> state;
    private final TCFDataCache<BigInteger> address;
    private final TCFDataCache<Collection<Map<String, Object>>> signal_list;
    private final TCFDataCache<SignalMask[]> signal_mask;
    private final Map<BigInteger, TCFSourceRef> line_info_cache;
    private final Map<String, TCFNodeSymbol> symbols = new HashMap<String, TCFNodeSymbol>();
    private int resumed_cnt;
    private static int seq_cnt;

    TCFNodeExecContext(TCFNode parent, final String id) {
        super(parent, id);
        this.seq_no = seq_cnt++;
        this.children_exec = new TCFChildrenExecContext(this);
        this.children_stack = new TCFChildrenStackTrace(this);
        this.line_info_cache = new LinkedHashMap<BigInteger, TCFSourceRef>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<BigInteger, TCFSourceRef> eldest) {
                return this.size() > 256;
            }
        };
        this.mem_context = new TCFDataCache<IMemory.MemoryContext>(this.channel){

            protected boolean startDataRetrieval() {
                if (!$assertionsDisabled && this.command != null) {
                    throw new AssertionError();
                }
                IMemory mem = (IMemory)TCFNodeExecContext.this.model.getLaunch().getService(IMemory.class);
                if (mem == null) {
                    this.set(null, null, null);
                    return true;
                }
                this.command = mem.getContext(id, new IMemory.DoneGetContext(){

                    public void doneGetContext(IToken token, Exception error, IMemory.MemoryContext context) {
                        this.set(token, error, context);
                    }
                });
                return false;
            }
        };
        this.run_context = new TCFDataCache<IRunControl.RunControlContext>(this.channel){

            protected boolean startDataRetrieval() {
                if (!$assertionsDisabled && this.command != null) {
                    throw new AssertionError();
                }
                IRunControl run = (IRunControl)TCFNodeExecContext.this.model.getLaunch().getService(IRunControl.class);
                if (run == null) {
                    this.set(null, null, null);
                    return true;
                }
                this.command = run.getContext(id, new IRunControl.DoneGetContext(){

                    public void doneGetContext(IToken token, Exception error, IRunControl.RunControlContext context) {
                        this.set(token, error, context);
                    }
                });
                return false;
            }
        };
        this.prs_context = new TCFDataCache<IProcesses.ProcessContext>(this.channel){

            protected boolean startDataRetrieval() {
                if (!$assertionsDisabled && this.command != null) {
                    throw new AssertionError();
                }
                IProcesses prs = (IProcesses)TCFNodeExecContext.this.model.getLaunch().getService(IProcesses.class);
                if (prs == null) {
                    this.set(null, null, null);
                    return true;
                }
                this.command = prs.getContext(id, new IProcesses.DoneGetContext(){

                    public void doneGetContext(IToken token, Exception error, IProcesses.ProcessContext context) {
                        this.set(token, error, context);
                    }
                });
                return false;
            }
        };
        this.memory_map = new TCFDataCache<MemoryRegion[]>(this.channel){

            protected boolean startDataRetrieval() {
                if (!$assertionsDisabled && this.command != null) {
                    throw new AssertionError();
                }
                IMemoryMap mmap = (IMemoryMap)TCFNodeExecContext.this.model.getLaunch().getService(IMemoryMap.class);
                if (mmap == null) {
                    this.set(null, null, null);
                    return true;
                }
                this.command = mmap.get(id, new IMemoryMap.DoneGet(){

                    public void doneGet(IToken token, Exception error, IMemoryMap.MemoryRegion[] map) {
                        MemoryRegion[] arr = null;
                        if (map != null) {
                            int i = 0;
                            arr = new MemoryRegion[map.length];
                            IMemoryMap.MemoryRegion[] memoryRegionArray = map;
                            int n = map.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IMemoryMap.MemoryRegion r = memoryRegionArray[n2];
                                arr[i++] = new MemoryRegion(r);
                                ++n2;
                            }
                        }
                        this.set(token, error, arr);
                    }
                });
                return false;
            }
        };
        this.state = new TCFDataCache<TCFContextState>(this.channel){

            protected boolean startDataRetrieval() {
                if (!$assertionsDisabled && this.command != null) {
                    throw new AssertionError();
                }
                if (!TCFNodeExecContext.this.run_context.validate((Runnable)((Object)this))) {
                    return false;
                }
                IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)TCFNodeExecContext.this.run_context.getData();
                if (ctx == null || !ctx.hasState()) {
                    this.set(null, null, null);
                    return true;
                }
                this.command = ctx.getState(new IRunControl.DoneGetState(){

                    public void doneGetState(IToken token, Exception error, boolean suspended, String pc, String reason, Map<String, Object> params) {
                        TCFContextState s = new TCFContextState();
                        s.is_suspended = suspended;
                        s.suspend_pc = pc;
                        s.suspend_reason = reason;
                        s.suspend_params = params;
                        this.set(token, error, s);
                    }
                });
                return false;
            }
        };
        this.address = new TCFDataCache<BigInteger>(this.channel){

            protected boolean startDataRetrieval() {
                if (!TCFNodeExecContext.this.run_context.validate((Runnable)((Object)this))) {
                    return false;
                }
                IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)TCFNodeExecContext.this.run_context.getData();
                if (ctx == null || !ctx.hasState()) {
                    this.set(null, TCFNodeExecContext.this.run_context.getError(), null);
                    return true;
                }
                if (!TCFNodeExecContext.this.state.validate((Runnable)((Object)this))) {
                    return false;
                }
                TCFContextState s = (TCFContextState)TCFNodeExecContext.this.state.getData();
                if (s == null) {
                    this.set(null, TCFNodeExecContext.this.state.getError(), null);
                    return true;
                }
                if (s.suspend_pc == null) {
                    this.set(null, null, null);
                    return true;
                }
                this.set(null, null, new BigInteger(s.suspend_pc));
                return true;
            }
        };
        this.signal_list = new TCFDataCache<Collection<Map<String, Object>>>(this.channel){

            protected boolean startDataRetrieval() {
                IProcesses prs = (IProcesses)this.channel.getRemoteService(IProcesses.class);
                if (prs == null) {
                    this.set(null, null, null);
                    return true;
                }
                this.command = prs.getSignalList(id, new IProcesses.DoneGetSignalList(){

                    public void doneGetSignalList(IToken token, Exception error, Collection<Map<String, Object>> list) {
                        this.set(token, error, list);
                    }
                });
                return false;
            }
        };
        this.signal_mask = new TCFDataCache<SignalMask[]>(this.channel){

            protected boolean startDataRetrieval() {
                if (!TCFNodeExecContext.this.signal_list.validate((Runnable)((Object)this))) {
                    return false;
                }
                IProcesses prs = (IProcesses)this.channel.getRemoteService(IProcesses.class);
                final Collection sigs = (Collection)TCFNodeExecContext.this.signal_list.getData();
                if (prs == null || sigs == null) {
                    this.set(null, TCFNodeExecContext.this.signal_list.getError(), null);
                    return true;
                }
                this.command = prs.getSignalMask(id, new IProcesses.DoneGetSignalMask(){

                    public void doneGetSignalMask(IToken token, Exception error, int dont_stop, int dont_pass, int pending) {
                        int n = 0;
                        SignalMask[] list = new SignalMask[sigs.size()];
                        for (Map m : sigs) {
                            int n2 = n++;
                            SignalMask signalMask = new SignalMask();
                            list[n2] = signalMask;
                            SignalMask s = signalMask;
                            s.props = m;
                            int mask = 1 << s.getIndex().intValue();
                            s.dont_stop = (dont_stop & mask) != 0;
                            s.dont_pass = (dont_pass & mask) != 0;
                            boolean bl = s.pending = (pending & mask) != 0;
                        }
                        this.set(token, error, list);
                    }
                });
                return false;
            }
        };
    }

    @Override
    void dispose() {
        this.run_context.dispose();
        this.prs_context.dispose();
        this.mem_context.dispose();
        this.memory_map.dispose();
        this.state.dispose();
        this.address.dispose();
        this.signal_list.dispose();
        this.signal_mask.dispose();
        this.children_exec.dispose();
        this.children_stack.dispose();
        ArrayList<TCFNodeSymbol> l = new ArrayList<TCFNodeSymbol>(this.symbols.values());
        for (TCFNodeSymbol s : l) {
            s.dispose();
        }
        assert (this.symbols.size() == 0);
        super.dispose();
    }

    @Override
    void dispose(String id) {
        this.children_exec.dispose(id);
        this.children_stack.dispose(id);
    }

    void setRunContext(IRunControl.RunControlContext ctx) {
        this.run_context.reset((Object)ctx);
    }

    void setProcessContext(IProcesses.ProcessContext ctx) {
        this.prs_context.reset((Object)ctx);
    }

    void setMemoryContext(IMemory.MemoryContext ctx) {
        this.mem_context.reset((Object)ctx);
    }

    public TCFDataCache<MemoryRegion[]> getMemoryMap() {
        return this.memory_map;
    }

    public TCFDataCache<Collection<Map<String, Object>>> getSignalList() {
        return this.signal_list;
    }

    public TCFDataCache<SignalMask[]> getSignalMask() {
        return this.signal_mask;
    }

    public Map<BigInteger, TCFSourceRef> getLineInfoCache() {
        return this.line_info_cache;
    }

    public TCFDataCache<IRunControl.RunControlContext> getRunContext() {
        return this.run_context;
    }

    public TCFDataCache<IProcesses.ProcessContext> getProcessContext() {
        return this.prs_context;
    }

    public TCFDataCache<IMemory.MemoryContext> getMemoryContext() {
        return this.mem_context;
    }

    public TCFDataCache<BigInteger> getAddress() {
        return this.address;
    }

    public TCFDataCache<TCFContextState> getState() {
        return this.state;
    }

    public TCFChildrenStackTrace getStackTrace() {
        return this.children_stack;
    }

    public TCFChildrenExecContext getChildren() {
        return this.children_exec;
    }

    @Override
    public void addSymbol(TCFNodeSymbol s) {
        assert (this.symbols.get(s.id) == null);
        this.symbols.put(s.id, s);
    }

    @Override
    public void removeSymbol(TCFNodeSymbol s) {
        assert (this.symbols.get(s.id) == s);
        this.symbols.remove(s.id);
    }

    @Override
    protected boolean getData(IChildrenCountUpdate result, Runnable done) {
        if (!this.run_context.validate(done)) {
            return false;
        }
        IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)this.run_context.getData();
        if (ctx != null && ctx.hasState()) {
            if (!this.children_stack.validate(done)) {
                return false;
            }
            if (!"org.eclipse.debug.ui.DebugView".equals(result.getPresentationContext().getId())) {
                TCFNodeStackFrame frame = this.children_stack.getTopFrame();
                if (frame != null) {
                    return frame.getData(result, done);
                }
                result.setChildCount(0);
            } else {
                result.setChildCount(this.children_stack.size());
            }
        } else {
            if (!this.children_exec.validate(done)) {
                return false;
            }
            result.setChildCount(this.children_exec.size());
        }
        return true;
    }

    @Override
    protected boolean getData(IChildrenUpdate result, Runnable done) {
        TCFNode[] arr = null;
        if (!this.run_context.validate(done)) {
            return false;
        }
        IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)this.run_context.getData();
        if (ctx != null && ctx.hasState()) {
            if (!this.children_stack.validate(done)) {
                return false;
            }
            if (!"org.eclipse.debug.ui.DebugView".equals(result.getPresentationContext().getId())) {
                TCFNodeStackFrame frame = this.children_stack.getTopFrame();
                if (frame != null) {
                    return frame.getData(result, done);
                }
                arr = new TCFNode[]{};
            } else {
                arr = this.children_stack.toArray();
            }
        } else {
            if (!this.children_exec.validate(done)) {
                return false;
            }
            arr = this.children_exec.toArray();
        }
        int offset = 0;
        int r_offset = result.getOffset();
        int r_length = result.getLength();
        TCFNode[] tCFNodeArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            TCFNode n3 = tCFNodeArray[n2];
            if (offset >= r_offset && offset < r_offset + r_length) {
                result.setChild((Object)n3, offset);
            }
            ++offset;
            ++n2;
        }
        return true;
    }

    @Override
    protected boolean getData(IHasChildrenUpdate result, Runnable done) {
        if (!this.run_context.validate(done)) {
            return false;
        }
        IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)this.run_context.getData();
        if (ctx != null && ctx.hasState()) {
            if (!this.children_stack.validate(done)) {
                return false;
            }
            if (!"org.eclipse.debug.ui.DebugView".equals(result.getPresentationContext().getId())) {
                TCFNodeStackFrame frame = this.children_stack.getTopFrame();
                if (frame == null) {
                    result.setHasChilren(false);
                } else if (!frame.getData(result, done)) {
                    return false;
                }
            } else {
                result.setHasChilren(this.children_stack.size() > 0);
            }
        } else {
            if (!this.children_exec.validate(done)) {
                return false;
            }
            result.setHasChilren(this.children_exec.size() > 0);
        }
        return true;
    }

    @Override
    protected boolean getData(ILabelUpdate result, Runnable done) {
        if (!this.run_context.validate(done)) {
            return false;
        }
        String image_name = null;
        String label = this.id;
        Throwable error = this.run_context.getError();
        if (error != null) {
            result.setForeground(new RGB(255, 0, 0), 0);
            label = String.valueOf(label) + ": " + TCFModel.getErrorMessage(error, false);
        } else {
            IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)this.run_context.getData();
            if (ctx != null) {
                if (!this.state.validate(done)) {
                    return false;
                }
                TCFContextState state_data = (TCFContextState)this.state.getData();
                if (ctx.hasState()) {
                    image_name = state_data != null && state_data.is_terminated ? "icons/full/obj16/threadt_obj.gif" : (state_data != null && state_data.is_suspended ? "icons/full/obj16/threads_obj.gif" : "icons/full/obj16/thread_obj.gif");
                } else {
                    Boolean b = this.hasSuspendedChildren(done);
                    if (b == null) {
                        return false;
                    }
                    image_name = b != false ? "icons/full/obj16/debugts_obj.gif" : "icons/full/obj16/debugt_obj.gif";
                }
                if (state_data != null && !state_data.is_suspended) {
                    label = String.valueOf(label) + " (Running)";
                } else if (state_data != null && state_data.is_suspended) {
                    String r = state_data.suspend_reason;
                    if (this.model.isContextActionResultAvailable(this.id)) {
                        r = this.model.getContextActionResult(this.id);
                    }
                    label = r != null ? String.valueOf(label) + " (" + r + ")" : String.valueOf(label) + " (Suspended)";
                }
                String file = (String)ctx.getProperties().get("File");
                if (file != null) {
                    label = String.valueOf(label) + " " + file;
                }
            }
        }
        result.setImageDescriptor(ImageCache.getImageDescriptor(image_name), 0);
        result.setLabel(label, 0);
        return true;
    }

    void onContextAdded(IRunControl.RunControlContext context) {
        this.children_exec.onContextAdded(context);
    }

    void onContextChanged(IRunControl.RunControlContext context) {
        assert (!this.disposed);
        this.run_context.reset((Object)context);
        this.signal_mask.reset();
        this.state.reset();
        this.children_stack.reset();
        this.children_stack.onSourceMappingChange();
        for (TCFNodeSymbol s : this.symbols.values()) {
            s.onMemoryMapChanged();
        }
        this.addModelDelta(3072);
    }

    void onContextAdded(IMemory.MemoryContext context) {
        this.children_exec.onContextAdded(context);
    }

    void onContextChanged(IMemory.MemoryContext context) {
        assert (!this.disposed);
        this.mem_context.reset((Object)context);
        for (TCFNodeSymbol s : this.symbols.values()) {
            s.onMemoryMapChanged();
        }
        this.addModelDelta(3072);
    }

    void onContextRemoved() {
        assert (!this.disposed);
        ++this.resumed_cnt;
        this.dispose();
        this.addModelDelta(2);
    }

    void onContainerSuspended() {
        assert (!this.disposed);
        if (this.run_context.isValid()) {
            IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)this.run_context.getData();
            if (ctx == null) {
                return;
            }
            if (!ctx.hasState()) {
                return;
            }
        }
        this.state.reset();
        this.address.reset();
        this.children_stack.onSuspended();
        this.addModelDelta(3072);
    }

    void onContainerResumed() {
        assert (!this.disposed);
        if (this.run_context.isValid()) {
            IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)this.run_context.getData();
            if (ctx == null) {
                return;
            }
            if (!ctx.hasState()) {
                return;
            }
        }
        this.state.reset();
        for (TCFNodeSymbol s : this.symbols.values()) {
            s.onExeStateChange();
        }
        this.addModelDelta(3072);
    }

    void onContextSuspended(String pc, String reason, Map<String, Object> params) {
        assert (!this.disposed);
        if (pc != null) {
            TCFContextState tCFContextState = new TCFContextState();
            tCFContextState.is_suspended = true;
            tCFContextState.suspend_pc = pc;
            tCFContextState.suspend_reason = reason;
            tCFContextState.suspend_params = params;
            this.state.reset((Object)tCFContextState);
        } else {
            this.state.reset();
        }
        this.address.reset();
        this.signal_mask.reset();
        ++this.resumed_cnt;
        this.children_stack.onSuspended();
        for (TCFNodeSymbol tCFNodeSymbol : this.symbols.values()) {
            tCFNodeSymbol.onExeStateChange();
        }
        this.addModelDelta(3072);
    }

    void onContextResumed() {
        assert (!this.disposed);
        this.state.reset((Object)new TCFContextState());
        this.addModelDelta(2048);
        final int cnt = ++this.resumed_cnt;
        Protocol.invokeLater((long)250L, (Runnable)new Runnable(){

            public void run() {
                if (cnt != TCFNodeExecContext.this.resumed_cnt) {
                    return;
                }
                if (TCFNodeExecContext.this.disposed) {
                    return;
                }
                TCFNodeExecContext.this.children_stack.onResumed();
                TCFNodeExecContext.this.addModelDelta(1024);
                if (TCFNodeExecContext.this.parent instanceof TCFNodeExecContext) {
                    ((TCFNodeExecContext)TCFNodeExecContext.this.parent).onChildResumedOrSuspended();
                }
            }
        });
    }

    void onChildResumedOrSuspended() {
        IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)this.run_context.getData();
        if (ctx != null && ctx.isContainer()) {
            this.addModelDelta(2048);
        }
        if (this.parent instanceof TCFNodeExecContext) {
            ((TCFNodeExecContext)this.parent).onChildResumedOrSuspended();
        }
    }

    void onContextException(String msg) {
    }

    void onMemoryChanged(Number[] addr, long[] size) {
        assert (!this.disposed);
    }

    void onMemoryMapChanged() {
        this.memory_map.reset();
        this.children_exec.onMemoryMapChanged();
        this.children_stack.onMemoryMapChanged();
    }

    void onRegistersChanged() {
        this.children_stack.onRegistersChanged();
        this.addModelDelta(1024);
    }

    void onRegisterValueChanged() {
        this.state.reset();
        this.address.reset();
        this.children_stack.onRegisterValueChanged();
        this.addModelDelta(1024);
    }

    private Boolean hasSuspendedChildren(Runnable done) {
        if (!this.children_exec.validate(done)) {
            return null;
        }
        Map m = (Map)this.children_exec.getData();
        if (m == null) {
            return false;
        }
        for (TCFNode n : m.values()) {
            if (!(n instanceof TCFNodeExecContext)) continue;
            TCFNodeExecContext e = (TCFNodeExecContext)n;
            if (!e.run_context.validate(done)) {
                return null;
            }
            IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)e.run_context.getData();
            if (ctx == null) continue;
            if (ctx.hasState()) {
                TCFDataCache<TCFContextState> state_cache = e.getState();
                if (!state_cache.validate(done)) {
                    return null;
                }
                TCFContextState state_data = (TCFContextState)state_cache.getData();
                if (state_data != null && state_data.is_suspended) {
                    return true;
                }
            }
            if (!ctx.isContainer()) continue;
            Boolean b = e.hasSuspendedChildren(done);
            if (b == null) {
                return null;
            }
            if (!b.booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(TCFNode n) {
        if (n instanceof TCFNodeExecContext) {
            TCFNodeExecContext f = (TCFNodeExecContext)n;
            if (this.seq_no < f.seq_no) {
                return -1;
            }
            if (this.seq_no > f.seq_no) {
                return 1;
            }
        }
        return this.id.compareTo(n.id);
    }

    public static class MemoryRegion {
        private final BigInteger addr_start;
        private final BigInteger addr_end;
        public final IMemoryMap.MemoryRegion region;

        private MemoryRegion(IMemoryMap.MemoryRegion region) {
            this.region = region;
            Number addr = region.getAddress();
            Number size = region.getSize();
            if (addr == null || size == null) {
                this.addr_start = null;
                this.addr_end = null;
            } else {
                this.addr_start = addr instanceof BigInteger ? (BigInteger)addr : new BigInteger(addr.toString());
                this.addr_end = this.addr_start.add(size instanceof BigInteger ? (BigInteger)size : new BigInteger(size.toString()));
            }
        }

        public boolean contains(BigInteger addr) {
            return this.addr_start != null && this.addr_end != null && this.addr_start.compareTo(addr) <= 0 && this.addr_end.compareTo(addr) > 0;
        }

        public String toString() {
            return this.region.getProperties().toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SignalMask {
        protected Map<String, Object> props;
        protected boolean dont_stop;
        protected boolean dont_pass;
        protected boolean pending;

        public Number getIndex() {
            return (Number)this.props.get("Index");
        }

        public Number getCode() {
            return (Number)this.props.get("Code");
        }

        public Map<String, Object> getProperties() {
            return this.props;
        }

        public boolean isDontStop() {
            return this.dont_stop;
        }

        public boolean isDontPass() {
            return this.dont_pass;
        }

        public boolean isPending() {
            return this.pending;
        }

        public String toString() {
            StringBuffer bf = new StringBuffer();
            bf.append("[attrs=");
            bf.append(this.props.toString());
            if (this.dont_stop) {
                bf.append(",don't stop");
            }
            if (this.dont_pass) {
                bf.append(",don't pass");
            }
            if (this.pending) {
                bf.append(",pending");
            }
            bf.append(']');
            return bf.toString();
        }
    }
}

