/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public class ImageCache {
    public static final String IMG_TCF = "icons/tcf.gif";
    public static final String IMG_TARGET_TAB = "icons/target_tab.gif";
    public static final String IMG_TARGET_WIZARD = "icons/full/wizban/debug_wiz.png";
    public static final String IMG_ARGUMENTS_TAB = "icons/arguments_tab.gif";
    public static final String IMG_ATTRIBUTE = "icons/attribute.gif";
    public static final String IMG_PATH = "icons/path.gif";
    public static final String IMG_THREAD_TERMINATED = "icons/full/obj16/threadt_obj.gif";
    public static final String IMG_THREAD_SUSPENDED = "icons/full/obj16/threads_obj.gif";
    public static final String IMG_THREAD_RUNNNIG = "icons/full/obj16/thread_obj.gif";
    public static final String IMG_PROCESS_TERMINATED = "icons/full/obj16/debugtt_obj.gif";
    public static final String IMG_PROCESS_SUSPENDED = "icons/full/obj16/debugts_obj.gif";
    public static final String IMG_PROCESS_RUNNING = "icons/full/obj16/debugt_obj.gif";
    public static final String IMG_REGISTER = "icons/full/obj16/genericregister_obj.gif";
    public static final String IMG_VARIABLE = "icons/full/obj16/genericvariable_obj.gif";
    public static final String IMG_SIGNALS = "icons/signals.gif";
    public static final String IMG_ARRAY_PARTITION = "icons/full/obj16/arraypartition_obj.gif";
    public static final String IMG_STACK_FRAME_SUSPENDED = "icons/full/obj16/stckframe_obj.gif";
    public static final String IMG_STACK_FRAME_RUNNING = "icons/full/obj16/stckframe_running_obj.gif";
    public static final String IMG_BREAKPOINT_ENABLED = "icons/full/obj16/brkp_obj.gif";
    public static final String IMG_BREAKPOINT_DISABLED = "icons/full/obj16/brkpd_obj.gif";
    private static final Map<String, ImageDescriptor> desc_cache = new HashMap<String, ImageDescriptor>();
    private static final Map<ImageDescriptor, Image> image_cache = new HashMap<ImageDescriptor, Image>();

    public static synchronized ImageDescriptor getImageDescriptor(String name) {
        if (name == null) {
            return null;
        }
        ImageDescriptor descriptor = desc_cache.get(name);
        if (descriptor == null) {
            URL url;
            Bundle bundle = Platform.getBundle((String)"org.eclipse.tm.tcf.debug.ui");
            if (bundle != null && (url = FileLocator.find((Bundle)bundle, (IPath)new Path(name), null)) != null) {
                descriptor = ImageDescriptor.createFromURL((URL)url);
            }
            if (descriptor == null && (bundle = Platform.getBundle((String)"org.eclipse.debug.ui")) != null && (url = FileLocator.find((Bundle)bundle, (IPath)new Path(name), null)) != null) {
                descriptor = ImageDescriptor.createFromURL((URL)url);
            }
            if (descriptor == null) {
                descriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            desc_cache.put(name, descriptor);
        }
        return descriptor;
    }

    public static synchronized Image getImage(ImageDescriptor desc) {
        Image image = image_cache.get(desc);
        if (image == null) {
            image = desc.createImage();
            image_cache.put(desc, image);
        }
        return image;
    }

    public static synchronized Image getImage(String name) {
        return ImageCache.getImage(ImageCache.getImageDescriptor(name));
    }
}

