/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.commands;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IStepIntoHandler;
import org.eclipse.tm.internal.tcf.debug.actions.TCFActionStepInto;
import org.eclipse.tm.internal.tcf.debug.model.TCFContextState;
import org.eclipse.tm.internal.tcf.debug.model.TCFSourceRef;
import org.eclipse.tm.internal.tcf.debug.ui.commands.StepCommand;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModel;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeStackFrame;
import org.eclipse.tm.tcf.services.IRunControl;
import org.eclipse.tm.tcf.services.IStackTrace;
import org.eclipse.tm.tcf.util.TCFDataCache;

public class StepIntoCommand
extends StepCommand
implements IStepIntoHandler {
    public StepIntoCommand(TCFModel model) {
        super(model);
    }

    protected boolean canExecute(IRunControl.RunControlContext ctx) {
        if (ctx == null) {
            return false;
        }
        if (ctx.canResume(4)) {
            return true;
        }
        return ctx.canResume(2);
    }

    protected void execute(IDebugCommandRequest monitor, IRunControl.RunControlContext ctx, boolean src_step, Runnable done) {
        new StepStateMachine(this.model, monitor, ctx, src_step, done);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StepStateMachine
    extends TCFActionStepInto {
        private final IDebugCommandRequest monitor;
        private final Runnable done;
        private final TCFNodeExecContext node;
        private TCFNodeStackFrame frame;

        StepStateMachine(TCFModel model, IDebugCommandRequest monitor, IRunControl.RunControlContext ctx, boolean src_step, Runnable done) {
            super(model.getLaunch(), ctx, src_step);
            this.monitor = monitor;
            this.done = done;
            this.node = (TCFNodeExecContext)model.getNode(this.context_id);
        }

        protected TCFDataCache<TCFContextState> getContextState() {
            if (this.node == null) {
                return null;
            }
            return this.node.getState();
        }

        protected TCFDataCache<TCFSourceRef> getLineInfo() {
            if (this.frame == null) {
                this.frame = this.node.getStackTrace().getTopFrame();
            }
            if (this.frame == null) {
                return null;
            }
            return this.frame.getLineInfo();
        }

        protected TCFDataCache<IStackTrace.StackTraceContext> getStackFrame() {
            if (this.frame == null) {
                this.frame = this.node.getStackTrace().getTopFrame();
            }
            if (this.frame == null) {
                return null;
            }
            return this.frame.getStackTraceContext();
        }

        protected int getStackFrameIndex() {
            if (this.frame == null) {
                this.frame = this.node.getStackTrace().getTopFrame();
            }
            if (this.frame == null) {
                return 0;
            }
            return this.frame.getFrameNo();
        }

        protected TCFDataCache<?> getStackTrace() {
            return this.node.getStackTrace();
        }

        protected void exit(Throwable error) {
            if (this.exited) {
                return;
            }
            super.exit(error);
            if (error != null && this.node.getChannel().getState() == 1) {
                this.monitor.setStatus((IStatus)new Status(4, "org.eclipse.tm.tcf.debug.ui", 0, "Cannot step", error));
            }
            this.done.run();
        }
    }
}

