/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.model;

import java.util.HashMap;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFChildren;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFChildrenStackTrace;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNode;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeRegister;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeStackFrame;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.services.IRegisters;

public class TCFChildrenRegisters
extends TCFChildren {
    private final TCFNodeStackFrame node;

    TCFChildrenRegisters(TCFNodeStackFrame node) {
        super(node.channel, 128);
        this.node = node;
    }

    void onSuspended() {
        for (TCFNode n : this.getNodes()) {
            ((TCFNodeRegister)n).onSuspended();
        }
        this.reset();
    }

    void onRegistersChanged() {
        for (TCFNode n : this.getNodes()) {
            ((TCFNodeRegister)n).onRegistersChanged();
        }
        this.reset();
    }

    protected boolean startDataRetrieval() {
        TCFChildrenStackTrace stack_trace_cache = ((TCFNodeExecContext)this.node.parent).getStackTrace();
        if (!stack_trace_cache.validate((Runnable)((Object)this))) {
            return false;
        }
        IRegisters regs = (IRegisters)this.node.model.getLaunch().getService(IRegisters.class);
        int frame_no = this.node.getFrameNo();
        if (regs == null || frame_no < 0) {
            this.set(null, null, new HashMap<String, TCFNode>());
            return true;
        }
        assert (this.command == null);
        final TCFNode parent = frame_no == 0 ? this.node.parent : this.node;
        this.command = regs.getChildren(parent.id, new IRegisters.DoneGetChildren(){

            public void doneGetChildren(IToken token, Exception error, String[] contexts) {
                HashMap<String, TCFNode> data = null;
                if (TCFChildrenRegisters.this.command == token && error == null) {
                    int index = 0;
                    data = new HashMap<String, TCFNode>();
                    String[] stringArray = contexts;
                    int n = contexts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String id = stringArray[n2];
                        TCFNode n3 = ((TCFChildrenRegisters)TCFChildrenRegisters.this).node.model.getNode(id);
                        if (n3 == null) {
                            n3 = new TCFNodeRegister(parent, id);
                        }
                        if (!$assertionsDisabled && n3.parent != parent) {
                            throw new AssertionError();
                        }
                        ((TCFNodeRegister)n3).setIndex(index++);
                        data.put(id, n3);
                        ++n2;
                    }
                }
                TCFChildrenRegisters.this.set(token, (Throwable)error, data);
            }
        });
        return false;
    }
}

