/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.provisional.AbstractModelProxy;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModel;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNode;
import org.eclipse.tm.tcf.protocol.Protocol;

public class TCFModelProxy
extends AbstractModelProxy
implements IModelProxy,
Runnable {
    private static final long MIN_IDLE_TIME = 250L;
    private static final TCFNode[] EMPTY_NODE_ARRAY = new TCFNode[0];
    private final TCFModel model;
    private final Map<TCFNode, Integer> node2flags = new HashMap<TCFNode, Integer>();
    private final Map<TCFNode, TCFNode[]> node2children = new HashMap<TCFNode, TCFNode[]>();
    private final Map<TCFNode, ModelDelta> node2delta = new HashMap<TCFNode, ModelDelta>();
    private TCFNode selection;
    private boolean posted;
    private boolean disposed;
    private long last_update_time;
    private final Runnable timer = new Runnable(){

        public void run() {
            TCFModelProxy.this.posted = false;
            long idle_time = System.currentTimeMillis() - TCFModelProxy.this.last_update_time;
            if (idle_time < 200L) {
                Protocol.invokeLater((long)(250L - idle_time), (Runnable)this);
                TCFModelProxy.this.posted = true;
            } else {
                TCFModelProxy.this.run();
            }
        }
    };
    private final ChildrenCountUpdate children_count_update = new ChildrenCountUpdate();
    private final ChildrenUpdate children_update = new ChildrenUpdate();
    private TCFNode pending_node;

    TCFModelProxy(TCFModel model) {
        this.model = model;
    }

    public void installed(Viewer viewer) {
        super.installed(viewer);
        Protocol.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                if (!$assertionsDisabled && TCFModelProxy.this.disposed) {
                    throw new AssertionError();
                }
                IPresentationContext p = TCFModelProxy.this.getPresentationContext();
                if (p != null) {
                    TCFModelProxy.this.model.onProxyInstalled(p, TCFModelProxy.this);
                }
            }
        });
    }

    public void dispose() {
        Protocol.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                if (!$assertionsDisabled && TCFModelProxy.this.disposed) {
                    throw new AssertionError();
                }
                IPresentationContext p = TCFModelProxy.this.getPresentationContext();
                if (p != null) {
                    TCFModelProxy.this.model.onProxyDisposed(p);
                }
                TCFModelProxy.this.disposed = true;
            }
        });
        super.dispose();
    }

    void addDelta(TCFNode node, int flags) {
        if (flags == 0) {
            return;
        }
        Integer delta = this.node2flags.get(node);
        if (delta != null) {
            this.node2flags.put(node, delta | flags);
        } else {
            this.node2flags.put(node, flags);
        }
        this.post();
    }

    void setSelection(TCFNode node) {
        this.selection = node;
        while (node.parent != null) {
            node = node.parent;
            this.addDelta(node, 0x100000);
        }
        this.post();
    }

    private void post() {
        assert (Protocol.isDispatchThread());
        if (!this.posted) {
            long idle_time = System.currentTimeMillis() - this.last_update_time;
            Protocol.invokeLater((long)(250L - idle_time), (Runnable)this.timer);
            this.posted = true;
        }
    }

    private TCFNode[] getNodeChildren(TCFNode node) {
        TCFNode[] res = this.node2children.get(node);
        if (res == null) {
            if (node.disposed) {
                res = EMPTY_NODE_ARRAY;
            } else if (!node.getData(this.children_count_update, null)) {
                this.pending_node = node;
                res = EMPTY_NODE_ARRAY;
            } else {
                this.children_update.setLength(this.children_count_update.count);
                if (!node.getData(this.children_update, null)) {
                    assert (false);
                    this.pending_node = node;
                    res = EMPTY_NODE_ARRAY;
                } else {
                    res = this.children_update.children;
                }
            }
            this.node2children.put(node, res);
        }
        return res;
    }

    private int getNodeIndex(TCFNode node) {
        TCFNode[] arr = this.getNodeChildren(node.parent);
        int i = 0;
        while (i < arr.length) {
            if (arr[i] == node) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private ModelDelta makeDelta(ModelDelta root, TCFNode node, int flags, boolean selection_delta) {
        ModelDelta delta = this.node2delta.get(node);
        if (delta == null) {
            if (node.parent == null) {
                if (root.getElement() instanceof TCFNode) {
                    return null;
                }
                int children = -1;
                if (selection_delta || (flags & 0x100000) != 0) {
                    children = this.getNodeChildren(node).length;
                }
                delta = root.addNode((Object)this.model.getLaunch(), -1, flags, children);
            } else if (node == root.getElement()) {
                delta = root;
            } else {
                int parent_flags = 0;
                Integer parent_flags_obj = this.node2flags.get(node.parent);
                if (parent_flags_obj != null) {
                    parent_flags = parent_flags_obj;
                }
                if ((parent_flags & 2) != 0) {
                    return null;
                }
                ModelDelta parent = this.makeDelta(root, node.parent, parent_flags, selection_delta);
                if (parent == null) {
                    return null;
                }
                int index = -1;
                int children = -1;
                if ((flags & 0x10) != 0) {
                    index = this.getNodeIndex(node);
                }
                if (selection_delta || (flags & 0x100000) != 0) {
                    if (index < 0) {
                        index = this.getNodeIndex(node);
                    }
                    children = this.getNodeChildren(node).length;
                }
                delta = parent.addNode((Object)node, index, flags, children);
            }
            this.node2delta.put(node, delta);
        }
        assert (delta.getFlags() == flags);
        return delta;
    }

    private void postDelta(final ModelDelta root) {
        this.model.getDisplay().asyncExec(new Runnable(){

            public void run() {
                TCFModelProxy.this.fireModelChanged((IModelDelta)root);
            }
        });
    }

    public void run() {
        assert (Protocol.isDispatchThread());
        if (this.disposed) {
            return;
        }
        if (this.node2flags.isEmpty() && this.selection == null) {
            return;
        }
        this.pending_node = null;
        this.node2children.clear();
        this.node2delta.clear();
        Object input = this.getViewer().getInput();
        int flags = 0;
        if (this.node2flags.containsKey(input)) {
            flags = this.node2flags.get(input);
        }
        ModelDelta root = new ModelDelta(input, flags);
        for (TCFNode node : this.node2flags.keySet()) {
            this.makeDelta(root, node, this.node2flags.get(node), false);
        }
        if (this.pending_node == null) {
            this.node2flags.clear();
            if ((root.getFlags() != 0 || this.node2delta.size() > 0) && (root.getFlags() & 2) == 0) {
                this.postDelta(root);
            }
            this.node2delta.clear();
            this.last_update_time = System.currentTimeMillis();
            if (this.selection != null) {
                root = new ModelDelta(input, 0);
                this.makeDelta(root, this.selection, 0x300000, true);
                this.node2delta.clear();
                if (this.pending_node == null) {
                    this.postDelta(root);
                    this.selection = null;
                }
            }
        }
        if (this.pending_node != null && this.pending_node.getData(this.children_count_update, (Runnable)this)) {
            assert (false);
            Protocol.invokeLater((Runnable)this);
        }
        this.node2children.clear();
    }

    private class ChildrenCountUpdate
    extends ViewerUpdate
    implements IChildrenCountUpdate {
        int count;

        private ChildrenCountUpdate() {
        }

        public void setChildCount(int count) {
            this.count = count;
        }
    }

    private class ChildrenUpdate
    extends ViewerUpdate
    implements IChildrenUpdate {
        int length;
        TCFNode[] children;

        private ChildrenUpdate() {
        }

        void setLength(int length) {
            this.length = length;
            this.children = length == 0 ? EMPTY_NODE_ARRAY : new TCFNode[length];
        }

        public int getLength() {
            return this.length;
        }

        public int getOffset() {
            return 0;
        }

        public void setChild(Object child, int offset) {
            this.children[offset] = (TCFNode)child;
        }
    }

    private class ViewerUpdate
    implements IViewerUpdate {
        IStatus status;

        private ViewerUpdate() {
        }

        public Object getElement() {
            return null;
        }

        public TreePath getElementPath() {
            return null;
        }

        public IPresentationContext getPresentationContext() {
            return TCFModelProxy.this.getPresentationContext();
        }

        public Object getViewerInput() {
            return TCFModelProxy.this.getViewer().getInput();
        }

        public void cancel() {
        }

        public void done() {
        }

        public IStatus getStatus() {
            return this.status;
        }

        public boolean isCanceled() {
            return false;
        }

        public void setStatus(IStatus status) {
            this.status = status;
        }
    }
}

