/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.tm.internal.tcf.debug.model.TCFContextState;
import org.eclipse.tm.internal.tcf.debug.ui.model.ISymbolOwner;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFChildrenExecContext;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModel;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNode;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeSymbol;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.tm.tcf.services.IMemory;
import org.eclipse.tm.tcf.services.IRunControl;
import org.eclipse.tm.tcf.util.TCFDataCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCFNodeLaunch
extends TCFNode
implements ISymbolOwner {
    private final TCFChildrenExecContext children;
    private final Map<String, TCFNodeSymbol> symbols = new HashMap<String, TCFNodeSymbol>();

    TCFNodeLaunch(final TCFModel model) {
        super(model);
        this.children = new TCFChildrenExecContext(this);
        Protocol.invokeLater((Runnable)new Runnable(){
            boolean done;

            public void run() {
                if (this.done) {
                    return;
                }
                ArrayList nodes = new ArrayList();
                if (!TCFNodeLaunch.this.searchSuspendedThreads(TCFNodeLaunch.this.children, (ArrayList<TCFNode>)nodes, this)) {
                    return;
                }
                for (TCFNode n : nodes) {
                    model.setDebugViewSelection(n.id);
                }
                this.done = true;
            }
        });
    }

    private boolean searchSuspendedThreads(TCFChildrenExecContext c, ArrayList<TCFNode> nodes, Runnable r) {
        if (!c.validate(r)) {
            return false;
        }
        Object[] arr = c.toArray();
        Arrays.sort(arr);
        Object[] objectArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            Object n3 = objectArray[n2];
            if (!this.searchSuspendedThreads((TCFNodeExecContext)n3, nodes, r)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean searchSuspendedThreads(TCFNodeExecContext n, ArrayList<TCFNode> nodes, Runnable r) {
        TCFDataCache<TCFContextState> state = n.getState();
        if (!state.validate(r)) {
            return false;
        }
        TCFContextState s = (TCFContextState)state.getData();
        if (s != null && s.is_suspended) {
            nodes.add(n);
        }
        return this.searchSuspendedThreads(n.getChildren(), nodes, r);
    }

    @Override
    void dispose() {
        this.children.dispose();
        ArrayList<TCFNodeSymbol> l = new ArrayList<TCFNodeSymbol>(this.symbols.values());
        for (TCFNodeSymbol s : l) {
            s.dispose();
        }
        assert (this.symbols.size() == 0);
        super.dispose();
    }

    @Override
    void dispose(String id) {
        this.children.dispose(id);
    }

    @Override
    protected boolean getData(IChildrenCountUpdate result, Runnable done) {
        if (!this.children.validate(done)) {
            return false;
        }
        result.setChildCount(this.children.size());
        return true;
    }

    @Override
    protected boolean getData(IChildrenUpdate result, Runnable done) {
        if (!this.children.validate(done)) {
            return false;
        }
        TCFNode[] arr = this.children.toArray();
        int offset = 0;
        int r_offset = result.getOffset();
        int r_length = result.getLength();
        TCFNode[] tCFNodeArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            TCFNode n3 = tCFNodeArray[n2];
            if (offset >= r_offset && offset < r_offset + r_length) {
                result.setChild((Object)n3, offset);
            }
            ++offset;
            ++n2;
        }
        return true;
    }

    @Override
    protected boolean getData(IHasChildrenUpdate result, Runnable done) {
        if (!this.children.validate(done)) {
            return false;
        }
        result.setHasChilren(this.children.size() > 0);
        return true;
    }

    void onContextAdded(IRunControl.RunControlContext context) {
        this.children.onContextAdded(context);
    }

    void onContextAdded(IMemory.MemoryContext context) {
        this.children.onContextAdded(context);
    }

    @Override
    public void addSymbol(TCFNodeSymbol s) {
        assert (this.symbols.get(s.id) == null);
        this.symbols.put(s.id, s);
    }

    @Override
    public void removeSymbol(TCFNodeSymbol s) {
        assert (this.symbols.get(s.id) == s);
        this.symbols.remove(s.id);
    }

    public TCFChildrenExecContext getChildren() {
        return this.children;
    }
}

