/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.model;

import java.math.BigInteger;
import java.util.Map;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.tm.internal.tcf.debug.model.TCFContextState;
import org.eclipse.tm.internal.tcf.debug.model.TCFSourceRef;
import org.eclipse.tm.internal.tcf.debug.ui.ImageCache;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFChildren;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFChildrenExpressions;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFChildrenLocalVariables;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFChildrenRegisters;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFChildrenStackTrace;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModel;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNode;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.tm.tcf.services.ILineNumbers;
import org.eclipse.tm.tcf.services.IMemory;
import org.eclipse.tm.tcf.services.IRunControl;
import org.eclipse.tm.tcf.services.IStackTrace;
import org.eclipse.tm.tcf.util.TCFDataCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCFNodeStackFrame
extends TCFNode {
    private int frame_no;
    private final boolean emulated;
    private final TCFChildrenRegisters children_regs;
    private final TCFChildrenLocalVariables children_vars;
    private final TCFChildrenExpressions children_exps;
    private final TCFDataCache<IStackTrace.StackTraceContext> stack_trace_context;
    private final TCFDataCache<TCFSourceRef> line_info;
    private final TCFDataCache<BigInteger> address;

    TCFNodeStackFrame(final TCFNodeExecContext parent, final String id, final boolean emulated) {
        super(parent, id);
        this.emulated = emulated;
        this.children_regs = new TCFChildrenRegisters(this);
        this.children_vars = new TCFChildrenLocalVariables(this);
        this.children_exps = new TCFChildrenExpressions(this);
        this.stack_trace_context = new TCFDataCache<IStackTrace.StackTraceContext>(this.channel){

            protected boolean startDataRetrieval() {
                if (!$assertionsDisabled && this.command != null) {
                    throw new AssertionError();
                }
                if (emulated) {
                    this.set(null, null, null);
                    return true;
                }
                TCFDataCache<TCFContextState> parent_state_cache = parent.getState();
                if (!parent_state_cache.validate((Runnable)((Object)this))) {
                    return false;
                }
                TCFContextState parent_state_data = (TCFContextState)parent_state_cache.getData();
                if (parent_state_data == null || !parent_state_data.is_suspended) {
                    this.set(null, null, null);
                    return true;
                }
                TCFChildrenStackTrace stack_trace_cache = parent.getStackTrace();
                if (!stack_trace_cache.validate((Runnable)((Object)this))) {
                    return false;
                }
                if (TCFNodeStackFrame.this.frame_no < 0) {
                    this.set(null, null, null);
                    return true;
                }
                IStackTrace st = (IStackTrace)TCFNodeStackFrame.this.model.getLaunch().getService(IStackTrace.class);
                if (st == null) {
                    if (!$assertionsDisabled && TCFNodeStackFrame.this.frame_no != 0) {
                        throw new AssertionError();
                    }
                    this.set(null, null, null);
                    return true;
                }
                this.command = st.getContext(new String[]{id}, new IStackTrace.DoneGetContext(){

                    public void doneGetContext(IToken token, Exception error, IStackTrace.StackTraceContext[] context) {
                        this.set(token, error, context == null || context.length == 0 ? null : context[0]);
                    }
                });
                return false;
            }
        };
        final Map<BigInteger, TCFSourceRef> line_info_cache = parent.getLineInfoCache();
        this.line_info = new TCFDataCache<TCFSourceRef>(this.channel){

            protected boolean startDataRetrieval() {
                if (!TCFNodeStackFrame.this.stack_trace_context.validate((Runnable)((Object)this))) {
                    return false;
                }
                if (!TCFNodeStackFrame.this.address.validate((Runnable)((Object)this))) {
                    return false;
                }
                BigInteger n = (BigInteger)TCFNodeStackFrame.this.address.getData();
                if (n == null) {
                    this.set(null, TCFNodeStackFrame.this.address.getError(), null);
                    return true;
                }
                IMemory.MemoryContext mem_ctx = null;
                TCFNode p = parent;
                while (p != null) {
                    if (p instanceof TCFNodeExecContext) {
                        TCFDataCache<IMemory.MemoryContext> cache = p.getMemoryContext();
                        if (!cache.validate((Runnable)((Object)this))) {
                            return false;
                        }
                        mem_ctx = (IMemory.MemoryContext)cache.getData();
                        if (mem_ctx != null) break;
                    }
                    p = p.parent;
                }
                TCFSourceRef l = (TCFSourceRef)line_info_cache.get(n);
                if (l != null) {
                    l.context = mem_ctx;
                    this.set(null, null, l);
                    return true;
                }
                ILineNumbers ln = (ILineNumbers)TCFNodeStackFrame.this.model.getLaunch().getService(ILineNumbers.class);
                if (ln == null) {
                    l = new TCFSourceRef();
                    l.context = mem_ctx;
                    l.address = n;
                    this.set(null, null, l);
                    return true;
                }
                final BigInteger n0 = n;
                BigInteger n1 = n0.add(BigInteger.valueOf(1L));
                final IMemory.MemoryContext ctx = mem_ctx;
                this.command = ln.mapToSource(parent.id, (Number)n0, (Number)n1, new ILineNumbers.DoneMapToSource(){

                    public void doneMapToSource(IToken token, Exception error, ILineNumbers.CodeArea[] areas) {
                        TCFSourceRef l = new TCFSourceRef();
                        l.context = ctx;
                        l.address = n0;
                        if (error == null && areas != null && areas.length > 0) {
                            ILineNumbers.CodeArea[] codeAreaArray = areas;
                            int n = areas.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ILineNumbers.CodeArea area = codeAreaArray[n2];
                                if (l.area == null || area.start_line < l.area.start_line) {
                                    l.area = area;
                                }
                                ++n2;
                            }
                        }
                        l.error = error;
                        this.set(token, null, l);
                        if (error == null) {
                            line_info_cache.put(l.address, l);
                        }
                    }
                });
                return false;
            }
        };
        this.address = new TCFDataCache<BigInteger>(this.channel){

            protected boolean startDataRetrieval() {
                if (!TCFNodeStackFrame.this.stack_trace_context.validate((Runnable)((Object)this))) {
                    return false;
                }
                IStackTrace.StackTraceContext ctx = (IStackTrace.StackTraceContext)TCFNodeStackFrame.this.stack_trace_context.getData();
                if (ctx != null) {
                    Number n = ctx.getInstructionAddress();
                    if (n instanceof BigInteger) {
                        this.set(null, null, (BigInteger)n);
                        return true;
                    }
                    if (n != null) {
                        this.set(null, null, new BigInteger(n.toString()));
                        return true;
                    }
                }
                if (TCFNodeStackFrame.this.frame_no == 0) {
                    TCFDataCache<BigInteger> addr_cache = parent.getAddress();
                    if (!addr_cache.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    this.set(null, addr_cache.getError(), (BigInteger)addr_cache.getData());
                    return true;
                }
                this.set(null, TCFNodeStackFrame.this.stack_trace_context.getError(), null);
                return true;
            }
        };
    }

    public int getFrameNo() {
        assert (Protocol.isDispatchThread());
        return this.frame_no;
    }

    void setFrameNo(int frame_no) {
        this.frame_no = frame_no;
    }

    @Override
    void dispose() {
        this.stack_trace_context.dispose();
        this.line_info.dispose();
        this.address.dispose();
        this.children_regs.dispose();
        this.children_vars.dispose();
        this.children_exps.dispose();
        super.dispose();
    }

    @Override
    void dispose(String id) {
        this.children_regs.dispose(id);
        this.children_vars.dispose(id);
        this.children_exps.dispose(id);
    }

    public TCFDataCache<TCFSourceRef> getLineInfo() {
        return this.line_info;
    }

    public TCFDataCache<IStackTrace.StackTraceContext> getStackTraceContext() {
        return this.stack_trace_context;
    }

    public TCFDataCache<BigInteger> getAddress() {
        return this.address;
    }

    public BigInteger getReturnAddress() {
        assert (Protocol.isDispatchThread());
        if (!this.stack_trace_context.isValid()) {
            return null;
        }
        IStackTrace.StackTraceContext ctx = (IStackTrace.StackTraceContext)this.stack_trace_context.getData();
        if (ctx != null) {
            Number n = ctx.getReturnAddress();
            if (n instanceof BigInteger) {
                return (BigInteger)n;
            }
            if (n != null) {
                return new BigInteger(n.toString());
            }
        }
        return null;
    }

    public boolean isEmulated() {
        return this.emulated;
    }

    private TCFChildren getChildren(IPresentationContext ctx) {
        String id = ctx.getId();
        if ("org.eclipse.debug.ui.RegisterView".equals(id)) {
            return this.children_regs;
        }
        if ("org.eclipse.debug.ui.VariableView".equals(id)) {
            return this.children_vars;
        }
        if ("org.eclipse.debug.ui.ExpressionView".equals(id)) {
            return this.children_exps;
        }
        return null;
    }

    @Override
    protected boolean getData(IHasChildrenUpdate result, Runnable done) {
        TCFChildren c = this.getChildren(result.getPresentationContext());
        if (c != null) {
            if (!c.validate(done)) {
                return false;
            }
            result.setHasChilren(c.size() > 0);
        } else {
            result.setHasChilren(false);
        }
        return true;
    }

    @Override
    protected boolean getData(IChildrenCountUpdate result, Runnable done) {
        TCFChildren c = this.getChildren(result.getPresentationContext());
        if (c != null) {
            if (!c.validate(done)) {
                return false;
            }
            result.setChildCount(c.size());
        } else {
            result.setChildCount(0);
        }
        return true;
    }

    @Override
    protected boolean getData(IChildrenUpdate result, Runnable done) {
        TCFNode[] arr = null;
        TCFChildren c = this.getChildren(result.getPresentationContext());
        if (c != null) {
            if (!c.validate(done)) {
                return false;
            }
        } else {
            return true;
        }
        arr = c.toArray();
        int offset = 0;
        int r_offset = result.getOffset();
        int r_length = result.getLength();
        TCFNode[] tCFNodeArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            TCFNode n3 = tCFNodeArray[n2];
            if (offset >= r_offset && offset < r_offset + r_length) {
                result.setChild((Object)n3, offset);
            }
            ++offset;
            ++n2;
        }
        return true;
    }

    @Override
    protected boolean getData(ILabelUpdate result, Runnable done) {
        TCFChildrenStackTrace stack_trace_cache = ((TCFNodeExecContext)this.parent).getStackTrace();
        if (!stack_trace_cache.validate(done)) {
            return false;
        }
        if (((Map)stack_trace_cache.getData()).get(this.id) == null) {
            result.setLabel("", 0);
        } else {
            TCFContextState state_data;
            String image_name;
            TCFDataCache<TCFContextState> state_cache = ((TCFNodeExecContext)this.parent).getState();
            if (!state_cache.validate(done)) {
                return false;
            }
            Throwable error = state_cache.getError();
            if (error == null) {
                error = stack_trace_cache.getError();
            }
            if (error == null) {
                TCFDataCache<IStackTrace.StackTraceContext> pending = null;
                if (!this.stack_trace_context.validate()) {
                    pending = this.stack_trace_context;
                }
                if (!this.line_info.validate()) {
                    pending = this.line_info;
                }
                if (pending != null) {
                    pending.wait(done);
                    return false;
                }
                error = this.stack_trace_context.getError();
                if (error == null) {
                    error = this.line_info.getError();
                }
            }
            String string = image_name = (state_data = (TCFContextState)state_cache.getData()) != null && state_data.is_suspended ? "icons/full/obj16/stckframe_obj.gif" : "icons/full/obj16/stckframe_running_obj.gif";
            if (error != null) {
                if (state_data == null || state_data.is_suspended) {
                    result.setForeground(new RGB(255, 0, 0), 0);
                    result.setLabel(TCFModel.getErrorMessage(error, false), 0);
                } else {
                    result.setLabel("...", 0);
                }
            } else {
                TCFSourceRef l = (TCFSourceRef)this.line_info.getData();
                if (l == null) {
                    result.setLabel("...", 0);
                } else {
                    String module = this.getModuleName(l.address, done);
                    if (module == null) {
                        return false;
                    }
                    String label = String.valueOf(this.makeHexAddrString(l.context, l.address)) + module;
                    if (l.area != null && l.area.file != null) {
                        label = String.valueOf(label) + ": " + l.area.file + ", line " + l.area.start_line;
                    }
                    result.setLabel(label, 0);
                }
            }
            result.setImageDescriptor(ImageCache.getImageDescriptor(image_name), 0);
        }
        return true;
    }

    private String getModuleName(BigInteger pc, Runnable done) {
        TCFDataCache<IRunControl.RunControlContext> parent_dc = ((TCFNodeExecContext)this.parent).getRunContext();
        if (!parent_dc.validate(done)) {
            return null;
        }
        IRunControl.RunControlContext parent_ctx = (IRunControl.RunControlContext)parent_dc.getData();
        if (parent_ctx == null) {
            return "";
        }
        String prs_id = parent_ctx.getProcessID();
        if (prs_id == null) {
            return "";
        }
        TCFNodeExecContext prs_node = (TCFNodeExecContext)this.model.getNode(prs_id);
        TCFDataCache<TCFNodeExecContext.MemoryRegion[]> map_dc = prs_node.getMemoryMap();
        if (!map_dc.validate(done)) {
            return null;
        }
        TCFNodeExecContext.MemoryRegion[] map = (TCFNodeExecContext.MemoryRegion[])map_dc.getData();
        if (map == null) {
            return "";
        }
        TCFNodeExecContext.MemoryRegion[] memoryRegionArray = map;
        int n = map.length;
        int n2 = 0;
        while (n2 < n) {
            TCFNodeExecContext.MemoryRegion r = memoryRegionArray[n2];
            String fnm = r.region.getFileName();
            if (fnm != null && r.contains(pc)) {
                int x = (fnm = fnm.replace('\\', '/')).lastIndexOf(47);
                if (x >= 0) {
                    fnm = fnm.substring(x + 1);
                }
                return " [" + fnm + "]";
            }
            ++n2;
        }
        return "";
    }

    private String makeHexAddrString(IMemory.MemoryContext m, BigInteger n) {
        String s;
        int sz = (m != null ? m.getAddressSize() : 4) * 2;
        int l = sz - (s = n.toString(16)).length();
        if (l < 0) {
            l = 0;
        }
        if (l > 16) {
            l = 16;
        }
        return String.valueOf("0x0000000000000000".substring(0, 2 + l)) + s;
    }

    void onSourceMappingChange() {
        this.line_info.reset();
        this.addModelDelta(2048);
    }

    void onSuspended() {
        this.stack_trace_context.cancel();
        this.line_info.cancel();
        this.address.cancel();
        this.children_regs.onSuspended();
        this.children_vars.onSuspended();
        this.children_exps.onSuspended();
        this.addModelDelta(3072);
    }

    void onMemoryMapChanged() {
        this.addModelDelta(2048);
    }

    void onRegistersChanged() {
        this.children_regs.onRegistersChanged();
        this.addModelDelta(3072);
    }

    void onRegisterValueChanged() {
        this.stack_trace_context.cancel();
        this.line_info.cancel();
        this.address.cancel();
        this.addModelDelta(2048);
    }

    @Override
    public int compareTo(TCFNode n) {
        if (n instanceof TCFNodeStackFrame) {
            TCFNodeStackFrame f = (TCFNodeStackFrame)n;
            if (this.frame_no < f.frame_no) {
                return -1;
            }
            if (this.frame_no > f.frame_no) {
                return 1;
            }
        }
        return this.id.compareTo(n.id);
    }
}

