/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.model;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.Launch;
import org.eclipse.tm.internal.tcf.debug.Activator;
import org.eclipse.tm.internal.tcf.debug.actions.TCFAction;
import org.eclipse.tm.internal.tcf.debug.launch.TCFLaunchDelegate;
import org.eclipse.tm.internal.tcf.debug.model.TCFBreakpointsStatus;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IPeer;
import org.eclipse.tm.tcf.protocol.IService;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.tm.tcf.services.IFileSystem;
import org.eclipse.tm.tcf.services.IPathMap;
import org.eclipse.tm.tcf.services.IProcesses;
import org.eclipse.tm.tcf.services.IRunControl;
import org.eclipse.tm.tcf.services.IStreams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCFLaunch
extends Launch {
    private static final Collection<Listener> listeners = new ArrayList<Listener>();
    private IChannel channel;
    private Throwable error;
    private TCFBreakpointsStatus breakpoints_status;
    private String mode;
    private boolean connecting;
    private boolean disconnected;
    private boolean shutdown;
    private boolean last_context_exited;
    private IProcesses.ProcessContext process;
    private Collection<Map<String, Object>> process_signals;
    private IToken process_start_command;
    private String process_input_stream_id;
    private int process_exit_code;
    private final HashMap<String, String> process_env = new HashMap();
    private final HashMap<String, LinkedList<Runnable>> context_action_queue = new HashMap();
    private final HashMap<String, String> stream_ids = new HashMap();
    private final LinkedList<LaunchStep> launch_steps = new LinkedList();
    private final LinkedList<String> redirection_path = new LinkedList();
    private final IStreams.StreamsListener streams_listener = new IStreams.StreamsListener(){

        public void created(String stream_type, String stream_id, String context_id) {
            if (!$assertionsDisabled && !"Processes".equals(stream_type)) {
                throw new AssertionError();
            }
            if (TCFLaunch.this.process_start_command == null) {
                TCFLaunch.this.disconnectStream(stream_id);
            } else {
                TCFLaunch.this.stream_ids.put(stream_id, context_id);
            }
        }

        public void disposed(String stream_type, String stream_id) {
        }
    };
    private final IProcesses.ProcessesListener prs_listener = new IProcesses.ProcessesListener(){

        public void exited(String process_id, int exit_code) {
            if (process_id.equals(TCFLaunch.this.process.getID())) {
                TCFLaunch.this.process_exit_code = exit_code;
            }
        }
    };

    public TCFLaunch(ILaunchConfiguration launchConfiguration, String mode) {
        super(launchConfiguration, mode, null);
        for (Listener l : listeners) {
            l.onCreated(this);
        }
    }

    private void onConnected() throws Exception {
        ILaunchConfiguration cfg = this.getLaunchConfiguration();
        if (cfg != null) {
            final String path_map = cfg.getAttribute("org.eclipse.tm.tcf.debug.PathMap", "");
            final IPathMap path_map_service = this.getService(IPathMap.class);
            if (path_map.length() != 0 && path_map_service != null) {
                new LaunchStep(){

                    void start() throws Exception {
                        ArrayList<TCFLaunchDelegate.PathMapRule> map = TCFLaunchDelegate.parsePathMapAttribute(path_map);
                        path_map_service.set(map.toArray(new IPathMap.PathMapRule[map.size()]), new IPathMap.DoneSet(){

                            public void doneSet(IToken token, Exception error) {
                                if (error != null) {
                                    TCFLaunch.this.channel.terminate((Throwable)error);
                                } else {
                                    this.done();
                                }
                            }
                        });
                    }
                };
            }
        }
        if (this.redirection_path.size() > 0) {
            new LaunchStep(){

                void start() throws Exception {
                    TCFLaunch.this.channel.redirect((String)TCFLaunch.this.redirection_path.removeFirst());
                }
            };
        } else {
            final IStreams streams = this.getService(IStreams.class);
            if (streams != null) {
                new LaunchStep(){

                    void start() {
                        streams.subscribe("Processes", TCFLaunch.this.streams_listener, new IStreams.DoneSubscribe(){

                            public void doneSubscribe(IToken token, Exception error) {
                                if (error != null) {
                                    TCFLaunch.this.channel.terminate((Throwable)error);
                                } else {
                                    this.done();
                                }
                            }
                        });
                    }
                };
            }
            if (this.mode.equals("debug")) {
                new LaunchStep(){

                    void start() throws Exception {
                        TCFLaunch.this.breakpoints_status = new TCFBreakpointsStatus(TCFLaunch.this);
                        Activator.getBreakpointsModel().downloadBreakpoints(TCFLaunch.this.channel, this);
                    }
                };
            }
            new LaunchStep(){

                void start() {
                    TCFLaunch.this.runLaunchSequence(this);
                }
            };
            if (cfg != null) {
                this.startRemoteProcess(cfg);
            }
            new LaunchStep(){

                void start() {
                    TCFLaunch.this.connecting = false;
                    for (Listener l : listeners) {
                        l.onConnected(TCFLaunch.this);
                    }
                    TCFLaunch.this.fireChanged();
                }
            };
        }
        this.launch_steps.removeFirst().start();
    }

    private void onDisconnected(Throwable error) {
        assert (!this.disconnected);
        assert (!this.shutdown);
        this.error = error;
        this.breakpoints_status = null;
        this.connecting = false;
        this.disconnected = true;
        for (Listener l : listeners) {
            l.onDisconnected(this);
        }
        if (DebugPlugin.getDefault() != null) {
            this.fireChanged();
        }
        this.runShutdownSequence(new Runnable(){

            public void run() {
                TCFLaunch.this.shutdown = true;
                if (DebugPlugin.getDefault() != null) {
                    TCFLaunch.this.fireTerminate();
                }
            }
        });
    }

    protected void runLaunchSequence(Runnable done) {
        done.run();
    }

    private String[] toArgsArray(String file, String cmd) {
        int i = 0;
        int l = cmd.length();
        ArrayList<String> arr = new ArrayList<String>();
        arr.add(file);
        while (true) {
            if (i < l && cmd.charAt(i) == ' ') {
                ++i;
                continue;
            }
            if (i >= l) break;
            String s = null;
            if (cmd.charAt(i) == '\"') {
                ++i;
                StringBuffer bf = new StringBuffer();
                while (i < l) {
                    char ch;
                    if ((ch = cmd.charAt(i++)) == '\"') break;
                    if (ch == '\\' && i < l) {
                        ch = cmd.charAt(i++);
                    }
                    bf.append(ch);
                }
                s = bf.toString();
            } else {
                int i0 = i;
                while (i < l && cmd.charAt(i) != ' ') {
                    ++i;
                }
                s = cmd.substring(i0, i);
            }
            arr.add(s);
        }
        return arr.toArray(new String[arr.size()]);
    }

    private void copyFileToRemoteTarget(String local_file, String remote_file, final Runnable done) {
        if (local_file == null) {
            this.channel.terminate((Throwable)new Exception("Program does not exist"));
            return;
        }
        final IFileSystem fs = (IFileSystem)this.channel.getRemoteService(IFileSystem.class);
        if (fs == null) {
            this.channel.terminate((Throwable)new Exception("Cannot download program file: target does not provide File System service"));
            return;
        }
        try {
            final FileInputStream inp = new FileInputStream(local_file);
            int flags = 26;
            fs.open(remote_file, flags, null, new IFileSystem.DoneOpen(){
                IFileSystem.IFileHandle handle;
                long offset = 0L;
                final Set<IToken> cmds = new HashSet<IToken>();
                final byte[] buf = new byte[4096];

                public void doneOpen(IToken token, IFileSystem.FileSystemException error, IFileSystem.IFileHandle handle) {
                    this.handle = handle;
                    if (error != null) {
                        TCFLaunch.this.error = new Exception("Cannot download program file", (Throwable)error);
                        TCFLaunch.this.fireChanged();
                        done.run();
                    } else {
                        this.write_next();
                    }
                }

                private void write_next() {
                    try {
                        while (this.cmds.size() < 8) {
                            int rd = inp.read(this.buf);
                            if (rd < 0) {
                                this.close();
                                break;
                            }
                            this.cmds.add(fs.write(this.handle, this.offset, this.buf, 0, rd, new IFileSystem.DoneWrite(){

                                public void doneWrite(IToken token, IFileSystem.FileSystemException error) {
                                    cmds.remove(token);
                                    if (error != null) {
                                        TCFLaunch.this.channel.terminate((Throwable)error);
                                    } else {
                                        this.write_next();
                                    }
                                }
                            }));
                            this.offset += (long)rd;
                        }
                    }
                    catch (Throwable x) {
                        TCFLaunch.this.channel.terminate(x);
                    }
                }

                private void close() {
                    if (this.cmds.size() > 0) {
                        return;
                    }
                    try {
                        inp.close();
                        fs.close(this.handle, new IFileSystem.DoneClose(){

                            public void doneClose(IToken token, IFileSystem.FileSystemException error) {
                                if (error != null) {
                                    TCFLaunch.this.channel.terminate((Throwable)error);
                                } else {
                                    done.run();
                                }
                            }
                        });
                    }
                    catch (Throwable x) {
                        TCFLaunch.this.channel.terminate(x);
                    }
                }
            });
        }
        catch (Throwable x) {
            this.channel.terminate(x);
        }
    }

    private void startRemoteProcess(ILaunchConfiguration cfg) throws Exception {
        final String project = cfg.getAttribute("org.eclipse.tm.tcf.debug.ProjectName", "");
        final String local_file = cfg.getAttribute("org.eclipse.tm.tcf.debug.LocalProgramFile", "");
        final String remote_file = cfg.getAttribute("org.eclipse.tm.tcf.debug.ProgramFile", "");
        if (local_file.length() != 0 && remote_file.length() != 0) {
            new LaunchStep(){

                void start() throws Exception {
                    TCFLaunch.this.copyFileToRemoteTarget(TCFLaunchDelegate.getProgramPath(project, local_file), remote_file, this);
                }
            };
        }
        if (local_file.length() != 0 || remote_file.length() != 0) {
            int no_pass;
            final IProcesses ps = (IProcesses)this.channel.getRemoteService(IProcesses.class);
            if (ps == null) {
                throw new Exception("Target does not provide Processes service");
            }
            boolean append = cfg.getAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, true);
            if (append) {
                new LaunchStep(){

                    void start() throws Exception {
                        ps.getEnvironment(new IProcesses.DoneGetEnvironment(){

                            public void doneGetEnvironment(IToken token, Exception error, Map<String, String> env) {
                                if (error != null) {
                                    TCFLaunch.this.channel.terminate((Throwable)error);
                                } else {
                                    if (env != null) {
                                        TCFLaunch.this.process_env.putAll(env);
                                    }
                                    this.done();
                                }
                            }
                        });
                    }
                };
            }
            final String dir = cfg.getAttribute("org.eclipse.tm.tcf.debug.WorkingDirectory", "");
            final String args = cfg.getAttribute("org.eclipse.tm.tcf.debug.ProgramArguments", "");
            final Map env = cfg.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null);
            new LaunchStep(){

                void start() {
                    String file;
                    if (env != null) {
                        TCFLaunch.this.process_env.putAll(env);
                    }
                    if ((file = remote_file) == null || file.length() == 0) {
                        file = TCFLaunchDelegate.getProgramPath(project, local_file);
                    }
                    if (file == null || file.length() == 0) {
                        TCFLaunch.this.channel.terminate((Throwable)new Exception("Program file does not exist"));
                        return;
                    }
                    boolean attach = TCFLaunch.this.mode.equals("debug");
                    TCFLaunch.this.process_start_command = ps.start(dir, file, TCFLaunch.this.toArgsArray(file, args), (Map)TCFLaunch.this.process_env, attach, new IProcesses.DoneStart(){

                        public void doneStart(IToken token, final Exception error, IProcesses.ProcessContext process) {
                            TCFLaunch.this.process_start_command = null;
                            if (error != null) {
                                for (String id : new HashSet(TCFLaunch.this.stream_ids.keySet())) {
                                    TCFLaunch.this.disconnectStream(id);
                                }
                                Protocol.sync((Runnable)new Runnable(){

                                    public void run() {
                                        TCFLaunch.this.channel.terminate((Throwable)error);
                                    }
                                });
                            } else {
                                TCFLaunch.this.process = process;
                                ps.addListener(TCFLaunch.this.prs_listener);
                                TCFLaunch.this.connectProcessStreams();
                                this.done();
                            }
                        }
                    });
                }
            };
            new LaunchStep(){

                void start() {
                    ps.getSignalList(TCFLaunch.this.process.getID(), new IProcesses.DoneGetSignalList(){

                        public void doneGetSignalList(IToken token, Exception error, Collection<Map<String, Object>> list) {
                            if (error != null) {
                                Activator.log("Can't get process signal list", error);
                            }
                            TCFLaunch.this.process_signals = list;
                            this.done();
                        }
                    });
                }
            };
            String dont_stop = cfg.getAttribute("org.eclipse.tm.tcf.debug.SignalsDontStop", "");
            String dont_pass = cfg.getAttribute("org.eclipse.tm.tcf.debug.SignalsDontPath", "");
            final int no_stop = dont_stop.length() > 0 ? Integer.parseInt(dont_stop, 16) : 0;
            int n = no_pass = dont_pass.length() > 0 ? Integer.parseInt(dont_pass, 16) : 0;
            if (no_stop != 0 || no_pass != 0) {
                new LaunchStep(){

                    void start() {
                        final HashSet<IToken> cmds = new HashSet<IToken>();
                        final IProcesses.DoneCommand done_set_mask = new IProcesses.DoneCommand(){

                            public void doneCommand(IToken token, Exception error) {
                                cmds.remove(token);
                                if (error != null) {
                                    TCFLaunch.this.channel.terminate((Throwable)error);
                                } else if (cmds.size() == 0) {
                                    this.done();
                                }
                            }
                        };
                        cmds.add(ps.setSignalMask(TCFLaunch.this.process.getID(), no_stop, no_pass, done_set_mask));
                        final IRunControl rc = (IRunControl)TCFLaunch.this.channel.getRemoteService(IRunControl.class);
                        if (rc != null) {
                            IRunControl.DoneGetChildren done_get_children = new IRunControl.DoneGetChildren(){

                                public void doneGetChildren(IToken token, Exception error, String[] context_ids) {
                                    if (context_ids != null) {
                                        String[] stringArray = context_ids;
                                        int n = context_ids.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            String id = stringArray[n2];
                                            cmds.add(ps.setSignalMask(id, no_stop, no_pass, done_set_mask));
                                            cmds.add(rc.getChildren(id, (IRunControl.DoneGetChildren)this));
                                            ++n2;
                                        }
                                    }
                                    cmds.remove(token);
                                    if (error != null) {
                                        TCFLaunch.this.channel.terminate((Throwable)error);
                                    } else if (cmds.size() == 0) {
                                        this.done();
                                    }
                                }
                            };
                            cmds.add(rc.getChildren(TCFLaunch.this.process.getID(), done_get_children));
                        }
                    }
                };
            }
        }
    }

    private void connectProcessStreams() {
        assert (this.process_start_command == null);
        IStreams streams = this.getService(IStreams.class);
        if (streams == null) {
            return;
        }
        String inp_id = (String)this.process.getProperties().get("StdInID");
        String out_id = (String)this.process.getProperties().get("StdOutID");
        String err_id = (String)this.process.getProperties().get("StdErrID");
        String[] stringArray = this.stream_ids.keySet().toArray(new String[this.stream_ids.size()]);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (id.equals(inp_id)) {
                this.process_input_stream_id = id;
            } else if (id.equals(out_id)) {
                this.connectStream(id, 0);
            } else if (id.equals(err_id)) {
                this.connectStream(id, 1);
            } else {
                this.disconnectStream(id);
            }
            ++n2;
        }
    }

    private void connectStream(final String id, final int no) {
        final String peocess_id = this.process.getID();
        final IStreams streams = this.getService(IStreams.class);
        IStreams.DoneRead done = new IStreams.DoneRead(){

            public void doneRead(IToken token, Exception error, int lost_size, byte[] data, boolean eos) {
                if (TCFLaunch.this.stream_ids.get(id) == null) {
                    return;
                }
                if (lost_size > 0) {
                    IOException x = new IOException("Process output data lost due buffer overflow");
                    for (Listener l : listeners) {
                        l.onProcessStreamError(TCFLaunch.this, peocess_id, no, x, lost_size);
                    }
                }
                if (data != null && data.length > 0) {
                    for (Listener l : listeners) {
                        l.onProcessOutput(TCFLaunch.this, peocess_id, no, data);
                    }
                }
                if (error != null) {
                    for (Listener l : listeners) {
                        l.onProcessStreamError(TCFLaunch.this, peocess_id, no, error, 0);
                    }
                }
                if (eos || error != null) {
                    TCFLaunch.this.disconnectStream(id);
                } else {
                    streams.read(id, 4096, (IStreams.DoneRead)this);
                }
            }
        };
        streams.read(id, 4096, done);
        streams.read(id, 4096, done);
        streams.read(id, 4096, done);
        streams.read(id, 4096, done);
    }

    private void disconnectStream(String id) {
        this.stream_ids.remove(id);
        if (this.channel.getState() != 1) {
            return;
        }
        IStreams streams = this.getService(IStreams.class);
        streams.disconnect(id, new IStreams.DoneDisconnect(){

            public void doneDisconnect(IToken token, Exception error) {
                if (TCFLaunch.this.channel.getState() != 1) {
                    return;
                }
                if (error != null) {
                    TCFLaunch.this.channel.terminate((Throwable)error);
                }
            }
        });
    }

    protected void runShutdownSequence(Runnable done) {
        done.run();
    }

    public Throwable getError() {
        return this.error;
    }

    public void setError(Throwable x) {
        this.error = x;
        if (x != null) {
            if (this.channel != null && this.channel.getState() == 1) {
                this.channel.terminate(x);
            } else if (!this.connecting) {
                this.disconnected = true;
            }
        }
        this.fireChanged();
    }

    public TCFBreakpointsStatus getBreakpointsStatus() {
        return this.breakpoints_status;
    }

    public static void addListener(Listener listener) {
        assert (Protocol.isDispatchThread());
        listeners.add(listener);
    }

    public static void removeListener(Listener listener) {
        assert (Protocol.isDispatchThread());
        listeners.remove(listener);
    }

    public IChannel getChannel() {
        return this.channel;
    }

    public IProcesses.ProcessContext getProcessContext() {
        return this.process;
    }

    public void writeProcessInputStream(byte[] buf, int pos, final int len) throws Exception {
        assert (Protocol.isDispatchThread());
        final String id = this.process_input_stream_id;
        if (this.channel.getState() != 1) {
            throw new IOException("Connection closed");
        }
        if (this.process == null) {
            throw new IOException("No target process");
        }
        final String prs = this.process.getID();
        IStreams streams = this.getService(IStreams.class);
        if (streams == null) {
            throw new IOException("Streams service not available");
        }
        if (this.stream_ids.get(id) == null) {
            throw new IOException("Input stream not available");
        }
        streams.write(id, buf, pos, len, new IStreams.DoneWrite(){

            public void doneWrite(IToken token, Exception error) {
                if (error == null) {
                    return;
                }
                if (TCFLaunch.this.stream_ids.get(id) == null) {
                    return;
                }
                for (Listener l : listeners) {
                    l.onProcessStreamError(TCFLaunch.this, prs, 0, error, len);
                }
                TCFLaunch.this.disconnectStream(id);
            }
        });
    }

    public boolean isConnecting() {
        return this.connecting;
    }

    public void onLastContextRemoved() {
        this.last_context_exited = true;
        this.closeChannel();
    }

    public void closeChannel() {
        assert (Protocol.isDispatchThread());
        if (this.channel == null) {
            return;
        }
        if (this.channel.getState() == 2) {
            return;
        }
        IStreams streams = this.getService(IStreams.class);
        final HashSet<IToken> cmds = new HashSet<IToken>();
        for (String id : this.stream_ids.keySet()) {
            cmds.add(streams.disconnect(id, new IStreams.DoneDisconnect(){

                public void doneDisconnect(IToken token, Exception error) {
                    cmds.remove(token);
                    if (TCFLaunch.this.channel.getState() == 2) {
                        return;
                    }
                    if (error != null) {
                        TCFLaunch.this.channel.terminate((Throwable)error);
                    } else if (cmds.isEmpty()) {
                        TCFLaunch.this.channel.close();
                    }
                }
            }));
        }
        this.stream_ids.clear();
        this.process_input_stream_id = null;
        if (cmds.isEmpty()) {
            this.channel.close();
        }
    }

    public IPeer getPeer() {
        assert (Protocol.isDispatchThread());
        return this.channel.getRemotePeer();
    }

    public <V extends IService> V getService(Class<V> cls) {
        assert (Protocol.isDispatchThread());
        return (V)this.channel.getRemoteService(cls);
    }

    public boolean canDisconnect() {
        return !this.disconnected;
    }

    public boolean isDisconnected() {
        return this.disconnected;
    }

    public void disconnect() throws DebugException {
        try {
            Protocol.invokeLater((Runnable)new Runnable(){

                public void run() {
                    TCFLaunch.this.closeChannel();
                }
            });
        }
        catch (IllegalStateException illegalStateException) {
            this.disconnected = true;
        }
    }

    public boolean canTerminate() {
        return false;
    }

    public boolean isTerminated() {
        return this.disconnected;
    }

    public void terminate() throws DebugException {
    }

    public boolean isExited() {
        return this.last_context_exited;
    }

    public int getExitCode() {
        return this.process_exit_code;
    }

    public Collection<Map<String, Object>> getSignalList() {
        return this.process_signals;
    }

    public void launchTCF(String mode, String id) {
        assert (Protocol.isDispatchThread());
        this.mode = mode;
        try {
            if (id == null || id.length() == 0) {
                throw new IOException("Invalid peer ID");
            }
            this.redirection_path.clear();
            while (true) {
                int i;
                if ((i = id.indexOf(47)) <= 0) break;
                this.redirection_path.add(id.substring(0, i));
                id = id.substring(i + 1);
            }
            this.redirection_path.add(id);
            String id0 = this.redirection_path.removeFirst();
            IPeer peer = (IPeer)Protocol.getLocator().getPeers().get(id0);
            if (peer == null) {
                throw new Exception("Cannot locate peer " + id0);
            }
            this.channel = peer.openChannel();
            this.channel.addChannelListener(new IChannel.IChannelListener(){

                public void onChannelOpened() {
                    try {
                        TCFLaunch.this.onConnected();
                    }
                    catch (Throwable x) {
                        TCFLaunch.this.channel.terminate(x);
                    }
                }

                public void congestionLevel(int level) {
                }

                public void onChannelClosed(Throwable error) {
                    TCFLaunch.this.channel.removeChannelListener((IChannel.IChannelListener)this);
                    TCFLaunch.this.onDisconnected(error);
                }
            });
            assert (this.channel.getState() == 0);
            this.connecting = true;
        }
        catch (Throwable e) {
            this.onDisconnected(e);
        }
    }

    public void addContextAction(TCFAction action, String context_id) {
        assert (Protocol.isDispatchThread());
        LinkedList<Runnable> list = this.context_action_queue.get(context_id);
        if (list == null) {
            list = new LinkedList();
            this.context_action_queue.put(context_id, list);
        }
        list.add(action);
        if (list.getFirst() == action) {
            Protocol.invokeLater((Runnable)action);
            for (Listener l : listeners) {
                l.onContextActionsStart(this, context_id);
            }
        }
    }

    public void removeContextAction(TCFAction action, String context_id, String result) {
        assert (Protocol.isDispatchThread());
        LinkedList<Runnable> list = this.context_action_queue.get(context_id);
        if (list == null) {
            return;
        }
        assert (list.getFirst() == action);
        list.removeFirst();
        if (!list.isEmpty()) {
            Protocol.invokeLater((Runnable)list.getFirst());
        } else {
            for (Listener l : listeners) {
                l.onContextActionsDone(this, context_id, result);
            }
        }
    }

    public void removeContextActions(String context_id, String result) {
        assert (Protocol.isDispatchThread());
        LinkedList<Runnable> list = this.context_action_queue.remove(context_id);
        if (list != null && list.size() > 0) {
            for (Listener l : listeners) {
                l.onContextActionsDone(this, context_id, result);
            }
        }
    }

    private abstract class LaunchStep
    implements Runnable {
        LaunchStep() {
            TCFLaunch.this.launch_steps.add(this);
        }

        abstract void start() throws Exception;

        void done() {
            if (TCFLaunch.this.channel.getState() != 1) {
                return;
            }
            try {
                ((LaunchStep)TCFLaunch.this.launch_steps.removeFirst()).start();
            }
            catch (Throwable x) {
                TCFLaunch.this.channel.terminate(x);
            }
        }

        public void run() {
            this.done();
        }
    }

    public static interface Listener {
        public void onCreated(TCFLaunch var1);

        public void onConnected(TCFLaunch var1);

        public void onDisconnected(TCFLaunch var1);

        public void onContextActionsStart(TCFLaunch var1, String var2);

        public void onContextActionsDone(TCFLaunch var1, String var2, String var3);

        public void onProcessOutput(TCFLaunch var1, String var2, int var3, byte[] var4);

        public void onProcessStreamError(TCFLaunch var1, String var2, int var3, Exception var4, int var5);
    }
}

