/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.tests;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.eclipse.tm.internal.tcf.debug.tests.ITCFTest;
import org.eclipse.tm.internal.tcf.debug.tests.TCFTestSuite;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.tm.tcf.services.IBreakpoints;
import org.eclipse.tm.tcf.services.IDiagnostics;
import org.eclipse.tm.tcf.services.ILineNumbers;
import org.eclipse.tm.tcf.services.IMemory;
import org.eclipse.tm.tcf.services.IRegisters;
import org.eclipse.tm.tcf.services.IRunControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TestRCBP1
implements ITCFTest,
IRunControl.RunControlListener {
    private final TCFTestSuite test_suite;
    private final int channel_id;
    private final IDiagnostics diag;
    private final IMemory mm;
    private final IRunControl rc;
    private final IRegisters rg;
    private final IBreakpoints bp;
    private final ILineNumbers ln;
    private final Map<String, IRunControl.RunControlContext> threads = new HashMap<String, IRunControl.RunControlContext>();
    private final Map<String, SuspendedContext> suspended = new HashMap<String, SuspendedContext>();
    private final Map<String, SuspendedContext> suspended_prev = new HashMap<String, SuspendedContext>();
    private final Set<String> running = new HashSet<String>();
    private final Set<IToken> get_state_cmds = new HashSet<IToken>();
    private final Map<String, Map<String, IRegisters.RegistersContext>> regs = new HashMap<String, Map<String, IRegisters.RegistersContext>>();
    private final Map<String, Map<String, Object>> bp_list = new HashMap<String, Map<String, Object>>();
    private final Map<String, IDiagnostics.ISymbol> sym_list = new HashMap<String, IDiagnostics.ISymbol>();
    private final Random rnd = new Random();
    private String[] test_list;
    private String test_ctx_id;
    private IRunControl.RunControlContext test_context;
    private String main_thread_id;
    private Runnable pending_cancel;
    private int bp_cnt = 0;
    private boolean done_get_state;
    private int resume_cnt = 0;
    private IToken cancel_test_cmd;
    private boolean bp_reset_done;
    private boolean bp_set_done;
    private boolean bp_change_done;
    private boolean bp_sync_done;
    private final IBreakpoints.BreakpointsListener bp_listener = new IBreakpoints.BreakpointsListener(){

        public void breakpointStatusChanged(String id, Map<String, Object> status) {
            if (TestRCBP1.this.bp_list.get(id) != null && TestRCBP1.this.test_context != null) {
                Collection list;
                String s = (String)status.get("Error");
                if (s != null) {
                    TestRCBP1.this.exit(new Exception("Invalid BP status: " + s));
                }
                if ((list = (Collection)status.get("Instances")) == null) {
                    return;
                }
                String err = null;
                for (Map map : list) {
                    String ctx = (String)map.get("LocationContext");
                    if (!TestRCBP1.this.test_context.getProcessID().equals(ctx) || map.get("Error") == null) continue;
                    err = (String)map.get("Error");
                }
                if (err != null) {
                    TestRCBP1.this.exit(new Exception("Invalid BP status: " + err));
                }
            }
        }

        public void contextAdded(Map<String, Object>[] bps) {
            Map<String, Object>[] mapArray = bps;
            int n = bps.length;
            int n2 = 0;
            while (n2 < n) {
                Map<String, Object> m0 = mapArray[n2];
                String id = (String)m0.get("ID");
                Map m1 = (Map)TestRCBP1.this.bp_list.get(id);
                if (!this.checkBPData(m0, m1)) {
                    return;
                }
                ++n2;
            }
        }

        public void contextChanged(Map<String, Object>[] bps) {
            Map<String, Object>[] mapArray = bps;
            int n = bps.length;
            int n2 = 0;
            while (n2 < n) {
                Map<String, Object> m0 = mapArray[n2];
                String id = (String)m0.get("ID");
                Map m1 = (Map)TestRCBP1.this.bp_list.get(id);
                if (!this.checkBPData(m0, m1)) {
                    return;
                }
                ++n2;
            }
        }

        public void contextRemoved(String[] ids) {
            if (!TestRCBP1.this.bp_change_done) {
                return;
            }
            String[] stringArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                if (TestRCBP1.this.bp_list.get(id) != null) {
                    TestRCBP1.this.exit(new Exception("Invalid Breakpoints.contextRemoved event"));
                    return;
                }
                ++n2;
            }
        }

        private boolean checkBPData(Map<String, Object> m0, Map<String, Object> m1) {
            if (m1 == null) {
                return true;
            }
            if ((m0 = new HashMap<String, Object>(m0)).get("Enabled") == null) {
                m0.put("Enabled", Boolean.FALSE);
            }
            if (m1.get("Enabled") == null) {
                m1.put("Enabled", Boolean.FALSE);
            }
            if (!m1.equals(m0)) {
                TestRCBP1.this.exit(new Exception("Invalid data in Breakpoints event: " + m0 + " != " + m1));
                return false;
            }
            return true;
        }
    };

    TestRCBP1(TCFTestSuite test_suite, IChannel channel, int channel_id) {
        this.test_suite = test_suite;
        this.channel_id = channel_id;
        this.diag = (IDiagnostics)channel.getRemoteService(IDiagnostics.class);
        this.mm = (IMemory)channel.getRemoteService(IMemory.class);
        this.rc = (IRunControl)channel.getRemoteService(IRunControl.class);
        this.rg = (IRegisters)channel.getRemoteService(IRegisters.class);
        this.bp = (IBreakpoints)channel.getRemoteService(IBreakpoints.class);
        this.ln = (ILineNumbers)channel.getRemoteService(ILineNumbers.class);
    }

    @Override
    public void start() {
        if (this.diag == null || this.rc == null) {
            this.test_suite.done(this, null);
        } else if (this.bp == null) {
            this.exit(new Exception("Remote Breakpoints service not found"));
        } else {
            this.runTest();
        }
        if (this.bp != null) {
            this.bp.addListener(this.bp_listener);
        }
    }

    private void runTest() {
        if (this.test_list == null) {
            this.getTestList();
            return;
        }
        if (this.test_ctx_id == null) {
            this.startTestContext();
            return;
        }
        if (this.test_context == null) {
            this.getTestContext();
            return;
        }
        if (this.sym_list.isEmpty()) {
            this.getSymbols();
            return;
        }
        if (!this.bp_reset_done) {
            this.bp.set(null, new IBreakpoints.DoneCommand(){

                public void doneCommand(IToken token, Exception error) {
                    if (error != null) {
                        TestRCBP1.this.exit(error);
                        return;
                    }
                    TestRCBP1.this.bp_reset_done = true;
                    TestRCBP1.this.runTest();
                }
            });
            return;
        }
        if (!this.bp_set_done) {
            this.iniBreakpoints();
            return;
        }
        if (!this.done_get_state) {
            assert (this.get_state_cmds.isEmpty());
            assert (this.threads.isEmpty());
            assert (this.running.isEmpty());
            assert (this.suspended.isEmpty());
            this.getContextState(this.test_ctx_id);
            return;
        }
        if (!this.bp_change_done) {
            this.changeBreakpoints();
            return;
        }
        for (SuspendedContext s : this.suspended.values()) {
            this.resume(s.id);
        }
    }

    private void getTestList() {
        this.diag.getTestList(new IDiagnostics.DoneGetTestList(){

            public void doneGetTestList(IToken token, Throwable error, String[] list) {
                if (!$assertionsDisabled && !TestRCBP1.this.test_suite.isActive(TestRCBP1.this)) {
                    throw new AssertionError();
                }
                if (error != null) {
                    TestRCBP1.this.exit(error);
                } else {
                    TestRCBP1.this.test_list = list;
                    TestRCBP1.this.runTest();
                }
            }
        });
    }

    private void startTestContext() {
        int i = 0;
        while (i < this.test_list.length) {
            if (this.test_list[i].equals("RCBP1")) {
                this.diag.runTest("RCBP1", new IDiagnostics.DoneRunTest(){

                    public void doneRunTest(IToken token, Throwable error, String context_id) {
                        if (error != null) {
                            TestRCBP1.this.exit(error);
                        } else {
                            if (!$assertionsDisabled && !TestRCBP1.this.test_suite.isActive(TestRCBP1.this)) {
                                throw new AssertionError();
                            }
                            if (!$assertionsDisabled && TestRCBP1.this.test_ctx_id != null) {
                                throw new AssertionError();
                            }
                            TestRCBP1.this.test_ctx_id = context_id;
                            if (TestRCBP1.this.pending_cancel != null) {
                                TestRCBP1.this.exit(null);
                            } else {
                                TestRCBP1.this.runTest();
                            }
                        }
                    }
                });
                return;
            }
            ++i;
        }
        this.exit(null);
    }

    private void getTestContext() {
        this.rc.getContext(this.test_ctx_id, new IRunControl.DoneGetContext(){

            public void doneGetContext(IToken token, Exception error, IRunControl.RunControlContext context) {
                TestRCBP1.this.get_state_cmds.remove(token);
                if (((TestRCBP1)TestRCBP1.this).test_suite.cancel) {
                    return;
                }
                if (error != null) {
                    TestRCBP1.this.exit(error);
                    return;
                }
                TestRCBP1.this.test_context = context;
                if (!$assertionsDisabled && !TestRCBP1.this.test_ctx_id.equals(context.getID())) {
                    throw new AssertionError();
                }
                TestRCBP1.this.rc.addListener((IRunControl.RunControlListener)TestRCBP1.this);
                TestRCBP1.this.runTest();
            }
        });
    }

    private void getSymbols() {
        final HashMap<IToken, String> cmds = new HashMap<IToken, String>();
        IDiagnostics.DoneGetSymbol done = new IDiagnostics.DoneGetSymbol(){

            public void doneGetSymbol(IToken token, Throwable error, IDiagnostics.ISymbol symbol) {
                String name = (String)cmds.remove(token);
                if (error != null) {
                    TestRCBP1.this.exit(error);
                    return;
                }
                if (!TestRCBP1.this.test_suite.isActive(TestRCBP1.this)) {
                    return;
                }
                if (!$assertionsDisabled && TestRCBP1.this.test_ctx_id == null) {
                    throw new AssertionError();
                }
                if (!symbol.isAbs()) {
                    TestRCBP1.this.exit(new Exception("Symbols must be absolute: " + name));
                } else if (symbol.getValue() == null || symbol.getValue().longValue() == 0L) {
                    TestRCBP1.this.exit(new Exception("Symbols must not be NULL: " + name));
                } else {
                    TestRCBP1.this.sym_list.put(name, symbol);
                    if (cmds.isEmpty()) {
                        TestRCBP1.this.runTest();
                    }
                }
            }
        };
        String[] syms = new String[]{"tcf_test_func0", "tcf_test_func1", "tcf_test_func2", "tcf_test_func3", "tcf_test_array"};
        String prs = this.test_context.getProcessID();
        String[] stringArray = syms;
        int n = syms.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            cmds.put(this.diag.getSymbol(prs, name, done), name);
            ++n2;
        }
    }

    private void iniBreakpoints() {
        assert (!this.bp_set_done);
        Map[] m = new Map[7];
        int i = 0;
        while (i < m.length) {
            m[i] = new HashMap();
            m[i].put("ID", "TcfTestBP" + i + this.channel_id);
            m[i].put("Enabled", Boolean.TRUE);
            switch (i) {
                case 0: {
                    m[i].put("Location", this.sym_list.get("tcf_test_func0").getValue().toString());
                    m[i].put("Condition", "$thread!=\"\"");
                    break;
                }
                case 1: {
                    m[i].put("Location", this.sym_list.get("tcf_test_func0").getValue().toString());
                    m[i].put("Condition", "$thread==\"\"");
                    break;
                }
                case 2: {
                    m[i].put("Location", "tcf_test_func0");
                    break;
                }
                case 3: {
                    m[i].put("Location", "(31+1)/16+tcf_test_func1-2");
                    m[i].put("Condition", "tcf_test_func0!=tcf_test_func1");
                    break;
                }
                case 4: {
                    m[i].put("Location", "tcf_test_func2");
                    m[i].put("Enabled", Boolean.FALSE);
                    break;
                }
                case 5: {
                    m[i].put("Location", "tcf_test_func2");
                    m[i].put("Enabled", Boolean.FALSE);
                    break;
                }
                case 6: {
                    m[i].put("Location", "tcf_test_func3");
                }
            }
            this.bp_list.put((String)m[i].get("ID"), m[i]);
            ++i;
        }
        this.bp.set(m, new IBreakpoints.DoneCommand(){

            public void doneCommand(IToken token, Exception error) {
                TestRCBP1.this.bp_set_done = true;
                if (error != null) {
                    TestRCBP1.this.exit(error);
                    return;
                }
                TestRCBP1.this.runTest();
            }
        });
    }

    private void getContextState(final String id) {
        this.get_state_cmds.add(this.rc.getChildren(id, new IRunControl.DoneGetChildren(){

            public void doneGetChildren(IToken token, Exception error, String[] contexts) {
                TestRCBP1.this.get_state_cmds.remove(token);
                if (((TestRCBP1)TestRCBP1.this).test_suite.cancel) {
                    return;
                }
                if (error != null) {
                    TestRCBP1.this.exit(error);
                    return;
                }
                String[] stringArray = contexts;
                int n = contexts.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    TestRCBP1.this.getContextState(s);
                    ++n2;
                }
                if (TestRCBP1.this.get_state_cmds.isEmpty()) {
                    TestRCBP1.this.doneContextState();
                }
            }
        }));
        this.get_state_cmds.add(this.rc.getContext(id, new IRunControl.DoneGetContext(){

            public void doneGetContext(IToken token, Exception error, IRunControl.RunControlContext context) {
                TestRCBP1.this.get_state_cmds.remove(token);
                if (((TestRCBP1)TestRCBP1.this).test_suite.cancel) {
                    return;
                }
                if (error != null) {
                    TestRCBP1.this.exit(error);
                    return;
                }
                if (context.hasState()) {
                    TestRCBP1.this.threads.put(id, context);
                    TestRCBP1.this.get_state_cmds.add(context.getState(new IRunControl.DoneGetState(){

                        public void doneGetState(IToken token, Exception error, boolean susp, String pc, String reason, Map<String, Object> params) {
                            TestRCBP1.this.get_state_cmds.remove(token);
                            if (((TestRCBP1)(this).TestRCBP1.this).test_suite.cancel) {
                                return;
                            }
                            if (error != null) {
                                TestRCBP1.this.exit(error);
                                return;
                            }
                            if (!susp) {
                                if (TestRCBP1.this.suspended.get(id) != null) {
                                    TestRCBP1.this.exit(new Exception("Invalid result of getState command"));
                                    return;
                                }
                                TestRCBP1.this.running.add(id);
                            } else {
                                if (!$assertionsDisabled && TestRCBP1.this.threads.get(id) == null) {
                                    throw new AssertionError();
                                }
                                if (TestRCBP1.this.running.contains(id)) {
                                    TestRCBP1.this.exit(new Exception("Invalid result of getState command"));
                                    return;
                                }
                                SuspendedContext sc = (SuspendedContext)TestRCBP1.this.suspended.get(id);
                                if (!(sc == null || sc.pc.equals(pc) && sc.reason.equals(reason))) {
                                    TestRCBP1.this.exit(new Exception("Invalid result of getState command"));
                                    return;
                                }
                                if ("Breakpoint".equals(reason)) {
                                    TestRCBP1.this.exit(new Exception("Invalid suspend reason of main thread after test start: " + reason + " " + pc));
                                    return;
                                }
                                TestRCBP1.this.suspended.put(id, new SuspendedContext(id, pc, reason, params));
                            }
                            if (TestRCBP1.this.get_state_cmds.isEmpty()) {
                                TestRCBP1.this.doneContextState();
                            }
                        }
                    }));
                }
                if (TestRCBP1.this.get_state_cmds.isEmpty()) {
                    TestRCBP1.this.doneContextState();
                }
            }
        }));
    }

    private void doneContextState() {
        assert (!this.done_get_state);
        assert (this.get_state_cmds.isEmpty());
        assert (this.resume_cnt == 0);
        assert (this.threads.size() == this.suspended.size() + this.running.size());
        assert (this.bp_set_done);
        assert (!this.bp_change_done);
        this.done_get_state = true;
        if (this.threads.size() == 0) {
            return;
        }
        this.runTest();
    }

    private void changeBreakpoints() {
        assert (!this.bp_change_done);
        final String bp_id = "TcfTestBP5" + this.channel_id;
        final Map<String, Object> m = this.bp_list.get(bp_id);
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.test_context.getProcessID());
        m.put("ContextIds", l);
        m.put("StopGroup", l);
        StringBuffer bf = new StringBuffer();
        for (final String id : this.threads.keySet()) {
            if (bf.length() > 0) {
                bf.append(" || ");
            }
            bf.append("$thread==\"");
            bf.append(id);
            bf.append('\"');
        }
        m.put("Condition", bf.toString());
        this.bp_list.put(bp_id, m);
        this.bp.change(m, new IBreakpoints.DoneCommand(){

            public void doneCommand(IToken token, Exception error) {
                TestRCBP1.this.bp_change_done = true;
                if (error != null) {
                    TestRCBP1.this.exit(error);
                }
            }
        });
        this.bp.getIDs(new IBreakpoints.DoneGetIDs(){

            public void doneGetIDs(IToken token, Exception error, String[] ids) {
                if (error != null) {
                    TestRCBP1.this.exit(error);
                    return;
                }
                if (!TestRCBP1.this.bp_change_done) {
                    TestRCBP1.this.exit(new Exception("Invalid responce order"));
                    return;
                }
                HashSet<String> s = new HashSet<String>();
                String[] stringArray = ids;
                int n = ids.length;
                int n2 = 0;
                while (n2 < n) {
                    String id = stringArray[n2];
                    s.add(id);
                    ++n2;
                }
                if (ids.length != s.size()) {
                    TestRCBP1.this.exit(new Exception("Invalis BP list: " + ids));
                    return;
                }
                for (String id : TestRCBP1.this.bp_list.keySet()) {
                    if (s.contains(id)) continue;
                    TestRCBP1.this.exit(new Exception("BP is not listed by Breakpoints.getIDs: " + id));
                    return;
                }
            }
        });
        for (final String id : this.bp_list.keySet()) {
            this.bp.getProperties(id, new IBreakpoints.DoneGetProperties(){

                public void doneGetProperties(IToken token, Exception error, Map<String, Object> properties) {
                    if (error != null) {
                        TestRCBP1.this.exit(error);
                        return;
                    }
                    HashMap<String, Object> m0 = new HashMap<String, Object>(properties);
                    HashMap m1 = (HashMap)TestRCBP1.this.bp_list.get(id);
                    if (m0.get("Enabled") == null) {
                        m0.put("Enabled", Boolean.FALSE);
                    }
                    if (m1.get("Enabled") == null) {
                        m1.put("Enabled", Boolean.FALSE);
                    }
                    if (!m1.equals(m0)) {
                        TestRCBP1.this.exit(new Exception("Invalid data returned by Breakpoints.getProperties: " + m0 + " != " + m1));
                        return;
                    }
                }
            });
            this.bp.getStatus(id, new IBreakpoints.DoneGetStatus(){

                public void doneGetStatus(IToken token, Exception error, Map<String, Object> status) {
                    if (error != null) {
                        TestRCBP1.this.exit(error);
                        return;
                    }
                }
            });
        }
        Protocol.sync((Runnable)new Runnable(){

            public void run() {
                if (!TestRCBP1.this.test_suite.isActive(TestRCBP1.this)) {
                    return;
                }
                if (!TestRCBP1.this.bp_change_done) {
                    TestRCBP1.this.exit(new Exception("Protocol.sync() test failed"));
                    return;
                }
                m.put("Enabled", Boolean.TRUE);
                TestRCBP1.this.bp.enable(new String[]{bp_id}, new IBreakpoints.DoneCommand(){

                    public void doneCommand(IToken token, Exception error) {
                        if (error != null) {
                            TestRCBP1.this.exit(error);
                        }
                    }
                });
                TestRCBP1.this.bp_sync_done = true;
                TestRCBP1.this.runTest();
            }
        });
    }

    public void containerResumed(String[] context_ids) {
        String[] stringArray = context_ids;
        int n = context_ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            this.contextResumed(id);
            ++n2;
        }
    }

    public void containerSuspended(String context, String pc, String reason, Map<String, Object> params, String[] suspended_ids) {
        String[] stringArray = suspended_ids;
        int n = suspended_ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (!id.equals(context)) {
                this.contextSuspended(id, null, null, null);
            }
            ++n2;
        }
        this.contextSuspended(context, pc, reason, params);
    }

    public void contextAdded(IRunControl.RunControlContext[] contexts) {
        IRunControl.RunControlContext[] runControlContextArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            IRunControl.RunControlContext ctx = runControlContextArray[n2];
            String id = ctx.getID();
            if (this.threads.get(id) != null) {
                this.exit(new Exception("Invalid contextAdded event"));
                return;
            }
            String p = ctx.getParentID();
            String c = ctx.getCreatorID();
            if ((this.test_ctx_id.equals(c) || this.test_ctx_id.equals(p)) && ctx.hasState()) {
                this.threads.put(id, ctx);
                if (!this.done_get_state) {
                    this.getContextState(id);
                } else {
                    this.running.add(id);
                }
            }
            ++n2;
        }
    }

    public void contextChanged(IRunControl.RunControlContext[] contexts) {
        IRunControl.RunControlContext[] runControlContextArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            IRunControl.RunControlContext ctx = runControlContextArray[n2];
            String id = ctx.getID();
            if (id.equals(this.test_ctx_id)) {
                this.test_context = ctx;
            }
            if (this.threads.get(id) != null) {
                this.threads.put(id, ctx);
            }
            ++n2;
        }
    }

    public void contextException(String id, String msg) {
        if (this.threads.get(id) != null) {
            this.exit(new Exception(msg));
        }
    }

    public void contextRemoved(String[] contexts) {
        String[] stringArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (this.suspended.get(id) != null) {
                this.exit(new Exception("Invalid contextRemoved event"));
                return;
            }
            this.running.remove(id);
            if (this.threads.remove(id) != null && this.threads.isEmpty()) {
                if (this.bp_cnt != 40) {
                    this.exit(new Exception("Test main thread breakpoint count = " + this.bp_cnt + ", expected 40"));
                }
                this.rc.removeListener((IRunControl.RunControlListener)this);
                this.bp_list.clear();
                this.bp.set(null, new IBreakpoints.DoneCommand(){

                    public void doneCommand(IToken token, Exception error) {
                        TestRCBP1.this.exit(error);
                    }
                });
            }
            ++n2;
        }
    }

    public void contextResumed(String id) {
        IRunControl.RunControlContext ctx = this.threads.get(id);
        if (ctx == null) {
            return;
        }
        if (!ctx.hasState()) {
            this.exit(new Exception("Resumed event for context that HasState = false"));
            return;
        }
        SuspendedContext sc = this.suspended.remove(id);
        if (this.isMyBreakpoint(sc)) {
            this.suspended_prev.put(id, sc);
        }
        this.running.add(id);
    }

    private long getSymAddr(String sym) {
        return this.sym_list.get(sym).getValue().longValue();
    }

    private String toSymName(long addr) {
        for (String name : this.sym_list.keySet()) {
            if (this.getSymAddr(name) != addr) continue;
            return name;
        }
        return "0x" + Long.toHexString(addr);
    }

    private void checkSuspendedContext(SuspendedContext sc, String sym) {
        long ss;
        long pc = Long.parseLong(sc.pc);
        if (pc != (ss = this.getSymAddr(sym)) || !"Breakpoint".equals(sc.reason)) {
            this.exit(new Exception("Invalid contextSuspended event: " + sc.id + " '" + this.toSymName(pc) + "' " + sc.pc + " " + sc.reason + ", expected breakpoint at '" + sym + "' " + ss));
        }
    }

    private boolean isMyBreakpoint(SuspendedContext sc) {
        if (!"Breakpoint".equals(sc.reason)) {
            return false;
        }
        long pc = Long.parseLong(sc.pc);
        for (IDiagnostics.ISymbol sym : this.sym_list.values()) {
            if (pc != sym.getValue().longValue()) continue;
            return true;
        }
        return false;
    }

    public void contextSuspended(final String id, String pc, String reason, Map<String, Object> params) {
        IRunControl.RunControlContext ctx = this.threads.get(id);
        if (ctx == null) {
            return;
        }
        if (!ctx.hasState()) {
            this.exit(new Exception("Suspended event for context that HasState = false"));
            return;
        }
        this.running.remove(id);
        SuspendedContext sc = this.suspended.get(id);
        if (sc != null) {
            if (this.done_get_state || !sc.pc.equals(pc) || !sc.reason.equals(reason)) {
                this.exit(new Exception("Invalid contextSuspended event"));
                return;
            }
        } else {
            sc = new SuspendedContext(id, pc, reason, params);
            this.suspended.put(id, sc);
        }
        if (this.main_thread_id == null && this.isMyBreakpoint(sc)) {
            if (!this.done_get_state) {
                this.exit(new Exception("Unexpeceted breakpoint hit"));
                return;
            }
            this.main_thread_id = id;
        }
        if (this.main_thread_id == null) {
            this.resume(id);
            return;
        }
        if (this.isMyBreakpoint(sc)) {
            SuspendedContext sp;
            String sp_sym;
            if (id.equals(this.main_thread_id)) {
                ++this.bp_cnt;
            }
            String string = sp_sym = (sp = this.suspended_prev.get(id)) == null ? null : this.toSymName(Long.parseLong(sp.pc));
            if (sp == null) {
                this.checkSuspendedContext(sc, "tcf_test_func0");
            } else if ("tcf_test_func0".equals(sp_sym)) {
                this.checkSuspendedContext(sc, "tcf_test_func1");
            } else if ("tcf_test_func1".equals(sp_sym)) {
                if (id.equals(this.main_thread_id)) {
                    this.checkSuspendedContext(sc, "tcf_test_func2");
                } else {
                    this.checkSuspendedContext(sc, "tcf_test_func3");
                }
            } else if ("tcf_test_func2".equals(sp_sym)) {
                this.checkSuspendedContext(sc, "tcf_test_func3");
            } else if ("tcf_test_func3".equals(sp_sym)) {
                this.checkSuspendedContext(sc, "tcf_test_func0");
            }
        }
        if (!this.test_suite.isActive(this)) {
            return;
        }
        final SuspendedContext sc0 = sc;
        ILineNumbers.DoneMapToSource ln_done = new ILineNumbers.DoneMapToSource(){

            public void doneMapToSource(IToken token, Exception error, ILineNumbers.CodeArea[] areas) {
                if (error != null) {
                    TestRCBP1.this.exit(error);
                    return;
                }
                TestRCBP1.this.runMemoryTest(sc0, new Runnable(){

                    public void run() {
                        TestRCBP1.this.runRegistersTest(sc0, new Runnable(){

                            public void run() {
                                TestRCBP1.this.resume(id);
                            }
                        });
                    }
                });
            }
        };
        if (this.ln != null) {
            BigInteger x = new BigInteger(pc);
            BigInteger y = x.add(BigInteger.valueOf(1L));
            this.ln.mapToSource(id, (Number)x, (Number)y, ln_done);
        } else {
            ln_done.doneMapToSource(null, null, null);
        }
    }

    private void resume(final String id) {
        assert (this.done_get_state || this.resume_cnt == 0);
        if (!this.bp_sync_done) {
            return;
        }
        ++this.resume_cnt;
        SuspendedContext sc = this.suspended.get(id);
        IRunControl.RunControlContext ctx = this.threads.get(id);
        if (ctx != null && sc != null) {
            int rm = this.rnd.nextInt(6);
            if (!ctx.canResume(rm)) {
                rm = 0;
            }
            ctx.resume(rm, 1, new HashMap(), new IRunControl.DoneCommand(){

                public void doneCommand(IToken token, Exception error) {
                    if (((TestRCBP1)TestRCBP1.this).test_suite.cancel) {
                        return;
                    }
                    if (!TestRCBP1.this.test_suite.isActive(TestRCBP1.this)) {
                        return;
                    }
                    if (TestRCBP1.this.threads.get(id) == null) {
                        return;
                    }
                    if (error != null) {
                        TestRCBP1.this.exit(error);
                    }
                }
            });
        }
    }

    private void runMemoryTest(final SuspendedContext sc, final Runnable done) {
        if (this.mm == null || this.test_suite.target_lock) {
            Protocol.invokeLater((Runnable)done);
            return;
        }
        this.test_suite.target_lock = true;
        this.mm.getContext(this.test_context.getProcessID(), new IMemory.DoneGetContext(){

            public void doneGetContext(IToken token, Exception error, final IMemory.MemoryContext mem_ctx) {
                if (TestRCBP1.this.suspended.get(sc.id) != sc) {
                    ((TestRCBP1)TestRCBP1.this).test_suite.target_lock = false;
                    return;
                }
                if (error != null) {
                    TestRCBP1.this.exit(error);
                    return;
                }
                if (!TestRCBP1.this.test_context.getProcessID().equals(mem_ctx.getID())) {
                    TestRCBP1.this.exit(new Exception("Bad memory context data: invalid ID"));
                }
                final boolean big_endian = mem_ctx.isBigEndian();
                final int addr_size = mem_ctx.getAddressSize();
                final byte[] buf = new byte[4096];
                mem_ctx.get(((IDiagnostics.ISymbol)TestRCBP1.this.sym_list.get("tcf_test_array")).getValue(), 1, buf, 0, addr_size, 0, new IMemory.DoneMemory(){

                    public void doneMemory(IToken token, IMemory.MemoryError error) {
                        if (TestRCBP1.this.suspended.get(sc.id) != sc) {
                            ((TestRCBP1)(this).TestRCBP1.this).test_suite.target_lock = false;
                            return;
                        }
                        if (error != null) {
                            TestRCBP1.this.exit((Throwable)error);
                            return;
                        }
                        byte[] tmp = new byte[addr_size + 1];
                        tmp[0] = 0;
                        if (big_endian) {
                            System.arraycopy(buf, 0, tmp, 1, addr_size);
                        } else {
                            int i = 0;
                            while (i < addr_size) {
                                tmp[i + 1] = buf[addr_size - i - 1];
                                ++i;
                            }
                        }
                        BigInteger mem_address = new BigInteger(tmp);
                        if (((Number)mem_address).longValue() == 0L) {
                            TestRCBP1.this.exit(new Exception("Bad value of 'tcf_test_array': " + mem_address));
                        }
                        TestRCBP1.this.testSetMemoryCommand(sc, mem_ctx, mem_address, buf, done);
                    }
                });
            }
        });
    }

    private void testSetMemoryCommand(final SuspendedContext sc, final IMemory.MemoryContext mem_ctx, final Number addr, final byte[] buf, final Runnable done) {
        final byte[] data = new byte[buf.length];
        this.rnd.nextBytes(data);
        mem_ctx.set(addr, 1, data, 0, data.length, 0, new IMemory.DoneMemory(){

            public void doneMemory(IToken token, IMemory.MemoryError error) {
                if (TestRCBP1.this.suspended.get(sc.id) != sc) {
                    ((TestRCBP1)TestRCBP1.this).test_suite.target_lock = false;
                    return;
                }
                if (error != null) {
                    TestRCBP1.this.exit((Throwable)error);
                    return;
                }
                mem_ctx.get(addr, 1, buf, 0, buf.length, 0, new IMemory.DoneMemory(){

                    public void doneMemory(IToken token, IMemory.MemoryError error) {
                        if (TestRCBP1.this.suspended.get(sc.id) != sc) {
                            ((TestRCBP1)(this).TestRCBP1.this).test_suite.target_lock = false;
                            return;
                        }
                        if (error != null) {
                            TestRCBP1.this.exit((Throwable)error);
                            return;
                        }
                        int i = 0;
                        while (i < data.length) {
                            if (data[i] != buf[i]) {
                                TestRCBP1.this.exit(new Exception("Invalid Memory.get responce: wrong data at offset " + i + ", expected " + data[i] + ", actual " + buf[i]));
                                return;
                            }
                            ++i;
                        }
                        TestRCBP1.this.testFillMemoryCommand(sc, mem_ctx, addr, buf, done);
                    }
                });
            }
        });
    }

    private void testFillMemoryCommand(final SuspendedContext sc, final IMemory.MemoryContext mem_ctx, final Number addr, final byte[] buf, final Runnable done) {
        final byte[] data = new byte[buf.length / 7];
        this.rnd.nextBytes(data);
        mem_ctx.fill(addr, 1, data, buf.length, 0, new IMemory.DoneMemory(){

            public void doneMemory(IToken token, IMemory.MemoryError error) {
                if (TestRCBP1.this.suspended.get(sc.id) != sc) {
                    ((TestRCBP1)TestRCBP1.this).test_suite.target_lock = false;
                    return;
                }
                if (error != null) {
                    TestRCBP1.this.exit((Throwable)error);
                    return;
                }
                mem_ctx.get(addr, 1, buf, 0, buf.length, 0, new IMemory.DoneMemory(){

                    public void doneMemory(IToken token, IMemory.MemoryError error) {
                        if (TestRCBP1.this.suspended.get(sc.id) != sc) {
                            ((TestRCBP1)(this).TestRCBP1.this).test_suite.target_lock = false;
                            return;
                        }
                        if (error != null) {
                            TestRCBP1.this.exit((Throwable)error);
                            return;
                        }
                        int i = 0;
                        while (i < data.length) {
                            if (data[i % data.length] != buf[i]) {
                                TestRCBP1.this.exit(new Exception("Invalid Memory.get responce: wrong data at offset " + i + ", expected " + data[i % data.length] + ", actual " + buf[i]));
                                return;
                            }
                            ++i;
                        }
                        ((TestRCBP1)(this).TestRCBP1.this).test_suite.target_lock = false;
                        done.run();
                    }
                });
            }
        });
    }

    private void runRegistersTest(final SuspendedContext sc, final Runnable done) {
        if (this.rg == null) {
            Protocol.invokeLater((Runnable)done);
            return;
        }
        if (this.regs.get(sc.id) == null) {
            final HashMap reg_map = new HashMap();
            final HashSet<IToken> cmds = new HashSet<IToken>();
            this.regs.put(sc.id, reg_map);
            cmds.add(this.rg.getChildren(sc.id, new IRegisters.DoneGetChildren(){

                public void doneGetChildren(IToken token, Exception error, String[] context_ids) {
                    cmds.remove(token);
                    if (TestRCBP1.this.suspended.get(sc.id) != sc) {
                        TestRCBP1.this.regs.remove(sc.id);
                        return;
                    }
                    if (error != null) {
                        for (IToken t : cmds) {
                            t.cancel();
                        }
                        TestRCBP1.this.exit(error);
                        return;
                    }
                    String[] stringArray = context_ids;
                    int n = context_ids.length;
                    int n2 = 0;
                    while (n2 < n) {
                        final String id = stringArray[n2];
                        cmds.add(TestRCBP1.this.rg.getChildren(id, (IRegisters.DoneGetChildren)this));
                        cmds.add(TestRCBP1.this.rg.getContext(id, new IRegisters.DoneGetContext(){

                            public void doneGetContext(IToken token, Exception error, IRegisters.RegistersContext context) {
                                cmds.remove(token);
                                if (TestRCBP1.this.suspended.get(sc.id) != sc) {
                                    TestRCBP1.this.regs.remove(sc.id);
                                    return;
                                }
                                if (error != null) {
                                    for (IToken t : cmds) {
                                        t.cancel();
                                    }
                                    TestRCBP1.this.exit(error);
                                    return;
                                }
                                reg_map.put(id, context);
                                if (cmds.isEmpty()) {
                                    TestRCBP1.this.testGetSetRegisterCommands(sc, done);
                                }
                            }
                        }));
                        ++n2;
                    }
                }
            }));
        } else {
            this.testGetSetRegisterCommands(sc, done);
        }
    }

    private void testGetSetRegisterCommands(final SuspendedContext sc, final Runnable done) {
        final HashSet<IToken> cmds = new HashSet<IToken>();
        Map<String, IRegisters.RegistersContext> reg_map = this.regs.get(sc.id);
        for (final IRegisters.RegistersContext ctx : reg_map.values()) {
            if (!ctx.isReadable() || ctx.isReadOnce()) continue;
            cmds.add(ctx.get(new IRegisters.DoneGet(){

                public void doneGet(IToken token, Exception error, byte[] value) {
                    cmds.remove(token);
                    if (TestRCBP1.this.suspended.get(sc.id) != sc) {
                        return;
                    }
                    if (error != null) {
                        for (IToken t : cmds) {
                            t.cancel();
                        }
                        TestRCBP1.this.exit(error);
                        return;
                    }
                    cmds.add(ctx.set(value, new IRegisters.DoneSet(){

                        public void doneSet(IToken token, Exception error) {
                            cmds.remove(token);
                            if (TestRCBP1.this.suspended.get(sc.id) != sc) {
                                return;
                            }
                            if (error != null) {
                                for (IToken t : cmds) {
                                    t.cancel();
                                }
                                TestRCBP1.this.exit(error);
                                return;
                            }
                            if (cmds.isEmpty()) {
                                done.run();
                            }
                        }
                    }));
                }
            }));
        }
        if (!reg_map.isEmpty()) {
            int data_size = 0;
            ArrayList<IRegisters.Location> locs = new ArrayList<IRegisters.Location>();
            String[] ids = reg_map.keySet().toArray(new String[reg_map.size()]);
            int i = 0;
            while (i < this.rnd.nextInt(32)) {
                String id = ids[this.rnd.nextInt(ids.length)];
                IRegisters.RegistersContext ctx = reg_map.get(id);
                if (ctx.isReadable() && ctx.isWriteable() && !ctx.isReadOnce() && !ctx.isWriteOnce()) {
                    int offs = this.rnd.nextInt(ctx.getSize());
                    int size = this.rnd.nextInt(ctx.getSize() - offs) + 1;
                    locs.add(new IRegisters.Location(id, offs, size));
                    data_size += size;
                }
                ++i;
            }
            final int total_size = data_size;
            final IRegisters.Location[] loc_arr = locs.toArray(new IRegisters.Location[locs.size()]);
            cmds.add(this.rg.getm(loc_arr, new IRegisters.DoneGet(){

                public void doneGet(IToken token, Exception error, byte[] value) {
                    cmds.remove(token);
                    if (TestRCBP1.this.suspended.get(sc.id) != sc) {
                        return;
                    }
                    if (error == null && value.length != total_size) {
                        error = new Exception("Invalid data size in Registers.getm reply");
                    }
                    if (error != null) {
                        for (IToken t : cmds) {
                            t.cancel();
                        }
                        TestRCBP1.this.exit(error);
                        return;
                    }
                    cmds.add(TestRCBP1.this.rg.setm(loc_arr, value, new IRegisters.DoneSet(){

                        public void doneSet(IToken token, Exception error) {
                            cmds.remove(token);
                            if (TestRCBP1.this.suspended.get(sc.id) != sc) {
                                return;
                            }
                            if (error != null) {
                                for (IToken t : cmds) {
                                    t.cancel();
                                }
                                TestRCBP1.this.exit(error);
                                return;
                            }
                            if (cmds.isEmpty()) {
                                done.run();
                            }
                        }
                    }));
                }
            }));
        }
        if (cmds.isEmpty()) {
            done.run();
        }
    }

    void cancel(final Runnable done) {
        if (this.rc != null) {
            this.rc.removeListener((IRunControl.RunControlListener)this);
        }
        if (this.test_ctx_id == null) {
            if (this.pending_cancel != null) {
                this.exit(null);
            } else {
                this.pending_cancel = done;
            }
        } else if (this.cancel_test_cmd == null) {
            this.cancel_test_cmd = this.diag.cancelTest(this.test_ctx_id, new IDiagnostics.DoneCancelTest(){

                public void doneCancelTest(IToken token, Throwable error) {
                    TestRCBP1.this.cancel_test_cmd = null;
                    TestRCBP1.this.exit(error);
                    done.run();
                }
            });
        } else {
            this.exit(new Exception("Cannot terminate remote test process"));
            done.run();
        }
    }

    private void exit(Throwable x) {
        if (!this.test_suite.isActive(this)) {
            return;
        }
        if (this.pending_cancel != null) {
            Protocol.invokeLater((Runnable)this.pending_cancel);
            this.pending_cancel = null;
        } else if (this.rc != null) {
            this.rc.removeListener((IRunControl.RunControlListener)this);
        }
        if (this.bp != null) {
            this.bp.removeListener(this.bp_listener);
        }
        this.test_suite.done(this, x);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SuspendedContext {
        final String id;
        final String pc;
        final String reason;
        final Map<String, Object> params;

        SuspendedContext(String id, String pc, String reason, Map<String, Object> params) {
            this.id = id;
            this.pc = pc;
            this.reason = reason;
            this.params = params;
        }
    }
}

