/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.actions;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.tm.internal.tcf.debug.actions.TCFAction;
import org.eclipse.tm.internal.tcf.debug.model.TCFContextState;
import org.eclipse.tm.internal.tcf.debug.model.TCFLaunch;
import org.eclipse.tm.internal.tcf.debug.model.TCFSourceRef;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.tm.tcf.services.IBreakpoints;
import org.eclipse.tm.tcf.services.ILineNumbers;
import org.eclipse.tm.tcf.services.IRunControl;
import org.eclipse.tm.tcf.services.IStackTrace;
import org.eclipse.tm.tcf.util.TCFDataCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TCFActionStepOver
extends TCFAction
implements IRunControl.RunControlListener {
    private final boolean src_step;
    private final IRunControl rc;
    private final IBreakpoints bps;
    private IRunControl.RunControlContext ctx;
    private TCFDataCache<TCFContextState> state;
    private TCFDataCache<TCFSourceRef> line_info;
    private TCFSourceRef source_ref;
    private BigInteger pc0;
    private BigInteger pc1;
    private int step_cnt;
    private Map<String, Object> bp;
    protected boolean exited;

    public TCFActionStepOver(TCFLaunch launch, IRunControl.RunControlContext ctx, boolean src_step) {
        super(launch, ctx.getID());
        this.rc = this.launch.getService(IRunControl.class);
        this.bps = this.launch.getService(IBreakpoints.class);
        this.ctx = ctx;
        this.src_step = src_step;
    }

    protected abstract TCFDataCache<TCFContextState> getContextState();

    protected abstract TCFDataCache<TCFSourceRef> getLineInfo();

    protected abstract TCFDataCache<?> getStackTrace();

    protected abstract TCFDataCache<IStackTrace.StackTraceContext> getStackFrame();

    protected abstract int getStackFrameIndex();

    @Override
    public void run() {
        if (this.exited) {
            return;
        }
        try {
            this.runAction();
        }
        catch (Throwable x) {
            this.exit(x);
        }
    }

    private void runAction() {
        int fno;
        if (this.state == null) {
            this.rc.addListener((IRunControl.RunControlListener)this);
            this.state = this.getContextState();
            if (this.state == null) {
                this.exit(new Exception("Invalid context ID"));
                return;
            }
        }
        if (!this.state.validate((Runnable)this)) {
            return;
        }
        if (this.state.getData() == null || !((TCFContextState)this.state.getData()).is_suspended) {
            this.exit(new Exception("Context is not suspended"));
            return;
        }
        if (this.ctx.canResume(this.src_step ? 3 : 1)) {
            if (this.step_cnt > 0) {
                this.exit(null);
                return;
            }
            this.ctx.resume(this.src_step ? 3 : 1, 1, new IRunControl.DoneCommand(){

                public void doneCommand(IToken token, Exception error) {
                    if (error != null) {
                        TCFActionStepOver.this.exit(error);
                    }
                }
            });
            ++this.step_cnt;
            return;
        }
        TCFDataCache<?> stack_trace = this.getStackTrace();
        if (!stack_trace.validate((Runnable)this)) {
            return;
        }
        if (this.src_step && this.source_ref == null) {
            this.line_info = this.getLineInfo();
            if (!this.line_info.validate((Runnable)this)) {
                return;
            }
            this.source_ref = (TCFSourceRef)this.line_info.getData();
            if (this.source_ref == null) {
                this.exit(new Exception("Line info not available"));
                return;
            }
            if (this.source_ref.error != null) {
                this.exit(this.source_ref.error);
                return;
            }
            ILineNumbers.CodeArea area = this.source_ref.area;
            if (area != null) {
                if (area.start_address instanceof BigInteger) {
                    this.pc0 = (BigInteger)area.start_address;
                } else if (area.start_address != null) {
                    this.pc0 = new BigInteger(area.start_address.toString());
                }
                if (area.end_address instanceof BigInteger) {
                    this.pc1 = (BigInteger)area.end_address;
                } else if (area.end_address != null) {
                    this.pc1 = new BigInteger(area.end_address.toString());
                }
            }
        }
        if ((fno = this.getStackFrameIndex()) < 0) {
            this.exit(null);
            return;
        }
        if (fno > 0) {
            if (this.ctx.canResume(5)) {
                this.ctx.resume(5, 1, new IRunControl.DoneCommand(){

                    public void doneCommand(IToken token, Exception error) {
                        if (error != null) {
                            TCFActionStepOver.this.exit(error);
                        }
                    }
                });
            } else if (this.bps != null && this.ctx.canResume(0)) {
                if (this.bp == null) {
                    TCFDataCache<IStackTrace.StackTraceContext> frame = this.getStackFrame();
                    if (!frame.validate((Runnable)this)) {
                        return;
                    }
                    Number addr = ((IStackTrace.StackTraceContext)frame.getData()).getInstructionAddress();
                    if (addr == null) {
                        this.exit(new Exception("Unknown PC address"));
                        return;
                    }
                    String id = "Step." + this.ctx.getID();
                    this.bp = new HashMap<String, Object>();
                    this.bp.put("ID", id);
                    this.bp.put("Location", addr.toString());
                    this.bp.put("Condition", "$thread==\"" + this.ctx.getID() + "\"");
                    this.bp.put("Enabled", Boolean.TRUE);
                    this.bps.add(this.bp, new IBreakpoints.DoneCommand(){

                        public void doneCommand(IToken token, Exception error) {
                            if (error != null) {
                                TCFActionStepOver.this.exit(error);
                            }
                        }
                    });
                }
                this.ctx.resume(0, 1, new IRunControl.DoneCommand(){

                    public void doneCommand(IToken token, Exception error) {
                        if (error != null) {
                            TCFActionStepOver.this.exit(error);
                        }
                    }
                });
                ++this.step_cnt;
            } else {
                this.exit(new Exception("Step over is not supported"));
            }
            return;
        }
        if (this.bp != null) {
            this.bps.remove(new String[]{(String)this.bp.get("ID")}, new IBreakpoints.DoneCommand(){

                public void doneCommand(IToken token, Exception error) {
                    if (error != null) {
                        TCFActionStepOver.this.exit(error);
                    }
                }
            });
            this.bp = null;
        }
        if (this.step_cnt > 0) {
            if (this.pc0 == null && this.pc1 == null || ((TCFContextState)this.state.getData()).suspend_pc == null) {
                this.exit(null);
                return;
            }
            assert (this.src_step);
            BigInteger pc = new BigInteger(((TCFContextState)this.state.getData()).suspend_pc);
            if (pc.compareTo(this.pc0) < 0 || pc.compareTo(this.pc1) >= 0) {
                if (!this.line_info.validate((Runnable)this)) {
                    return;
                }
                TCFSourceRef ref = (TCFSourceRef)this.line_info.getData();
                if (ref != null && ref.area != null) {
                    if (this.isSameLine(this.source_ref.area, ref.area)) {
                        this.source_ref = ref;
                        ILineNumbers.CodeArea area = this.source_ref.area;
                        if (area.start_address instanceof BigInteger) {
                            this.pc0 = (BigInteger)area.start_address;
                        } else if (area.start_address != null) {
                            this.pc0 = new BigInteger(area.start_address.toString());
                        }
                        if (area.end_address instanceof BigInteger) {
                            this.pc1 = (BigInteger)area.end_address;
                        } else if (area.end_address != null) {
                            this.pc1 = new BigInteger(area.end_address.toString());
                        }
                    } else {
                        this.exit(null);
                        return;
                    }
                }
            }
        }
        ++this.step_cnt;
        if (this.ctx.canResume(1)) {
            this.ctx.resume(1, 1, new IRunControl.DoneCommand(){

                public void doneCommand(IToken token, Exception error) {
                    if (error != null) {
                        TCFActionStepOver.this.exit(error);
                    }
                }
            });
        } else if (this.ctx.canResume(2)) {
            this.ctx.resume(2, 1, new IRunControl.DoneCommand(){

                public void doneCommand(IToken token, Exception error) {
                    if (error != null) {
                        TCFActionStepOver.this.exit(error);
                    }
                }
            });
        } else {
            this.exit(new Exception("Step over is not supported"));
        }
    }

    protected void exit(Throwable error) {
        this.exit(error, "Step Over");
    }

    protected void exit(Throwable error, String reason) {
        if (this.exited) {
            return;
        }
        if (this.bp != null) {
            this.bps.remove(new String[]{(String)this.bp.get("ID")}, new IBreakpoints.DoneCommand(){

                public void doneCommand(IToken token, Exception error) {
                }
            });
        }
        this.rc.removeListener((IRunControl.RunControlListener)this);
        this.exited = true;
        this.done(reason);
    }

    public void containerResumed(String[] context_ids) {
    }

    public void containerSuspended(String context, String pc, String reason, Map<String, Object> params, String[] suspended_ids) {
        String[] stringArray = suspended_ids;
        int n = suspended_ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (!id.equals(context)) {
                this.contextSuspended(id, null, null, null);
            }
            ++n2;
        }
        this.contextSuspended(context, pc, reason, params);
    }

    public void contextAdded(IRunControl.RunControlContext[] contexts) {
    }

    public void contextChanged(IRunControl.RunControlContext[] contexts) {
        IRunControl.RunControlContext[] runControlContextArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            IRunControl.RunControlContext c = runControlContextArray[n2];
            if (c.getID().equals(this.ctx.getID())) {
                this.ctx = c;
            }
            ++n2;
        }
    }

    public void contextException(String context, String msg) {
        if (context.equals(this.ctx.getID())) {
            this.exit(new Exception(msg));
        }
    }

    public void contextRemoved(String[] context_ids) {
        String[] stringArray = context_ids;
        int n = context_ids.length;
        int n2 = 0;
        while (n2 < n) {
            String context = stringArray[n2];
            if (context.equals(this.ctx.getID())) {
                this.exit(null);
            }
            ++n2;
        }
    }

    public void contextResumed(String context) {
    }

    public void contextSuspended(String context, String pc, String reason, Map<String, Object> params) {
        BigInteger x;
        if (!context.equals(this.ctx.getID())) {
            return;
        }
        if ("Step".equals(reason) || this.isMyBreakpoint(pc, reason)) {
            Protocol.invokeLater((Runnable)this);
            return;
        }
        if ("Breakpoint".equals(reason) && this.pc0 != null && this.pc1 != null && (x = new BigInteger(pc)).compareTo(this.pc0) >= 0 && x.compareTo(this.pc1) < 0) {
            Protocol.invokeLater((Runnable)this);
            return;
        }
        this.exit(null, reason);
    }

    private boolean isSameLine(ILineNumbers.CodeArea x, ILineNumbers.CodeArea y) {
        if (x == null || y == null) {
            return false;
        }
        if (x.start_line != y.start_line) {
            return false;
        }
        if (!(x.directory == y.directory || x.directory != null && x.directory.equals(y.directory))) {
            return false;
        }
        return x.file == y.file || x.file != null && x.file.equals(y.file);
    }

    private boolean isMyBreakpoint(String pc, String reason) {
        if (this.bp == null) {
            return false;
        }
        if (pc == null) {
            return false;
        }
        if (!"Breakpoint".equals(reason)) {
            return false;
        }
        BigInteger x = new BigInteger(pc);
        BigInteger y = new BigInteger((String)this.bp.get("Location"));
        return x.equals(y);
    }
}

