/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.rse.files;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.services.clientserver.FileTypeMatcher;
import org.eclipse.rse.services.clientserver.IMatcher;
import org.eclipse.rse.services.clientserver.NamePatternMatcher;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.clientserver.messages.SystemOperationFailedException;
import org.eclipse.rse.services.files.AbstractFileService;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.tm.internal.tcf.rse.ITCFSubSystem;
import org.eclipse.tm.internal.tcf.rse.TCFConnectorService;
import org.eclipse.tm.internal.tcf.rse.TCFConnectorServiceManager;
import org.eclipse.tm.internal.tcf.rse.TCFRSETask;
import org.eclipse.tm.internal.tcf.rse.files.TCFFileResource;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.tm.tcf.services.IFileSystem;
import org.eclipse.tm.tcf.util.TCFFileInputStream;
import org.eclipse.tm.tcf.util.TCFFileOutputStream;

public class TCFFileService
extends AbstractFileService {
    private final TCFConnectorService connector;
    private UserInfo user_info;

    public TCFFileService(IHost host) {
        this.connector = (TCFConnectorService)TCFConnectorServiceManager.getInstance().getConnectorService(host, ITCFSubSystem.class);
    }

    public String getDescription() {
        return "The TCF File Service uses the Target Communication Framework to provide servicefor the Files subsystem. It requires a TCF agent to be running on the remote machine.";
    }

    public SystemMessage getMessage(Throwable x) {
        return new SimpleSystemMessage("org.eclipse.tm.tcf.rse", 69, x.getMessage(), x);
    }

    public String getName() {
        return "TCF File Service";
    }

    private String toRemotePath(String parent, String name) throws SystemMessageException {
        assert (!Protocol.isDispatchThread());
        String s = null;
        if (parent != null) {
            parent = parent.replace('\\', '/');
        }
        if (name != null) {
            name = name.replace('\\', '/');
        }
        if ((s = parent == null || parent.length() == 0 ? name : (name == null || name.equals(".") ? parent : (name.equals("/") ? parent : (parent.endsWith("/") ? String.valueOf(parent) + name : String.valueOf(parent) + '/' + name)))).startsWith("./") || s.equals(".")) {
            UserInfo ui = this.getUserInfo();
            if (ui.error != null) {
                throw new SystemMessageException(this.getMessage(ui.error));
            }
            s = String.valueOf(ui.home.replace('\\', '/')) + s.substring(1);
        }
        while (s.endsWith("/.")) {
            s = s.substring(0, s.length() - 2);
        }
        return s;
    }

    public void copy(String srcParent, String srcName, String tgtParent, String tgtName, IProgressMonitor monitor) throws SystemMessageException {
        final String src = this.toRemotePath(srcParent, srcName);
        final String tgt = this.toRemotePath(tgtParent, tgtName);
        new TCFRSETask<Boolean>(){

            public void run() {
                IFileSystem fs = TCFFileService.this.connector.getFileSystemService();
                fs.copy(src, tgt, false, false, new IFileSystem.DoneCopy(){

                    public void doneCopy(IToken token, IFileSystem.FileSystemException error) {
                        if (error != null) {
                            this.error((Throwable)error);
                        } else {
                            this.done(Boolean.TRUE);
                        }
                    }
                });
            }
        }.getS(monitor, "Copy: " + srcName);
    }

    public void copyBatch(String[] srcParents, String[] srcNames, String tgtParent, IProgressMonitor monitor) throws SystemMessageException {
        int i = 0;
        while (i < srcParents.length) {
            this.copy(srcParents[i], srcNames[i], tgtParent, srcNames[i], monitor);
            ++i;
        }
    }

    public IHostFile createFile(String parent, String name, IProgressMonitor monitor) throws SystemMessageException {
        try {
            this.getOutputStream(parent, name, true, monitor).close();
            return this.getFile(parent, name, monitor);
        }
        catch (IOException e) {
            throw new SystemMessageException(this.getMessage(e));
        }
    }

    public IHostFile createFolder(String parent, String name, IProgressMonitor monitor) throws SystemMessageException {
        final String path = this.toRemotePath(parent, name);
        return (IHostFile)new TCFRSETask<IHostFile>(){

            public void run() {
                final IFileSystem fs = TCFFileService.this.connector.getFileSystemService();
                fs.mkdir(path, null, new IFileSystem.DoneMkDir(){

                    public void doneMkDir(IToken token, IFileSystem.FileSystemException error) {
                        if (error != null) {
                            this.error((Throwable)error);
                            return;
                        }
                        fs.stat(path, new IFileSystem.DoneStat(){

                            public void doneStat(IToken token, IFileSystem.FileSystemException error, IFileSystem.FileAttrs attrs) {
                                if (error != null) {
                                    this.error((Throwable)error);
                                } else {
                                    this.done((Object)new TCFFileResource(TCFFileService.this, path, null, attrs, false));
                                }
                            }
                        });
                    }
                });
            }
        }.getS(monitor, "Create folder");
    }

    public void delete(String parent, String name, IProgressMonitor monitor) throws SystemMessageException {
        final String path = this.toRemotePath(parent, name);
        new TCFRSETask<Boolean>(){

            public void run() {
                final IFileSystem fs = TCFFileService.this.connector.getFileSystemService();
                fs.stat(path, new IFileSystem.DoneStat(){

                    public void doneStat(IToken token, IFileSystem.FileSystemException error, IFileSystem.FileAttrs attrs) {
                        if (error != null) {
                            this.error((Throwable)error);
                            return;
                        }
                        IFileSystem.DoneRemove done = new IFileSystem.DoneRemove(){

                            public void doneRemove(IToken token, IFileSystem.FileSystemException error) {
                                if (error != null) {
                                    this.error((Throwable)error);
                                    return;
                                }
                                this.done(Boolean.TRUE);
                            }
                        };
                        if (attrs.isDirectory()) {
                            fs.rmdir(path, done);
                        } else {
                            fs.remove(path, done);
                        }
                    }
                });
            }
        }.getS(monitor, "Delete");
    }

    public void deleteBatch(String[] remoteParents, String[] fileNames, IProgressMonitor monitor) throws SystemMessageException {
        int i = 0;
        while (i < remoteParents.length) {
            this.delete(remoteParents[i], fileNames[i], monitor);
            ++i;
        }
    }

    public void download(String parent, String name, File file, boolean is_binary, String host_encoding, IProgressMonitor monitor) throws SystemMessageException {
        IHostFile hostFile = this.getFile(parent, name, (IProgressMonitor)new NullProgressMonitor());
        monitor.beginTask("Downloading " + this.toRemotePath(parent, name) + " ...", Long.valueOf(hostFile.getSize() / 1024L).intValue());
        try {
            try {
                file.getParentFile().mkdirs();
                InputStream inp = this.getInputStream(parent, name, is_binary, (IProgressMonitor)new NullProgressMonitor());
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
                this.copyStream(inp, out, is_binary, "UTF8", host_encoding, monitor);
            }
            catch (Exception x) {
                if (x instanceof SystemMessageException) {
                    throw (SystemMessageException)x;
                }
                throw new SystemOperationFailedException("org.eclipse.tm.tcf.rse", x);
            }
        }
        finally {
            monitor.done();
        }
    }

    public String getEncoding(IProgressMonitor monitor) throws SystemMessageException {
        return "UTF8";
    }

    public IHostFile getFile(String parent, String name, IProgressMonitor monitor) throws SystemMessageException {
        final String path = this.toRemotePath(parent, name);
        return (IHostFile)new TCFRSETask<IHostFile>(){

            public void run() {
                IFileSystem fs = TCFFileService.this.connector.getFileSystemService();
                fs.stat(path, new IFileSystem.DoneStat(){

                    public void doneStat(IToken token, IFileSystem.FileSystemException error, IFileSystem.FileAttrs attrs) {
                        if (error != null) {
                            if (error.getStatus() == 65538) {
                                this.done((Object)new TCFFileResource(TCFFileService.this, path, null, null, false));
                                return;
                            }
                            this.error((Throwable)error);
                            return;
                        }
                        this.done((Object)new TCFFileResource(TCFFileService.this, path, null, attrs, false));
                    }
                });
            }
        }.getS(monitor, "Stat");
    }

    protected IHostFile[] internalFetch(String parent, final String filter, final int fileType, IProgressMonitor monitor) throws SystemMessageException {
        final String path = this.toRemotePath(parent, null);
        final boolean wantFiles = fileType == 0 || (fileType & 1) != 0;
        final boolean wantFolders = fileType == 0 || fileType % 2 != 0;
        return (IHostFile[])new TCFRSETask<IHostFile[]>(){
            private IMatcher matcher = null;

            public void run() {
                if (filter == null) {
                    this.matcher = null;
                } else if (filter.endsWith(",")) {
                    String[] types = filter.split(",");
                    this.matcher = new FileTypeMatcher(types, true);
                } else {
                    this.matcher = new NamePatternMatcher(filter, true, true);
                }
                final ArrayList results = new ArrayList();
                final IFileSystem fs = TCFFileService.this.connector.getFileSystemService();
                fs.opendir(path, new IFileSystem.DoneOpen(){

                    public void doneOpen(IToken token, IFileSystem.FileSystemException error, final IFileSystem.IFileHandle handle) {
                        if (error != null) {
                            this.error((Throwable)error);
                            return;
                        }
                        fs.readdir(handle, new IFileSystem.DoneReadDir(){

                            public void doneReadDir(IToken token, IFileSystem.FileSystemException error, IFileSystem.DirEntry[] entries, boolean eof) {
                                if (error != null) {
                                    this.error((Throwable)error);
                                    return;
                                }
                                IFileSystem.DirEntry[] dirEntryArray = entries;
                                int n = entries.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IFileSystem.DirEntry e = dirEntryArray[n2];
                                    if (e.attrs != null) {
                                        if (e.attrs.isDirectory()) {
                                            if (wantFolders && (matcher == null || fileType == 0 || matcher.matches(e.filename))) {
                                                results.add(new TCFFileResource(TCFFileService.this, path, e.filename, e.attrs, false));
                                            }
                                        } else if (e.attrs.isFile() && wantFiles && (matcher == null || matcher.matches(e.filename))) {
                                            results.add(new TCFFileResource(TCFFileService.this, path, e.filename, e.attrs, false));
                                        }
                                    }
                                    ++n2;
                                }
                                if (eof) {
                                    fs.close(handle, new IFileSystem.DoneClose(){

                                        public void doneClose(IToken token, IFileSystem.FileSystemException error) {
                                            if (error != null) {
                                                this.error((Throwable)error);
                                                return;
                                            }
                                            this.done(results.toArray(new TCFFileResource[results.size()]));
                                        }
                                    });
                                } else {
                                    fs.readdir(handle, (IFileSystem.DoneReadDir)this);
                                }
                            }
                        });
                    }
                });
            }
        }.getS(monitor, "Get files and folders");
    }

    public InputStream getInputStream(String parent, String name, boolean isBinary, IProgressMonitor monitor) throws SystemMessageException {
        final String path = this.toRemotePath(parent, name);
        IFileSystem.IFileHandle handle = (IFileSystem.IFileHandle)new TCFRSETask<IFileSystem.IFileHandle>(){

            public void run() {
                IFileSystem fs = TCFFileService.this.connector.getFileSystemService();
                fs.open(path, 1, null, new IFileSystem.DoneOpen(){

                    public void doneOpen(IToken token, IFileSystem.FileSystemException error, IFileSystem.IFileHandle handle) {
                        if (error != null) {
                            this.error((Throwable)error);
                        } else {
                            this.done(handle);
                        }
                    }
                });
            }
        }.getS(monitor, "Get input stream");
        return new TCFFileInputStream(handle);
    }

    public OutputStream getOutputStream(String parent, String name, boolean isBinary, IProgressMonitor monitor) throws SystemMessageException {
        final String path = this.toRemotePath(parent, name);
        IFileSystem.IFileHandle handle = (IFileSystem.IFileHandle)new TCFRSETask<IFileSystem.IFileHandle>(){

            public void run() {
                IFileSystem fs = TCFFileService.this.connector.getFileSystemService();
                int flags = 26;
                fs.open(path, flags, null, new IFileSystem.DoneOpen(){

                    public void doneOpen(IToken token, IFileSystem.FileSystemException error, IFileSystem.IFileHandle handle) {
                        if (error != null) {
                            this.error((Throwable)error);
                        } else {
                            this.done(handle);
                        }
                    }
                });
            }
        }.getS(monitor, "Get output stream");
        return new TCFFileOutputStream(handle);
    }

    public IHostFile[] getRoots(IProgressMonitor monitor) throws SystemMessageException {
        return (IHostFile[])new TCFRSETask<IHostFile[]>(){

            public void run() {
                IFileSystem fs = TCFFileService.this.connector.getFileSystemService();
                fs.roots(new IFileSystem.DoneRoots(){

                    public void doneRoots(IToken token, IFileSystem.FileSystemException error, IFileSystem.DirEntry[] entries) {
                        if (error != null) {
                            this.error((Throwable)error);
                            return;
                        }
                        ArrayList<TCFFileResource> l = new ArrayList<TCFFileResource>();
                        IFileSystem.DirEntry[] dirEntryArray = entries;
                        int n = entries.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IFileSystem.DirEntry e = dirEntryArray[n2];
                            if (e.attrs != null) {
                                l.add(new TCFFileResource(TCFFileService.this, null, e.filename, e.attrs, true));
                            }
                            ++n2;
                        }
                        this.done(l.toArray(new IHostFile[l.size()]));
                    }
                });
            }
        }.getS(monitor, "Get roots");
    }

    public IHostFile getUserHome() {
        UserInfo ui = this.getUserInfo();
        try {
            return this.getFile(ui.home, ".", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (SystemMessageException e) {
            throw new Error(e);
        }
    }

    public boolean isCaseSensitive() {
        return true;
    }

    public void move(String srcParent, String srcName, String tgtParent, String tgtName, IProgressMonitor monitor) throws SystemMessageException {
        final String src_path = this.toRemotePath(srcParent, srcName);
        final String tgt_path = this.toRemotePath(tgtParent, tgtName);
        new TCFRSETask<Boolean>(){

            public void run() {
                IFileSystem fs = TCFFileService.this.connector.getFileSystemService();
                fs.rename(src_path, tgt_path, new IFileSystem.DoneRename(){

                    public void doneRename(IToken token, IFileSystem.FileSystemException error) {
                        if (error != null) {
                            this.error((Throwable)error);
                        } else {
                            this.done(Boolean.TRUE);
                        }
                    }
                });
            }
        }.getS(monitor, "Move");
    }

    public void rename(String remoteParent, String oldName, String newName, IProgressMonitor monitor) throws SystemMessageException {
        this.move(remoteParent, oldName, remoteParent, newName, monitor);
    }

    public void rename(String remoteParent, String oldName, String newName, IHostFile oldFile, IProgressMonitor monitor) throws SystemMessageException {
        this.move(remoteParent, oldName, remoteParent, newName, monitor);
        oldFile.renameTo(this.toRemotePath(remoteParent, newName));
    }

    public void setLastModified(String parent, String name, final long timestamp, IProgressMonitor monitor) throws SystemMessageException {
        final String path = this.toRemotePath(parent, name);
        new TCFRSETask<Boolean>(){

            public void run() {
                IFileSystem fs = TCFFileService.this.connector.getFileSystemService();
                IFileSystem.FileAttrs attrs = new IFileSystem.FileAttrs(8, 0L, 0, 0, 0, timestamp, timestamp, null);
                fs.setstat(path, attrs, new IFileSystem.DoneSetStat(){

                    public void doneSetStat(IToken token, IFileSystem.FileSystemException error) {
                        if (error != null) {
                            this.error((Throwable)error);
                        } else {
                            this.done(Boolean.TRUE);
                        }
                    }
                });
            }
        }.getS(monitor, "Set modification time");
    }

    public void setReadOnly(String parent, String name, final boolean readOnly, IProgressMonitor monitor) throws SystemMessageException {
        final String path = this.toRemotePath(parent, name);
        new TCFRSETask<Boolean>(){

            public void run() {
                final IFileSystem fs = TCFFileService.this.connector.getFileSystemService();
                fs.stat(path, new IFileSystem.DoneStat(){

                    public void doneStat(IToken token, IFileSystem.FileSystemException error, IFileSystem.FileAttrs attrs) {
                        if (error != null) {
                            this.error((Throwable)error);
                            return;
                        }
                        int p = attrs.permissions;
                        if (readOnly) {
                            p &= 0xFFFFFF7F;
                            p &= 0xFFFFFFEF;
                            p &= 0xFFFFFFFD;
                        } else {
                            p |= 0x80;
                            p |= 0x10;
                            p |= 2;
                        }
                        IFileSystem.FileAttrs new_attrs = new IFileSystem.FileAttrs(4, 0L, 0, 0, p, 0L, 0L, null);
                        fs.setstat(path, new_attrs, new IFileSystem.DoneSetStat(){

                            public void doneSetStat(IToken token, IFileSystem.FileSystemException error) {
                                if (error != null) {
                                    this.error((Throwable)error);
                                } else {
                                    this.done(Boolean.TRUE);
                                }
                            }
                        });
                    }
                });
            }
        }.getS(monitor, "Set permissions");
    }

    public void upload(InputStream inp, String parent, String name, boolean isBinary, String hostEncoding, IProgressMonitor monitor) throws SystemMessageException {
        monitor.beginTask("Upload", 1);
        try {
            try {
                OutputStream out = this.getOutputStream(parent, name, isBinary, (IProgressMonitor)new NullProgressMonitor());
                this.copyStream(inp, out, isBinary, hostEncoding, "UTF8", (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Throwable x) {
                if (x instanceof SystemMessageException) {
                    throw (SystemMessageException)x;
                }
                throw new SystemMessageException(this.getMessage(x));
            }
        }
        finally {
            monitor.done();
        }
    }

    public void upload(File localFile, String parent, String name, boolean isBinary, String srcEncoding, String hostEncoding, IProgressMonitor monitor) throws SystemMessageException {
        monitor.beginTask("Uploading " + localFile.toString() + " ...", Long.valueOf(localFile.length() / 1024L).intValue());
        try {
            try {
                OutputStream out = this.getOutputStream(parent, name, isBinary, (IProgressMonitor)new NullProgressMonitor());
                BufferedInputStream inp = new BufferedInputStream(new FileInputStream(localFile));
                this.copyStream(inp, out, isBinary, hostEncoding, "UTF8", monitor);
            }
            catch (Throwable x) {
                if (x instanceof SystemMessageException) {
                    throw (SystemMessageException)x;
                }
                throw new SystemMessageException(this.getMessage(x));
            }
        }
        finally {
            monitor.done();
        }
    }

    private void copyStream(InputStream inp, OutputStream out, boolean is_binary, String inp_encoding, String out_encoding, IProgressMonitor monitor) throws IOException {
        block10: {
            try {
                int buf_len;
                if (!is_binary) {
                    if (inp_encoding == null || inp_encoding.equals("UTF-8")) {
                        inp_encoding = "UTF8";
                    }
                    if (out_encoding == null || out_encoding.equals("UTF-8")) {
                        out_encoding = "UTF8";
                    }
                }
                if (is_binary || inp_encoding.equals(out_encoding)) {
                    byte[] buf = new byte[4096];
                    while (true) {
                        int buf_len2;
                        if ((buf_len2 = inp.read(buf)) < 0) {
                            break block10;
                        }
                        out.write(buf, 0, buf_len2);
                        if (monitor == null) continue;
                        monitor.worked(buf_len2 / 1024);
                    }
                }
                InputStreamReader reader = new InputStreamReader(inp, inp_encoding);
                OutputStreamWriter writer = new OutputStreamWriter(out, out_encoding);
                char[] buf = new char[4096];
                while ((buf_len = reader.read(buf)) >= 0) {
                    ((Writer)writer).write(buf, 0, buf_len);
                    if (monitor == null) continue;
                    monitor.worked(buf_len / 1024);
                }
                ((Writer)writer).flush();
            }
            finally {
                out.close();
                inp.close();
            }
        }
    }

    private synchronized UserInfo getUserInfo() {
        if (this.user_info == null || this.user_info.error != null) {
            this.user_info = (UserInfo)new TCFRSETask<UserInfo>(){

                public void run() {
                    IFileSystem fs = TCFFileService.this.connector.getFileSystemService();
                    fs.user(new IFileSystem.DoneUser(){

                        public void doneUser(IToken token, IFileSystem.FileSystemException error, int real_uid, int effective_uid, int real_gid, int effective_gid, String home) {
                            if (error != null) {
                                this.done(new UserInfo((Throwable)error));
                            } else {
                                this.done(new UserInfo(real_uid, effective_uid, real_gid, effective_gid, home));
                            }
                        }
                    });
                }
            }.getE();
        }
        return this.user_info;
    }

    public boolean canRead(IFileSystem.FileAttrs attrs) {
        if ((attrs.flags & 4) == 0) {
            return false;
        }
        if ((attrs.flags & 2) == 0) {
            return false;
        }
        UserInfo ui = this.getUserInfo();
        if (ui.error != null) {
            return false;
        }
        if (ui.e_uid == attrs.uid) {
            return (attrs.permissions & 0x100) != 0;
        }
        if (ui.e_gid == attrs.gid) {
            return (attrs.permissions & 0x20) != 0;
        }
        return (attrs.permissions & 4) != 0;
    }

    public boolean canWrite(IFileSystem.FileAttrs attrs) {
        if ((attrs.flags & 4) == 0) {
            return false;
        }
        if ((attrs.flags & 2) == 0) {
            return false;
        }
        UserInfo ui = this.getUserInfo();
        if (ui.error != null) {
            return false;
        }
        if (ui.e_uid == attrs.uid) {
            return (attrs.permissions & 0x80) != 0;
        }
        if (ui.e_gid == attrs.gid) {
            return (attrs.permissions & 0x10) != 0;
        }
        return (attrs.permissions & 2) != 0;
    }

    private static final class UserInfo {
        final int r_uid;
        final int e_uid;
        final int r_gid;
        final int e_gid;
        final String home;
        final Throwable error;

        UserInfo(int r_uid, int e_uid, int r_gid, int e_gid, String home) {
            this.r_uid = r_uid;
            this.e_uid = e_uid;
            this.r_gid = r_gid;
            this.e_gid = e_gid;
            this.home = home;
            this.error = null;
        }

        UserInfo(Throwable error) {
            this.error = error;
            this.r_uid = -1;
            this.e_uid = -1;
            this.r_gid = -1;
            this.e_gid = -1;
            this.home = null;
        }
    }
}

