/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers;

import org.eclipse.cdt.codan.checkers.CodanCheckersActivator;
import org.eclipse.cdt.codan.core.cxx.model.AbstractIndexAstChecker;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;

public class NonVirtualDestructor
extends AbstractIndexAstChecker {
    public static final String ER_ID = "org.eclipse.cdt.codan.internal.checkers.NonVirtualDestructorProblem";

    public void processAst(IASTTranslationUnit ast) {
        ast.accept((ASTVisitor)new OnEachClass());
    }

    class OnEachClass
    extends ASTVisitor {
        private IASTName className;
        private IBinding virtualMethod;
        private IBinding destructor;
        private IASTDeclSpecifier warningLocation;

        OnEachClass() {
            this.shouldVisitDeclSpecifiers = true;
        }

        public int visit(IASTDeclSpecifier decl) {
            if (this.isClassDecl(decl)) {
                try {
                    boolean err = this.hasErrorCondition(decl);
                    if (err) {
                        String clazz = this.className.toString();
                        String method = this.virtualMethod.getName();
                        IASTDeclSpecifier node = decl;
                        if (this.destructor != null && this.destructor instanceof ICPPInternalBinding) {
                            IASTNode[] decls = ((ICPPInternalBinding)this.destructor).getDeclarations();
                            if (this.warningLocation == null) {
                                if (decls != null && decls.length > 0) {
                                    node = decls[0];
                                }
                            } else {
                                node = this.warningLocation;
                            }
                        }
                        NonVirtualDestructor.this.reportProblem(NonVirtualDestructor.ER_ID, (IASTNode)node, new Object[]{clazz, method});
                    }
                }
                catch (DOMException dOMException) {
                }
                catch (Exception e) {
                    CodanCheckersActivator.log(e);
                }
                return 1;
            }
            return 3;
        }

        private boolean hasErrorCondition(IASTDeclSpecifier decl) throws DOMException {
            boolean noVirtualDtorInBase;
            ICPPMethod[] allDeclaredMethods;
            ICPPASTCompositeTypeSpecifier spec = (ICPPASTCompositeTypeSpecifier)decl;
            this.className = spec.getName();
            IBinding binding = this.className.resolveBinding();
            if (!(binding instanceof ICPPClassType)) {
                return false;
            }
            ICPPClassType classType = (ICPPClassType)binding;
            this.virtualMethod = null;
            this.destructor = null;
            this.warningLocation = null;
            ICPPMethod[] declaredMethods = classType.getDeclaredMethods();
            boolean hasOwnVirtualMethod = false;
            boolean hasOwnNonVirtualDestructor = false;
            boolean hasDestructor = false;
            boolean hasVirtualMethod = false;
            ICPPMethod[] iCPPMethodArray = declaredMethods;
            int n = declaredMethods.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPMethod method = iCPPMethodArray[n2];
                if (method.isPureVirtual()) {
                    return false;
                }
                if (method.isVirtual() && !method.isDestructor()) {
                    hasOwnVirtualMethod = true;
                    this.virtualMethod = method;
                }
                if (method.isDestructor()) {
                    hasDestructor = true;
                    if (!method.isVirtual()) {
                        hasOwnNonVirtualDestructor = true;
                        this.destructor = method;
                    }
                }
                ++n2;
            }
            boolean hasVirtualDestructor = false;
            if (hasOwnVirtualMethod && hasOwnNonVirtualDestructor) {
                if (classType.getFriends().length == 0) {
                    if (this.destructor instanceof ICPPMethod && ((ICPPMethod)this.destructor).getVisibility() != 1) {
                        return false;
                    }
                    return !this.hasVirtualDtorInBaseClass(classType);
                }
                return true;
            }
            if (hasOwnVirtualMethod && !hasDestructor && classType.getBases().length == 0) {
                return true;
            }
            if (!hasOwnVirtualMethod && hasDestructor && !hasOwnNonVirtualDestructor) {
                return false;
            }
            ICPPMethod[] iCPPMethodArray2 = allDeclaredMethods = classType.getAllDeclaredMethods();
            int n3 = allDeclaredMethods.length;
            int n4 = 0;
            while (n4 < n3) {
                ICPPMethod method = iCPPMethodArray2[n4];
                if (method.isVirtual() && !method.isDestructor()) {
                    hasVirtualMethod = true;
                    if (this.virtualMethod == null) {
                        this.virtualMethod = method;
                    }
                }
                if (method.isDestructor()) {
                    hasDestructor = true;
                    if (method.isVirtual()) {
                        hasVirtualDestructor = true;
                    } else if (this.destructor == null) {
                        this.destructor = method;
                    }
                }
                ++n4;
            }
            if (hasOwnVirtualMethod) {
                if (hasDestructor && !hasVirtualDestructor) {
                    boolean bl = noVirtualDtorInBase = !this.hasVirtualDtorInBaseClass(classType);
                    if (noVirtualDtorInBase) {
                        this.warningLocation = decl;
                    }
                    return noVirtualDtorInBase;
                }
            } else if (hasVirtualMethod) {
                if (hasOwnNonVirtualDestructor) {
                    return true;
                }
                boolean bl = noVirtualDtorInBase = !this.hasVirtualDtorInBaseClass(classType);
                if (noVirtualDtorInBase) {
                    this.warningLocation = decl;
                }
                return noVirtualDtorInBase;
            }
            return false;
        }

        private boolean hasVirtualDtorInBaseClass(ICPPClassType classType) {
            ICPPBase[] bases;
            ICPPBase[] iCPPBaseArray = bases = classType.getBases();
            int n = bases.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPBase base = iCPPBaseArray[n2];
                if (base.getBaseClass() instanceof ICPPClassType) {
                    ICPPMethod[] declaredBaseMethods;
                    ICPPClassType testedBaseClass = (ICPPClassType)base.getBaseClass();
                    ICPPMethod[] iCPPMethodArray = declaredBaseMethods = testedBaseClass.getDeclaredMethods();
                    int n3 = declaredBaseMethods.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ICPPMethod method = iCPPMethodArray[n4];
                        if (method.isPureVirtual()) {
                            return false;
                        }
                        if (method.isDestructor() && method.isVirtual()) {
                            return true;
                        }
                        ++n4;
                    }
                    if (this.hasVirtualDtorInBaseClass(testedBaseClass)) {
                        return true;
                    }
                }
                ++n2;
            }
            return false;
        }

        private boolean isClassDecl(IASTDeclSpecifier decl) {
            return decl instanceof ICPPASTCompositeTypeSpecifier;
        }
    }
}

