/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.ui.actions;

import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.snapshot.Album;
import org.eclipse.cdt.debug.edc.internal.snapshot.SnapshotUtils;
import org.eclipse.cdt.debug.edc.internal.ui.actions.AbstractSnapshotCommandHandler;
import org.eclipse.cdt.debug.edc.snapshot.IAlbum;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.debug.ui.contexts.DebugContextEvent;

public class PreviousSnapshotCommandHandler
extends AbstractSnapshotCommandHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            if (this.isSnapshotSession()) {
                this.getAlbumContext().stopPlayingSnapshots();
                this.getAlbumContext().openPreviousSnapshot();
            } else {
                Album album = Album.getRecordingForSession((String)this.getSelectionExecutionDMC().getSessionId());
                album.setCurrentSnapshotIndex(album.getSnapshots().size() - 1);
                if (album.getSessionID().length() == 0) {
                    SnapshotUtils.launchAlbumSession((Album)album);
                } else {
                    album.openSnapshot(album.getSnapshots().size() - 1);
                }
            }
        }
        catch (Exception e) {
            EDCDebugger.getMessageLogger().logError(null, (Throwable)e);
        }
        return null;
    }

    public void debugContextChanged(DebugContextEvent event) {
        super.debugContextChanged(event);
        IAlbum album = this.getAlbumContext();
        boolean enableit = false;
        if (album != null) {
            boolean bl = enableit = this.isSnapshotSession() && album.getCurrentSnapshotIndex() > 0;
            if (!enableit) {
                IRunControl.IExecutionDMContext selectionDMC = this.getSelectionExecutionDMC();
                enableit = selectionDMC != null && Album.getRecordingForSession((String)this.getSelectionExecutionDMC().getSessionId()) != null;
            }
        }
        this.setBaseEnabled(this.isEnabled() && enableit);
    }
}

