/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers.ui.quickfix;

import org.eclipse.cdt.codan.core.cxx.CxxAstUtils;
import org.eclipse.cdt.codan.internal.checkers.ui.CheckersUiActivator;
import org.eclipse.cdt.codan.internal.checkers.ui.quickfix.Messages;
import org.eclipse.cdt.codan.ui.AbstractAstRewriteQuickFix;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.INodeFactory;
import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;

public class QuickFixCreateLocalVariable
extends AbstractAstRewriteQuickFix {
    public String getLabel() {
        return Messages.QuickFixCreateLocalVariable_0;
    }

    public void modifyAST(IIndex index, IMarker marker) {
        IASTTranslationUnit ast;
        CxxAstUtils utils = CxxAstUtils.getInstance();
        try {
            ITranslationUnit tu = this.getTranslationUnitViaEditor(marker);
            ast = tu.getAST(index, 2);
        }
        catch (CoreException e) {
            CheckersUiActivator.log(e);
            return;
        }
        IASTName astName = this.isCodanProblem() ? this.getASTNameFromMarker(marker, ast) : this.getAstNameFromProblemArgument(marker, ast, 0);
        if (astName == null) {
            return;
        }
        ASTRewrite r = ASTRewrite.create((IASTTranslationUnit)ast);
        INodeFactory factory = ast.getASTNodeFactory();
        IASTDeclaration declaration = utils.createDeclaration(astName, factory, index);
        IASTDeclarationStatement newStatement = factory.newDeclarationStatement(declaration);
        IASTStatement targetStatement = utils.getEnclosingStatement((IASTNode)astName);
        if (targetStatement == null) {
            return;
        }
        r.insertBefore(targetStatement.getParent(), (IASTNode)targetStatement, (IASTNode)newStatement, null);
        Change c = r.rewriteAST();
        try {
            c.perform((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            CheckersUiActivator.log(e);
            return;
        }
        try {
            marker.delete();
        }
        catch (CoreException e) {
            CheckersUiActivator.log(e);
        }
    }

    public boolean isApplicable(IMarker marker) {
        if (this.isCodanProblem()) {
            String problemArgument = this.getProblemArgument(marker, 1);
            return problemArgument.contains(":func");
        }
        return true;
    }
}

