/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions;

import java.math.BigInteger;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.ASTEvalMessages;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.CompoundInstruction;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.GetValue;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.Interpreter;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperandValue;
import org.eclipse.cdt.debug.edc.internal.symbols.ICPPBasicType;
import org.eclipse.cdt.debug.edc.symbols.IType;
import org.eclipse.core.runtime.CoreException;

public abstract class BinaryOperator
extends CompoundInstruction {
    protected BinaryOperator(int resultId, boolean isAssignmentOperator, int start) {
        super(start);
    }

    public void execute() throws CoreException {
        OperandValue right = this.popValue();
        OperandValue left = this.popValue();
        right = this.convertForPromotion(right);
        if (this.customHandleOperation(this.fInterpreter, left = this.convertForPromotion(left), right)) {
            return;
        }
        int resultType = this.getJavaBinaryPromotionType(right, left);
        IType type = resultType == 11 ? left.getValueType() : this.getBinaryPromotionType(right, left);
        if (type instanceof ICPPBasicType && ((ICPPBasicType)type).getBaseType() == 6) {
            type = this.fInterpreter.getTypeEngine().getIntegerTypeFor(6, true);
        }
        switch (resultType) {
            case 11: {
                this.pushNewValue(type, this.getStringResult(GetValue.getStringValue(left), GetValue.getStringValue(right)));
                break;
            }
            case 8: {
                this.pushNewValue(type, this.getDoubleResult(GetValue.getDoubleValue(left), GetValue.getDoubleValue(right)));
                break;
            }
            case 9: {
                this.pushNewValue(type, Float.valueOf(this.getFloatResult(GetValue.getFloatValue(left), GetValue.getFloatValue(right))));
                break;
            }
            case 7: {
                this.pushNewValue(type, this.getLongResult(GetValue.getLongValue(left), GetValue.getLongValue(right)));
                break;
            }
            case 10: {
                this.pushNewValue(type, this.getIntResult(GetValue.getIntValue(left), GetValue.getIntValue(right)));
                break;
            }
            case 5: {
                this.pushNewValue(type, this.getBooleanResult(GetValue.getBooleanValue(left), GetValue.getBooleanValue(right)));
                break;
            }
            case 13: {
                this.pushNewValue(type, this.getBigIntegerResult(GetValue.getBigIntegerValue(left), GetValue.getBigIntegerValue(right), 8));
                break;
            }
            default: {
                throw EDCDebugger.newCoreException(String.valueOf(ASTEvalMessages.UnhandledTypeCode) + resultType);
            }
        }
    }

    protected boolean customHandleOperation(Interpreter fInterpreter, OperandValue left, OperandValue right) throws CoreException {
        return false;
    }

    protected abstract int getIntResult(int var1, int var2) throws CoreException;

    protected abstract long getLongResult(long var1, long var3) throws CoreException;

    protected abstract BigInteger getBigIntegerResult(BigInteger var1, BigInteger var2, int var3) throws CoreException;

    protected abstract float getFloatResult(float var1, float var2);

    protected abstract double getDoubleResult(double var1, double var3);

    protected abstract boolean getBooleanResult(boolean var1, boolean var2);

    protected String getStringResult(String leftOperand, String rightOperand) throws CoreException {
        throw EDCDebugger.newCoreException(ASTEvalMessages.UnsupportedStringOperation);
    }
}

