/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.internal.PathUtils;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Modules;
import org.eclipse.cdt.debug.edc.internal.symbols.FileLineEntryProvider;
import org.eclipse.cdt.debug.edc.internal.symbols.LineEntry;
import org.eclipse.cdt.debug.edc.symbols.ICompileUnitScope;
import org.eclipse.cdt.debug.edc.symbols.IFunctionScope;
import org.eclipse.cdt.debug.edc.symbols.ILineEntry;
import org.eclipse.cdt.debug.edc.symbols.ILineEntryProvider;
import org.eclipse.cdt.debug.edc.symbols.IModuleLineEntryProvider;
import org.eclipse.cdt.debug.edc.symbols.IScope;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleLineEntryProvider
implements IModuleLineEntryProvider {
    private Set<ICompileUnitScope> parsedCUs = new HashSet<ICompileUnitScope>();
    private PathToLineEntryMap pathToLineEntryMap = new PathToLineEntryMap();
    private FileLineEntryProviders fileProviders = new FileLineEntryProviders();
    private FileLineEntryProvider[] fileProviderArray;

    public void addCompileUnit(ICompileUnitScope cu) {
        if (this.parsedCUs.contains(cu)) {
            return;
        }
        this.parsedCUs.add(cu);
        Collection<ILineEntry> lineEntries = cu.getLineEntries();
        if (lineEntries.size() > 0) {
            HashMap<IPath, FileLineEntryProvider> fileProviders = new HashMap<IPath, FileLineEntryProvider>(4);
            for (ILineEntry entry : lineEntries) {
                IPath path = entry.getFilePath();
                FileLineEntryProvider provider = (FileLineEntryProvider)fileProviders.get(path);
                if (provider == null) {
                    provider = this.getFileLineProviderForCU(cu, path);
                    provider.setCULineEntries(lineEntries);
                    fileProviders.put(path, provider);
                }
                provider.addLineEntry(entry);
            }
        }
        for (IScope child : cu.getChildren()) {
            this.addCompileUnitChild(cu, child);
        }
    }

    public void addCompileUnitChild(ICompileUnitScope cu, IScope child) {
        IFunctionScope func;
        IPath declFile;
        if (child instanceof IFunctionScope && (declFile = (func = (IFunctionScope)child).getDeclFile()) != null) {
            FileLineEntryProvider provider = this.getFileLineProviderForCU(cu, declFile);
            int declLine = func.getDeclLine();
            int declColumn = func.getDeclColumn();
            Collection<ILineEntry> curEntries = provider.getLineEntriesForLines(declFile, declLine, declLine);
            if (curEntries.isEmpty()) {
                LineEntry entry = new LineEntry(declFile, declLine, declColumn, func.getLowAddress(), func.getLowAddress());
                provider.addLineEntry(entry);
            }
        }
    }

    private FileLineEntryProvider getFileLineProviderForCU(ICompileUnitScope cu, IPath declFile) {
        FileLineEntryProviders providers = (FileLineEntryProviders)this.pathToLineEntryMap.get(declFile);
        if (providers != null) {
            for (FileLineEntryProvider p : providers) {
                if (!p.getCU().equals(cu)) continue;
                return p;
            }
        }
        FileLineEntryProvider provider = new FileLineEntryProvider(cu, declFile);
        this.registerFileLineEntryProvider(declFile, provider);
        return provider;
    }

    private void registerFileLineEntryProvider(IPath path, FileLineEntryProvider provider) {
        FileLineEntryProviders fileEntries = (FileLineEntryProviders)this.pathToLineEntryMap.get(path);
        if (fileEntries == null) {
            fileEntries = new FileLineEntryProviders();
            this.pathToLineEntryMap.put(path, fileEntries);
        }
        fileEntries.add(provider);
        this.fileProviders.add(provider);
        this.fileProviderArray = null;
    }

    @Override
    public Collection<ILineEntryProvider> getLineEntryProvidersForFile(IPath sourceFile) {
        List cus = (List)this.pathToLineEntryMap.get(sourceFile);
        if (cus != null) {
            return Collections.unmodifiableCollection(cus);
        }
        for (Map.Entry entry : this.pathToLineEntryMap.entrySet()) {
            if (PathUtils.isCaseSensitive() || ((IPath)entry.getKey()).toOSString().compareToIgnoreCase(sourceFile.toOSString()) != 0) continue;
            cus = (List)entry.getValue();
            this.pathToLineEntryMap.put(sourceFile, (FileLineEntryProviders)entry.getValue());
            return Collections.unmodifiableCollection(cus);
        }
        for (Map.Entry entry : this.pathToLineEntryMap.entrySet()) {
            if (!((IPath)entry.getKey()).equals((Object)sourceFile)) continue;
            cus = (List)entry.getValue();
            return Collections.unmodifiableCollection(cus);
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<ILineEntry> getLineEntriesForLines(IPath file, int startLineNumber, int endLineNumber) {
        FileLineEntryProviders matches = (FileLineEntryProviders)this.pathToLineEntryMap.get(file);
        if (matches == null) {
            return Collections.emptyList();
        }
        ArrayList<ILineEntry> ret = null;
        for (FileLineEntryProvider provider : matches) {
            Collection<ILineEntry> entries = provider.getLineEntriesForLines(file, startLineNumber, endLineNumber);
            if (entries.isEmpty()) continue;
            if (ret == null) {
                ret = new ArrayList<ILineEntry>(entries);
                continue;
            }
            ret.addAll(entries);
        }
        if (ret == null) {
            return Collections.emptyList();
        }
        return ret;
    }

    @Override
    public ILineEntry getLineEntryAtAddress(IAddress linkAddress) {
        if (this.fileProviderArray == null) {
            this.fileProviderArray = this.fileProviders.toArray(new FileLineEntryProvider[this.fileProviders.size()]);
        }
        FileLineEntryProvider[] fileLineEntryProviderArray = this.fileProviderArray;
        int n = this.fileProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILineEntry entry;
            FileLineEntryProvider provider = fileLineEntryProviderArray[n2];
            if (provider.getCU().getLowAddress().compareTo((Object)linkAddress) <= 0 && provider.getCU().getHighAddress().compareTo((Object)linkAddress) > 0 && (entry = provider.getLineEntryAtAddress(linkAddress)) != null && !entry.getLowAddress().equals((Object)entry.getHighAddress())) {
                return entry;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public ILineEntry getLineEntryInFunction(IAddress linkAddress, IFunctionScope parentFunction) {
        ILineEntry functionEntry = this.getLineEntryAtAddress(parentFunction.getLowAddress());
        if (functionEntry == null) {
            return null;
        }
        Collection<ILineEntryProvider> parentProviders = this.getLineEntryProvidersForFile(functionEntry.getFilePath());
        for (ILineEntryProvider iLineEntryProvider : parentProviders) {
            ILineEntry entry;
            if (!(iLineEntryProvider instanceof FileLineEntryProvider) || (entry = ((FileLineEntryProvider)iLineEntryProvider).getLineEntryInFunction(linkAddress, parentFunction)) == null) continue;
            return entry;
        }
        return null;
    }

    @Override
    public ILineEntry getNextLineEntry(ILineEntry entry, boolean collapseInlineFunctions) {
        FileLineEntryProvider[] matchArray;
        if (entry == null) {
            return null;
        }
        IAddress entryLowAddr = entry.getLowAddress();
        IAddress entryHighAddr = entry.getHighAddress();
        IPath entryPath = entry.getFilePath();
        FileLineEntryProviders matches = (FileLineEntryProviders)this.pathToLineEntryMap.get(entryPath);
        if (matches == null) {
            return null;
        }
        FileLineEntryProvider[] fileLineEntryProviderArray = matchArray = matches.toArray(new FileLineEntryProvider[matches.size()]);
        int n = matchArray.length;
        int n2 = 0;
        while (n2 < n) {
            FileLineEntryProvider provider = fileLineEntryProviderArray[n2];
            ICompileUnitScope cuScope = provider.getCU();
            if (cuScope.getLowAddress().compareTo((Object)entryLowAddr) <= 0 && cuScope.getHighAddress().compareTo((Object)entryHighAddr) >= 0) {
                return provider.getNextLineEntry(entry, collapseInlineFunctions);
            }
            ++n2;
        }
        return null;
    }

    @Override
    public ILineEntry getPreviousLineEntry(ILineEntry entry, boolean collapseInlineFunctions) {
        if (entry == null) {
            return null;
        }
        FileLineEntryProviders matches = (FileLineEntryProviders)this.pathToLineEntryMap.get(entry.getFilePath());
        if (matches != null) {
            FileLineEntryProvider[] matchArray;
            IAddress entryLowAddr = entry.getLowAddress();
            IAddress entryHighAddr = entry.getHighAddress();
            boolean entryIsInline = false;
            boolean inlineEstablished = false;
            FileLineEntryProvider[] fileLineEntryProviderArray = matchArray = matches.toArray(new FileLineEntryProvider[matches.size()]);
            int n = matchArray.length;
            int n2 = 0;
            while (n2 < n) {
                FileLineEntryProvider provider = fileLineEntryProviderArray[n2];
                ICompileUnitScope cuScope = provider.getCU();
                if (cuScope.getLowAddress().compareTo((Object)entryLowAddr) <= 0 && cuScope.getHighAddress().compareTo((Object)entryHighAddr) >= 0) {
                    ILineEntry prev;
                    if (!inlineEstablished) {
                        entryIsInline = FileLineEntryProvider.isInlinedFunction(cuScope.getFunctionAtAddress(entryLowAddr));
                        inlineEstablished = true;
                    }
                    if ((prev = provider.getPreviousLineEntry(entry, collapseInlineFunctions)) == null && collapseInlineFunctions && entryIsInline) {
                        return provider.getPreviousLineEntryInCU(entry);
                    }
                    if (prev != null) {
                        return prev;
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public List<ILineEntryProvider.ILineAddresses> findClosestLineWithCode(IPath sourceFile, int anchorLine, int neighbor_limit) {
        ArrayList<ILineEntryProvider.ILineAddresses> ret = new ArrayList<ILineEntryProvider.ILineAddresses>(1);
        Collection<ILineEntryProvider> fileProviders = this.getLineEntryProvidersForFile(sourceFile);
        if (fileProviders.isEmpty()) {
            return ret;
        }
        for (ILineEntryProvider fileProvider : fileProviders) {
            List<ILineEntryProvider.ILineAddresses> la = fileProvider.findClosestLineWithCode(sourceFile, anchorLine, neighbor_limit);
            if (la.isEmpty()) continue;
            assert (la.size() == 1);
            ILineEntryProvider.ILineAddresses newCodeLine = la.get(0);
            if (ret.isEmpty()) {
                ret.add(newCodeLine);
                continue;
            }
            boolean merged = false;
            for (ILineEntryProvider.ILineAddresses e : ret) {
                if (newCodeLine.getLineNumber() != e.getLineNumber()) continue;
                ((Modules.EDCLineAddresses)e).addAddress(newCodeLine.getAddress());
                merged = true;
                break;
            }
            if (merged) continue;
            ret.add(newCodeLine);
        }
        return ret;
    }

    @Override
    public boolean hasSourceFile(IPath sourceFile) {
        Collection<ILineEntryProvider> fileProviders = this.getLineEntryProvidersForFile(sourceFile);
        return fileProviders != null && !fileProviders.isEmpty();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class FileLineEntryProviders
    extends ArrayList<FileLineEntryProvider> {
        private static final long serialVersionUID = -2157263701372708990L;

        private FileLineEntryProviders() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class PathToLineEntryMap
    extends HashMap<IPath, FileLineEntryProviders> {
        private static final long serialVersionUID = 7064789571684986782L;

        private PathToLineEntryMap() {
        }
    }
}

