/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.lrparser.tests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.dom.ast.IASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.lrparser.gnu.GCCLanguage;
import org.eclipse.cdt.core.lrparser.tests.ParseHelper;
import org.eclipse.cdt.core.model.ILanguage;

public class LRCompletionParseTest
extends TestCase {
    private static final Comparator<IBinding> BINDING_COMPARATOR = new Comparator<IBinding>(){

        @Override
        public int compare(IBinding b1, IBinding b2) {
            return b1.getName().compareTo(b2.getName());
        }
    };

    public static TestSuite suite() {
        return new TestSuite(LRCompletionParseTest.class);
    }

    public LRCompletionParseTest() {
    }

    public LRCompletionParseTest(String name) {
        super(name);
    }

    protected IASTCompletionNode parse(String code, int offset) throws Exception {
        return ParseHelper.getCompletionNode(code, this.getCLanguage(), offset);
    }

    public static IBinding[] getBindings(IASTName[] names) {
        ArrayList<IBinding> bindings = new ArrayList<IBinding>();
        IASTName[] iASTNameArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            IASTName name = iASTNameArray[n2];
            if (name.getTranslationUnit() != null) {
                IBinding[] iBindingArray = name.getCompletionContext().findBindings(name, true);
                int n3 = iBindingArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IBinding binding = iBindingArray[n4];
                    bindings.add(binding);
                    ++n4;
                }
            }
            ++n2;
        }
        Collections.sort(bindings, BINDING_COMPARATOR);
        return bindings.toArray(new IBinding[bindings.size()]);
    }

    protected ILanguage getCLanguage() {
        return GCCLanguage.getDefault();
    }

    public void testCompletionStructField() throws Exception {
        String code = "int aVar; struct D{    int aField1;    int aField2; }; void foo(){   struct D d;    d.a }\n";
        int index = code.indexOf("d.a");
        IASTCompletionNode node = this.parse(code, index + 3);
        LRCompletionParseTest.assertNotNull((Object)node);
        String prefix = node.getPrefix();
        LRCompletionParseTest.assertNotNull((Object)prefix);
        LRCompletionParseTest.assertEquals((String)prefix, (String)"a");
        IASTName[] names = node.getNames();
        LRCompletionParseTest.assertEquals((int)1, (int)names.length);
        IBinding[] bindings = LRCompletionParseTest.getBindings(names);
        LRCompletionParseTest.assertEquals((int)2, (int)bindings.length);
        LRCompletionParseTest.assertEquals((String)"aField1", (String)((IField)bindings[0]).getName());
        LRCompletionParseTest.assertEquals((String)"aField2", (String)((IField)bindings[1]).getName());
    }

    public void testCompletionStructFieldPointer() throws Exception {
        String code = "struct Cube {                          int nLen;                           int nWidth;                         int nHeight;                     };                                  int volume( struct Cube * pCube ) {    pCube->SP                        ";
        IASTCompletionNode node = this.parse(code, code.indexOf("SP"));
        IASTName[] names = node.getNames();
        LRCompletionParseTest.assertEquals((int)1, (int)names.length);
        IBinding[] bindings = LRCompletionParseTest.getBindings(names);
        LRCompletionParseTest.assertEquals((int)3, (int)bindings.length);
        LRCompletionParseTest.assertEquals((String)"nHeight", (String)((IField)bindings[0]).getName());
        LRCompletionParseTest.assertEquals((String)"nLen", (String)((IField)bindings[1]).getName());
        LRCompletionParseTest.assertEquals((String)"nWidth", (String)((IField)bindings[2]).getName());
    }

    public void testCompletionParametersAsLocalVariables() throws Exception {
        String code = "int foo( int aParameter ){   int aLocal;   if( aLocal != 0 ){      int aBlockLocal;      a \n";
        int index = code.indexOf(" a ");
        IASTCompletionNode node = this.parse(code, index + 2);
        LRCompletionParseTest.assertNotNull((Object)node);
        LRCompletionParseTest.assertEquals((String)"a", (String)node.getPrefix());
        IASTName[] names = node.getNames();
        LRCompletionParseTest.assertEquals((int)2, (int)names.length);
        IBinding[] bindings = LRCompletionParseTest.getBindings(names);
        LRCompletionParseTest.assertEquals((int)3, (int)bindings.length);
        LRCompletionParseTest.assertEquals((String)"aBlockLocal", (String)((IVariable)bindings[0]).getName());
        LRCompletionParseTest.assertEquals((String)"aLocal", (String)((IVariable)bindings[1]).getName());
        LRCompletionParseTest.assertEquals((String)"aParameter", (String)((IVariable)bindings[2]).getName());
    }

    public void testCompletionTypedef() throws Exception {
        String code = "typedef int Int; InSP";
        int index = code.indexOf("SP");
        IASTCompletionNode node = this.parse(code, index);
        LRCompletionParseTest.assertNotNull((Object)node);
        IASTName[] names = node.getNames();
        LRCompletionParseTest.assertEquals((int)1, (int)names.length);
        LRCompletionParseTest.assertEquals((String)"In", (String)node.getPrefix());
        IBinding[] bindings = LRCompletionParseTest.getBindings(names);
        LRCompletionParseTest.assertEquals((int)1, (int)bindings.length);
        LRCompletionParseTest.assertEquals((String)"Int", (String)((ITypedef)bindings[0]).getName());
    }

    public void testCompletion() throws Exception {
        String code = "#define GL_T 0x2001\n#define GL_TRUE 0x1\ntypedef unsigned char   GLboolean;\nstatic GLboolean should_rotate = GL_T";
        int index = code.indexOf("= GL_T");
        IASTCompletionNode node = this.parse(code, index + 6);
        LRCompletionParseTest.assertNotNull((Object)node);
        LRCompletionParseTest.assertEquals((String)"GL_T", (String)node.getPrefix());
        IASTName[] names = node.getNames();
        LRCompletionParseTest.assertEquals((int)1, (int)names.length);
    }

    public void testCompletionInTypeDef() throws Exception {
        String code = "struct A {  int name;  };  \ntypedef struct A * PA;     \nint main() {               \n   PA a;                   \n   a->SP                   \n}                          \n";
        int index = code.indexOf("SP");
        IASTCompletionNode node = this.parse(code, index);
        LRCompletionParseTest.assertNotNull((Object)node);
        IASTName[] names = node.getNames();
        LRCompletionParseTest.assertEquals((int)1, (int)names.length);
        IBinding[] bindings = LRCompletionParseTest.getBindings(names);
        LRCompletionParseTest.assertEquals((int)1, (int)bindings.length);
        LRCompletionParseTest.assertEquals((String)"name", (String)((IField)bindings[0]).getName());
    }

    public void _testCompletionFunctionCall() throws Exception {
        String code = "struct A {  \t      \n   int f2;  \t\t  \n   int f4;           \n};                   \nconst A * foo(){}    \nvoid main( )         \n{                    \n   foo()->SP         \n";
        int index = code.indexOf("SP");
        IASTCompletionNode node = this.parse(code, index);
        LRCompletionParseTest.assertNotNull((Object)node);
        IASTName[] names = node.getNames();
        LRCompletionParseTest.assertEquals((int)1, (int)names.length);
        IBinding[] bindings = LRCompletionParseTest.getBindings(names);
        LRCompletionParseTest.assertEquals((int)2, (int)bindings.length);
        LRCompletionParseTest.assertEquals((String)"f2", (String)((IField)bindings[0]).getName());
        LRCompletionParseTest.assertEquals((String)"f4", (String)((IField)bindings[1]).getName());
    }

    public void _testCompletionSizeof() throws Exception {
        String code = "int f() {\nshort blah;\nint x = sizeof(bl";
        int index = code.indexOf("of(bl");
        IASTCompletionNode node = this.parse(code, index + 5);
        LRCompletionParseTest.assertNotNull((Object)node);
        IASTName[] names = node.getNames();
        LRCompletionParseTest.assertEquals((int)1, (int)names.length);
        IBinding[] bindings = LRCompletionParseTest.getBindings(names);
        LRCompletionParseTest.assertEquals((int)1, (int)bindings.length);
        LRCompletionParseTest.assertEquals((String)"blah", (String)((IVariable)bindings[0]).getName());
    }

    public void testCompletionForLoop() throws Exception {
        String code = "int f() {\n int biSizeImage = 5;\nfor (int i = 0; i < bi ";
        int index = code.indexOf("< bi");
        IASTCompletionNode node = this.parse(code, index + 4);
        LRCompletionParseTest.assertNotNull((Object)node);
        IASTName[] names = node.getNames();
        LRCompletionParseTest.assertEquals((int)1, (int)names.length);
        IBinding[] bindings = LRCompletionParseTest.getBindings(names);
        LRCompletionParseTest.assertEquals((int)1, (int)bindings.length);
        LRCompletionParseTest.assertEquals((String)"biSizeImage", (String)((IVariable)bindings[0]).getName());
    }

    public void testCompletionStructPointer() throws Exception {
        String code = " struct Temp { char * total; }; int f(struct Temp * t) { t->t[5] = t->";
        int index = code.indexOf("= t->");
        IASTCompletionNode node = this.parse(code, index + 5);
        LRCompletionParseTest.assertNotNull((Object)node);
        IASTName[] names = node.getNames();
        LRCompletionParseTest.assertEquals((int)1, (int)names.length);
        IBinding[] bindings = LRCompletionParseTest.getBindings(names);
        LRCompletionParseTest.assertEquals((int)1, (int)bindings.length);
        LRCompletionParseTest.assertEquals((String)"total", (String)((IVariable)bindings[0]).getName());
    }

    public void testCompletionEnum() throws Exception {
        String code = "typedef int DWORD;\ntypedef char BYTE;\n#define MAKEFOURCC(ch0, ch1, ch2, ch3)                  \\\n((DWORD)(BYTE)(ch0) | ((DWORD)(BYTE)(ch1) << 8) |       \\\n((DWORD)(BYTE)(ch2) << 16) | ((DWORD)(BYTE)(ch3) << 24 ))\nenum e {\nblah1 = 5,\nblah2 = MAKEFOURCC('a', 'b', 'c', 'd'),\nblah3\n};\ne mye = bl\n";
        int index = code.indexOf("= bl");
        IASTCompletionNode node = this.parse(code, index + 4);
        LRCompletionParseTest.assertNotNull((Object)node);
        IASTName[] names = node.getNames();
        LRCompletionParseTest.assertEquals((int)1, (int)names.length);
        IBinding[] bindings = LRCompletionParseTest.getBindings(names);
        LRCompletionParseTest.assertEquals((int)3, (int)bindings.length);
        LRCompletionParseTest.assertEquals((String)"blah1", (String)((IEnumerator)bindings[0]).getName());
        LRCompletionParseTest.assertEquals((String)"blah2", (String)((IEnumerator)bindings[1]).getName());
        LRCompletionParseTest.assertEquals((String)"blah3", (String)((IEnumerator)bindings[2]).getName());
    }

    public void testCompletionStructArray() throws Exception {
        String code = "struct packet { int a; int b; };\nstruct packet buffer[5];\nint main(int argc, char **argv) {\n buffer[2].";
        int index = code.indexOf("[2].");
        IASTCompletionNode node = this.parse(code, index + 4);
        LRCompletionParseTest.assertNotNull((Object)node);
        IASTName[] names = node.getNames();
        LRCompletionParseTest.assertEquals((int)1, (int)names.length);
        IBinding[] bindings = LRCompletionParseTest.getBindings(names);
        LRCompletionParseTest.assertEquals((int)2, (int)bindings.length);
        LRCompletionParseTest.assertEquals((String)"a", (String)((IField)bindings[0]).getName());
        LRCompletionParseTest.assertEquals((String)"b", (String)((IField)bindings[1]).getName());
    }

    public void testCompletionPreprocessorDirective() throws Exception {
        IASTCompletionNode node = this.parse("#", 1);
        LRCompletionParseTest.assertNotNull((Object)node);
        IASTName[] names = node.getNames();
        LRCompletionParseTest.assertEquals((int)1, (int)names.length);
    }

    public void testCompletionPreprocessorMacro() throws Exception {
        String code = "#define AMACRO 99 \nint main() { \n\tint AVAR; \n\tint x = A \n";
        int index = code.indexOf("= A");
        IASTCompletionNode node = this.parse(code, index + 3);
        LRCompletionParseTest.assertNotNull((Object)node);
        IASTName[] names = node.getNames();
        LRCompletionParseTest.assertEquals((int)1, (int)names.length);
        LRCompletionParseTest.assertEquals((String)"A", (String)node.getPrefix());
    }

    public void testCompletionInsidePreprocessorDirective() throws Exception {
        String code = "#define MAC1 99 \n#define MAC2 99 \n#ifdef MA";
        int index = code.length();
        IASTCompletionNode node = this.parse(code, index);
        LRCompletionParseTest.assertNotNull((Object)node);
        LRCompletionParseTest.assertEquals((String)"MA", (String)node.getPrefix());
    }
}

