/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.callhierarchy;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IEnumeration;
import org.eclipse.cdt.core.model.IEnumerator;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.IVariableDeclaration;
import org.eclipse.cdt.internal.ui.callhierarchy.CHMessages;
import org.eclipse.cdt.internal.ui.callhierarchy.CallHierarchyUI;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.actions.SelectionDispatchAction;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.texteditor.ITextEditor;

public class OpenCallHierarchyAction
extends SelectionDispatchAction {
    private ITextEditor fEditor;

    public OpenCallHierarchyAction(IWorkbenchSite site) {
        super(site);
        this.setText(CHMessages.OpenCallHierarchyAction_label);
        this.setToolTipText(CHMessages.OpenCallHierarchyAction_tooltip);
    }

    public OpenCallHierarchyAction(ITextEditor editor) {
        this((IWorkbenchSite)editor.getSite());
        this.fEditor = editor;
        this.setEnabled(this.fEditor != null && CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editor.getEditorInput()) != null);
    }

    public void run(ITextSelection sel) {
        CallHierarchyUI.open(this.fEditor, sel);
    }

    public void run(IStructuredSelection selection) {
        Object selectedObject;
        ICElement elem;
        if (!selection.isEmpty() && (elem = (ICElement)this.getAdapter(selectedObject = selection.getFirstElement(), ICElement.class)) != null) {
            CallHierarchyUI.open(this.getSite().getWorkbenchWindow(), elem);
        }
    }

    public void selectionChanged(ITextSelection sel) {
    }

    public void selectionChanged(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            this.setEnabled(false);
            return;
        }
        Object selectedObject = selection.getFirstElement();
        ICElement elem = (ICElement)this.getAdapter(selectedObject, ICElement.class);
        if (elem != null) {
            this.setEnabled(this.isValidElement(elem));
        } else {
            this.setEnabled(false);
        }
    }

    private boolean isValidElement(ICElement elem) {
        if (elem instanceof IFunctionDeclaration) {
            return true;
        }
        if (elem instanceof IVariableDeclaration) {
            return !(elem instanceof IEnumeration);
        }
        return elem instanceof IEnumerator;
    }

    private Object getAdapter(Object object, Class desiredClass) {
        if (desiredClass.isInstance(object)) {
            return object;
        }
        if (object instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)object;
            return adaptable.getAdapter(desiredClass);
        }
        return null;
    }
}

