/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.gettersandsetters;

import java.util.ArrayList;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.internal.ui.refactoring.gettersandsetters.GetterSetterInsertEditProvider;
import org.eclipse.cdt.internal.ui.refactoring.gettersandsetters.GetterSetterNameGenerator;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetterSetterContext
implements ITreeContentProvider {
    public ArrayList<IASTSimpleDeclaration> existingFields = new ArrayList();
    public ArrayList<IASTFunctionDefinition> existingFunctionDefinitions = new ArrayList();
    public ArrayList<IASTSimpleDeclaration> existingFunctionDeclarations = new ArrayList();
    public SortedSet<GetterSetterInsertEditProvider> selectedFunctions = new TreeSet<GetterSetterInsertEditProvider>();
    public IASTName selectedName;
    private ArrayList<FieldWrapper> wrappedFields;
    private boolean implementationInHeader = false;

    public Object[] getChildren(Object parentElement) {
        ArrayList<Object> children = new ArrayList();
        if (parentElement instanceof FieldWrapper) {
            FieldWrapper wrapper = (FieldWrapper)parentElement;
            if (wrapper.getChildNodes().isEmpty()) {
                if (!wrapper.getter.exists()) {
                    wrapper.childNodes.add(this.createGetterInserter(wrapper.field));
                }
                if (!wrapper.setter.exists() && !wrapper.field.getDeclSpecifier().isConst()) {
                    wrapper.childNodes.add(this.createSetterInserter(wrapper.field));
                }
            }
            children = wrapper.getChildNodes();
        }
        return children.toArray();
    }

    public GetterSetterInsertEditProvider createGetterInserter(IASTSimpleDeclaration simpleDeclaration) {
        IASTName fieldName = this.getFieldDeclarationName(simpleDeclaration);
        return new GetterSetterInsertEditProvider(fieldName, simpleDeclaration, GetterSetterInsertEditProvider.AccessorKind.GETTER);
    }

    public GetterSetterInsertEditProvider createSetterInserter(IASTSimpleDeclaration simpleDeclaration) {
        IASTName fieldName = this.getFieldDeclarationName(simpleDeclaration);
        return new GetterSetterInsertEditProvider(fieldName, simpleDeclaration, GetterSetterInsertEditProvider.AccessorKind.SETTER);
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof FieldWrapper) {
            FieldWrapper wrapper = (FieldWrapper)element;
            return wrapper.missingGetterOrSetter();
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return this.getWrappedFields().toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public boolean isImplementationInHeader() {
        return this.implementationInHeader;
    }

    public void setImplementationInHeader(boolean implementationInHeader) {
        this.implementationInHeader = implementationInHeader;
    }

    private ArrayList<FieldWrapper> getWrappedFields() {
        if (this.wrappedFields == null) {
            this.wrappedFields = new ArrayList();
            for (IASTSimpleDeclaration currentField : this.existingFields) {
                FieldWrapper wrapper = new FieldWrapper();
                wrapper.field = currentField;
                wrapper.getter = this.getGetterForField(currentField);
                wrapper.setter = this.getSetterForField(currentField);
                if (!wrapper.missingGetterOrSetter()) continue;
                this.wrappedFields.add(wrapper);
            }
        }
        return this.wrappedFields;
    }

    private FunctionWrapper getGetterForField(IASTSimpleDeclaration currentField) {
        FunctionWrapper wrapper = new FunctionWrapper();
        String name = GetterSetterNameGenerator.generateGetterName(this.getFieldDeclarationName(currentField));
        this.setFunctionToWrapper(wrapper, name);
        return wrapper;
    }

    private IASTName getFieldDeclarationName(IASTSimpleDeclaration fieldDeclaration) {
        IASTDeclarator declarator = fieldDeclaration.getDeclarators()[0];
        while (declarator.getNestedDeclarator() != null) {
            declarator = declarator.getNestedDeclarator();
        }
        return declarator.getName();
    }

    private FunctionWrapper getSetterForField(IASTSimpleDeclaration currentField) {
        FunctionWrapper wrapper = new FunctionWrapper();
        String name = GetterSetterNameGenerator.generateSetterName(this.getFieldDeclarationName(currentField));
        this.setFunctionToWrapper(wrapper, name);
        return wrapper;
    }

    private void setFunctionToWrapper(FunctionWrapper wrapper, String getterName) {
        for (IASTFunctionDefinition currentDefinition : this.existingFunctionDefinitions) {
            if (!currentDefinition.getDeclarator().getName().toString().endsWith(getterName)) continue;
            wrapper.functionDefinition = currentDefinition;
        }
        for (IASTSimpleDeclaration currentDeclaration : this.existingFunctionDeclarations) {
            if (!this.getFieldDeclarationName(currentDeclaration).toString().endsWith(getterName)) continue;
            wrapper.functionDeclaration = currentDeclaration;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class FieldWrapper {
        protected IASTSimpleDeclaration field;
        protected FunctionWrapper getter;
        protected FunctionWrapper setter;
        protected ArrayList<GetterSetterInsertEditProvider> childNodes = new ArrayList(2);

        protected FieldWrapper() {
        }

        public String toString() {
            IASTDeclarator declarator = this.field.getDeclarators()[0];
            while (declarator.getNestedDeclarator() != null) {
                declarator = declarator.getNestedDeclarator();
            }
            return declarator.getName().toString();
        }

        public ArrayList<GetterSetterInsertEditProvider> getChildNodes() {
            return this.childNodes;
        }

        public boolean missingGetterOrSetter() {
            return !this.getter.exists() || !this.setter.exists();
        }
    }

    protected class FunctionWrapper {
        protected IASTSimpleDeclaration functionDeclaration;
        protected IASTFunctionDefinition functionDefinition;

        protected FunctionWrapper() {
        }

        public boolean exists() {
            return this.functionDeclaration != null || this.functionDefinition != null;
        }
    }
}

