/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.model;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.provisional.AbstractModelProxy;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModel;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNode;
import org.eclipse.tm.tcf.protocol.Protocol;

public class TCFModelProxy
extends AbstractModelProxy
implements IModelProxy,
Runnable {
    private static final long MIN_IDLE_TIME = 50L;
    private static final TCFNode[] EMPTY_NODE_ARRAY = new TCFNode[0];
    private final TCFModel model;
    private final Map<TCFNode, Integer> node2flags = new HashMap<TCFNode, Integer>();
    private final Map<TCFNode, TCFNode[]> node2children = new HashMap<TCFNode, TCFNode[]>();
    private final Map<TCFNode, ModelDelta> node2delta = new HashMap<TCFNode, ModelDelta>();
    private final LinkedList<TCFNode> selection = new LinkedList();
    private boolean posted;
    private boolean installed;
    private boolean disposed;
    private long last_update_time;
    private final Runnable timer = new Runnable(){

        public void run() {
            TCFModelProxy.this.posted = false;
            long idle_time = System.currentTimeMillis() - TCFModelProxy.this.last_update_time;
            long min_idle_time = 50L;
            int congestion = Protocol.getCongestionLevel() + 50;
            if (congestion > 0) {
                min_idle_time += (long)(congestion * 10);
            }
            if (idle_time < min_idle_time - 10L) {
                Protocol.invokeLater((long)(min_idle_time - idle_time), (Runnable)this);
                TCFModelProxy.this.posted = true;
            } else {
                TCFModelProxy.this.run();
            }
        }
    };
    private final ChildrenCountUpdate children_count_update = new ChildrenCountUpdate();
    private final ChildrenUpdate children_update = new ChildrenUpdate();
    private TCFNode pending_node;

    TCFModelProxy(TCFModel model) {
        this.model = model;
    }

    public void installed(Viewer viewer) {
        super.installed(viewer);
        Protocol.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                if (!$assertionsDisabled && TCFModelProxy.this.installed) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && TCFModelProxy.this.disposed) {
                    throw new AssertionError();
                }
                TCFModelProxy.this.model.onProxyInstalled(TCFModelProxy.this);
                TCFModelProxy.this.installed = true;
            }
        });
    }

    public void dispose() {
        Protocol.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                if (!$assertionsDisabled && TCFModelProxy.this.disposed) {
                    throw new AssertionError();
                }
                if (TCFModelProxy.this.installed) {
                    TCFModelProxy.this.model.onProxyDisposed(TCFModelProxy.this);
                }
                TCFModelProxy.this.disposed = true;
            }
        });
        super.dispose();
    }

    void addDelta(TCFNode node, int flags) {
        assert (Protocol.isDispatchThread());
        assert (this.installed && !this.disposed);
        if (flags == 0) {
            return;
        }
        Integer delta = this.node2flags.get(node);
        if (delta != null) {
            this.node2flags.put(node, delta | flags);
        } else {
            this.node2flags.put(node, flags);
        }
        this.post();
    }

    void expand(TCFNode node) {
        Object input = this.getInput();
        IPresentationContext ctx = this.getPresentationContext();
        while (node != null && node != input) {
            this.addDelta(node, 0x100000);
            node = node.getParent(ctx);
        }
        this.post();
    }

    void setSelection(TCFNode node) {
        this.selection.add(node);
        this.expand(node.getParent(this.getPresentationContext()));
    }

    Object getInput() {
        return this.getViewer().getInput();
    }

    public void post() {
        assert (Protocol.isDispatchThread());
        assert (this.installed && !this.disposed);
        if (!this.posted) {
            long idle_time = System.currentTimeMillis() - this.last_update_time;
            Protocol.invokeLater((long)(50L - idle_time), (Runnable)this.timer);
            this.posted = true;
        }
    }

    private TCFNode[] getNodeChildren(TCFNode node) {
        TCFNode[] res = this.node2children.get(node);
        if (res == null) {
            if (node.isDisposed()) {
                res = EMPTY_NODE_ARRAY;
            } else if (!node.getData(this.children_count_update, null)) {
                this.pending_node = node;
                res = EMPTY_NODE_ARRAY;
            } else {
                this.children_update.setLength(this.children_count_update.count);
                if (!node.getData(this.children_update, null)) {
                    assert (false);
                    this.pending_node = node;
                    res = EMPTY_NODE_ARRAY;
                } else {
                    res = this.children_update.children;
                }
            }
            this.node2children.put(node, res);
        }
        return res;
    }

    private int getNodeIndex(TCFNode node) {
        TCFNode p = node.getParent(this.getPresentationContext());
        if (p == null) {
            return -1;
        }
        TCFNode[] arr = this.getNodeChildren(p);
        int i = 0;
        while (i < arr.length) {
            if (arr[i] == node) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private ModelDelta makeDelta(ModelDelta root, TCFNode node, TCFNode selection) {
        int flags;
        ModelDelta delta = this.node2delta.get(node);
        if (delta == null) {
            if (node == root.getElement()) {
                delta = root;
            } else {
                flags = 0;
                Integer flags_obj = this.node2flags.get(node);
                if (flags_obj != null) {
                    flags = flags_obj;
                }
                if (node.parent == null) {
                    if (root.getElement() instanceof TCFNode) {
                        return null;
                    }
                    int children = -1;
                    if (selection != null && selection != node || (flags & 0x100000) != 0) {
                        children = this.getNodeChildren(node).length;
                    }
                    delta = root.addNode((Object)this.model.getLaunch(), -1, flags, children);
                } else {
                    TCFNode parent = node.getParent(this.getPresentationContext());
                    if (parent == null) {
                        return null;
                    }
                    ModelDelta up = this.makeDelta(root, parent, selection);
                    if (up == null) {
                        return null;
                    }
                    int index = -1;
                    int children = -1;
                    if (selection != null || (flags & 0x10) != 0 || (flags & 0x100000) != 0) {
                        index = this.getNodeIndex(node);
                    }
                    if (selection != null && selection != node || (flags & 0x100000) != 0) {
                        children = this.getNodeChildren(node).length;
                    }
                    delta = up.addNode((Object)node, index, flags, children);
                }
                this.node2delta.put(node, delta);
            }
        }
        if (((flags = delta.getFlags()) & 2) != 0) {
            return null;
        }
        if ((flags & 0x400) != 0 && (flags & 0x100000) == 0) {
            return null;
        }
        return delta;
    }

    private void postDelta(final ModelDelta root) {
        assert (this.pending_node == null);
        this.model.getDisplay().asyncExec(new Runnable(){

            public void run() {
                TCFModelProxy.this.fireModelChanged((IModelDelta)root);
            }
        });
    }

    public void run() {
        TCFNode node;
        Integer i;
        assert (Protocol.isDispatchThread());
        if (this.disposed) {
            return;
        }
        if (this.node2flags.isEmpty() && this.selection.isEmpty()) {
            return;
        }
        Object input = this.getInput();
        int flags = 0;
        if (input instanceof TCFNode && (i = this.node2flags.get(node = (TCFNode)input)) != null && ((flags = i.intValue()) & 0x800) != 0) {
            if ((flags &= 0xFFFFF7FF) == 0) {
                this.node2flags.remove(node);
                if (this.node2flags.isEmpty() && this.selection.isEmpty()) {
                    return;
                }
            } else {
                this.node2flags.put(node, flags);
            }
        }
        this.pending_node = null;
        this.node2children.clear();
        this.node2delta.clear();
        ModelDelta root = new ModelDelta(input, flags);
        for (TCFNode node2 : this.node2flags.keySet()) {
            this.makeDelta(root, node2, null);
        }
        if (this.pending_node == null) {
            this.node2flags.clear();
            if ((root.getFlags() != 0 || this.node2delta.size() > 0) && (root.getFlags() & 2) == 0) {
                this.postDelta(root);
            }
            this.node2delta.clear();
            this.last_update_time = System.currentTimeMillis();
            while (!this.selection.isEmpty()) {
                TCFNode node2;
                node2 = this.selection.getFirst();
                this.node2flags.put(node2, 0x200800);
                root = new ModelDelta(input, 0);
                this.makeDelta(root, node2, node2);
                this.node2delta.clear();
                this.node2flags.clear();
                if (this.pending_node != null) break;
                this.postDelta(root);
                this.selection.remove(node2);
            }
        }
        if (this.pending_node != null && this.pending_node.getData(this.children_count_update, (Runnable)this)) {
            assert (false);
            Protocol.invokeLater((Runnable)this);
        }
        this.node2children.clear();
    }

    private class ChildrenCountUpdate
    extends ViewerUpdate
    implements IChildrenCountUpdate {
        int count;

        private ChildrenCountUpdate() {
        }

        public void setChildCount(int count) {
            this.count = count;
        }
    }

    private class ChildrenUpdate
    extends ViewerUpdate
    implements IChildrenUpdate {
        int length;
        TCFNode[] children;

        private ChildrenUpdate() {
        }

        void setLength(int length) {
            this.length = length;
            this.children = length == 0 ? EMPTY_NODE_ARRAY : new TCFNode[length];
        }

        public int getLength() {
            return this.length;
        }

        public int getOffset() {
            return 0;
        }

        public void setChild(Object child, int offset) {
            this.children[offset] = (TCFNode)child;
        }
    }

    private class ViewerUpdate
    implements IViewerUpdate {
        IStatus status;

        private ViewerUpdate() {
        }

        public Object getElement() {
            return null;
        }

        public TreePath getElementPath() {
            return null;
        }

        public IPresentationContext getPresentationContext() {
            return TCFModelProxy.this.getPresentationContext();
        }

        public Object getViewerInput() {
            return TCFModelProxy.this.getInput();
        }

        public void cancel() {
        }

        public void done() {
        }

        public IStatus getStatus() {
            return this.status;
        }

        public boolean isCanceled() {
            return false;
        }

        public void setStatus(IStatus status) {
            this.status = status;
        }
    }
}

