/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.settings.model.ICConfigExtensionReference;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.TraceUtil;
import org.eclipse.cdt.utils.CygPath;
import org.eclipse.cdt.utils.ICygwinToolsFactroy;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CygpathTranslator {
    private static final String DEFAULT_CYGWIN_ROOT = "C:\\cygwin";
    private CygPath cygPath = null;
    private boolean isAvailable = false;

    public CygpathTranslator(IProject project) {
        try {
            ICConfigExtensionReference[] parserRef = CCorePlugin.getDefault().getDefaultBinaryParserExtensions(project);
            int i = 0;
            while (i < parserRef.length) {
                try {
                    IBinaryParser parser = CoreModelUtil.getBinaryParser((ICConfigExtensionReference)parserRef[i]);
                    ICygwinToolsFactroy cygwinToolFactory = (ICygwinToolsFactroy)parser.getAdapter(ICygwinToolsFactroy.class);
                    if (cygwinToolFactory != null) {
                        this.cygPath = cygwinToolFactory.getCygPath();
                        if (this.cygPath != null) {
                            this.isAvailable = true;
                            break;
                        }
                    }
                }
                catch (ClassCastException classCastException) {}
                ++i;
            }
            if (this.cygPath == null && Platform.getOS().equals("win32")) {
                this.cygPath = new File(DEFAULT_CYGWIN_ROOT).exists() ? new CygPath("C:\\cygwin\\bin\\cygpath.exe") : new CygPath("cygpath");
                this.isAvailable = this.cygPath.getFileName("test").equals("test");
            }
        }
        catch (CoreException coreException) {
        }
        catch (IOException iOException) {
            this.isAvailable = false;
        }
    }

    public static List<String> translateIncludePaths(IProject project, List<String> sumIncludes) {
        boolean translationNeeded = false;
        if (Platform.getOS().equals("win32")) {
            for (String include : sumIncludes) {
                if (!include.startsWith("/")) continue;
                translationNeeded = true;
                break;
            }
        }
        if (!translationNeeded) {
            return sumIncludes;
        }
        CygpathTranslator cygpath = new CygpathTranslator(project);
        ArrayList<String> translatedIncludePaths = new ArrayList<String>();
        for (String includePath : sumIncludes) {
            String drive;
            Path realPath = new Path(includePath);
            if (realPath.getDevice() != null && realPath.toFile().exists()) {
                translatedIncludePaths.add(includePath);
                continue;
            }
            String translatedPath = includePath;
            if (cygpath.isAvailable) {
                try {
                    translatedPath = cygpath.cygPath.getFileName(includePath);
                }
                catch (IOException iOException) {
                    TraceUtil.outputError("CygpathTranslator unable to translate path: ", includePath);
                }
            } else if (realPath.segmentCount() >= 2 && "cygdrive".equals(realPath.segment(0)) && (drive = realPath.segment(1)).length() == 1) {
                translatedPath = realPath.removeFirstSegments(2).makeAbsolute().setDevice(String.valueOf(drive.toUpperCase()) + ':').toOSString();
            }
            if (!translatedPath.equals(includePath)) {
                if (new File(translatedPath).exists()) {
                    translatedIncludePaths.add(translatedPath);
                    continue;
                }
                if (cygpath.isAvailable) {
                    translatedIncludePaths.add(translatedPath);
                    continue;
                }
                translatedIncludePaths.add(includePath);
                continue;
            }
            translatedIncludePaths.add(translatedPath);
        }
        if (cygpath.cygPath != null) {
            cygpath.cygPath.dispose();
        }
        return translatedIncludePaths;
    }
}

