/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.indexer;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.model.AbstractLanguage;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.parser.FileContent;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.internal.core.index.IndexFileLocation;
import org.eclipse.cdt.internal.core.indexer.FileEncodingRegistry;
import org.eclipse.cdt.internal.core.indexer.StandaloneIndexer;
import org.eclipse.cdt.internal.core.parser.InternalParserUtil;
import org.eclipse.cdt.internal.core.pdom.IndexerInputAdapter;
import org.eclipse.cdt.internal.core.pdom.indexer.FileExistsCache;
import org.eclipse.cdt.utils.UNCPathConverter;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.Path;

public class StandaloneIndexerInputAdapter
extends IndexerInputAdapter {
    private final HashMap<String, IIndexFileLocation> fIflCache = new HashMap();
    private final FileExistsCache fExistsCache;
    private final StandaloneIndexer fIndexer;

    public StandaloneIndexerInputAdapter(StandaloneIndexer indexer) {
        this.fIndexer = indexer;
        this.fExistsCache = new FileExistsCache(this.isCaseInsensitiveFileSystem());
    }

    public IScannerInfo getBuildConfiguration(int linkageID, Object tu) {
        return this.fIndexer.getScannerInfo(tu.toString());
    }

    public long getLastModified(IIndexFileLocation location) {
        return new File(URIUtil.toPath((URI)location.getURI()).toOSString()).lastModified();
    }

    public String getEncoding(IIndexFileLocation ifl) {
        String encoding = this.getFileEncoding(this.getASTPath(ifl));
        if (encoding == null) {
            return InternalParserUtil.SYSTEM_DEFAULT_ENCODING;
        }
        return encoding;
    }

    public boolean isSourceUnit(Object tu) {
        return this.isValidSourceUnitName(tu.toString());
    }

    public boolean isIndexedOnlyIfIncluded(Object tu) {
        return false;
    }

    public boolean isSource(String filename) {
        return this.isValidSourceUnitName(filename);
    }

    public long getFileSize(String astFilePath) {
        return new File(astFilePath).length();
    }

    public IIndexFileLocation resolveFile(Object tu) {
        return this.resolveASTPath(tu.toString());
    }

    public String getASTPath(IIndexFileLocation ifl) {
        return URIUtil.toPath((URI)ifl.getURI()).toOSString();
    }

    public IIndexFileLocation resolveASTPath(String astPath) {
        IIndexFileLocation result = this.fIflCache.get(astPath);
        if (result == null) {
            try {
                astPath = new File(astPath).getCanonicalPath();
            }
            catch (IOException iOException) {}
            result = new IndexFileLocation(UNCPathConverter.getInstance().toURI(astPath), null);
            this.fIflCache.put(astPath, result);
        }
        return result;
    }

    public boolean doesIncludeFileExist(String includePath) {
        return this.fExistsCache.isFile(includePath);
    }

    public IIndexFileLocation resolveIncludeFile(String includePath) {
        if (!this.fExistsCache.isFile(includePath)) {
            return null;
        }
        IIndexFileLocation result = this.fIflCache.get(includePath);
        if (result == null) {
            File file = new File(includePath);
            try {
                includePath = file.getCanonicalPath();
            }
            catch (IOException iOException) {}
            result = new IndexFileLocation(UNCPathConverter.getInstance().toURI(includePath), null);
            this.fIflCache.put(includePath, result);
        }
        return result;
    }

    public boolean isFileBuildConfigured(Object tu) {
        return this.isValidSourceUnitName(tu.toString());
    }

    public boolean canBePartOfSDK(IIndexFileLocation ifl) {
        return false;
    }

    public FileContent getCodeReader(Object tu) {
        String stu = tu.toString();
        String fileEncoding = this.getFileEncoding(stu);
        return FileContent.createForExternalFileLocation(stu, fileEncoding);
    }

    public String getFileEncoding(String stu) {
        String fileEncoding = null;
        FileEncodingRegistry fileEncodingRegistry = this.fIndexer.getFileEncodingRegistry();
        if (fileEncodingRegistry != null) {
            fileEncoding = fileEncodingRegistry.getFileEncoding(stu);
        }
        if (fileEncoding == null) {
            return InternalParserUtil.SYSTEM_DEFAULT_ENCODING;
        }
        return fileEncoding;
    }

    public Object getInputFile(IIndexFileLocation location) {
        return URIUtil.toPath((URI)location.getURI());
    }

    public AbstractLanguage[] getLanguages(Object tu, boolean bothForHeaders) {
        ILanguage language = this.fIndexer.getLanguageMapper().getLanguage(tu.toString());
        if (language instanceof AbstractLanguage) {
            return new AbstractLanguage[]{(AbstractLanguage)language};
        }
        return new AbstractLanguage[0];
    }

    private boolean isValidSourceUnitName(String file) {
        Path path = new Path(file);
        if (this.fIndexer.getValidSourceUnitNames() == null || this.fIndexer.getValidSourceUnitNames().size() == 0) {
            return true;
        }
        return this.fIndexer.getValidSourceUnitNames().contains(path.getFileExtension());
    }

    public boolean isCaseInsensitiveFileSystem() {
        return new File("a").equals(new File("A"));
    }
}

