/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.core.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.codan.core.CodanRuntime;
import org.eclipse.cdt.codan.core.model.IChecker;
import org.eclipse.cdt.codan.core.model.ICheckerInvocationContext;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.model.IProblemLocation;
import org.eclipse.cdt.codan.core.model.IProblemProfile;
import org.eclipse.cdt.codan.core.model.IProblemReporter;
import org.eclipse.cdt.codan.core.model.IProblemReporterPersistent;
import org.eclipse.cdt.codan.core.model.IProblemReporterSessionPersistent;
import org.eclipse.cdt.codan.core.model.IRunnableInEditorChecker;
import org.eclipse.cdt.codan.internal.core.CheckersRegistry;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.OperationCanceledException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractChecker
implements IChecker {
    private ICheckerInvocationContext context;
    private IProblemReporter problemReporter;

    @Override
    public boolean enabledInContext(IResource res) {
        return res instanceof IFile;
    }

    public void reportProblem(String id, IFile file, int lineNumber, Object ... args) {
        this.getProblemReporter().reportProblem(id, this.createProblemLocation(file, lineNumber), args);
    }

    public IProblem getProblemById(String id, IResource file) {
        IProblem problem = CheckersRegistry.getInstance().getResourceProfile(file).findProblem(id);
        if (problem == null) {
            throw new IllegalArgumentException("Id is not registered");
        }
        return problem;
    }

    public List<IProblem> getProblemsByMainId(String id, IResource file) {
        ArrayList<IProblem> list = new ArrayList<IProblem>();
        IProblemProfile resourceProfile = CheckersRegistry.getInstance().getResourceProfile(file);
        IProblem[] problems = resourceProfile.getProblems();
        int i = 0;
        while (i < problems.length) {
            IProblem p = problems[i];
            if (p.getId().equals(id)) {
                list.add(p);
            } else if (p.getId().startsWith(String.valueOf(id) + ".COPY")) {
                list.add(p);
            }
            ++i;
        }
        return list;
    }

    public void reportProblem(String id, IFile file, int lineNumber) {
        this.getProblemReporter().reportProblem(id, this.createProblemLocation(file, lineNumber), new Object[0]);
    }

    @Override
    public IProblemReporter getProblemReporter() {
        return this.problemReporter;
    }

    protected CodanRuntime getRuntime() {
        return CodanRuntime.getInstance();
    }

    protected IProblemLocation createProblemLocation(IFile file, int line) {
        return this.getRuntime().getProblemLocationFactory().createProblemLocation(file, line);
    }

    protected IProblemLocation createProblemLocation(IFile file, int startChar, int endChar) {
        return this.getRuntime().getProblemLocationFactory().createProblemLocation(file, startChar, endChar);
    }

    @Override
    public boolean runInEditor() {
        return this instanceof IRunnableInEditorChecker;
    }

    public void reportProblem(String problemId, IProblemLocation loc, Object ... args) {
        this.getProblemReporter().reportProblem(problemId, loc, args);
    }

    protected ICheckerInvocationContext getContext() {
        return this.context;
    }

    protected void setContext(ICheckerInvocationContext context) {
        this.context = context;
    }

    @Override
    public void before(IResource resource) {
        IProblemReporter problemReporter;
        this.problemReporter = problemReporter = CodanRuntime.getInstance().getProblemReporter();
        if (problemReporter instanceof IProblemReporterSessionPersistent) {
            this.problemReporter = ((IProblemReporterSessionPersistent)problemReporter).createReporter(resource, this);
            ((IProblemReporterSessionPersistent)this.problemReporter).start();
        } else if (problemReporter instanceof IProblemReporterPersistent) {
            ((IProblemReporterPersistent)problemReporter).deleteProblems(resource, this);
        }
    }

    @Override
    public void after(IResource resource) {
        if (this.problemReporter instanceof IProblemReporterSessionPersistent) {
            ((IProblemReporterSessionPersistent)this.problemReporter).done();
        }
        this.problemReporter = null;
    }

    public abstract boolean processResource(IResource var1) throws OperationCanceledException;

    @Override
    public synchronized boolean processResource(IResource resource, ICheckerInvocationContext context) throws OperationCanceledException {
        this.setContext(context);
        try {
            boolean bl = this.processResource(resource);
            return bl;
        }
        finally {
            this.setContext(null);
        }
    }
}

