/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.tcf.extension;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.eclipse.cdt.debug.edc.tcf.extension.AgentException;
import org.eclipse.cdt.debug.edc.tcf.extension.PartialMemoryBlock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryBlockMultiStatusException
extends AgentException {
    private static final long serialVersionUID = -5403275982691807261L;
    private final ArrayList<PartialMemoryBlock> pbList;
    private final ByteBuffer buf;

    public MemoryBlockMultiStatusException(String msg, ByteBuffer block, MemoryBlockMultiStatusException m) {
        super(msg);
        this.buf = block;
        this.pbList = m != null ? m.getPartialBLocks() : null;
    }

    public MemoryBlockMultiStatusException(String msg, ByteBuffer fullBlock, MemoryBlockMultiStatusException m1, MemoryBlockMultiStatusException m2) {
        super(msg);
        this.buf = fullBlock;
        if (m1 != null) {
            this.pbList = m1.getPartialBLocks();
            if (m2 != null && m2.getPartialBLocks() != null) {
                this.pbList.addAll(m2.getPartialBLocks());
            }
        } else {
            this.pbList = m2 != null ? m2.getPartialBLocks() : null;
        }
    }

    public MemoryBlockMultiStatusException(ByteBuffer block, int addr, int size) {
        super((String)null);
        this.buf = block;
        this.buf.put((byte)-66);
        this.pbList = new ArrayList(1);
        this.pbList.add(new PartialMemoryBlock(addr, size, 2));
    }

    public ArrayList<PartialMemoryBlock> getPartialBLocks() {
        return this.pbList;
    }

    public ByteBuffer getBuf() {
        return this.buf;
    }
}

