/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.ui;

import org.eclipse.cdt.debug.edc.internal.snapshot.Album;
import org.eclipse.cdt.debug.edc.internal.snapshot.Snapshot;
import org.eclipse.cdt.debug.edc.internal.snapshot.SnapshotUtils;
import org.eclipse.cdt.debug.edc.internal.ui.views.SnapshotView;
import org.eclipse.cdt.debug.edc.snapshot.IAlbum;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class SnapshotDeleteHandler
extends AbstractHandler {
    private boolean deleteAlbum(IProject project, final IAlbum album, final Shell shell) throws CoreException {
        ILaunchConfiguration lc;
        if (album == null) {
            return false;
        }
        IPath extractedAlbum = album.getAlbumRootDirectory();
        if (extractedAlbum.toFile().exists()) {
            SnapshotView.deleteDir(extractedAlbum.toFile());
        }
        if ((lc = SnapshotUtils.findExistingLaunchForAlbum((IAlbum)album)) != null) {
            lc.delete();
        }
        final boolean[] success = new boolean[1];
        project.accept(new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy proxy) throws CoreException {
                if (proxy.getType() == 1) {
                    IPath currentFile = proxy.requestResource().getRawLocation();
                    if (album.getLocation().toFile().getAbsolutePath().equals(currentFile.toFile().getAbsolutePath())) {
                        boolean okToDelete = false;
                        okToDelete = proxy.requestResource().isLinked() ? MessageDialog.openQuestion((Shell)shell, (String)"Delete Album", (String)("Are you sure you want to remove the linked file \"" + currentFile.toOSString() + "\"?\n\nThis action will not delete the file from disk.")) : MessageDialog.openQuestion((Shell)shell, (String)"Delete Album", (String)("Are you sure you want to delete album \"" + currentFile.toOSString() + "\"from disk?\n\nThis action cannot be undone."));
                        if (okToDelete) {
                            proxy.requestResource().delete(true, null);
                        }
                        success[0] = true;
                        return false;
                    }
                }
                return true;
            }
        }, 0);
        return success[0];
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow wbWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (!(part instanceof SnapshotView)) {
            assert (false) : "Delete handler invoked from unexpected view. Expecting Snapshot view";
            return null;
        }
        Object element = this.getSelectedItem(event.getApplicationContext());
        if (element != null) {
            if (element instanceof IAlbum) {
                IAlbum album = (IAlbum)element;
                try {
                    if (this.deleteAlbum(SnapshotUtils.getSnapshotsProject(), album, wbWindow.getShell())) {
                        ((SnapshotView)part).refresh();
                    }
                }
                catch (CoreException e) {
                    MessageDialog.open((int)1, (Shell)wbWindow.getShell(), (String)part.getTitle(), (String)("Error deleting item: " + e.getLocalizedMessage()), (int)0);
                }
            } else if (element instanceof Snapshot) {
                Snapshot snap = (Snapshot)element;
                String descr = snap.getSnapshotDisplayName();
                if (MessageDialog.openQuestion((Shell)wbWindow.getShell(), (String)"Delete Snapshot", (String)("Are you sure you want to delete snapshot \"" + descr + "\"?"))) {
                    snap.getAlbum().deleteSnapshot(snap);
                    ((SnapshotView)part).refresh();
                }
            }
        }
        return null;
    }

    private Object getSelectedItem(Object evaluationContext) {
        if (evaluationContext instanceof IEvaluationContext) {
            TreeNode node;
            Object element;
            IStructuredSelection ss;
            Object s = ((IEvaluationContext)evaluationContext).getVariable("selection");
            if (!(s instanceof IStructuredSelection)) {
                s = ((IEvaluationContext)evaluationContext).getVariable("activeMenuSelection");
            }
            if (s instanceof IStructuredSelection && (ss = (IStructuredSelection)s).size() == 1 && ((element = (node = (TreeNode)ss.getFirstElement()).getValue()) instanceof Album || element instanceof Snapshot)) {
                return element;
            }
        }
        return null;
    }
}

