/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.scripting;

import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.eclipse.cdt.debug.edc.internal.scripting.DOMUtils;
import org.eclipse.cdt.debug.edc.internal.services.dsf.RunControl;
import org.eclipse.cdt.debug.edc.services.IEDCDMContext;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.scripting.ScriptingPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionContext {
    public static final String STEP_OVER = "StepOver";
    public static final String STEP_INTO = "StepInto";
    public static final String STEP_RETURN = "StepReturn";
    private static Object suspendedListener;

    public static Map<String, Object>[] getStackFrames(String contextId) throws Exception {
        return DOMUtils.getDMContextProperties(DOMUtils.getStackFrames(contextId));
    }

    public static int resume(final String contextId) throws InterruptedException, ExecutionException {
        final DsfSession session = DsfSession.getSession((String)DOMUtils.getSessionForContext(contextId));
        final int activity = ScriptingPlugin.newPendingActivityId();
        session.getExecutor().submit((Runnable)new DsfRunnable(){

            public void run() {
                DsfServicesTracker servicesTracker = DOMUtils.getDsfServicesTracker(session);
                final RunControl runControlService = (RunControl)servicesTracker.getService(RunControl.class);
                if (runControlService != null) {
                    runControlService.canResume(runControlService.getContext(contextId), new DataRequestMonitor<Boolean>((Executor)session.getExecutor(), null){

                        protected void handleCompleted() {
                            if (((Boolean)this.getData()).booleanValue()) {
                                runControlService.resume(runControlService.getContext(contextId), new RequestMonitor((Executor)session.getExecutor(), null){

                                    protected void handleCompleted() {
                                        ScriptingPlugin.setActivityDone((int)activity);
                                    }
                                });
                            }
                        }
                    });
                }
            }
        });
        return activity;
    }

    private static IRunControl.StepType getStepType(String stepType) {
        if (stepType.equals(STEP_OVER)) {
            return IRunControl.StepType.STEP_OVER;
        }
        if (stepType.equals(STEP_INTO)) {
            return IRunControl.StepType.STEP_INTO;
        }
        if (stepType.equals(STEP_RETURN)) {
            return IRunControl.StepType.STEP_RETURN;
        }
        return IRunControl.StepType.STEP_OVER;
    }

    public static int step(final String contextId, final String stepTypeName) {
        final DsfSession session = DsfSession.getSession((String)DOMUtils.getSessionForContext(contextId));
        final int activity = ScriptingPlugin.newPendingActivityId();
        suspendedListener = new SuspendedEventAdapter(session, activity, contextId);
        session.getExecutor().submit((Runnable)new DsfRunnable(){

            public void run() {
                session.addServiceEventListener(suspendedListener, null);
                DsfServicesTracker servicesTracker = DOMUtils.getDsfServicesTracker(session);
                final RunControl runControlService = (RunControl)servicesTracker.getService(RunControl.class);
                if (runControlService != null) {
                    final IRunControl.StepType stepType = ExecutionContext.getStepType(stepTypeName);
                    runControlService.canStep(runControlService.getContext(contextId), stepType, new DataRequestMonitor<Boolean>((Executor)session.getExecutor(), null){

                        protected void handleCompleted() {
                            if (((Boolean)this.getData()).booleanValue()) {
                                RunControl.ExecutionDMC context = runControlService.getContext(contextId);
                                runControlService.step(context, stepType, new RequestMonitor((Executor)session.getExecutor(), null){

                                    protected void handleCompleted() {
                                        ScriptingPlugin.setActivityDone((int)activity);
                                    }
                                });
                            }
                        }
                    });
                }
            }
        });
        return activity;
    }

    public static String getContextId(Map<String, Object> properties) {
        return (String)properties.get("ID");
    }

    public static final class SuspendedEventAdapter {
        private final DsfSession session;
        private final int activity;
        private final String contextId;

        private SuspendedEventAdapter(DsfSession session, int activity, String contextId) {
            this.session = session;
            this.activity = activity;
            this.contextId = contextId;
        }

        @DsfServiceEventHandler
        public void eventDispatched(IRunControl.ISuspendedDMEvent e) {
            IEDCDMContext dmContext = (IEDCDMContext)e.getDMContext();
            String id = (String)dmContext.getProperty("ID");
            if (this.contextId.equals(id)) {
                ScriptingPlugin.setActivityDone((int)this.activity);
                this.session.removeServiceEventListener(suspendedListener);
            }
        }
    }
}

