/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols.dwarf;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.IStreamBuffer;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.MemoryStreamBuffer;
import org.eclipse.cdt.debug.edc.internal.services.dsf.RunControl;
import org.eclipse.cdt.debug.edc.internal.symbols.MemoryVariableLocation;
import org.eclipse.cdt.debug.edc.internal.symbols.RegisterOffsetVariableLocation;
import org.eclipse.cdt.debug.edc.internal.symbols.RegisterVariableLocation;
import org.eclipse.cdt.debug.edc.internal.symbols.ValueVariableLocation;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.DwarfDebugInfoProvider;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.DwarfFrameRegisters;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.DwarfInfoReader;
import org.eclipse.cdt.debug.edc.services.EDCServicesTracker;
import org.eclipse.cdt.debug.edc.services.IEDCModuleDMContext;
import org.eclipse.cdt.debug.edc.services.IFrameRegisterProvider;
import org.eclipse.cdt.debug.edc.services.IFrameRegisters;
import org.eclipse.cdt.debug.edc.services.Registers;
import org.eclipse.cdt.debug.edc.services.Stack;
import org.eclipse.cdt.debug.edc.symbols.IRangeList;
import org.eclipse.cdt.debug.edc.symbols.IVariableLocation;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;

public class DwarfFrameRegisterProvider
implements IFrameRegisterProvider {
    private static ErrorRule UNIMPLEMENTED = new ErrorRule("unimplemented support for reading this location");
    private DwarfDebugInfoProvider provider;

    public DwarfFrameRegisterProvider(DwarfDebugInfoProvider provider) {
        this.provider = provider;
    }

    public void dispose() {
        this.provider = null;
    }

    public IFrameRegisters getFrameRegisters(DsfSession session, EDCServicesTracker tracker, IStack.IFrameDMContext context) throws CoreException {
        FrameDescriptionEntry currentFrameEntry;
        Registers registers = tracker.getService(Registers.class);
        IStack stack = tracker.getService(IStack.class);
        RunControl.ExecutionDMC exeDMC = (RunControl.ExecutionDMC)DMContexts.getAncestorOfType((IDMContext)context, RunControl.ExecutionDMC.class);
        if (registers == null || exeDMC == null || !(context instanceof Stack.StackFrameDMC)) {
            throw EDCDebugger.newCoreException("cannot read frame");
        }
        Stack.StackFrameDMC stackFrame = (Stack.StackFrameDMC)context;
        if (stackFrame.getLevel() == 0) {
            return new Stack.CurrentFrameRegisters(exeDMC, registers);
        }
        Stack.StackFrameDMC childFrame = this.getChildFrame(session, stack, exeDMC, stackFrame);
        if (childFrame == null) {
            return null;
        }
        IFrameRegisters childRegisters = childFrame.getFrameRegisters();
        IAddress linkaddress = childFrame.getInstructionPtrAddress();
        IEDCModuleDMContext module = childFrame.getModule();
        if (module != null) {
            linkaddress = module.toLinkAddress(linkaddress);
        }
        if ((currentFrameEntry = this.provider.findFrameDescriptionEntry(linkaddress)) == null) {
            return null;
        }
        return new DwarfFrameRegisters(tracker, childFrame, currentFrameEntry, childRegisters, this.provider);
    }

    private Stack.StackFrameDMC getChildFrame(DsfSession session, IStack stack, RunControl.ExecutionDMC exeDMC, Stack.StackFrameDMC stackFrame) throws CoreException {
        Stack.StackFrameDMC childFrame = stackFrame.getCalledFrame();
        return childFrame;
    }

    public static abstract class AbstractInstruction {
        public abstract void applyInstruction(InstructionState var1) throws CoreException;
    }

    public static abstract class AbstractRegisterInstruction
    extends AbstractInstruction {
        protected final int thereg;

        public AbstractRegisterInstruction(int thereg) {
            this.thereg = thereg;
        }

        public String toString() {
            return "R" + this.thereg;
        }
    }

    public static abstract class AbstractRule {
        public abstract IVariableLocation evaluate(InstructionState var1) throws CoreException;
    }

    static class CFARegisterRule
    extends AbstractRule {
        private int regnum;
        private long offset;

        public CFARegisterRule(int regnum, long offset) {
            this.regnum = regnum;
            this.offset = offset;
        }

        public String toString() {
            return "[" + this.regnum + "]" + (this.offset < 0L ? "-" : "+") + Math.abs(this.offset);
        }

        public IVariableLocation evaluate(InstructionState state) throws CoreException {
            return new RegisterOffsetVariableLocation(state.tracker, (IDMContext)state.context, null, this.regnum, this.offset);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CommonInformationEntry {
        final long codeAlignmentFactor;
        final long dataAlignmentFactor;
        final int version;
        final int returnAddressRegister;
        final int addressSize;
        final IStreamBuffer instructions;
        private List<AbstractInstruction> initialLocations;
        private CoreException initialLocationsError;
        private boolean cfaOffsetSfIsFactored;
        private boolean cfaOffsetsAreReversed;

        public CommonInformationEntry(long codeAlignmentFactor, long dataAlignmentFactor, int returnAddressRegister, int version, IStreamBuffer instructions, int addressSize, String producer, String augmentation) {
            this.codeAlignmentFactor = codeAlignmentFactor;
            this.dataAlignmentFactor = dataAlignmentFactor;
            this.returnAddressRegister = returnAddressRegister;
            this.version = version;
            this.instructions = instructions;
            this.addressSize = addressSize;
            this.checkAugmentations(producer, augmentation);
        }

        private void checkAugmentations(String producer, String augmentation) {
            if (!(augmentation.startsWith("armcc") && augmentation.contains("+") || producer == null || !producer.contains("RVCT"))) {
                if (this.version == 1) {
                    this.cfaOffsetSfIsFactored = true;
                    this.cfaOffsetsAreReversed = true;
                }
                if (this.version == 3) {
                    this.cfaOffsetsAreReversed = true;
                }
            }
        }

        public List<AbstractInstruction> getInitialLocations(DwarfDebugInfoProvider provider) throws CoreException {
            if (this.initialLocations == null) {
                try {
                    this.initialLocations = this.parseInitialLocations(provider);
                }
                catch (CoreException e) {
                    this.initialLocationsError = e;
                }
            }
            if (this.initialLocationsError != null) {
                throw this.initialLocationsError;
            }
            return this.initialLocations;
        }

        public List<AbstractInstruction> parseInitialLocations(DwarfDebugInfoProvider provider) throws CoreException {
            ArrayList<AbstractInstruction> instrs = new ArrayList<AbstractInstruction>();
            IStreamBuffer buffer = this.instructions.wrapSubsection(this.instructions.capacity());
            buffer.position(0L);
            try {
                while (buffer.hasRemaining()) {
                    int opcode = buffer.get() & 0xFF;
                    AbstractInstruction inst = this.parseInstruction(opcode, buffer, provider, this.addressSize, this.dataAlignmentFactor);
                    if (inst == null) continue;
                    instrs.add(inst);
                }
            }
            catch (Exception e) {
                throw EDCDebugger.newCoreException("Malformed data at " + buffer, e);
            }
            return instrs;
        }

        public AbstractInstruction parseInstruction(int opcode, IStreamBuffer buffer, DwarfDebugInfoProvider provider, int addressSize, long dataAlignmentFactor) throws IOException {
            if (opcode >= 128 && opcode < 192) {
                int reg = opcode - 128;
                long offset = DwarfInfoReader.read_unsigned_leb128(buffer) * dataAlignmentFactor;
                return new OffsetInstruction(reg, offset);
            }
            if (opcode >= 192 && opcode < 256) {
                int reg = opcode - 192;
                return new RestoreInstruction(reg);
            }
            switch (opcode) {
                case 0: {
                    return new NopInstruction();
                }
                case 12: {
                    int reg = this.readRegister(buffer);
                    long offset = DwarfInfoReader.read_unsigned_leb128(buffer);
                    if (this.cfaOffsetSfIsFactored) {
                        offset *= dataAlignmentFactor;
                    }
                    return new DefCFAInstruction(reg, offset);
                }
                case 18: {
                    int reg = this.readRegister(buffer);
                    long offset = DwarfInfoReader.read_signed_leb128(buffer) * dataAlignmentFactor;
                    return new DefCFAInstruction(reg, offset);
                }
                case 13: {
                    int reg = this.readRegister(buffer);
                    return new DefCFARegisterInstruction(reg);
                }
                case 14: {
                    long offset = DwarfInfoReader.read_unsigned_leb128(buffer);
                    if (this.cfaOffsetSfIsFactored) {
                        offset *= dataAlignmentFactor;
                    }
                    return new DefCFAOffsetInstruction(offset);
                }
                case 19: {
                    long offset = DwarfInfoReader.read_signed_leb128(buffer) * dataAlignmentFactor;
                    return new DefCFAOffsetInstruction(offset);
                }
                case 15: {
                    byte form = buffer.get();
                    IStreamBuffer expr = this.readExpression(form, addressSize, provider, buffer);
                    return new DefCFAExpressionInstruction(expr);
                }
            }
            if (opcode >= 128 && opcode < 192) {
                int reg = opcode - 128;
                long offset = DwarfInfoReader.read_unsigned_leb128(buffer) * dataAlignmentFactor;
                return new OffsetInstruction(reg, offset);
            }
            if (opcode >= 192 && opcode < 256) {
                int reg = opcode - 192;
                return new RestoreInstruction(reg);
            }
            switch (opcode) {
                case 0: {
                    break;
                }
                case 7: {
                    int reg = this.readRegister(buffer);
                    return new UndefinedInstruction(reg);
                }
                case 8: {
                    int reg = this.readRegister(buffer);
                    return new SameValueInstruction(reg);
                }
                case 5: {
                    int reg = this.readRegister(buffer);
                    long offset = DwarfInfoReader.read_unsigned_leb128(buffer) * dataAlignmentFactor;
                    return new OffsetInstruction(reg, offset);
                }
                case 17: {
                    int reg = this.readRegister(buffer);
                    long offset = DwarfInfoReader.read_signed_leb128(buffer) * dataAlignmentFactor;
                    return new OffsetInstruction(reg, offset);
                }
                case 20: {
                    int reg = this.readRegister(buffer);
                    long offset = DwarfInfoReader.read_unsigned_leb128(buffer) * dataAlignmentFactor;
                    return new ValueOffsetInstruction(reg, offset);
                }
                case 21: {
                    int reg = this.readRegister(buffer);
                    long offset = DwarfInfoReader.read_signed_leb128(buffer) * dataAlignmentFactor;
                    return new ValueOffsetInstruction(reg, offset);
                }
                case 9: {
                    int reg = this.readRegister(buffer);
                    int otherReg = this.readRegister(buffer);
                    return new RegisterInstruction(reg, otherReg);
                }
                case 16: {
                    int reg = this.readRegister(buffer);
                    byte form = buffer.get();
                    IStreamBuffer expr = this.readExpression(form, addressSize, provider, buffer);
                    return new ExpressionInstruction(reg, expr);
                }
                case 22: {
                    int reg = this.readRegister(buffer);
                    byte form = buffer.get();
                    IStreamBuffer expr = this.readExpression(form, addressSize, provider, buffer);
                    return new ValueExpressionInstruction(reg, expr);
                }
                case 6: {
                    int reg = this.readRegister(buffer);
                    return new RestoreInstruction(reg);
                }
                case 10: {
                    return new RememberStateInstruction();
                }
                case 11: {
                    return new RestoreStateInstruction();
                }
            }
            return null;
        }

        private int readRegister(IStreamBuffer buffer) throws IOException {
            return (int)DwarfInfoReader.read_unsigned_leb128(buffer);
        }

        private IStreamBuffer readExpression(byte form, int addressSize, DwarfDebugInfoProvider provider, IStreamBuffer buffer) {
            DwarfDebugInfoProvider.AttributeValue value = new DwarfDebugInfoProvider.AttributeValue(form, buffer, (byte)addressSize, null);
            return new MemoryStreamBuffer(value.getValueAsBytes(), provider.getExecutableSymbolicsReader().getByteOrder());
        }
    }

    public static class DefCFAExpressionInstruction
    extends AbstractInstruction {
        IStreamBuffer expression;

        public DefCFAExpressionInstruction(IStreamBuffer expression) {
            this.expression = expression;
        }

        public String toString() {
            return "CFA := expression";
        }

        public void applyInstruction(InstructionState state) throws CoreException {
            throw EDCDebugger.newCoreException("CFA expression not implemented");
        }
    }

    public static class DefCFAInstruction
    extends AbstractInstruction {
        long regnum;
        long offset;

        public DefCFAInstruction(long regnum, long offset) {
            this.regnum = regnum;
        }

        public String toString() {
            return "CFA := R" + this.regnum + " + " + this.offset;
        }

        public void applyInstruction(InstructionState state) throws CoreException {
            state.cfaRegRule.regnum = (int)this.regnum;
            state.cfaRegRule.offset = this.offset;
        }
    }

    public static class DefCFAOffsetInstruction
    extends AbstractInstruction {
        long offset;

        public DefCFAOffsetInstruction(long offset) {
            this.offset = offset;
        }

        public String toString() {
            return "CFA offset := " + this.offset;
        }

        public void applyInstruction(InstructionState state) throws CoreException {
            state.cfaRegRule.offset = this.offset;
        }
    }

    public static class DefCFARegisterInstruction
    extends AbstractInstruction {
        long regnum;

        public DefCFARegisterInstruction(long regnum) {
            this.regnum = regnum;
        }

        public String toString() {
            return "CFA register := R" + this.regnum;
        }

        public void applyInstruction(InstructionState state) throws CoreException {
            state.cfaRegRule.regnum = (int)this.regnum;
        }
    }

    static class ErrorRule
    extends AbstractRule {
        private String message;

        public ErrorRule(String message) {
            this.message = message;
        }

        public String toString() {
            return "error: " + this.message;
        }

        public IVariableLocation evaluate(InstructionState state) throws CoreException {
            throw EDCDebugger.newCoreException(this.message);
        }
    }

    public static class ExpressionInstruction
    extends AbstractRegisterInstruction {
        IStreamBuffer expression;

        public ExpressionInstruction(int thereg, IStreamBuffer expression) {
            super(thereg);
            this.expression = expression;
        }

        public String toString() {
            return String.valueOf(super.toString()) + "@ expression";
        }

        public void applyInstruction(InstructionState state) throws CoreException {
            state.regRules.put(this.thereg, UNIMPLEMENTED);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FrameDescriptionEntry {
        final Long fdePtr;
        final Long ciePtr;
        final int addressSize;
        private final IStreamBuffer instructions;
        private final long low;
        private final long high;
        private CommonInformationEntry cie;
        private CoreException parseException;
        private TreeMap<IRangeList.Entry, List<AbstractInstruction>> instructionMap;

        public CommonInformationEntry getCIE() {
            return this.cie;
        }

        public void setCIE(CommonInformationEntry cie) {
            this.cie = cie;
        }

        public FrameDescriptionEntry(long fdePtr, long ciePtr, long low, long high, IStreamBuffer instructions, int addressSize) {
            this.ciePtr = ciePtr;
            this.fdePtr = fdePtr;
            this.instructions = instructions;
            this.addressSize = addressSize;
            this.low = low;
            this.high = high;
        }

        public String toString() {
            return "FDE at " + this.instructions + " with CIE " + (this.cie != null ? this.cie : this.ciePtr);
        }

        public int getReturnAddressRegister() {
            return this.cie != null ? this.cie.returnAddressRegister : 0;
        }

        public TreeMap<IRangeList.Entry, List<AbstractInstruction>> getInstructions(DwarfDebugInfoProvider provider) throws CoreException {
            if (this.instructionMap == null) {
                try {
                    this.instructionMap = this.parseRules(provider);
                }
                catch (CoreException e) {
                    this.parseException = e;
                }
            }
            if (this.parseException != null) {
                throw this.parseException;
            }
            return this.instructionMap;
        }

        private TreeMap<IRangeList.Entry, List<AbstractInstruction>> parseRules(DwarfDebugInfoProvider provider) throws CoreException {
            TreeMap<IRangeList.Entry, List<AbstractInstruction>> rules = new TreeMap<IRangeList.Entry, List<AbstractInstruction>>();
            IStreamBuffer buffer = this.instructions.wrapSubsection(this.instructions.capacity());
            buffer.position(0L);
            long current = this.low;
            ArrayList<AbstractInstruction> row = new ArrayList<AbstractInstruction>();
            try {
                while (buffer.hasRemaining()) {
                    int opcode = buffer.get() & 0xFF;
                    long offset = -1L;
                    if (opcode >= 64 && opcode < 128) {
                        offset = (long)(opcode - 64) * this.cie.codeAlignmentFactor;
                    } else {
                        switch (opcode) {
                            case 1: {
                                offset = DwarfInfoReader.readAddress(buffer, this.addressSize) - current;
                                break;
                            }
                            case 2: {
                                offset = (long)(buffer.get() & 0xFF) * this.cie.codeAlignmentFactor;
                                break;
                            }
                            case 3: {
                                offset = (long)(buffer.getShort() & 0xFFFF) * this.cie.codeAlignmentFactor;
                                break;
                            }
                            case 4: {
                                offset = (long)(buffer.getInt() & 0xFFFFFFFF) * this.cie.codeAlignmentFactor;
                            }
                        }
                    }
                    if (offset > 0L) {
                        rules.put(new IRangeList.Entry(current, current + offset), row);
                        current += offset;
                        row = new ArrayList();
                        continue;
                    }
                    AbstractInstruction instr = this.cie.parseInstruction(opcode, buffer, provider, this.addressSize, this.cie.dataAlignmentFactor);
                    if (instr != null) {
                        row.add(instr);
                        continue;
                    }
                    assert (false);
                    throw EDCDebugger.newCoreException("Unimplemented opcode " + opcode + " at " + buffer);
                }
            }
            catch (CoreException e) {
                throw e;
            }
            catch (Exception e) {
                throw EDCDebugger.newCoreException("error parsing FDE rules at " + buffer, e);
            }
            if (!row.isEmpty()) {
                rules.put(new IRangeList.Entry(current, this.high), row);
            }
            return rules;
        }
    }

    public static class InstructionState {
        public EDCServicesTracker tracker;
        public Map<Integer, AbstractRule> regRules;
        public IStack.IFrameDMContext context;
        public IFrameRegisters childRegisters;
        public Map<Integer, AbstractRule> initialRules;
        public Stack<Map<Integer, AbstractRule>> stateStack;
        CFARegisterRule cfaRegRule = new CFARegisterRule(0, 0L);
        private final int addressSize;
        public boolean cfaOffsetsAreReversed;
        public static final int CFA = -1;

        public InstructionState(EDCServicesTracker tracker, IStack.IFrameDMContext context, IFrameRegisters childRegisters, FrameDescriptionEntry fde) {
            this.tracker = tracker;
            this.addressSize = fde.addressSize;
            this.cfaOffsetsAreReversed = fde.getCIE().cfaOffsetsAreReversed;
            this.regRules = new TreeMap<Integer, AbstractRule>();
            this.stateStack = new Stack();
            this.initialRules = new TreeMap<Integer, AbstractRule>();
            this.context = context;
            this.childRegisters = childRegisters;
        }

        public BigInteger readCFA() throws CoreException {
            BigInteger regval = this.childRegisters.getRegister(this.cfaRegRule.regnum, this.addressSize);
            return regval.add(BigInteger.valueOf(this.cfaOffsetsAreReversed ? -this.cfaRegRule.offset : this.cfaRegRule.offset));
        }

        public int getCFARegister() {
            return this.cfaRegRule.regnum;
        }
    }

    public static class NopInstruction
    extends AbstractInstruction {
        public String toString() {
            return "nop";
        }

        public void applyInstruction(InstructionState state) throws CoreException {
        }
    }

    public static class OffsetInstruction
    extends AbstractRegisterInstruction {
        long offset;

        public OffsetInstruction(int thereg, long offset) {
            super(thereg);
            this.offset = offset;
        }

        public String toString() {
            return String.valueOf(super.toString()) + "@ CFA + " + this.offset;
        }

        public void applyInstruction(InstructionState state) throws CoreException {
            state.regRules.put(this.thereg, new OffsetRule(this.offset));
        }
    }

    static class OffsetRule
    extends AbstractRule {
        private final long offset;

        public OffsetRule(long offset) {
            this.offset = offset;
        }

        public String toString() {
            return "offset(" + this.offset + ")";
        }

        public IVariableLocation evaluate(InstructionState state) throws CoreException {
            BigInteger cfa = state.readCFA();
            return new MemoryVariableLocation(state.tracker, (IDMContext)state.context, cfa.add(BigInteger.valueOf(this.offset)), true);
        }
    }

    public static class RegisterInstruction
    extends AbstractRegisterInstruction {
        int regnum;

        public RegisterInstruction(int thereg, int regnum) {
            super(thereg);
            this.regnum = regnum;
        }

        public String toString() {
            return String.valueOf(super.toString()) + "copy R" + this.regnum;
        }

        public void applyInstruction(InstructionState state) throws CoreException {
            if (state.regRules.containsKey(this.regnum)) {
                state.regRules.put(this.thereg, state.regRules.get(this.regnum));
            } else {
                state.regRules.put(this.thereg, new UndefinedRule(this.regnum));
            }
        }
    }

    static class RegisterRule
    extends AbstractRule {
        private final int regnum;

        public RegisterRule(int regnum) {
            this.regnum = regnum;
        }

        public String toString() {
            return "register(" + this.regnum + ")";
        }

        public IVariableLocation evaluate(InstructionState state) throws CoreException {
            return new RegisterVariableLocation(state.tracker, (IDMContext)state.context, null, this.regnum);
        }
    }

    public static class RememberStateInstruction
    extends AbstractInstruction {
        public String toString() {
            return "remember state";
        }

        public void applyInstruction(InstructionState state) throws CoreException {
            state.stateStack.push(new TreeMap<Integer, AbstractRule>(state.regRules));
        }
    }

    public static class RestoreInstruction
    extends AbstractRegisterInstruction {
        public RestoreInstruction(int thereg) {
            super(thereg);
        }

        public String toString() {
            return String.valueOf(super.toString()) + " restore";
        }

        public void applyInstruction(InstructionState state) throws CoreException {
            if (state.initialRules.containsKey(this.thereg)) {
                state.regRules.put(this.thereg, state.initialRules.get(this.thereg));
            } else {
                state.regRules.remove(this.thereg);
            }
        }
    }

    public static class RestoreStateInstruction
    extends AbstractInstruction {
        public String toString() {
            return "restore state";
        }

        public void applyInstruction(InstructionState state) throws CoreException {
            state.regRules.clear();
            state.regRules.putAll(state.stateStack.pop());
        }
    }

    public static class SameValueInstruction
    extends AbstractRegisterInstruction {
        public SameValueInstruction(int thereg) {
            super(thereg);
        }

        public String toString() {
            return String.valueOf(super.toString()) + "same value";
        }

        public void applyInstruction(InstructionState state) throws CoreException {
            state.regRules.put(this.thereg, new SameValueRule(this.thereg));
        }
    }

    static class SameValueRule
    extends AbstractRule {
        private final int regnum;

        public SameValueRule(int regnum) {
            this.regnum = regnum;
        }

        public String toString() {
            return "R" + this.regnum + ": same value";
        }

        public IVariableLocation evaluate(InstructionState state) throws CoreException {
            return new ValueVariableLocation(state.childRegisters.getRegister(this.regnum, state.addressSize));
        }
    }

    public static class UndefinedInstruction
    extends AbstractRegisterInstruction {
        public UndefinedInstruction(int thereg) {
            super(thereg);
        }

        public String toString() {
            return String.valueOf(super.toString()) + "undefined";
        }

        public void applyInstruction(InstructionState state) throws CoreException {
            state.regRules.put(this.thereg, new UndefinedRule(this.thereg));
        }
    }

    static class UndefinedRule
    extends AbstractRule {
        private final int regnum;

        public UndefinedRule(int regnum) {
            this.regnum = regnum;
        }

        public String toString() {
            return "R" + this.regnum + ": undefined";
        }

        public IVariableLocation evaluate(InstructionState state) throws CoreException {
            return null;
        }
    }

    public static class ValueExpressionInstruction
    extends AbstractRegisterInstruction {
        IStreamBuffer expression;

        public ValueExpressionInstruction(int thereg, IStreamBuffer expression) {
            super(thereg);
            this.expression = expression;
        }

        public String toString() {
            return String.valueOf(super.toString()) + " expression";
        }

        public void applyInstruction(InstructionState state) throws CoreException {
            state.regRules.put(this.thereg, UNIMPLEMENTED);
        }
    }

    public static class ValueOffsetInstruction
    extends AbstractRegisterInstruction {
        long offset;

        public ValueOffsetInstruction(int thereg, long offset) {
            super(thereg);
            this.offset = offset;
        }

        public String toString() {
            return String.valueOf(super.toString()) + "CFA + " + this.offset;
        }

        public void applyInstruction(InstructionState state) throws CoreException {
            state.regRules.put(this.thereg, new ValueOffsetRule(this.offset));
        }
    }

    static class ValueOffsetRule
    extends AbstractRule {
        private final long offset;

        public ValueOffsetRule(long offset) {
            this.offset = offset;
        }

        public String toString() {
            return "val_offset(" + this.offset + ")";
        }

        public IVariableLocation evaluate(InstructionState state) throws CoreException {
            BigInteger cfa = state.readCFA();
            return new ValueVariableLocation(cfa.add(BigInteger.valueOf(this.offset)));
        }
    }
}

