/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.remote.launching;

import org.eclipse.cdt.dsf.gdb.launching.GdbLaunchDelegate;
import org.eclipse.cdt.internal.launch.remote.Messages;
import org.eclipse.cdt.launch.remote.IRemoteConnectionConfigurationConstants;
import org.eclipse.cdt.launch.remote.RSEHelper;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.rse.core.RSECorePlugin;

public class RemoteGdbLaunchDelegate
extends GdbLaunchDelegate {
    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (!RSECorePlugin.isInitComplete((int)1)) {
            monitor.subTask(Messages.RemoteRunLaunchDelegate_10);
            try {
                RSECorePlugin.waitForInitCompletion((int)1);
            }
            catch (InterruptedException e) {
                throw new CoreException((IStatus)new Status(4, this.getPluginID(), 0, e.getLocalizedMessage(), (Throwable)e));
            }
        }
        IPath exePath = this.checkBinaryDetails(config);
        Process remoteShellProcess = null;
        if (exePath != null) {
            String remoteExePath = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_REMOTE_PATH, "");
            monitor.setTaskName(Messages.RemoteRunLaunchDelegate_2);
            RSEHelper.remoteFileDownload(config, launch, exePath.toString(), remoteExePath, (IProgressMonitor)new SubProgressMonitor(monitor, 80));
            String gdbserverPortNumber = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_GDBSERVER_PORT, "2345");
            String gdbserverCommand = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_GDBSERVER_COMMAND, "gdbserver");
            String commandArguments = ":" + gdbserverPortNumber + " " + RSEHelper.spaceEscapify(remoteExePath);
            String arguments = this.getProgramArguments(config);
            String prelaunchCmd = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_PRERUN_COMMANDS, "");
            if (arguments != null && !arguments.equals("")) {
                commandArguments = String.valueOf(commandArguments) + " " + arguments;
            }
            monitor.setTaskName(Messages.RemoteRunLaunchDelegate_9);
            remoteShellProcess = RSEHelper.remoteShellExec(config, prelaunchCmd, gdbserverCommand, commandArguments, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
            DebugPlugin.newProcess((ILaunch)launch, (Process)remoteShellProcess, (String)Messages.RemoteRunLaunchDelegate_RemoteShell);
            ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
            wc.setAttribute("org.eclipse.cdt.dsf.gdb.REMOTE_TCP", true);
            wc.setAttribute("org.eclipse.cdt.dsf.gdb.HOST", RSEHelper.getRemoteHostname(config));
            wc.setAttribute("org.eclipse.cdt.dsf.gdb.PORT", gdbserverPortNumber);
            wc.doSave();
        }
        try {
            try {
                super.launch(config, mode, launch, monitor);
            }
            catch (CoreException ex) {
                if (remoteShellProcess != null) {
                    remoteShellProcess.destroy();
                }
                throw ex;
            }
        }
        finally {
            monitor.done();
        }
    }

    protected String getProgramArguments(ILaunchConfiguration config) throws CoreException {
        String args = config.getAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", null);
        if (args != null) {
            args = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(args);
        }
        return args;
    }

    protected String getPluginID() {
        return "org.eclipse.cdt.launch.remote";
    }
}

